/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.recon.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.recon.FmReconResultCollection;
import com.kingdee.eas.fm.recon.FmReconResultFactory;
import com.kingdee.eas.fm.recon.SipgFmBillStateEnum;
import com.kingdee.eas.fm.recon.SipgFmBizTypeEnum;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionCollection;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionFactory;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionInfo;
import com.kingdee.eas.fm.recon.app.AbstractSipgFmReconDirectionControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SipgFmReconDirectionControllerBean
extends AbstractSipgFmReconDirectionControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.recon.app.SipgFmReconDirectionControllerBean");
    private static final String RECON_RES = "com.kingdee.eas.fm.recon.FmReconBaseResource";

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection src = new SelectorItemCollection();
        src.add("id");
        src.add("number");
        src.add("billState");
        src.add("bizType");
        return src;
    }

    @Override
    protected Map _actionCancel(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        SipgFmReconDirectionCollection colls = SipgFmReconDirectionFactory.getLocalInstance(ctx).getSipgFmReconDirectionCollection(view);
        String errorDetail = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        int validCount = 0;
        for (int i = 0; i < colls.size(); ++i) {
            SipgFmReconDirectionInfo info = colls.get(i);
            if (!SipgFmBillStateEnum.start.equals((Object)info.getBillState())) {
                errorDetail = errorDetail + ResourceBase.getString((String)RECON_RES, (String)"12_StartNoStop", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()}) + "\n";
                continue;
            }
            ++validCount;
            info.setBillState(SipgFmBillStateEnum.stop);
            try {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("billState");
                this.updatePartial(ctx, (CoreBaseInfo)info, selector);
                continue;
            }
            catch (BOSException e) {
                e.printStackTrace();
                errorDetail = errorDetail + ResourceBase.getString((String)RECON_RES, (String)"13_Exception", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber(), e.getMessage()}) + "\n";
            }
        }
        map.put("validCount", new Integer(validCount));
        map.put("errorDetail", errorDetail);
        return map;
    }

    @Override
    protected Map _actionCancelCancel(Context ctx, Set idSet) throws BOSException, EASBizException {
        CtrlUnitInfo CU = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCtrlUnit();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        SipgFmReconDirectionCollection colls = SipgFmReconDirectionFactory.getLocalInstance(ctx).getSipgFmReconDirectionCollection(view);
        String errorDetail = "";
        HashMap<SipgFmBizTypeEnum, Object> mapOnly = new HashMap<SipgFmBizTypeEnum, Object>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < colls.size(); ++i) {
            SipgFmReconDirectionInfo info = colls.get(i);
            if (mapOnly.containsKey((Object)info.getBizType())) {
                mapOnly.remove((Object)info.getBizType());
                mapOnly.put(info.getBizType(), "more");
                errorDetail = errorDetail + ResourceBase.getString((String)RECON_RES, (String)"43_bizTypeOnlyDirectionStart", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getBizType()}) + "\n";
                continue;
            }
            mapOnly.put(info.getBizType(), i);
        }
        int validCount = 0;
        for (int i = 0; i < colls.size(); ++i) {
            SipgFmReconDirectionInfo info = colls.get(i);
            if (mapOnly.get((Object)info.getBizType()).equals("more")) continue;
            if (SipgFmBillStateEnum.start.equals((Object)info.getBillState())) {
                errorDetail = errorDetail + ResourceBase.getString((String)RECON_RES, (String)"41_StartNoStart", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()}) + "\n";
                continue;
            }
            String error = this.doStart(ctx, info, CU);
            errorDetail = errorDetail + error;
            if (!error.equals("")) continue;
            ++validCount;
        }
        map.put("validCount", new Integer(validCount));
        map.put("errorDetail", errorDetail);
        return map;
    }

    private String doStart(Context ctx, SipgFmReconDirectionInfo info, CtrlUnitInfo CU) {
        String errorDetail = "";
        if ((errorDetail = errorDetail + this.checkOtherIsStart(ctx, info, CU)).equals("")) {
            info.setBillState(SipgFmBillStateEnum.start);
            try {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("billState");
                this.updatePartial(ctx, (CoreBaseInfo)info, selector);
            }
            catch (BOSException e) {
                e.printStackTrace();
                errorDetail = errorDetail + ResourceBase.getString((String)RECON_RES, (String)"13_Exception", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber(), e.getMessage()}) + "\n";
            }
            catch (EASBizException e) {
                e.printStackTrace();
                errorDetail = errorDetail + ResourceBase.getString((String)RECON_RES, (String)"13_Exception", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber(), e.getMessage()}) + "\n";
            }
        }
        return errorDetail;
    }

    private String checkOtherIsStart(Context ctx, SipgFmReconDirectionInfo info, CtrlUnitInfo CU) {
        String errorDetail = "";
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("billState");
        selector.add("CU.id");
        selector.add("bizType");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.setSelector(selector);
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)"2"));
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)CU.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("bizType", (Object)info.getBizType()));
        try {
            SipgFmReconDirectionCollection colls = SipgFmReconDirectionFactory.getLocalInstance(ctx).getSipgFmReconDirectionCollection(view);
            if (colls.size() >= 1) {
                errorDetail = errorDetail + ResourceBase.getString((String)RECON_RES, (String)"21_SipgFmReconDirectionControllerBean", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber(), info.getBizType()}) + "\n";
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            errorDetail = errorDetail + ResourceBase.getString((String)RECON_RES, (String)"13_Exception", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber(), e.getMessage()}) + "\n";
        }
        return errorDetail;
    }

    @Override
    protected Map _actionRemove(Context ctx, Set idSet) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        SipgFmReconDirectionCollection colls = SipgFmReconDirectionFactory.getLocalInstance(ctx).getSipgFmReconDirectionCollection(view);
        String errorDetail = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        int validCount = 0;
        for (int i = 0; i < colls.size(); ++i) {
            SipgFmReconDirectionInfo info = colls.get(i);
            errorDetail = SipgFmBillStateEnum.start.equals((Object)info.getBillState()) ? errorDetail + info.getNumber() + ":" + ResourceBase.getString((String)RECON_RES, (String)"20_StartDirectionCannotRemove", (Locale)ctx.getLocale()) + "\n" : errorDetail + this.checkIsUsed(ctx, info, currentCompany);
            if (!errorDetail.equals("")) continue;
            ++validCount;
        }
        map.put("validCount", new Integer(validCount));
        map.put("errorDetail", errorDetail);
        return map;
    }

    private String checkIsUsed(Context ctx, SipgFmReconDirectionInfo info, CompanyOrgUnitInfo currentCompany) throws BOSException {
        String errorDetail = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("direction.id", (Object)info.getId(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection src = new SelectorItemCollection();
        src.add("id");
        src.add("number");
        view.setSelector(src);
        FmReconResultCollection colls = FmReconResultFactory.getLocalInstance(ctx).getFmReconResultCollection(view);
        if (colls.size() > 1) {
            errorDetail = errorDetail + info.getNumber() + ":" + ResourceBase.getString((String)RECON_RES, (String)"36_isUsedCannotRemove", (Locale)ctx.getLocale()) + "\n";
        }
        return errorDetail;
    }
}

