/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.recon.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.AbstractBizControllerBean;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fi.cas.JournalBalanceCollection;
import com.kingdee.eas.fi.cas.JournalBalanceFactory;
import com.kingdee.eas.fi.cas.JournalBalanceInfo;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.IReportCacl;
import com.kingdee.eas.fi.rpt.ReportCaclFactory;
import com.kingdee.eas.fm.recon.SipgAccountDirectionEnum;
import com.kingdee.eas.fm.recon.SipgFmCashflow;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionEntryInfo;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionInfo;
import com.kingdee.eas.fm.recon.SipgFmReconMappingEntryInfo;
import com.kingdee.eas.fm.recon.SipgFmReconMappingInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

public class SipgFmReconStrategyBase
extends AbstractBizControllerBean {
    protected static String bizType;
    protected static PeriodInfo reconPeriod;
    protected static SipgFmReconMappingInfo reconMapping;
    protected static SipgFmReconDirectionInfo directionInfo;
    protected CompanyOrgUnitInfo currentCompany;
    protected static SimpleDateFormat sdf;
    protected int persion;
    protected static boolean radUnPosted;
    protected CurrencyInfo baseCurrency;

    protected boolean initParams(HashMap hmParams) {
        if (hmParams == null) {
            return false;
        }
        bizType = (String)hmParams.get("bizType");
        reconPeriod = (PeriodInfo)hmParams.get("reconPeriod");
        reconMapping = (SipgFmReconMappingInfo)hmParams.get("reconMapping");
        directionInfo = (SipgFmReconDirectionInfo)hmParams.get("reconDirection");
        this.currentCompany = (CompanyOrgUnitInfo)hmParams.get("companyInfo");
        this.baseCurrency = this.currentCompany.getBaseCurrency();
        if (hmParams.get("radUnPosted") != null) {
            radUnPosted = (Boolean)hmParams.get("radUnPosted");
        }
        this.persion = this.currentCompany.getBaseCurrency().getPrecision();
        return true;
    }

    protected HashMap getJournalBalance(Context ctx, AccountBankInfo account, String currency, PeriodInfo period) {
        if (account == null || period == null) {
            return null;
        }
        PeriodInfo prePeriod = null;
        try {
            prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)period);
            if (prePeriod == null) {
                prePeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        HashMap<String, BigDecimal> hmBal = new HashMap<String, BigDecimal>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("currency.number", (Object)currency, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)account.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)prePeriod.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isInit", (Object)false, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)AccountTypeEnum.BANKACCOUNT, CompareType.EQUALS));
        evi.setFilter(filter);
        try {
            BigDecimal jbBegin = new BigDecimal("0.00");
            jbBegin.setScale(this.persion);
            JournalBalanceCollection jbCol = JournalBalanceFactory.getLocalInstance((Context)ctx).getJournalBalanceCollection(evi);
            for (int i = 0; i < jbCol.size(); ++i) {
                JournalBalanceInfo jbInfo = jbCol.get(i);
                jbBegin = jbBegin.add(jbInfo.getMonthBalance());
            }
            EntityViewInfo eviJournal = new EntityViewInfo();
            FilterInfo filterJournal = new FilterInfo();
            filterJournal.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString(), CompareType.EQUALS));
            filterJournal.getFilterItems().add(new FilterItemInfo("accountView.number", (Object)"1002", CompareType.EQUALS));
            filterJournal.getFilterItems().add(new FilterItemInfo("currency.number", (Object)currency, CompareType.EQUALS));
            filterJournal.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)account.getId().toString(), CompareType.EQUALS));
            filterJournal.getFilterItems().add(new FilterItemInfo("period.id", (Object)period.getId().toString(), CompareType.EQUALS));
            filterJournal.getFilterItems().add(new FilterItemInfo("type", (Object)AccountTypeEnum.BANKACCOUNT, CompareType.EQUALS));
            eviJournal.setFilter(filterJournal);
            BigDecimal jbDebit = new BigDecimal("0.00");
            jbDebit.setScale(this.persion);
            BigDecimal jbCredit = new BigDecimal("0.00");
            jbCredit.setScale(this.persion);
            BigDecimal jbEnd = new BigDecimal("0.00");
            jbEnd.setScale(this.persion);
            JournalCollection jCol = JournalFactory.getLocalInstance((Context)ctx).getJournalCollection(eviJournal);
            for (int i = 0; i < jCol.size(); ++i) {
                JournalInfo journalInfo = jCol.get(i);
                jbDebit = jbDebit.add(journalInfo.getDebitAmount());
                jbCredit = jbCredit.add(journalInfo.getCreditAmount());
            }
            jbEnd = jbBegin.add(jbDebit).subtract(jbCredit);
            hmBal.put("jbBegin", jbBegin);
            hmBal.put("jbDebit", jbDebit);
            hmBal.put("jbCredit", jbCredit);
            hmBal.put("jbEnd", jbEnd);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return hmBal;
    }

    protected HashMap<String, BigDecimal> getGLBalance(Context ctx, SipgFmReconMappingEntryInfo mappingEntry, CurrencyInfo currencyInfo) {
        HashMap<String, BigDecimal> hmBal = new HashMap<String, BigDecimal>();
        String orgNumber = this.currentCompany.getNumber();
        String acctNumber = this.getAccountNumber(ctx, mappingEntry.getAccount().getId().toString());
        int periodYear = 0;
        int periodNumber = 0;
        try {
            periodYear = reconPeriod.getPeriodYear();
            periodNumber = reconPeriod.getPeriodNumber();
        }
        catch (UuidException e1) {
            e1.printStackTrace();
        }
        BigDecimal glBegin = new BigDecimal("0.00");
        glBegin.setScale(this.persion);
        BigDecimal glDebit = new BigDecimal("0.00");
        glDebit.setScale(this.persion);
        BigDecimal glCredit = new BigDecimal("0.00");
        glCredit.setScale(this.persion);
        BigDecimal glEnd = new BigDecimal("0.00");
        glEnd.setScale(this.persion);
        hmBal.put("glBegin", glBegin);
        hmBal.put("glDebit", glDebit);
        hmBal.put("glCredit", glCredit);
        hmBal.put("glEnd", glEnd);
        try {
            IReportCacl cacl = ReportCaclFactory.getLocalInstance((Context)ctx);
            glBegin = cacl.acct(orgNumber, acctNumber, BalanceTypeEnum.C, periodYear, periodNumber, periodYear, periodNumber, currencyInfo.getNumber(), false, radUnPosted, false);
            glDebit = cacl.acct(orgNumber, acctNumber, BalanceTypeEnum.JF, periodYear, periodNumber, periodYear, periodNumber, currencyInfo.getNumber(), false, radUnPosted, false);
            glCredit = cacl.acct(orgNumber, acctNumber, BalanceTypeEnum.DF, periodYear, periodNumber, periodYear, periodNumber, currencyInfo.getNumber(), false, radUnPosted, false);
            glEnd = cacl.acct(orgNumber, acctNumber, BalanceTypeEnum.Y, periodYear, periodNumber, periodYear, periodNumber, currencyInfo.getNumber(), false, radUnPosted, false);
            hmBal.put("glBegin", glBegin);
            hmBal.put("glDebit", glDebit);
            hmBal.put("glCredit", glCredit);
            hmBal.put("glEnd", glEnd);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return hmBal;
    }

    private String getAccountNumber(Context ctx, String accountId) {
        try {
            AccountViewInfo account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)accountId)));
            if (account != null) {
                return account.getNumber();
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected BOSObjectType getBOSType() {
        return null;
    }

    protected BigDecimal getGap(Object a, Object b) {
        if (a instanceof BigDecimal && b instanceof BigDecimal) {
            BigDecimal aa = (BigDecimal)a;
            BigDecimal bb = (BigDecimal)b;
            return aa.subtract(bb);
        }
        return new BigDecimal("-1");
    }

    protected HashMap<String, Object> getReturnValue(Context ctx, String fmNumber, String fmName, String glNumber, String glName, HashMap fmIncDec, CurrencyInfo currency, SipgFmReconMappingEntryInfo mappingEntry) {
        HashMap<String, Object> hmResult = new HashMap<String, Object>();
        hmResult.put("fmNumber", fmNumber);
        hmResult.put("fmName", fmName);
        if (!EmptyUtil.isEmpty((CoreBaseInfo)currency)) {
            hmResult.put("currency", currency.getName());
        } else {
            hmResult.put("currency", currency);
        }
        BigDecimal fmIncrease = (BigDecimal)fmIncDec.get("fmIncrease");
        hmResult.put("fmIncrease", fmIncrease);
        BigDecimal fmDecrease = (BigDecimal)fmIncDec.get("fmDecrease");
        hmResult.put("fmDecrease", fmDecrease);
        BigDecimal fmEnd = (BigDecimal)fmIncDec.get("fmEnd");
        BigDecimal fmBegin = fmEnd.add(fmDecrease).subtract(fmIncrease);
        hmResult.put("fmBegin", fmBegin);
        hmResult.put("fmEnd", fmEnd);
        hmResult.put("glNumber", glNumber);
        hmResult.put("glName", glName);
        HashMap<String, BigDecimal> hmGL = this.getGLBalance(ctx, mappingEntry, currency);
        BigDecimal glBegin = hmGL.get("glBegin");
        hmResult.put("glBegin", glBegin);
        BigDecimal glDebit = hmGL.get("glDebit");
        hmResult.put("glDebit", glDebit);
        BigDecimal glCredit = hmGL.get("glCredit");
        hmResult.put("glCredit", glCredit);
        BigDecimal glEnd = hmGL.get("glEnd");
        hmResult.put("glEnd", glEnd);
        Map directionSet = this.getdirection(directionInfo);
        BigDecimal zero = new BigDecimal("0.00");
        zero.setScale(2);
        SipgAccountDirectionEnum adddirection = (SipgAccountDirectionEnum)((Object)directionSet.get("add"));
        switch (Integer.parseInt(adddirection.getValue())) {
            case 1: {
                hmResult.put("increaseDifference", this.getGap(fmIncDec.get("fmIncrease"), hmGL.get("glDebit")));
                break;
            }
            case -1: {
                hmResult.put("increaseDifference", this.getGap(fmIncDec.get("fmIncrease"), hmGL.get("glCredit")));
                break;
            }
            case 0: {
                hmResult.put("increaseDifference", this.getGap(fmIncDec.get("fmIncrease"), zero));
            }
        }
        SipgAccountDirectionEnum lessdirection = (SipgAccountDirectionEnum)((Object)directionSet.get("less"));
        switch (Integer.parseInt(lessdirection.getValue())) {
            case 1: {
                hmResult.put("decreaseDifference", this.getGap(fmIncDec.get("fmDecrease"), hmGL.get("glDebit")));
                break;
            }
            case -1: {
                hmResult.put("decreaseDifference", this.getGap(fmIncDec.get("fmDecrease"), hmGL.get("glCredit")));
                break;
            }
            case 0: {
                hmResult.put("decreaseDifference", this.getGap(fmIncDec.get("fmDecrease"), zero));
            }
        }
        hmResult.put("beginDifference", this.getGap(fmBegin, hmGL.get("glBegin")));
        hmResult.put("gap", this.getGap(fmEnd, hmGL.get("glEnd")));
        hmResult.put("reconMapping", mappingEntry);
        hmResult.put("currenctInfo", currency);
        return hmResult;
    }

    private Map getdirection(SipgFmReconDirectionInfo sipgFmReconDirectionInfo) {
        HashMap<String, SipgAccountDirectionEnum> set = new HashMap<String, SipgAccountDirectionEnum>();
        SipgFmReconDirectionEntryInfo entryInfo = new SipgFmReconDirectionEntryInfo();
        for (int i = 0; i < sipgFmReconDirectionInfo.getEntrys().size(); ++i) {
            entryInfo = sipgFmReconDirectionInfo.getEntrys().get(i);
            if (entryInfo.getCashflow() == SipgFmCashflow.increase && !set.containsKey("add")) {
                set.put("add", entryInfo.getAccountDirection());
                continue;
            }
            if (entryInfo.getCashflow() != SipgFmCashflow.decrease || set.containsKey("less")) continue;
            set.put("less", entryInfo.getAccountDirection());
        }
        if (set.get("add") == null) {
            set.put("add", SipgAccountDirectionEnum.none);
        }
        if (set.get("less") == null) {
            set.put("less", SipgAccountDirectionEnum.none);
        }
        return set;
    }

    static {
        sdf = new SimpleDateFormat("yyyy-MM-dd");
        radUnPosted = false;
    }
}

