/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.recon.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.FinancingProductsFactory;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.ft.FundTransferBillCollection;
import com.kingdee.eas.fm.ft.FundTransferBillFactory;
import com.kingdee.eas.fm.ft.FundTransferBillInfo;
import com.kingdee.eas.fm.ft.FundTransferExtBillCollection;
import com.kingdee.eas.fm.ft.FundTransferExtBillFactory;
import com.kingdee.eas.fm.ft.FundTransferExtBillInfo;
import com.kingdee.eas.fm.ft.FundTransferRepayBillCollection;
import com.kingdee.eas.fm.ft.FundTransferRepayBillFactory;
import com.kingdee.eas.fm.ft.FundTransferRepayBillInfo;
import com.kingdee.eas.fm.recon.SipgFmCashflow;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionEntryCollection;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionEntryInfo;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionInfo;
import com.kingdee.eas.fm.recon.SipgFmReconMappingEntryInfo;
import com.kingdee.eas.fm.recon.app.ISipgFmReconStrategy;
import com.kingdee.eas.fm.recon.app.SipgFmReconStrategyBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SipgFundTransferBillStrategy
extends SipgFmReconStrategyBase
implements ISipgFmReconStrategy {
    private static final long serialVersionUID = 336692658876219746L;
    private static final Logger logger = CoreUIObject.getLogger(SipgFundTransferBillStrategy.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Map<String, Object>> _getReconResult(Context ctx, HashMap hmParams) {
        if (!this.initParams(hmParams)) {
            return null;
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        int i = 0;
        int count = reconMapping.getEntrys().size();
        while (true) {
            HashMap<String, BigDecimal> hmTDB_Detail;
            HashSet<CurrencyInfo> currencyId;
            HashMap<CurrencyInfo, Map<String, BigDecimal>> currencyMap;
            String glName;
            String glNumber;
            String fmName;
            String fmNumber;
            SipgFmReconMappingEntryInfo mappingEntry;
            block16: {
                if (i >= count) {
                    return result;
                }
                mappingEntry = reconMapping.getEntrys().get(i);
                fmNumber = null;
                fmName = null;
                glNumber = null;
                glName = null;
                try {
                    FinancingProductsInfo productsInfo = FinancingProductsFactory.getLocalInstance((Context)ctx).getFinancingProductsInfo((IObjectPK)new ObjectUuidPK(mappingEntry.getProducts().getId()));
                    fmNumber = productsInfo.getNumber();
                    fmName = productsInfo.getName();
                    AccountViewCollection accountViewCollection = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection("select name, number where id='" + mappingEntry.getAccount().getId().toString() + "'");
                    if (accountViewCollection.size() > 0) {
                        AccountViewInfo accountViewInfo = accountViewCollection.get(0);
                        glNumber = accountViewInfo.getNumber();
                        glName = accountViewInfo.getName();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                HashSet currencyIds = (HashSet)hmParams.get("currencyIds");
                currencyMap = this.getCurrencyFmEnd(ctx, mappingEntry, currencyIds);
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("account.number", glNumber, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("account.name", glName, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("sourceSys", (Object)6, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)5, CompareType.EQUALS));
                ev.getSelector().add(new SelectorItemInfo("currency.id"));
                ev.setFilter(filter);
                IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fi.gl.app.VoucherEntryQuery");
                IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
                exec.setObjectView(ev);
                currencyId = null;
                hmTDB_Detail = new HashMap<String, BigDecimal>();
                BigDecimal value = new BigDecimal("0.00");
                hmTDB_Detail.put("fmBegin", value);
                hmTDB_Detail.put("fmIncrease", value);
                hmTDB_Detail.put("fmDecrease", value);
                hmTDB_Detail.put("fmEnd", value);
                try {
                    IRowSet rs = exec.executeQuery();
                    if (rs.size() <= 0) break block16;
                    currencyId = new HashSet<CurrencyInfo>();
                    CurrencyInfo currencyInfo = null;
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("number"));
                    try {
                        while (rs.next()) {
                            String id = rs.getString("currency.id");
                            try {
                                currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(id), sic);
                                if (currencyInfo == null) continue;
                                currencyId.add(currencyInfo);
                            }
                            catch (EASBizException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            if (!EmptyUtil.isEmpty(currencyId)) {
                for (CurrencyInfo info : currencyId) {
                    if (currencyMap.containsKey(info)) continue;
                    currencyMap.put(info, hmTDB_Detail);
                }
            }
            for (CurrencyInfo cur : currencyMap.keySet()) {
                HashMap fmIncDec = (HashMap)currencyMap.get(cur);
                HashMap<String, Object> hmResult = this.getReturnValue(ctx, fmNumber, fmName, glNumber, glName, fmIncDec, cur, mappingEntry);
                result.add(hmResult);
            }
            ++i;
        }
    }

    private HashMap<CurrencyInfo, Map<String, BigDecimal>> getCurrencyFmEnd(Context ctx, SipgFmReconMappingEntryInfo mappingEntry, Set currencyIds) {
        Date bizDateStart = reconPeriod.getBeginDate();
        Timestamp bizDateEnd = reconPeriod.getEndDate();
        CurrencyInfo originalCurrency = null;
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("Currency.name"));
        sic.add(new SelectorItemInfo("Currency.number"));
        evi.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)this.currentCompany.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)sdf.format(bizDateEnd), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(this.getMappingFilter(mappingEntry));
        if (!EmptyUtil.isEmpty((Collection)currencyIds)) {
            filter.getFilterItems().add(new FilterItemInfo("Currency.id", (Object)currencyIds, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(this.getDirectionFilter());
        try {
            FundTransferBillCollection fundCol = FundTransferBillFactory.getLocalInstance((Context)ctx).getFundTransferBillCollection(evi);
            HashMap<CurrencyInfo, Map<String, BigDecimal>> hmTDB = new HashMap<CurrencyInfo, Map<String, BigDecimal>>();
            int count = fundCol.size();
            for (int i = 0; i < count; ++i) {
                HashMap<String, BigDecimal> hmTDB_Detail = new HashMap<String, BigDecimal>();
                FundTransferBillInfo fundInfo = fundCol.get(i);
                originalCurrency = fundInfo.getCurrency();
                HashMap hmIncDec = this.getFmIncDec(ctx, mappingEntry, directionInfo, bizDateStart, bizDateEnd, fundInfo.getCurrency(), fundInfo);
                BigDecimal bdIncs = (BigDecimal)hmIncDec.get("endIncrease");
                BigDecimal bdDecs = (BigDecimal)hmIncDec.get("endDecrease");
                BigDecimal fmEnd = bdIncs.subtract(bdDecs);
                BigDecimal fmInc = (BigDecimal)hmIncDec.get("fmIncrease");
                BigDecimal fmDec = (BigDecimal)hmIncDec.get("fmDecrease");
                BigDecimal fmBegin = fmEnd.add(fmDec).subtract(fmInc);
                hmTDB_Detail.put("fmBegin", fmBegin);
                hmTDB_Detail.put("fmIncrease", fmInc);
                hmTDB_Detail.put("fmDecrease", fmDec);
                hmTDB_Detail.put("fmEnd", fmEnd);
                if (hmTDB.containsKey(originalCurrency)) {
                    HashMap hashMap = (HashMap)hmTDB.get(originalCurrency);
                    BigDecimal fmsBegin = (BigDecimal)hashMap.get("fmBegin");
                    BigDecimal fmsIncrease = (BigDecimal)hashMap.get("fmIncrease");
                    BigDecimal fmsDecrease = (BigDecimal)hashMap.get("fmDecrease");
                    BigDecimal fmsEnd = (BigDecimal)hashMap.get("fmEnd");
                    hmTDB_Detail.put("fmBegin", fmsBegin.add(fmBegin));
                    hmTDB_Detail.put("fmIncrease", fmsIncrease.add(fmInc));
                    hmTDB_Detail.put("fmDecrease", fmsDecrease.add(fmDec));
                    hmTDB_Detail.put("fmEnd", fmsEnd.add(fmEnd));
                    hmTDB.put(originalCurrency, hmTDB_Detail);
                    continue;
                }
                hmTDB.put(originalCurrency, hmTDB_Detail);
            }
            if (fundCol.size() == 0) {
                logger.error((Object)"getCurrencyFmEnd,fundCol.size()==0");
                HashMap<String, BigDecimal> hmTDB_Detail = new HashMap<String, BigDecimal>();
                hmTDB_Detail.put("fmBegin", new BigDecimal("0.00").setScale(this.persion));
                hmTDB_Detail.put("fmIncrease", new BigDecimal("0.00").setScale(this.persion));
                hmTDB_Detail.put("fmDecrease", new BigDecimal("0.00").setScale(this.persion));
                hmTDB_Detail.put("fmEnd", new BigDecimal("0.00").setScale(this.persion));
                hmTDB.put(this.baseCurrency, hmTDB_Detail);
            }
            return hmTDB;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    private FilterItemInfo getDirectionFilter() {
        HashSet<Integer> state = new HashSet<Integer>();
        FilterItemInfo itemInfo = new FilterItemInfo();
        SipgFmReconDirectionEntryCollection directionEntryCollection = directionInfo.getEntrys();
        int count = directionEntryCollection.size();
        for (int i = 0; i < count; ++i) {
            SipgFmReconDirectionEntryInfo entryInfo = directionEntryCollection.get(i);
            if (entryInfo.getStatusName().equals("\u4fdd\u5b58") && !entryInfo.getCashflow().equals((Object)SipgFmCashflow.none)) {
                state.add(0);
                continue;
            }
            if (entryInfo.getStatusName().equals("\u63d0\u4ea4") && !entryInfo.getCashflow().equals((Object)SipgFmCashflow.none)) {
                state.add(1);
                continue;
            }
            if (!entryInfo.getStatusName().equals("\u5ba1\u6279") || entryInfo.getCashflow().equals((Object)SipgFmCashflow.none)) continue;
            state.add(3);
        }
        if (state.size() > 0) {
            itemInfo = new FilterItemInfo("status", state, CompareType.INCLUDE);
        } else {
            state.add(30);
            itemInfo = new FilterItemInfo("status", state, CompareType.INCLUDE);
        }
        return itemInfo;
    }

    private FilterItemInfo getMappingFilter(SipgFmReconMappingEntryInfo mappingEntry) {
        FilterItemInfo itemInfo = new FilterItemInfo();
        if (mappingEntry.getProducts() != null) {
            itemInfo = new FilterItemInfo("finacingProduct.id", (Object)mappingEntry.getProducts().getId().toString(), CompareType.EQUALS);
            return itemInfo;
        }
        if (mappingEntry.getInstitution() != null) {
            itemInfo = new FilterItemInfo("Institution", (Object)mappingEntry.getInstitution().getId().toString(), CompareType.EQUALS);
            return itemInfo;
        }
        return itemInfo;
    }

    private HashMap getFmIncDec(Context ctx, SipgFmReconMappingEntryInfo mappingEntry, SipgFmReconDirectionInfo reconDirection, Date bizDateStart, Date bizDateEnd, CurrencyInfo currency, FundTransferBillInfo fundInfo) {
        try {
            HashMap<String, BigDecimal> hashmap = new HashMap<String, BigDecimal>();
            BigDecimal fmIncrease = new BigDecimal("0.00");
            fmIncrease = fmIncrease.setScale(this.persion);
            BigDecimal fmDecrease = new BigDecimal("0.00");
            fmDecrease = fmDecrease.setScale(this.persion);
            BigDecimal bdIncrease = new BigDecimal("0.00");
            bdIncrease = bdIncrease.setScale(this.persion);
            BigDecimal bdDecrease = new BigDecimal("0.00");
            bdDecrease = bdDecrease.setScale(this.persion);
            String direction = null;
            HashMap fmIncDecMap = new HashMap();
            boolean ispred = this.IsInPeriod(fundInfo.getBizDate());
            switch (fundInfo.getStatus().getValue()) {
                case 1: {
                    direction = this.getDirectionType(reconDirection, 1);
                    break;
                }
                case 3: {
                    direction = this.getDirectionType(reconDirection, 2);
                    fmIncDecMap = this.getfmAmount(ctx, fundInfo, bizDateEnd, reconDirection);
                    fmIncrease = fmIncrease.add((BigDecimal)fmIncDecMap.get("fmIncrease"));
                    fmDecrease = fmDecrease.add((BigDecimal)fmIncDecMap.get("fmDecrease"));
                    bdIncrease = bdIncrease.add((BigDecimal)fmIncDecMap.get("endIncrease"));
                    bdDecrease = bdIncrease.add((BigDecimal)fmIncDecMap.get("endDecrease"));
                }
            }
            if (direction == "increase") {
                FundTransferRepayBillCollection repayAmoutColl = FundTransferRepayBillFactory.getLocalInstance((Context)ctx).getFundTransferRepayBillCollection("select repayAmt where loan = '" + fundInfo.getId().toString() + "'");
                Iterator it = repayAmoutColl.iterator();
                FundTransferRepayBillInfo repay = null;
                BigDecimal repayAmout = new BigDecimal("0.00");
                repayAmout = repayAmout.setScale(this.persion);
                while (it.hasNext()) {
                    repay = (FundTransferRepayBillInfo)it.next();
                    repayAmout = repayAmout.add(repay.getRepayAmt());
                }
                if (fundInfo.isIsHistoryBill()) {
                    bdIncrease = fundInfo.getLoanBalanceAmt();
                    bdIncrease = bdIncrease.add(repayAmout);
                } else {
                    bdIncrease = bdIncrease.add(fundInfo.getLoanAmt());
                }
                if (ispred) {
                    BigDecimal localBalance = fundInfo.getLoanBalanceAmt();
                    fmIncrease = fmIncrease.add(localBalance);
                    fmIncrease = fmIncrease.add(repayAmout);
                }
            } else if (direction == "decrease") {
                bdDecrease = bdDecrease.add(fundInfo.getLoanAmt());
                if (ispred) {
                    fmDecrease = fmDecrease.add(fundInfo.getLoanAmt());
                }
            }
            hashmap.put("fmIncrease", fmIncrease);
            hashmap.put("fmDecrease", fmDecrease);
            hashmap.put("endIncrease", bdIncrease);
            hashmap.put("endDecrease", bdDecrease);
            return hashmap;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    private HashMap getfmAmount(Context ctx, FundTransferBillInfo fundInfo, Date bizDateEnd, SipgFmReconDirectionInfo directionInfo2) throws BOSException {
        boolean ispred;
        BigDecimal fmIncrease = new BigDecimal("0.00");
        fmIncrease = fmIncrease.setScale(this.persion);
        BigDecimal fmDecrease = new BigDecimal("0.00");
        fmDecrease = fmDecrease.setScale(this.persion);
        BigDecimal bdIncrease = new BigDecimal("0.00");
        bdIncrease = bdIncrease.setScale(this.persion);
        BigDecimal bdDecrease = new BigDecimal("0.00");
        bdDecrease = bdDecrease.setScale(this.persion);
        EntityViewInfo eviDefer = new EntityViewInfo();
        FilterInfo filterDefer = new FilterInfo();
        eviDefer.setFilter(filterDefer);
        filterDefer.getFilterItems().add(new FilterItemInfo("loan", (Object)fundInfo.getId().toString(), CompareType.EQUALS));
        filterDefer.getFilterItems().add(new FilterItemInfo("bizDate", (Object)sdf.format(bizDateEnd), CompareType.LESS_EQUALS));
        FundTransferExtBillCollection fundExtCol = FundTransferExtBillFactory.getLocalInstance((Context)ctx).getFundTransferExtBillCollection(eviDefer);
        String direction = this.getDirectionType(directionInfo, 3);
        for (int i = 0; i < fundExtCol.size(); ++i) {
            FundTransferExtBillInfo fundExtInfo = fundExtCol.get(i);
            ispred = this.IsInPeriod(fundExtInfo.getBizDate());
        }
        EntityViewInfo eviRepayment = new EntityViewInfo();
        FilterInfo filterRepayment = new FilterInfo();
        filterRepayment.getFilterItems().add(new FilterItemInfo("bizDate", (Object)sdf.format(bizDateEnd), CompareType.LESS_EQUALS));
        filterRepayment.getFilterItems().add(new FilterItemInfo("loan", (Object)fundInfo.getId().toString(), CompareType.EQUALS));
        eviRepayment.setFilter(filterRepayment);
        FundTransferRepayBillCollection repayBillColl = FundTransferRepayBillFactory.getLocalInstance((Context)ctx).getFundTransferRepayBillCollection(eviRepayment);
        direction = this.getDirectionType(directionInfo, 4);
        int count = repayBillColl.size();
        for (int p = 0; p < count; ++p) {
            FundTransferRepayBillInfo repaymentBillInfo = repayBillColl.get(p);
            ispred = this.IsInPeriod(repaymentBillInfo.getBizDate());
            if (direction == "increase") {
                bdIncrease = bdIncrease.add(repaymentBillInfo.getRepayAmt());
                if (!ispred) continue;
                fmIncrease = fmIncrease.add(repaymentBillInfo.getRepayAmt());
                continue;
            }
            if (direction != "decrease") continue;
            bdDecrease = bdDecrease.add(repaymentBillInfo.getRepayAmt());
            if (!ispred) continue;
            fmDecrease = fmDecrease.add(repaymentBillInfo.getRepayAmt());
        }
        HashMap<String, BigDecimal> hashmap = new HashMap<String, BigDecimal>();
        hashmap.put("fmIncrease", fmIncrease);
        hashmap.put("fmDecrease", fmDecrease);
        hashmap.put("endIncrease", bdIncrease);
        hashmap.put("endDecrease", bdDecrease);
        return hashmap;
    }

    private String getDirectionType(SipgFmReconDirectionInfo directionInfo2, int i) {
        SipgFmReconDirectionEntryCollection directionEntryCollection = directionInfo.getEntrys();
        SipgFmReconDirectionEntryInfo entryInfo = directionEntryCollection.get(i);
        if (entryInfo.getCashflow() == SipgFmCashflow.increase) {
            return "increase";
        }
        if (entryInfo.getCashflow() == SipgFmCashflow.none) {
            return "none";
        }
        return "decrease";
    }

    private boolean IsInPeriod(Date bizDate) {
        if (bizDate == reconPeriod.getEndDate() || bizDate == reconPeriod.getBeginDate()) {
            return true;
        }
        return !bizDate.after(reconPeriod.getEndDate()) && !bizDate.before(reconPeriod.getBeginDate());
    }
}

