/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.recon.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.FinancingProductsFactory;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.fin.LoanInterestCollection;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.LoanInterestInfo;
import com.kingdee.eas.fm.recon.SipgFmCashflow;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionEntryCollection;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionEntryInfo;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionInfo;
import com.kingdee.eas.fm.recon.SipgFmReconMappingEntryInfo;
import com.kingdee.eas.fm.recon.app.ISipgFmReconStrategy;
import com.kingdee.eas.fm.recon.app.SipgFmReconStrategyBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SipgInterestStrategy
extends SipgFmReconStrategyBase
implements ISipgFmReconStrategy {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List _getReconResult(Context ctx, HashMap hmParams) {
        if (!this.initParams(hmParams)) {
            return null;
        }
        ArrayList<HashMap<String, Object>> result = new ArrayList<HashMap<String, Object>>();
        int i = 0;
        while (true) {
            HashMap<String, BigDecimal> hmTDB_Detail;
            HashSet<CurrencyInfo> currencyId;
            HashMap currencyMap;
            String glName;
            String glNumber;
            String fmName;
            String fmNumber;
            SipgFmReconMappingEntryInfo mappingEntry;
            block16: {
                if (i >= reconMapping.getEntrys().size()) {
                    return result;
                }
                ArrayList results = new ArrayList();
                mappingEntry = reconMapping.getEntrys().get(i);
                fmNumber = null;
                fmName = null;
                glNumber = null;
                glName = null;
                try {
                    FinancingProductsInfo productsInfo = FinancingProductsFactory.getLocalInstance((Context)ctx).getFinancingProductsInfo((IObjectPK)new ObjectUuidPK(mappingEntry.getProducts().getId()));
                    fmNumber = productsInfo.getNumber();
                    fmName = productsInfo.getName();
                    AccountViewCollection accountViewCollection = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection("select * where id='" + mappingEntry.getAccount().getId().toString() + "'");
                    if (accountViewCollection.size() > 0) {
                        AccountViewInfo accountViewInfo = accountViewCollection.get(0);
                        glNumber = accountViewInfo.getNumber();
                        glName = accountViewInfo.getName();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                HashSet currencyIds = (HashSet)hmParams.get("currencyIds");
                currencyMap = this.getCurrencyFmEnd(ctx, mappingEntry, currencyIds);
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("account.number", glNumber, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("account.name", glName, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("sourceSys", (Object)6, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)5, CompareType.EQUALS));
                ev.getSelector().add(new SelectorItemInfo("currency.id"));
                ev.setFilter(filter);
                IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fi.gl.app.VoucherEntryQuery");
                IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
                exec.setObjectView(ev);
                currencyId = null;
                hmTDB_Detail = new HashMap<String, BigDecimal>();
                BigDecimal value = new BigDecimal("0.00");
                hmTDB_Detail.put("fmBegin", value);
                hmTDB_Detail.put("fmIncrease", value);
                hmTDB_Detail.put("fmDecrease", value);
                hmTDB_Detail.put("fmEnd", value);
                try {
                    IRowSet rs = exec.executeQuery();
                    if (rs.size() <= 0) break block16;
                    currencyId = new HashSet<CurrencyInfo>();
                    try {
                        while (rs.next()) {
                            String id = rs.getString("currency.id");
                            try {
                                CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(id));
                                currencyId.add(currencyInfo);
                            }
                            catch (EASBizException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            if (!EmptyUtil.isEmpty(currencyId)) {
                Iterator it = currencyId.iterator();
                CurrencyInfo info = null;
                while (it.hasNext()) {
                    info = (CurrencyInfo)it.next();
                    if (currencyMap.containsKey(info)) continue;
                    currencyMap.put(info, hmTDB_Detail);
                }
            }
            for (CurrencyInfo cur : currencyMap.keySet()) {
                HashMap fmIncDec = (HashMap)currencyMap.get(cur);
                HashMap<String, Object> hmResult = this.getReturnValue(ctx, fmNumber, fmName, glNumber, glName, fmIncDec, cur, mappingEntry);
                result.add(hmResult);
            }
            ++i;
        }
    }

    private HashMap getCurrencyFmEnd(Context ctx, SipgFmReconMappingEntryInfo mappingEntry, Set currencyIds) {
        String productsId = mappingEntry.getProducts().getId().toString();
        Date bizDateStart = reconPeriod.getBeginDate();
        Timestamp bizDateEnd = reconPeriod.getEndDate();
        bizDateEnd.setHours(23);
        bizDateEnd.setMinutes(59);
        bizDateEnd.setSeconds(59);
        Date date = new Date();
        CurrencyInfo originalCurrency = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)this.currentCompany.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)sdf.format(bizDateEnd), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("loan.Type", (Object)productsId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isPrediction", (Object)new Boolean(false)));
        if (!EmptyUtil.isEmpty((Collection)currencyIds)) {
            filter.getFilterItems().add(new FilterItemInfo("Currency.id", (Object)currencyIds, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(this.getDirectionFilter());
        try {
            LoanInterestCollection liCol = LoanInterestFactory.getLocalInstance((Context)ctx).getLoanInterestCollection(evi);
            HashMap hmTDB = new HashMap();
            for (int i = 0; i < liCol.size(); ++i) {
                HashMap<String, BigDecimal> hmTDB_Detail = new HashMap<String, BigDecimal>();
                LoanInterestInfo loanInterestInfo = liCol.get(i);
                if (loanInterestInfo.getCurrency() != null && loanInterestInfo.getCurrency().getId() != null) {
                    try {
                        originalCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(loanInterestInfo.getCurrency().getId().toString()));
                        this.persion = originalCurrency.getPrecision();
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                    }
                }
                HashMap<String, BigDecimal> hmIncDec = this.getFmIncDec(ctx, mappingEntry, directionInfo, bizDateStart, bizDateEnd, loanInterestInfo.getCurrency(), loanInterestInfo);
                BigDecimal bdIncs = hmIncDec.get("endIncrease");
                BigDecimal bdDecs = hmIncDec.get("endDecrease");
                BigDecimal fmEnd = bdIncs.subtract(bdDecs);
                BigDecimal fmInc = hmIncDec.get("fmIncrease");
                BigDecimal fmDec = hmIncDec.get("fmDecrease");
                BigDecimal fmBegin = fmEnd.add(fmDec).subtract(fmInc);
                hmTDB_Detail.put("fmBegin", fmBegin);
                hmTDB_Detail.put("fmIncrease", fmInc);
                hmTDB_Detail.put("fmDecrease", fmDec);
                hmTDB_Detail.put("fmEnd", fmEnd);
                if (hmTDB.containsKey(originalCurrency)) {
                    HashMap hashMap = (HashMap)hmTDB.get(originalCurrency);
                    BigDecimal fmsBegin = (BigDecimal)hashMap.get("fmBegin");
                    BigDecimal fmsIncrease = (BigDecimal)hashMap.get("fmIncrease");
                    BigDecimal fmsDecrease = (BigDecimal)hashMap.get("fmDecrease");
                    BigDecimal fmsEnd = (BigDecimal)hashMap.get("fmEnd");
                    hmTDB_Detail.put("fmBegin", fmsBegin.add(fmBegin));
                    hmTDB_Detail.put("fmIncrease", fmsIncrease.add(fmInc));
                    hmTDB_Detail.put("fmDecrease", fmsDecrease.add(fmDec));
                    hmTDB_Detail.put("fmEnd", fmsEnd.add(fmEnd));
                    hmTDB.put(originalCurrency, hmTDB_Detail);
                    continue;
                }
                hmTDB.put(originalCurrency, hmTDB_Detail);
            }
            if (liCol.size() == 0) {
                HashMap<String, BigDecimal> hmTDB_Detail = new HashMap<String, BigDecimal>();
                hmTDB_Detail.put("fmBegin", new BigDecimal("0.00"));
                hmTDB_Detail.put("fmIncrease", new BigDecimal("0.00"));
                hmTDB_Detail.put("fmDecrease", new BigDecimal("0.00"));
                hmTDB_Detail.put("fmEnd", new BigDecimal("0.00"));
            }
            return hmTDB;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    private FilterItemInfo getDirectionFilter() {
        HashSet<Integer> state = new HashSet<Integer>();
        FilterItemInfo itemInfo = new FilterItemInfo();
        SipgFmReconDirectionEntryCollection directionEntryCollection = directionInfo.getEntrys();
        for (int i = 0; i < directionEntryCollection.size(); ++i) {
            SipgFmReconDirectionEntryInfo entryInfo = directionEntryCollection.get(i);
            if (entryInfo.getStatusName().equals("\u9884\u63d0") && !entryInfo.getCashflow().equals((Object)SipgFmCashflow.none)) {
                state.add(0);
                continue;
            }
            if (entryInfo.getStatusName().equals("\u4ed8\u606f") && !entryInfo.getCashflow().equals((Object)SipgFmCashflow.none)) {
                state.add(4);
                continue;
            }
            if (!entryInfo.getStatusName().equals("\u8fd8\u672c\u4ed8\u606f") || entryInfo.getCashflow().equals((Object)SipgFmCashflow.none)) continue;
            state.add(2);
        }
        if (state.size() > 0) {
            itemInfo = new FilterItemInfo("interestType", state, CompareType.INCLUDE);
        } else {
            state.add(10);
            itemInfo = new FilterItemInfo("interestType", state, CompareType.INCLUDE);
        }
        return itemInfo;
    }

    private HashMap<String, BigDecimal> getFmIncDec(Context ctx, SipgFmReconMappingEntryInfo mappingEntry, SipgFmReconDirectionInfo reconDirection, Date bizDateStart, Date bizDateEnd, CurrencyInfo currency, LoanInterestInfo loanInterestInfo) {
        HashMap<String, BigDecimal> hashmap = new HashMap<String, BigDecimal>();
        BigDecimal fmIncrease = new BigDecimal("0.00");
        fmIncrease = fmIncrease.setScale(this.persion);
        BigDecimal fmDecrease = new BigDecimal("0.00");
        fmDecrease = fmDecrease.setScale(this.persion);
        BigDecimal bdIncrease = new BigDecimal("0.00");
        bdIncrease = bdIncrease.setScale(this.persion);
        BigDecimal bdDecrease = new BigDecimal("0.00");
        bdDecrease = bdDecrease.setScale(this.persion);
        String direction = null;
        boolean ispred = this.IsInPeriod(loanInterestInfo.getBizDate());
        switch (loanInterestInfo.getInterestType().getValue()) {
            case 0: {
                direction = this.getDirectionType(directionInfo, 0);
                break;
            }
            case 4: {
                direction = this.getDirectionType(directionInfo, 1);
                break;
            }
            case 2: {
                direction = this.getDirectionType(directionInfo, 2);
            }
        }
        if (direction == "increase") {
            bdIncrease = bdIncrease.add(loanInterestInfo.getRealInterest());
            if (ispred) {
                fmIncrease = fmIncrease.add(loanInterestInfo.getRealInterest());
            }
        } else if (direction == "decrease") {
            bdDecrease = bdDecrease.add(loanInterestInfo.getRealInterest());
            if (ispred) {
                fmDecrease = fmDecrease.add(loanInterestInfo.getRealInterest());
            }
        }
        hashmap.put("fmIncrease", fmIncrease);
        hashmap.put("fmDecrease", fmDecrease);
        hashmap.put("endIncrease", bdIncrease);
        hashmap.put("endDecrease", bdDecrease);
        return hashmap;
    }

    private boolean IsInPeriod(Date bizDate) {
        if (bizDate == reconPeriod.getEndDate() || bizDate == reconPeriod.getBeginDate()) {
            return true;
        }
        return !bizDate.after(reconPeriod.getEndDate()) && !bizDate.before(reconPeriod.getBeginDate());
    }

    private String getDirectionType(SipgFmReconDirectionInfo directionInfo2, int i) {
        SipgFmReconDirectionEntryCollection directionEntryCollection = directionInfo.getEntrys();
        SipgFmReconDirectionEntryInfo entryInfo = directionEntryCollection.get(i);
        if (entryInfo.getCashflow() == SipgFmCashflow.increase) {
            return "increase";
        }
        if (entryInfo.getCashflow() == SipgFmCashflow.none) {
            return "none";
        }
        return "decrease";
    }
}

