/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.recon.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.FinancingProductsFactory;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.fin.LoanCollection;
import com.kingdee.eas.fm.fin.LoanDeferCollection;
import com.kingdee.eas.fm.fin.LoanDeferFactory;
import com.kingdee.eas.fm.fin.LoanDeferInfo;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.RepaymentCollection;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.recon.SipgFmCashflow;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionEntryCollection;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionEntryInfo;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionInfo;
import com.kingdee.eas.fm.recon.SipgFmReconMappingEntryInfo;
import com.kingdee.eas.fm.recon.app.ISipgFmReconStrategy;
import com.kingdee.eas.fm.recon.app.SipgFmReconStrategyBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SipgLoanBillStrategy
extends SipgFmReconStrategyBase
implements ISipgFmReconStrategy {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List _getReconResult(Context ctx, HashMap hmParams) {
        if (!this.initParams(hmParams)) {
            return null;
        }
        ArrayList<HashMap<String, Object>> result = new ArrayList<HashMap<String, Object>>();
        int i = 0;
        while (true) {
            HashMap<String, BigDecimal> hmTDB_Detail;
            HashSet<CurrencyInfo> currencyId;
            HashMap<CurrencyInfo, Map<String, BigDecimal>> currencyMap;
            String glName;
            String glNumber;
            String fmName;
            String fmNumber;
            SipgFmReconMappingEntryInfo mappingEntry;
            block16: {
                if (i >= reconMapping.getEntrys().size()) {
                    return result;
                }
                mappingEntry = reconMapping.getEntrys().get(i);
                fmNumber = null;
                fmName = null;
                glNumber = null;
                glName = null;
                Object accountId = null;
                try {
                    FinancingProductsInfo productsInfo = FinancingProductsFactory.getLocalInstance((Context)ctx).getFinancingProductsInfo((IObjectPK)new ObjectUuidPK(mappingEntry.getProducts().getId()));
                    fmNumber = productsInfo.getNumber();
                    fmName = productsInfo.getName();
                    AccountViewCollection accountViewCollection = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection("select * where id='" + mappingEntry.getAccount().getId().toString() + "'");
                    if (accountViewCollection.size() > 0) {
                        AccountViewInfo accountViewInfo = accountViewCollection.get(0);
                        glNumber = accountViewInfo.getNumber();
                        glName = accountViewInfo.getName();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                HashSet currencyIds = (HashSet)hmParams.get("currencyIds");
                currencyMap = this.getCurrencyFmEnd(ctx, mappingEntry, currencyIds);
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("account.number", glNumber, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("account.name", glName, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("sourceSys", (Object)6, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)5, CompareType.EQUALS));
                ev.getSelector().add(new SelectorItemInfo("currency.id"));
                ev.setFilter(filter);
                IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fi.gl.app.VoucherEntryQuery");
                IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
                exec.setObjectView(ev);
                currencyId = null;
                hmTDB_Detail = new HashMap<String, BigDecimal>();
                BigDecimal value = new BigDecimal("0.00");
                hmTDB_Detail.put("fmBegin", value);
                hmTDB_Detail.put("fmIncrease", value);
                hmTDB_Detail.put("fmDecrease", value);
                hmTDB_Detail.put("fmEnd", value);
                try {
                    IRowSet rs = exec.executeQuery();
                    if (rs.size() <= 0) break block16;
                    currencyId = new HashSet<CurrencyInfo>();
                    try {
                        while (rs.next()) {
                            String id = rs.getString("currency.id");
                            try {
                                CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(id));
                                currencyId.add(currencyInfo);
                            }
                            catch (EASBizException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            if (!EmptyUtil.isEmpty(currencyId)) {
                for (CurrencyInfo info : currencyId) {
                    if (currencyMap.containsKey(info)) continue;
                    currencyMap.put(info, hmTDB_Detail);
                }
            }
            for (CurrencyInfo cur : currencyMap.keySet()) {
                HashMap fmIncDec = (HashMap)currencyMap.get(cur);
                HashMap<String, Object> hmResult = this.getReturnValue(ctx, fmNumber, fmName, glNumber, glName, fmIncDec, cur, mappingEntry);
                result.add(hmResult);
            }
            ++i;
        }
    }

    private HashMap<CurrencyInfo, Map<String, BigDecimal>> getCurrencyFmEnd(Context ctx, SipgFmReconMappingEntryInfo mappingEntry, Set currencyIds) {
        Date bizDateStart = reconPeriod.getBeginDate();
        Timestamp bizDateEnd = reconPeriod.getEndDate();
        bizDateEnd.setHours(23);
        bizDateEnd.setMinutes(59);
        bizDateEnd.setSeconds(59);
        CurrencyInfo originalCurrency = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)this.currentCompany.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)sdf.format(bizDateEnd), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(this.getMappingFilter(mappingEntry));
        if (!EmptyUtil.isEmpty((Collection)currencyIds)) {
            filter.getFilterItems().add(new FilterItemInfo("Currency.id", (Object)currencyIds, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(this.getDirectionFilter());
        try {
            LoanCollection loanCol = LoanFactory.getLocalInstance((Context)ctx).getLoanCollection(evi);
            HashMap<CurrencyInfo, Map<String, BigDecimal>> hmTDB = new HashMap<CurrencyInfo, Map<String, BigDecimal>>();
            for (int i = 0; i < loanCol.size(); ++i) {
                HashMap<String, BigDecimal> hmTDB_Detail = new HashMap<String, BigDecimal>();
                LoanInfo loanInfo = loanCol.get(i);
                if (loanInfo.getCurrency() != null && loanInfo.getCurrency().getId() != null) {
                    try {
                        originalCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(loanInfo.getCurrency().getId().toString()));
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                    }
                }
                HashMap hmIncDec = this.getFmIncDec(ctx, mappingEntry, directionInfo, bizDateStart, bizDateEnd, loanInfo.getCurrency(), loanInfo);
                BigDecimal bdIncs = (BigDecimal)hmIncDec.get("endIncrease");
                BigDecimal bdDecs = (BigDecimal)hmIncDec.get("endDecrease");
                BigDecimal fmEnd = bdIncs.subtract(bdDecs);
                BigDecimal fmInc = (BigDecimal)hmIncDec.get("fmIncrease");
                BigDecimal fmDec = (BigDecimal)hmIncDec.get("fmDecrease");
                BigDecimal fmBegin = fmEnd.add(fmDec).subtract(fmInc);
                hmTDB_Detail.put("fmBegin", fmBegin);
                hmTDB_Detail.put("fmIncrease", fmInc);
                hmTDB_Detail.put("fmDecrease", fmDec);
                hmTDB_Detail.put("fmEnd", fmEnd);
                if (hmTDB.containsKey(originalCurrency)) {
                    HashMap hashMap = (HashMap)hmTDB.get(originalCurrency);
                    BigDecimal fmsBegin = (BigDecimal)hashMap.get("fmBegin");
                    BigDecimal fmsIncrease = (BigDecimal)hashMap.get("fmIncrease");
                    BigDecimal fmsDecrease = (BigDecimal)hashMap.get("fmDecrease");
                    BigDecimal fmsEnd = (BigDecimal)hashMap.get("fmEnd");
                    hmTDB_Detail.put("fmBegin", fmsBegin.add(fmBegin));
                    hmTDB_Detail.put("fmIncrease", fmsIncrease.add(fmInc));
                    hmTDB_Detail.put("fmDecrease", fmsDecrease.add(fmDec));
                    hmTDB_Detail.put("fmEnd", fmsEnd.add(fmEnd));
                    hmTDB.put(originalCurrency, hmTDB_Detail);
                    continue;
                }
                hmTDB.put(originalCurrency, hmTDB_Detail);
            }
            if (loanCol.size() == 0) {
                HashMap<String, BigDecimal> hmTDB_Detail = new HashMap<String, BigDecimal>();
                hmTDB_Detail.put("fmBegin", new BigDecimal("0.00").setScale(this.persion));
                hmTDB_Detail.put("fmIncrease", new BigDecimal("0.00").setScale(this.persion));
                hmTDB_Detail.put("fmDecrease", new BigDecimal("0.00").setScale(this.persion));
                hmTDB_Detail.put("fmEnd", new BigDecimal("0.00").setScale(this.persion));
            }
            return hmTDB;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    private FilterItemInfo getDirectionFilter() {
        HashSet<Integer> state = new HashSet<Integer>();
        FilterItemInfo itemInfo = new FilterItemInfo();
        SipgFmReconDirectionEntryCollection directionEntryCollection = directionInfo.getEntrys();
        for (int i = 0; i < directionEntryCollection.size(); ++i) {
            SipgFmReconDirectionEntryInfo entryInfo = directionEntryCollection.get(i);
            if (entryInfo.getStatusName().equals("\u63d0\u4ea4") && !entryInfo.getCashflow().equals((Object)SipgFmCashflow.none)) {
                state.add(1);
                continue;
            }
            if (!entryInfo.getStatusName().equals("\u5ba1\u6279") || entryInfo.getCashflow().equals((Object)SipgFmCashflow.none)) continue;
            state.add(3);
        }
        if (state.size() > 0) {
            itemInfo = new FilterItemInfo("status", state, CompareType.INCLUDE);
        } else {
            state.add(30);
            itemInfo = new FilterItemInfo("status", state, CompareType.INCLUDE);
        }
        return itemInfo;
    }

    private FilterItemInfo getMappingFilter(SipgFmReconMappingEntryInfo mappingEntry) {
        FilterItemInfo itemInfo = new FilterItemInfo();
        if (mappingEntry.getProducts() != null) {
            itemInfo = new FilterItemInfo("Type", (Object)mappingEntry.getProducts().getId().toString(), CompareType.EQUALS);
            return itemInfo;
        }
        if (mappingEntry.getInstitution() != null) {
            itemInfo = new FilterItemInfo("Institution", (Object)mappingEntry.getInstitution().getId().toString(), CompareType.EQUALS);
            return itemInfo;
        }
        return itemInfo;
    }

    private HashMap getFmIncDec(Context ctx, SipgFmReconMappingEntryInfo mappingEntry, SipgFmReconDirectionInfo reconDirection, Date bizDateStart, Date bizDateEnd, CurrencyInfo currency, LoanInfo loanInfo) {
        try {
            HashMap<String, BigDecimal> hashmap = new HashMap<String, BigDecimal>();
            BigDecimal fmIncrease = new BigDecimal("0.00");
            fmIncrease = fmIncrease.setScale(this.persion);
            BigDecimal fmDecrease = new BigDecimal("0.00");
            fmDecrease = fmDecrease.setScale(this.persion);
            BigDecimal bdIncrease = new BigDecimal("0.00");
            bdIncrease = bdIncrease.setScale(this.persion);
            BigDecimal bdDecrease = new BigDecimal("0.00");
            bdDecrease = bdDecrease.setScale(this.persion);
            String direction = null;
            HashMap fmIncDecMap = new HashMap();
            boolean ispred = this.IsInPeriod(loanInfo.getBizDate());
            switch (loanInfo.getStatus().getValue()) {
                case 1: {
                    direction = this.getDirectionType(reconDirection, 0);
                    break;
                }
                case 3: {
                    direction = this.getDirectionType(reconDirection, 1);
                    fmIncDecMap = this.getfmAmount(ctx, loanInfo, bizDateEnd, reconDirection);
                    fmIncrease = fmIncrease.add((BigDecimal)fmIncDecMap.get("fmIncrease"));
                    fmDecrease = fmDecrease.add((BigDecimal)fmIncDecMap.get("fmDecrease"));
                    bdIncrease = bdIncrease.add((BigDecimal)fmIncDecMap.get("endIncrease"));
                    bdDecrease = bdIncrease.add((BigDecimal)fmIncDecMap.get("endDecrease"));
                }
            }
            if (direction == "increase") {
                RepaymentCollection repayAmoutColl = RepaymentFactory.getLocalInstance((Context)ctx).getRepaymentCollection("select amount where sourceBillId = '" + loanInfo.getId().toString() + "'");
                Iterator it = repayAmoutColl.iterator();
                RepaymentInfo repay = null;
                BigDecimal repayAmout = new BigDecimal("0.00");
                repayAmout = repayAmout.setScale(this.persion);
                while (it.hasNext()) {
                    repay = (RepaymentInfo)it.next();
                    repayAmout = repayAmout.add(repay.getAmount());
                }
                if (loanInfo.isHistoryBill()) {
                    bdIncrease = loanInfo.getBalance();
                    bdIncrease = bdIncrease.add(repayAmout);
                } else {
                    bdIncrease = bdIncrease.add(loanInfo.getAmount());
                }
                if (ispred) {
                    BigDecimal localBalance = loanInfo.getBalance();
                    fmIncrease = fmIncrease.add(localBalance);
                    fmIncrease = fmIncrease.add(repayAmout);
                }
            } else if (direction == "decrease") {
                bdDecrease = bdDecrease.add(loanInfo.getAmount());
                if (ispred) {
                    fmDecrease = fmDecrease.add(loanInfo.getAmount());
                }
            }
            hashmap.put("fmIncrease", fmIncrease);
            hashmap.put("fmDecrease", fmDecrease);
            hashmap.put("endIncrease", bdIncrease);
            hashmap.put("endDecrease", bdDecrease);
            return hashmap;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    private HashMap getfmAmount(Context ctx, LoanInfo loanInfo, Date bizDateEnd, SipgFmReconDirectionInfo directionInfo2) throws BOSException {
        boolean ispred;
        BigDecimal fmIncrease = new BigDecimal("0.00");
        fmIncrease = fmIncrease.setScale(this.persion);
        BigDecimal fmDecrease = new BigDecimal("0.00");
        fmDecrease = fmDecrease.setScale(this.persion);
        BigDecimal bdIncrease = new BigDecimal("0.00");
        bdIncrease = bdIncrease.setScale(this.persion);
        BigDecimal bdDecrease = new BigDecimal("0.00");
        bdDecrease = bdDecrease.setScale(this.persion);
        EntityViewInfo eviDefer = new EntityViewInfo();
        FilterInfo filterDefer = new FilterInfo();
        eviDefer.setFilter(filterDefer);
        filterDefer.getFilterItems().add(new FilterItemInfo("loan", (Object)loanInfo.getId().toString(), CompareType.EQUALS));
        filterDefer.getFilterItems().add(new FilterItemInfo("bizDate", (Object)sdf.format(bizDateEnd), CompareType.LESS_EQUALS));
        LoanDeferCollection loanDeferCol = LoanDeferFactory.getLocalInstance((Context)ctx).getLoanDeferCollection(eviDefer);
        String direction = this.getDirectionType(directionInfo, 2);
        for (int i = 0; i < loanDeferCol.size(); ++i) {
            LoanDeferInfo billInfo = loanDeferCol.get(i);
            ispred = this.IsInPeriod(billInfo.getBizDate());
            if (direction == "increase") {
                bdIncrease = bdIncrease.add(billInfo.getLocalAmount());
                if (!ispred) continue;
                fmIncrease = fmIncrease.add(billInfo.getLocalAmount());
                continue;
            }
            if (direction != "decrease") continue;
            bdDecrease = bdDecrease.add(billInfo.getLocalAmount());
            if (!ispred) continue;
            fmDecrease = fmDecrease.add(billInfo.getLocalAmount());
        }
        EntityViewInfo eviRepayment = new EntityViewInfo();
        FilterInfo filterRepayment = new FilterInfo();
        filterRepayment.getFilterItems().add(new FilterItemInfo("bizDate", (Object)sdf.format(bizDateEnd), CompareType.LESS_EQUALS));
        filterRepayment.getFilterItems().add(new FilterItemInfo("loan", (Object)loanInfo.getId().toString(), CompareType.EQUALS));
        eviRepayment.setFilter(filterRepayment);
        RepaymentCollection repaymentCol = RepaymentFactory.getLocalInstance((Context)ctx).getRepaymentCollection(eviRepayment);
        direction = this.getDirectionType(directionInfo, 3);
        for (int p = 0; p < repaymentCol.size(); ++p) {
            RepaymentInfo repaymentInfo = repaymentCol.get(p);
            ispred = this.IsInPeriod(repaymentInfo.getBizDate());
            if (direction == "increase") {
                bdIncrease = bdIncrease.add(repaymentInfo.getAmount());
                if (!ispred) continue;
                fmIncrease = fmIncrease.add(repaymentInfo.getAmount());
                continue;
            }
            if (direction != "decrease") continue;
            bdDecrease = bdDecrease.add(repaymentInfo.getAmount());
            if (!ispred) continue;
            fmDecrease = fmDecrease.add(repaymentInfo.getAmount());
        }
        HashMap<String, BigDecimal> hashmap = new HashMap<String, BigDecimal>();
        hashmap.put("fmIncrease", fmIncrease);
        hashmap.put("fmDecrease", fmDecrease);
        hashmap.put("endIncrease", bdIncrease);
        hashmap.put("endDecrease", bdDecrease);
        return hashmap;
    }

    private String getDirectionType(SipgFmReconDirectionInfo directionInfo2, int i) {
        SipgFmReconDirectionEntryCollection directionEntryCollection = directionInfo.getEntrys();
        SipgFmReconDirectionEntryInfo entryInfo = directionEntryCollection.get(i);
        if (entryInfo.getCashflow() == SipgFmCashflow.increase) {
            return "increase";
        }
        if (entryInfo.getCashflow() == SipgFmCashflow.none) {
            return "none";
        }
        return "decrease";
    }

    private boolean IsInPeriod(Date bizDate) {
        if (bizDate == reconPeriod.getEndDate() || bizDate == reconPeriod.getBeginDate()) {
            return true;
        }
        return !bizDate.after(reconPeriod.getEndDate()) && !bizDate.before(reconPeriod.getBeginDate());
    }
}

