/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.recon.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fm.recon.SipgFmCashflow;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionEntryCollection;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionEntryInfo;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionInfo;
import com.kingdee.eas.fm.recon.SipgFmReconMappingEntryInfo;
import com.kingdee.eas.fm.recon.app.ISipgFmReconStrategy;
import com.kingdee.eas.fm.recon.app.SipgFmReconStrategyBase;
import com.kingdee.eas.fm.td.TimeDepositBillCollection;
import com.kingdee.eas.fm.td.TimeDepositBillFactory;
import com.kingdee.eas.fm.td.TimeDepositBillInfo;
import com.kingdee.eas.fm.td.UnTimeDepositBillCollection;
import com.kingdee.eas.fm.td.UnTimeDepositBillFactory;
import com.kingdee.eas.fm.td.UnTimeDepositBillInfo;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class SipgTimeDeopsitStrategy
extends SipgFmReconStrategyBase
implements ISipgFmReconStrategy {
    @Override
    public List _getReconResult(Context ctx, HashMap hmParams) {
        if (!this.initParams(hmParams)) {
            return null;
        }
        HashMap bankDepAcctHashMap = new HashMap();
        ArrayList results = new ArrayList();
        AccountBankInfo bankInfo = null;
        for (int i = 0; i < reconMapping.getEntrys().size(); ++i) {
            SipgFmReconMappingEntryInfo mappingEntry = reconMapping.getEntrys().get(i);
            String fmNumber = null;
            String fmName = null;
            Object glNumber = null;
            Object glName = null;
            try {
                this.baseCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.baseCurrency.getId()));
                bankInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(mappingEntry.getAccountBank().getId()));
                fmNumber = bankInfo.getBankAccountNumber();
                fmName = bankInfo.getName();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            HashMap currencyMap = this.getCurrencyFmEnd(ctx, mappingEntry);
            HashMap fmIncDec = (HashMap)currencyMap.get(mappingEntry);
            HashMap hmJB = this.getJournalBalance(ctx, bankInfo, this.baseCurrency.getNumber(), reconPeriod);
            HashMap<String, Object> hmResult = new HashMap<String, Object>();
            hmResult.put("fmNumber", fmNumber);
            hmResult.put("fmName", fmName);
            hmResult.put("currenctInfo", this.baseCurrency);
            hmResult.put("currency", this.baseCurrency.getName());
            hmResult.put("fmBegin", fmIncDec.get("fmBegin"));
            hmResult.put("fmIncrease", fmIncDec.get("fmIncrease"));
            hmResult.put("fmDecrease", fmIncDec.get("fmDecrease"));
            hmResult.put("fmEnd", fmIncDec.get("fmEnd"));
            hmResult.put("glNumber", fmNumber);
            hmResult.put("glName", fmNumber);
            hmResult.put("glBegin", hmJB.get("jbBegin"));
            hmResult.put("glDebit", hmJB.get("jbDebit"));
            hmResult.put("glCredit", hmJB.get("jbCredit"));
            hmResult.put("glEnd", hmJB.get("jbEnd"));
            hmResult.put("beginDifference", this.getGap(fmIncDec.get("fmBegin"), hmJB.get("jbBegin")));
            hmResult.put("increaseDifference", this.getGap(fmIncDec.get("fmIncrease"), hmJB.get("jbDebit")));
            hmResult.put("decreaseDifference", this.getGap(fmIncDec.get("fmDecrease"), hmJB.get("jbCredit")));
            hmResult.put("gap", this.getGap(fmIncDec.get("fmEnd"), hmJB.get("jbEnd")));
            hmResult.put("reconMapping", mappingEntry);
            results.add(hmResult);
        }
        return results;
    }

    private HashMap getCurrencyFmEnd(Context ctx, SipgFmReconMappingEntryInfo mappingEntry) {
        Date bizDateStart = reconPeriod.getBeginDate();
        Timestamp bizDateEnd = reconPeriod.getEndDate();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)this.currentCompany.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)sdf.format(bizDateEnd), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(this.getMappingFilter(mappingEntry));
        filter.getFilterItems().add(this.getDirectionFilter());
        try {
            TimeDepositBillCollection rbCol = TimeDepositBillFactory.getLocalInstance((Context)ctx).getTimeDepositBillCollection(evi);
            HashMap hmTDB = new HashMap();
            for (int i = 0; i < rbCol.size(); ++i) {
                HashMap<String, BigDecimal> hmTDB_Detail = new HashMap<String, BigDecimal>();
                TimeDepositBillInfo depositBillInfo = rbCol.get(i);
                HashMap hmIncDec = this.getFmIncDec(ctx, mappingEntry, directionInfo, bizDateStart, bizDateEnd, depositBillInfo.getCurrency(), depositBillInfo);
                BigDecimal bdIncs = (BigDecimal)hmIncDec.get("endIncrease");
                BigDecimal bdDecs = (BigDecimal)hmIncDec.get("endDecrease");
                BigDecimal fmEnd = bdIncs.subtract(bdDecs);
                BigDecimal fmInc = (BigDecimal)hmIncDec.get("fmIncrease");
                BigDecimal fmDec = (BigDecimal)hmIncDec.get("fmDecrease");
                BigDecimal fmBegin = fmEnd.add(fmDec).subtract(fmInc);
                hmTDB_Detail.put("fmBegin", fmBegin);
                hmTDB_Detail.put("fmIncrease", fmInc);
                hmTDB_Detail.put("fmDecrease", fmDec);
                hmTDB_Detail.put("fmEnd", fmEnd);
                if (hmTDB.containsKey(mappingEntry)) {
                    HashMap hashMap = (HashMap)hmTDB.get(mappingEntry);
                    BigDecimal fmsBegin = (BigDecimal)hashMap.get("fmBegin");
                    BigDecimal fmsIncrease = (BigDecimal)hashMap.get("fmIncrease");
                    BigDecimal fmsDecrease = (BigDecimal)hashMap.get("fmDecrease");
                    BigDecimal fmsEnd = (BigDecimal)hashMap.get("fmEnd");
                    hmTDB_Detail.put("fmBegin", fmsBegin.add(fmBegin));
                    hmTDB_Detail.put("fmIncrease", fmsIncrease.add(fmInc));
                    hmTDB_Detail.put("fmDecrease", fmsDecrease.add(fmDec));
                    hmTDB_Detail.put("fmEnd", fmsEnd.add(fmEnd));
                    hmTDB.put(mappingEntry, hmTDB_Detail);
                    continue;
                }
                hmTDB.put(mappingEntry, hmTDB_Detail);
            }
            if (rbCol.size() == 0) {
                HashMap<String, BigDecimal> hmTDB_Detail = new HashMap<String, BigDecimal>();
                hmTDB_Detail.put("fmBegin", new BigDecimal("0.00"));
                hmTDB_Detail.put("fmIncrease", new BigDecimal("0.00"));
                hmTDB_Detail.put("fmDecrease", new BigDecimal("0.00"));
                hmTDB_Detail.put("fmEnd", new BigDecimal("0.00"));
                hmTDB.put(mappingEntry, hmTDB_Detail);
            }
            return hmTDB;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    private HashMap getFmIncDec(Context ctx, SipgFmReconMappingEntryInfo mappingEntry, SipgFmReconDirectionInfo reconDirection, Date bizDateStart, Date bizDateEnd, CurrencyInfo currency, TimeDepositBillInfo depositBillInfo) {
        try {
            HashMap<String, BigDecimal> hashmap = new HashMap<String, BigDecimal>();
            BigDecimal fmIncrease = new BigDecimal("0.00");
            fmIncrease = fmIncrease.setScale(this.persion);
            BigDecimal fmDecrease = new BigDecimal("0.00");
            fmDecrease = fmDecrease.setScale(this.persion);
            BigDecimal bdIncrease = new BigDecimal("0.00");
            bdIncrease = bdIncrease.setScale(this.persion);
            BigDecimal bdDecrease = new BigDecimal("0.00");
            bdDecrease = bdDecrease.setScale(this.persion);
            String direction = null;
            HashMap fmIncDecMap = new HashMap();
            HashMap fmcisAddBydepositMap = new HashMap();
            boolean ispred = this.IsInPeriod(depositBillInfo.getBizDate());
            switch (depositBillInfo.getEffectedStatus().getValue()) {
                case 1: {
                    direction = this.getDirectionType(directionInfo, 0);
                    fmcisAddBydepositMap = this.getaddBydeposit(depositBillInfo);
                    fmIncrease = fmIncrease.add((BigDecimal)fmcisAddBydepositMap.get("fmIncrease"));
                    fmDecrease = fmDecrease.add((BigDecimal)fmcisAddBydepositMap.get("fmDecrease"));
                    bdIncrease = bdIncrease.add((BigDecimal)fmcisAddBydepositMap.get("endIncrease"));
                    bdDecrease = bdIncrease.add((BigDecimal)fmcisAddBydepositMap.get("endDecrease"));
                    break;
                }
                case 2: {
                    direction = this.getDirectionType(directionInfo, 1);
                    fmIncDecMap = this.getfmAmount(ctx, depositBillInfo, bizDateEnd, directionInfo);
                    fmIncrease = fmIncrease.add((BigDecimal)fmIncDecMap.get("fmIncrease"));
                    fmDecrease = fmDecrease.add((BigDecimal)fmIncDecMap.get("fmDecrease"));
                    bdIncrease = bdIncrease.add((BigDecimal)fmIncDecMap.get("endIncrease"));
                    bdDecrease = bdIncrease.add((BigDecimal)fmIncDecMap.get("endDecrease"));
                }
            }
            if (direction == "increase") {
                bdIncrease = bdIncrease.add(depositBillInfo.getDepositLocalAmt());
                if (ispred) {
                    fmIncrease = fmIncrease.add(depositBillInfo.getDepositLocalAmt());
                }
            } else if (direction == "decrease") {
                bdDecrease = bdDecrease.add(depositBillInfo.getDepositLocalAmt());
                if (ispred) {
                    fmDecrease = fmDecrease.add(depositBillInfo.getDepositLocalAmt());
                }
            }
            hashmap.put("fmIncrease", fmIncrease);
            hashmap.put("fmDecrease", fmDecrease);
            hashmap.put("endIncrease", bdIncrease);
            hashmap.put("endDecrease", bdDecrease);
            return hashmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private HashMap getaddBydeposit(TimeDepositBillInfo depositBillInfo) {
        BigDecimal fmIncrease = new BigDecimal("0.00");
        fmIncrease = fmIncrease.setScale(this.persion);
        BigDecimal fmDecrease = new BigDecimal("0.00");
        fmDecrease = fmDecrease.setScale(this.persion);
        BigDecimal bdIncrease = new BigDecimal("0.00");
        bdIncrease = bdIncrease.setScale(this.persion);
        BigDecimal bdDecrease = new BigDecimal("0.00");
        bdDecrease = bdDecrease.setScale(this.persion);
        String direction = this.getDirectionType(directionInfo, 2);
        if (depositBillInfo.isIsAddedByReDeposit()) {
            boolean ispred = this.IsInPeriod(depositBillInfo.getBizDate());
            if (direction == "increase") {
                bdIncrease = bdIncrease.add(depositBillInfo.getDepositLocalAmt());
                if (ispred) {
                    fmIncrease = fmIncrease.add(depositBillInfo.getDepositLocalAmt());
                }
            } else if (direction == "decrease") {
                bdDecrease = bdDecrease.add(depositBillInfo.getDepositLocalAmt());
                if (ispred) {
                    fmDecrease = fmDecrease.add(depositBillInfo.getDepositLocalAmt());
                }
            }
        }
        HashMap<String, BigDecimal> hashmap = new HashMap<String, BigDecimal>();
        hashmap.put("fmIncrease", fmIncrease);
        hashmap.put("fmDecrease", fmDecrease);
        hashmap.put("endIncrease", bdIncrease);
        hashmap.put("endDecrease", bdDecrease);
        return null;
    }

    private HashMap getfmAmount(Context ctx, TimeDepositBillInfo depositBillInfo, Date bizDateEnd, SipgFmReconDirectionInfo directionInfo) throws BOSException {
        boolean ispred;
        BigDecimal fmIncrease = new BigDecimal("0.00");
        fmIncrease = fmIncrease.setScale(this.persion);
        BigDecimal fmDecrease = new BigDecimal("0.00");
        fmDecrease = fmDecrease.setScale(this.persion);
        BigDecimal bdIncrease = new BigDecimal("0.00");
        bdIncrease = bdIncrease.setScale(this.persion);
        BigDecimal bdDecrease = new BigDecimal("0.00");
        bdDecrease = bdDecrease.setScale(this.persion);
        EntityViewInfo eviUnTime = new EntityViewInfo();
        FilterInfo filterUnTime = new FilterInfo();
        eviUnTime.setFilter(filterUnTime);
        filterUnTime.getFilterItems().add(new FilterItemInfo("bizDate", (Object)sdf.format(bizDateEnd), CompareType.LESS_EQUALS));
        filterUnTime.getFilterItems().add(new FilterItemInfo("timeDepositBill", (Object)depositBillInfo.getId().toString(), CompareType.EQUALS));
        UnTimeDepositBillCollection utdCol = UnTimeDepositBillFactory.getLocalInstance((Context)ctx).getUnTimeDepositBillCollection(eviUnTime);
        String direction = this.getDirectionType(directionInfo, 3);
        for (int i = 0; i < utdCol.size(); ++i) {
            UnTimeDepositBillInfo billInfo = utdCol.get(i);
            ispred = this.IsInPeriod(billInfo.getBizDate());
            if (direction == "increase") {
                bdIncrease = bdIncrease.add(billInfo.getUnDepositAmtLocal());
                if (!ispred) continue;
                fmIncrease = fmIncrease.add(billInfo.getUnDepositAmtLocal());
                continue;
            }
            if (direction != "decrease") continue;
            bdDecrease = bdDecrease.add(billInfo.getUnDepositAmtLocal());
            if (!ispred) continue;
            fmDecrease = fmDecrease.add(billInfo.getUnDepositAmtLocal());
        }
        direction = this.getDirectionType(directionInfo, 2);
        if (depositBillInfo.isIsAddedByReDeposit()) {
            ispred = this.IsInPeriod(depositBillInfo.getBizDate());
            if (direction == "increase") {
                bdIncrease = bdIncrease.add(depositBillInfo.getDepositLocalAmt());
                if (ispred) {
                    fmIncrease = fmIncrease.add(depositBillInfo.getDepositLocalAmt());
                }
            } else if (direction == "decrease") {
                bdDecrease = bdDecrease.add(depositBillInfo.getDepositLocalAmt());
                if (ispred) {
                    fmDecrease = fmDecrease.add(depositBillInfo.getDepositLocalAmt());
                }
            }
        }
        HashMap<String, BigDecimal> hashmap = new HashMap<String, BigDecimal>();
        hashmap.put("fmIncrease", fmIncrease);
        hashmap.put("fmDecrease", fmDecrease);
        hashmap.put("endIncrease", bdIncrease);
        hashmap.put("endDecrease", bdDecrease);
        return hashmap;
    }

    private boolean IsInPeriod(Date bizDate) {
        if (bizDate == reconPeriod.getEndDate() || bizDate == reconPeriod.getBeginDate()) {
            return true;
        }
        return !bizDate.after(reconPeriod.getEndDate()) && !bizDate.before(reconPeriod.getBeginDate());
    }

    private String getDirectionType(SipgFmReconDirectionInfo directionInfo2, int i) {
        SipgFmReconDirectionEntryCollection directionEntryCollection = directionInfo.getEntrys();
        SipgFmReconDirectionEntryInfo entryInfo = directionEntryCollection.get(i);
        if (entryInfo.getCashflow() == SipgFmCashflow.increase) {
            return "increase";
        }
        if (entryInfo.getCashflow() == SipgFmCashflow.none) {
            return "none";
        }
        return "decrease";
    }

    private FilterItemInfo getMappingFilter(SipgFmReconMappingEntryInfo mappingEntry) {
        FilterItemInfo itemInfo = new FilterItemInfo();
        if (mappingEntry.getAccountBank() != null) {
            itemInfo = new FilterItemInfo("bankDepAcct", (Object)mappingEntry.getAccountBank().getId().toString(), CompareType.EQUALS);
            return itemInfo;
        }
        return itemInfo;
    }

    private FilterItemInfo getDirectionFilter() {
        HashSet<Integer> state = new HashSet<Integer>();
        FilterItemInfo itemInfo = new FilterItemInfo();
        SipgFmReconDirectionEntryCollection directionEntryCollection = directionInfo.getEntrys();
        for (int i = 0; i < directionEntryCollection.size(); ++i) {
            SipgFmReconDirectionEntryInfo entryInfo = directionEntryCollection.get(i);
            if (entryInfo.getStatusName().equals("\u4fdd\u5b58") && !entryInfo.getCashflow().equals((Object)SipgFmCashflow.none)) {
                state.add(1);
                continue;
            }
            if (!entryInfo.getStatusName().equals("\u751f\u6548") || entryInfo.getCashflow().equals((Object)SipgFmCashflow.none)) continue;
            state.add(2);
        }
        if (state.size() > 0) {
            itemInfo = new FilterItemInfo("effectedStatus", state, CompareType.INCLUDE);
        } else {
            state.add(20);
            itemInfo = new FilterItemInfo("effectedStatus", state, CompareType.INCLUDE);
        }
        return itemInfo;
    }
}

