/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpa.app;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.rpa.RPAAddressInfo;
import com.kingdee.eas.fm.rpa.RPAScheJobCollection;
import com.kingdee.eas.fm.rpa.RPAScheJobFactory;
import com.kingdee.eas.fm.rpa.RPAScheJobInfo;
import com.kingdee.eas.fm.rpa.app.AbstractRPAScheJobControllerBean;
import com.kingdee.eas.fm.rpa.app.service.IRpaInvoker;
import com.kingdee.eas.fm.rpa.app.service.RpaGetProcessSch;
import com.kingdee.eas.fm.rpa.app.service.RpaInvokerFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class RPAScheJobControllerBean
extends AbstractRPAScheJobControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.rpa.app.RPAScheJobControllerBean");

    @Override
    protected Map _syncScheJob(Context ctx, String id) throws BOSException, EASBizException {
        RPAScheJobInfo process = this.getRPAScheJob(ctx, id);
        RPAAddressInfo rpaaddress = process.getRpaAdd();
        RpaGetProcessSch rpa = new RpaGetProcessSch();
        rpa.setToken(rpaaddress.getToken());
        rpa.setUrl(rpaaddress.getAddress());
        rpa.setAppkey(rpaaddress.getAppkey());
        String simpleName = rpaaddress.getSimpleName();
        rpa.setIsaType(simpleName);
        IRpaInvoker iRpainvoker = RpaInvokerFactory.getRpaInvoker(ctx, simpleName);
        JSONObject result = iRpainvoker.request(rpa);
        Map curScheJobMap = this.getCurScheJobMap(ctx);
        CoreBaseCollection coll = iRpainvoker.parseScheJob(rpaaddress, result, curScheJobMap);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)coll) && coll.size() > 0) {
            RPAScheJobFactory.getLocalInstance(ctx).addnew(coll);
        }
        return null;
    }

    private Map getCurScheJobMap(Context ctx) throws BOSException {
        HashMap<String, RPAScheJobInfo> curMap = new HashMap<String, RPAScheJobInfo>();
        RPAScheJobCollection curColl = RPAScheJobFactory.getLocalInstance(ctx).getRPAScheJobCollection();
        for (int i = 0; i < curColl.size(); ++i) {
            RPAScheJobInfo curInfo = curColl.get(i);
            curMap.put(curInfo.getScheID(), curInfo);
        }
        return curMap;
    }

    private RPAScheJobInfo getRPAScheJob(Context ctx, String id) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("RPAAdd.*"));
        view.setSelector(sic);
        RPAScheJobCollection coll = RPAScheJobFactory.getLocalInstance(ctx).getRPAScheJobCollection(view);
        RPAScheJobInfo info = null;
        if (coll != null && coll.size() > 0) {
            info = coll.get(0);
        }
        return info;
    }
}

