/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.rpa.RPAException;
import com.kingdee.eas.fm.rpa.SolutionSettingEntryFactory;
import com.kingdee.eas.fm.rpa.UkeyAccountBankCollection;
import com.kingdee.eas.fm.rpa.UkeyAccountBankInfo;
import com.kingdee.eas.fm.rpa.UkeyCollection;
import com.kingdee.eas.fm.rpa.UkeyInfo;
import com.kingdee.eas.fm.rpa.app.AbstractUkeyControllerBean;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class UkeyControllerBean
extends AbstractUkeyControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.rpa.app.UkeyControllerBean");
    private static final String FLAG = "******";

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UkeyInfo info = (UkeyInfo)model;
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"name");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"rPABank");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        boolean isNumberDup = this.exists(ctx, filter);
        if (isNumberDup) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{info.getNumber(), ""});
        }
        UkeyAccountBankCollection acctColl = info.getUkeyAccBank();
        if (acctColl == null || acctColl.size() == 0) {
            throw new RPAException(RPAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"ENTRY_NUll")});
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < acctColl.size(); ++i) {
            UkeyAccountBankInfo ukeyAcctInfo = acctColl.get(i);
            AccountBankInfo acctBank = ukeyAcctInfo.getBankAccount();
            if (acctBank == null) {
                throw new RPAException(RPAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"ENTRY_ACCTBANK_NUll")});
            }
            String seq = (String)map.get(acctBank.getId().toString());
            if (seq != null) {
                throw new RPAException(RPAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"ENTRY_ACCTBANK_DUP")});
            }
            map.put(acctBank.getId().toString(), String.valueOf(i + 1));
        }
        if (FLAG.equals(info.getUserPassWord()) || FLAG.equals(info.getKeyPassWord())) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("userPassWord"));
            sic.add(new SelectorItemInfo("keyPassWord"));
            FilterInfo file = new FilterInfo();
            file.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
            view.setFilter(file);
            UkeyCollection coll = this.getUkeyCollection(ctx, view);
            UkeyInfo uInfo = coll.get(0);
            if (FLAG.equals(info.getUserPassWord())) {
                if (uInfo != null) {
                    info.setUserPassWord(uInfo.getUserPassWord());
                } else {
                    info.setUserPassWord("");
                }
            }
            if (FLAG.equals(info.getKeyPassWord())) {
                if (uInfo != null) {
                    info.setKeyPassWord(uInfo.getKeyPassWord());
                } else {
                    info.setKeyPassWord("");
                }
            }
        }
        IObjectPK pk = super._save(ctx, model);
        return pk;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        UkeyInfo ukey = this.getUkeyInfo(ctx, pk);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ukey.id", (Object)pk.toString()));
        if (SolutionSettingEntryFactory.getLocalInstance(ctx).exists(filter)) {
            throw new RPAException(RPAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"Solution_exists_ukey", (String[])new String[]{ukey.getNumber()})});
        }
        super._delete(ctx, pk);
    }
}

