/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpa.app.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.rpa.RPAAddressInfo;
import com.kingdee.eas.fm.rpa.RPALogFactory;
import com.kingdee.eas.fm.rpa.RPALogInfo;
import com.kingdee.eas.fm.rpa.RPAProcessInfo;
import com.kingdee.eas.fm.rpa.RPARobotsInfo;
import com.kingdee.eas.fm.rpa.RPAScheJobInfo;
import com.kingdee.eas.fm.rpa.RobotStatusEnum;
import com.kingdee.eas.fm.rpa.StatusEnum;
import com.kingdee.eas.fm.rpa.app.service.BaseIsaRpa;
import com.kingdee.eas.fm.rpa.app.service.IRpaInvoker;
import com.kingdee.eas.fm.rpa.app.service.util.IsaRpa2Util;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.text.MessageFormat;
import java.util.Map;

public class IsaRpa2Invoker
implements IRpaInvoker {
    @Override
    public JSONObject doPost(BaseIsaRpa rpa) throws BOSException {
        String url = rpa.getUrl();
        String action = rpa.getAction();
        String appkey = rpa.getAppkey();
        JSONObject param = rpa.getParams();
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = IsaRpa2Util.assembleSign(param, appkey, timestamp);
        JSONObject paramsign = new JSONObject();
        paramsign.put("appkey", (Object)appkey);
        paramsign.put("timestamp", (Object)timestamp);
        paramsign.put("signature", (Object)sign);
        String data = IsaRpa2Util.getJsonStr(param);
        String pattern = "http://{0}{1}";
        return IsaRpa2Util.postHeader(MessageFormat.format(pattern, url, action), paramsign, appkey, timestamp, sign, data);
    }

    @Override
    public CoreBaseCollection parseProcess(RPAAddressInfo rpaaddress, JSONObject result, Map<String, RPAProcessInfo> curProcessMap) throws BOSException {
        CoreBaseCollection coll = new CoreBaseCollection();
        Integer code = (Integer)result.get((Object)"code");
        if (code.equals(0)) {
            JSONObject items = result.getJSONObject("result");
            JSONArray processList = (JSONArray)items.get((Object)"items");
            int size = processList.size();
            for (int i = 0; i < size; ++i) {
                JSONObject processItem = processList.getJSONObject(i);
                String name = (String)processItem.get((Object)"procCode");
                if (curProcessMap.containsKey(name)) continue;
                RPAProcessInfo info = new RPAProcessInfo();
                info.setName(name);
                info.setNumber((String)processItem.get((Object)"procVer"));
                info.setDescription((String)processItem.get((Object)"procDesc"));
                String status = (String)processItem.get((Object)"workStatus");
                if (status.equals("release")) {
                    info.setStatus(StatusEnum.ENABLE);
                } else {
                    info.setStatus(StatusEnum.DISNABLE);
                }
                info.setRPAAdd(rpaaddress);
                coll.add((CoreBaseInfo)info);
            }
        } else {
            String msg = (String)result.get((Object)"msg");
            throw new BOSException(msg);
        }
        return coll;
    }

    @Override
    public JSONObject request(BaseIsaRpa rpa) throws BOSException {
        return this.doPost(rpa);
    }

    @Override
    public CoreBaseCollection parseRobots(RPAAddressInfo rpaaddress, JSONObject result, Map<String, RPARobotsInfo> curRobotsMap) throws BOSException {
        CoreBaseCollection coll = new CoreBaseCollection();
        Integer code = (Integer)result.get((Object)"code");
        if (code.equals(0)) {
            JSONObject items = result.getJSONObject("result");
            JSONArray rpaRobotList = (JSONArray)items.get((Object)"items");
            int size = rpaRobotList.size();
            for (int i = 0; i < size; ++i) {
                JSONObject rpaRobotItem = rpaRobotList.getJSONObject(i);
                String agentNo = (String)rpaRobotItem.get((Object)"agent_no");
                if (curRobotsMap.containsKey(agentNo)) continue;
                RPARobotsInfo info = new RPARobotsInfo();
                info.setAdd(rpaRobotItem.get((Object)"agentIp") + ":10080");
                info.setName((String)rpaRobotItem.get((Object)"agentName"));
                info.setUserName((String)rpaRobotItem.get((Object)"rpaUserName"));
                info.setTerminator((String)rpaRobotItem.get((Object)"agentNo"));
                info.setOperSys((String)rpaRobotItem.get((Object)"agentOs"));
                String status = (String)rpaRobotItem.get((Object)"dataStatus");
                if (status.equals("free")) {
                    info.setStatus(RobotStatusEnum.FREE);
                } else {
                    info.setStatus(RobotStatusEnum.BUSY);
                }
                info.setNumber((String)rpaRobotItem.get((Object)"agentNo"));
                info.setRPAAdd(rpaaddress);
                coll.add((CoreBaseInfo)info);
            }
        } else {
            String msg = (String)result.get((Object)"msg");
            throw new BOSException(msg);
        }
        return coll;
    }

    @Override
    public void parseStartResult(Context ctx, CoreBaseCollection logColl, JSONObject result) throws BOSException, EASBizException {
        Map jobMap = (Map)result.get((Object)"result");
        String jobNo = (String)jobMap.get("job_no");
        for (int i = 0; i < logColl.size(); ++i) {
            RPALogInfo logInfo = (RPALogInfo)logColl.get(i);
            logInfo.setJobNo(jobNo);
        }
        RPALogFactory.getLocalInstance(ctx).update(logColl);
    }

    @Override
    public CoreBaseCollection parseScheJob(RPAAddressInfo rpaaddress, JSONObject result, Map<String, RPAScheJobInfo> curScheJobMap) throws BOSException {
        return null;
    }

    @Override
    public JSONObject getProcessParam(BaseIsaRpa rpa) {
        JSONObject params = new JSONObject();
        params.put("page", (Object)1);
        params.put("size", (Object)10);
        return params;
    }

    @Override
    public JSONObject getRobotParam(BaseIsaRpa rpa) {
        JSONObject params = new JSONObject();
        params.put("page", (Object)1);
        params.put("size", (Object)10);
        return params;
    }

    @Override
    public JSONObject getStartJobParam(BaseIsaRpa rpa) {
        JSONObject param = new JSONObject();
        param.put("procCode", rpa.getParams().get((Object)"procCode"));
        param.put("robot_no", rpa.getParams().get((Object)"robot_no"));
        return param;
    }
}

