/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpa.app.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.rpa.RPAAddressInfo;
import com.kingdee.eas.fm.rpa.RPAProcessInfo;
import com.kingdee.eas.fm.rpa.RPARobotsInfo;
import com.kingdee.eas.fm.rpa.RPAScheJobInfo;
import com.kingdee.eas.fm.rpa.RobotStatusEnum;
import com.kingdee.eas.fm.rpa.StatusEnum;
import com.kingdee.eas.fm.rpa.app.service.BaseIsaRpa;
import com.kingdee.eas.fm.rpa.app.service.IRpaInvoker;
import com.kingdee.eas.fm.rpa.app.service.util.IsaHttpUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.util.Map;
import org.apache.log4j.Logger;

public class IsaRpa4Invoker
implements IRpaInvoker {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.rpa.app.service.IsaRpa4Invoker");

    @Override
    public JSONObject doPost(BaseIsaRpa rpa) throws BOSException {
        return this.request(rpa);
    }

    @Override
    public JSONObject request(BaseIsaRpa rpa) throws BOSException {
        String action = rpa.getAction();
        String token = rpa.getToken();
        String appkey = rpa.getAppkey();
        JSONObject paramMap = rpa.getParams();
        String url = rpa.getUrl();
        String requestType = rpa.getRequestType();
        if (StringUtils.isEmpty((String)url)) {
            logger.error((Object)"url is null ");
            return null;
        }
        logger.error((Object)("ISAHttp request is :" + url + action + paramMap + requestType + token + appkey));
        String result = !StringUtils.isEmpty((String)requestType) && requestType.equals("POST") ? IsaHttpUtil.post(url, action, (Map<String, Object>)paramMap, "POST", token, appkey) : IsaHttpUtil.get(url, action, (Map<String, Object>)paramMap, "GET", token, appkey);
        return (JSONObject)JSONObject.parse((String)result);
    }

    @Override
    public CoreBaseCollection parseProcess(RPAAddressInfo rpaaddress, JSONObject result, Map<String, RPAProcessInfo> curProcessMap) throws BOSException {
        CoreBaseCollection coll = new CoreBaseCollection();
        Integer code = (Integer)result.get((Object)"code");
        if (code.equals(0)) {
            JSONObject items = result.getJSONObject("result");
            JSONArray processList = (JSONArray)items.get((Object)"items");
            int size = processList.size();
            for (int i = 0; i < size; ++i) {
                JSONObject processItem = processList.getJSONObject(i);
                String name = (String)processItem.get((Object)"procCode");
                if (curProcessMap.containsKey(name)) continue;
                RPAProcessInfo info = new RPAProcessInfo();
                info.setName(name);
                info.setNumber(name);
                info.setDescription((String)processItem.get((Object)"procDesc"));
                String status = (String)processItem.get((Object)"workStatus");
                if (status.equals("release")) {
                    info.setStatus(StatusEnum.ENABLE);
                } else {
                    info.setStatus(StatusEnum.DISNABLE);
                }
                String proId = processItem.get((Object)"id").toString();
                info.setSimpleName(proId);
                info.setRPAAdd(rpaaddress);
                coll.add((CoreBaseInfo)info);
            }
        } else {
            String msg = (String)result.get((Object)"msg");
            throw new BOSException(msg);
        }
        return coll;
    }

    @Override
    public CoreBaseCollection parseRobots(RPAAddressInfo rpaaddress, JSONObject result, Map<String, RPARobotsInfo> curRobotsMap) throws BOSException {
        CoreBaseCollection coll = new CoreBaseCollection();
        Integer code = (Integer)result.get((Object)"code");
        if (code.equals(0)) {
            JSONObject items = result.getJSONObject("result");
            JSONArray rpaRobotList = (JSONArray)items.get((Object)"items");
            int size = rpaRobotList.size();
            for (int i = 0; i < size; ++i) {
                JSONObject rpaRobotItem = rpaRobotList.getJSONObject(i);
                String agentNo = (String)rpaRobotItem.get((Object)"agentNo");
                if (curRobotsMap.containsKey(agentNo)) continue;
                RPARobotsInfo info = new RPARobotsInfo();
                info.setAdd(rpaRobotItem.get((Object)"agentIp") + ":10080");
                info.setName((String)rpaRobotItem.get((Object)"agentName"));
                info.setUserName((String)rpaRobotItem.get((Object)"rpaUserName"));
                info.setTerminator((String)rpaRobotItem.get((Object)"agentNo"));
                info.setOperSys((String)rpaRobotItem.get((Object)"agentOs"));
                String status = (String)rpaRobotItem.get((Object)"dataStatus");
                if (status.equals("free")) {
                    info.setStatus(RobotStatusEnum.FREE);
                } else {
                    info.setStatus(RobotStatusEnum.BUSY);
                }
                info.setNumber((String)rpaRobotItem.get((Object)"agentNo"));
                info.setRPAAdd(rpaaddress);
                coll.add((CoreBaseInfo)info);
            }
        } else {
            String msg = (String)result.get((Object)"msg");
            throw new BOSException(msg);
        }
        return coll;
    }

    @Override
    public CoreBaseCollection parseScheJob(RPAAddressInfo rpaaddress, JSONObject result, Map<String, RPAScheJobInfo> curScheJobMap) throws BOSException {
        CoreBaseCollection coll = new CoreBaseCollection();
        Integer code = (Integer)result.get((Object)"code");
        if (code.equals(0)) {
            JSONObject items = result.getJSONObject("result");
            JSONArray scheJobList = (JSONArray)items.get((Object)"items");
            int size = scheJobList.size();
            for (int i = 0; i < size; ++i) {
                JSONObject scheJobItem = scheJobList.getJSONObject(i);
                String scheID = scheJobItem.get((Object)"id").toString();
                if (curScheJobMap.containsKey(scheID)) {
                    logger.error((Object)("\u5df2\u5b58\u5728\u8c03\u5ea6\u4efb\u52a1\uff1a" + scheID));
                    continue;
                }
                RPAScheJobInfo info = new RPAScheJobInfo();
                info.setCurOrgName((String)scheJobItem.get((Object)"curOrgName"));
                info.setOwberUserId(scheJobItem.get((Object)"owberUserId").toString());
                info.setOwberUser((String)scheJobItem.get((Object)"owberUser"));
                info.setScheID(scheJobItem.get((Object)"id").toString());
                info.setSchName((String)scheJobItem.get((Object)"schName"));
                info.setProcCode((String)scheJobItem.get((Object)"procCode"));
                info.setProcVer((String)scheJobItem.get((Object)"procVer"));
                info.setPriority(scheJobItem.get((Object)"priority").toString());
                info.setOrgCode((String)scheJobItem.get((Object)"orgCode"));
                info.setExecRobotsNames((String)scheJobItem.get((Object)"execRobotsNames"));
                info.setExecRobotsNo((String)scheJobItem.get((Object)"execRobotsNo"));
                info.setSchParam((String)scheJobItem.get((Object)"schParam"));
                info.setRunMode(scheJobItem.get((Object)"runMode").toString());
                info.setPendingTimeout(scheJobItem.get((Object)"pendingTimeout").toString());
                info.setSchJobNums(scheJobItem.get((Object)"schJobNums").toString());
                info.setDeveloperUser((String)scheJobItem.get((Object)"developerUser"));
                info.setScheduleMode((String)scheJobItem.get((Object)"scheduleMode"));
                info.setScheduleCommand((String)scheJobItem.get((Object)"scheduleCommand"));
                info.setScheduleExpre((String)scheJobItem.get((Object)"scheduleExpre"));
                info.setScheduleExpreDesc((String)scheJobItem.get((Object)"scheduleExpreDesc"));
                info.setJobType(scheJobItem.get((Object)"jobType").toString());
                info.setStatus(scheJobItem.get((Object)"status").toString());
                info.setName((String)scheJobItem.get((Object)"schName"));
                info.setNumber((String)scheJobItem.get((Object)"schName"));
                info.setRpaAdd(rpaaddress);
                coll.add((CoreBaseInfo)info);
            }
        } else {
            String msg = (String)result.get((Object)"msg");
            throw new BOSException(msg);
        }
        return coll;
    }

    @Override
    public void parseStartResult(Context ctx, CoreBaseCollection logColl, JSONObject result) throws BOSException, EASBizException {
    }

    @Override
    public JSONObject getProcessParam(BaseIsaRpa rpa) {
        JSONObject params = new JSONObject();
        params.put("page", (Object)1);
        params.put("size", (Object)10);
        return params;
    }

    @Override
    public JSONObject getRobotParam(BaseIsaRpa rpa) {
        JSONObject params = new JSONObject();
        params.put("page", (Object)1);
        params.put("size", (Object)10);
        return params;
    }

    @Override
    public JSONObject getStartJobParam(BaseIsaRpa rpa) {
        JSONObject param = new JSONObject();
        param.put("id", rpa.getParams().get((Object)"id"));
        return param;
    }
}

