/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpa.app.service;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.eas.cp.eip.sso.util.BASE64Util;
import com.kingdee.eas.fm.rpa.app.service.BaseIsaRpa;
import com.kingdee.eas.fm.rpa.app.service.RpaStartJob;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class IsaRpaInvoker {
    public static void main(String[] args) {
        RpaStartJob rpa = new RpaStartJob();
        JSONObject param = new JSONObject(true);
        param.put("procCode", (Object)"BankDetailsRPA");
        param.put("priority", (Object)"max");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");
        param.put("scheduleTime", (Object)sdf.format(new Date()));
        rpa.setParams(param);
        rpa.setAction("/api/v2/jobs");
        rpa.setToken("7ad2b7cb728d458aa414796df429fa3f");
        rpa.setUrl("http://172.18.7.70:10080");
        try {
            IsaRpaInvoker.doPost(rpa);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static JSONObject doPost(BaseIsaRpa rpa) throws BOSException {
        String url = rpa.getUrl();
        String action = rpa.getAction();
        JSONObject param = rpa.getParams();
        String appkey = rpa.getToken();
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = IsaRpaInvoker.getSign(param, appkey, timestamp);
        JSONObject paramsign = new JSONObject();
        paramsign.put("appkey", (Object)appkey);
        paramsign.put("timestamp", (Object)timestamp);
        paramsign.put("signature", (Object)sign);
        return IsaRpaInvoker.doPost(url + action, paramsign);
    }

    public static String assembleRequUrl(String ip, String port) {
        String pattern = "http://{0}:{1}/rapi/rcall.action";
        return MessageFormat.format(pattern, ip, port);
    }

    private static String sha256_HMAC(String message, String secret) {
        String hash = "";
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(secret.getBytes(), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] bytes = sha256_HMAC.doFinal(message.getBytes());
            hash = IsaRpaInvoker.byteArrayToHexString(bytes);
        }
        catch (Exception e) {
            System.out.println("Error HmacSHA256 ===========" + e.getMessage());
        }
        return hash;
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (int n = 0; b != null && n < b.length; ++n) {
            String stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append('0');
            }
            hs.append(stmp);
        }
        return hs.toString().toLowerCase();
    }

    public static JSONObject doPost(String url, JSONObject params) throws BOSException {
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        Set paramsSet = params.keySet();
        for (Object key : paramsSet) {
            String key0 = key.toString();
            parameters.add(new BasicNameValuePair(key0, String.valueOf(params.get((Object)key0))));
        }
        System.out.println(url);
        return IsaRpaInvoker.doPost0(url, parameters);
    }

    public static JSONObject doPost0(String url, List<BasicNameValuePair> parameters) throws BOSException {
        HttpPost post = new HttpPost(url);
        RequestConfig config = RequestConfig.custom().setConnectTimeout(3000).build();
        post.setConfig(config);
        try {
            CloseableHttpClient client = HttpClients.createDefault();
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
            HttpResponse response = client.execute((HttpUriRequest)post);
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            System.out.println(result);
            return (JSONObject)JSONObject.parse((String)result);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (ConnectTimeoutException e) {
            e.printStackTrace();
            throw new BOSException("\u8fde\u63a5\u8d85\u65f6,\u8fde\u63a5\u4fe1\u606f\uff1a" + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    private static String getSign(JSONObject param, String appkey, String timestamp) {
        String paramStr = "";
        Object[] arr = param.keySet().toArray();
        Arrays.sort(arr);
        for (Object key : arr) {
            paramStr = paramStr + "&" + key + "=" + param.getString(key.toString());
        }
        System.out.println(paramStr);
        paramStr = paramStr + "&appkey=" + appkey;
        paramStr = paramStr + "&timestamp=" + timestamp;
        System.out.println(paramStr);
        String newSources = "";
        try {
            newSources = URLEncoder.encode(paramStr, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        newSources = newSources.replace("+", "%20");
        newSources = newSources.replace("*", "%2A");
        newSources = newSources.replace("~", "%7E");
        System.out.println(newSources);
        String shra256 = IsaRpaInvoker.sha256_HMAC(newSources, appkey);
        System.out.println(shra256);
        shra256 = shra256.replaceAll("\\s*", "");
        String sign = BASE64Util.encode((byte[])shra256.getBytes());
        sign = sign.replace("\\s*", "");
        System.out.println(sign);
        return sign;
    }
}

