/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpa.app.service.isa;

import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Encoder;

public class SignUtil {
    public static String genSignStr(Map<String, Object> param, String accessToken, String timestamp) {
        String str = SignUtil.resortStrSite(param, accessToken, timestamp);
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        return SignUtil.generateSignStr(str, accessToken);
    }

    private static String resortStrSite(Map<String, Object> param, String accessToken, String timestamp) {
        if (StringUtils.isEmpty((String)accessToken) || StringUtils.isEmpty((String)timestamp)) {
            return null;
        }
        String str = SignUtil.getParamStr(param);
        StringBuilder sb = new StringBuilder(StringUtils.isEmpty((String)str) ? "" : str.concat("&"));
        return sb.append("token=").append(accessToken).append("&timestamp=").append(timestamp).toString();
    }

    private static String getParamStr(Map<String, Object> param) {
        if (param != null && param.size() > 0) {
            StringBuilder sb = new StringBuilder();
            Object[] arr = param.keySet().toArray();
            Arrays.sort(arr);
            for (Object key : arr) {
                sb.append("&").append(key).append("=").append(param.get(key.toString()).toString());
            }
            String newstr = null;
            if (!StringUtils.isEmpty((String)sb.toString())) {
                newstr = sb.toString().substring(0, sb.length() - 1);
            }
            return StringUtils.isEmpty(newstr) ? "" : "{".concat(newstr).concat("}");
        }
        return null;
    }

    private static String generateSignStr(String str, String accessToken) {
        String sign = null;
        try {
            String encodestr = SignUtil.UrlEncodeSpecial(str);
            if (StringUtils.isEmpty((String)encodestr)) {
                return null;
            }
            String sha256Str = SignUtil.HMACSHA256StrByKey(encodestr, accessToken);
            if (StringUtils.isEmpty((String)sha256Str)) {
                return null;
            }
            sign = SignUtil.BASE64Encoder(sha256Str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sign;
    }

    private static String BASE64Encoder(String str) {
        BASE64Encoder encoder = new BASE64Encoder();
        String sign = encoder.encodeBuffer(str.getBytes(Charset.forName("UTF-8")));
        return sign.replace("\r", "").replace("\n", "");
    }

    private static String HMACSHA256StrByKey(String source, String key) {
        StringBuilder sb = new StringBuilder();
        try {
            byte[] bytes;
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(key.getBytes(), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] var = bytes = sha256_HMAC.doFinal(source.getBytes());
            int n = bytes.length;
            for (int i = 0; i < n; ++i) {
                byte item = var[i];
                sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private static String UrlEncodeSpecial(String str) {
        String newsource = null;
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        try {
            newsource = URLEncoder.encode(str, "UTF8");
            newsource = newsource.replace("+", "%20");
            newsource = newsource.replace("*", "%2A");
            newsource = newsource.replace("~", "%7E");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return newsource;
    }
}

