/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpa.app.service.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.kingdee.eas.cp.eip.sso.util.BASE64Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class IsaRpa2Util {
    public static String assembleSign(JSONObject jsonObj, String appkey, String timestamp) {
        return IsaRpa2Util.assembleSign0(jsonObj, appkey, timestamp);
    }

    private static String assembleSign(String jsonStr, String appkey, String timestamp) {
        JSONObject jsonObj = JSONObject.parseObject((String)jsonStr);
        return IsaRpa2Util.assembleSign0(jsonObj, appkey, timestamp);
    }

    private static String assembleSign0(JSONObject jsonObj, String appkey, String timestamp) {
        String sortJson = IsaRpa2Util.getJsonStr(jsonObj);
        String sign_yc = MessageFormat.format("{0}&appkey={1}&timestamp={2}", sortJson, appkey, timestamp);
        System.out.println("sign_yc:" + sign_yc);
        String url_bm = "";
        try {
            url_bm = URLEncoder.encode(sign_yc, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        url_bm = url_bm.replace("+", "%20");
        url_bm = url_bm.replace("*", "%2A");
        url_bm = url_bm.replace("~", "%7E");
        System.out.println("URL\u7f16\u7801:" + url_bm);
        String shra256 = IsaRpa2Util.sha256_HMAX(url_bm, appkey);
        String sign = BASE64Util.encode((byte[])shra256.getBytes());
        sign = sign.replaceAll("\\s*", "");
        return sign;
    }

    public static String getJsonStr(JSONObject jsonObj) {
        SerializerFeature[] serializerFeatureArray = new SerializerFeature[1];
        serializerFeatureArray[0] = SerializerFeature.MapSortField;
        String sortJson = JSONObject.toJSONString((Object)jsonObj, (SerializerFeature[])serializerFeatureArray);
        sortJson = sortJson.replaceAll("\":\"", "\": \"");
        sortJson = sortJson.replaceAll("\"\\,\"", "\"\\, \"");
        return sortJson;
    }

    private static String sha256_HMAX(String source, String key) {
        String hash = "";
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(key.getBytes(), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] bytes = sha256_HMAC.doFinal(source.getBytes());
            hash = IsaRpa2Util.byteArrayToHexString(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (int n = 0; b != null && n < b.length; ++n) {
            String stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append('0');
            }
            hs.append(stmp);
        }
        return hs.toString().toLowerCase();
    }

    public static JSONObject postHeader(String url, JSONObject params, String appkey, String timestamp, String sign, String data) {
        HttpPost post = new HttpPost(url);
        post.setHeader("Content-Type", "application/json; charset=UTF-8");
        post.setHeader("appkey", appkey);
        post.setHeader("timestamp", timestamp);
        post.setHeader("signature", sign);
        RequestConfig config = RequestConfig.custom().setConnectTimeout(3000).build();
        post.setConfig(config);
        try {
            CloseableHttpClient client = HttpClients.createDefault();
            StringEntity postStr = new StringEntity(data, "UTF-8");
            post.setEntity((HttpEntity)postStr);
            HttpResponse response = client.execute((HttpUriRequest)post);
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            System.out.println(result);
            return (JSONObject)JSONObject.parse((String)result);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

