/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpa.app.service.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.eas.cp.eip.sso.util.BASE64Util;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;

public class Sign5Util {
    private static Logger logger = Logger.getLogger(Sign5Util.class);

    public static String genPostSignStr(Map<String, Object> param, String accessToken, String timestamp) {
        if (StringUtils.isEmpty((String)accessToken) || StringUtils.isEmpty((String)timestamp)) {
            return null;
        }
        String paramStr = Sign5Util.getPostParamStr(param);
        logger.debug((Object)("sorted param :" + paramStr));
        StringBuilder sb = new StringBuilder(StringUtils.isEmpty((String)paramStr) ? "" : paramStr.concat("&"));
        String postSignStr = sb.append("timestamp=").append(timestamp).toString();
        logger.debug((Object)("\u6e90\u4e32\uff1a" + postSignStr));
        if (StringUtils.isEmpty((String)postSignStr)) {
            return null;
        }
        return Sign5Util.generateSignStr(postSignStr, accessToken);
    }

    public static String getPostParamStr(Map<String, Object> param) {
        JSONObject paramJson = new JSONObject(param);
        String str = paramJson.toJSONString();
        logger.debug((Object)("sorted param :" + str));
        return str;
    }

    public static String genGetSignStr(Map<String, Object> param, String accessToken, String timestamp) {
        if (StringUtils.isEmpty((String)accessToken) || StringUtils.isEmpty((String)timestamp)) {
            return null;
        }
        String newstr = Sign5Util.getUrlParamStr(param);
        logger.debug((Object)("sorted param : " + newstr));
        StringBuilder sb = new StringBuilder(StringUtils.isEmpty((String)newstr) ? "" : newstr.concat("&"));
        String signStr = sb.append("timestamp=").append(timestamp).toString();
        logger.debug((Object)("\u6e90\u4e32 : " + signStr));
        if (StringUtils.isEmpty((String)signStr)) {
            return null;
        }
        return Sign5Util.generateSignStr(signStr, accessToken);
    }

    public static String getUrlParamStr(Map<String, Object> param) {
        if (param != null && param.size() > 0) {
            StringBuilder sb = new StringBuilder();
            Object[] arr = param.keySet().toArray();
            Arrays.sort(arr);
            for (Object key : arr) {
                sb.append("&").append(key).append("=").append(param.get(key.toString()).toString());
            }
            String newstr = null;
            if (!StringUtils.isEmpty((String)sb.toString())) {
                newstr = sb.toString().substring(1, sb.length());
            }
            return newstr;
        }
        return null;
    }

    private static String generateSignStr(String str, String accessToken) {
        String sign = null;
        try {
            String encodestr = Sign5Util.UrlEncodeSpecial(str);
            if (StringUtils.isEmpty((String)encodestr)) {
                return null;
            }
            String sha256Str = Sign5Util.HMACSHA256StrByKey(encodestr, accessToken);
            if (StringUtils.isEmpty((String)sha256Str)) {
                return null;
            }
            sign = Sign5Util.BASE64Encoder(sha256Str);
            System.out.println("\u7b7e\u540d\u503csign\uff1a" + sign);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(sign);
        return sign;
    }

    private static String BASE64Encoder(String str) {
        String sign = BASE64Util.encode((byte[])str.getBytes(Charset.forName("UTF-8")));
        return sign.replace("\r", "").replace("\n", "");
    }

    private static String HMACSHA256StrByKey(String source, String key) {
        StringBuilder sb = new StringBuilder();
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(key.getBytes(), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] bytes = sha256_HMAC.doFinal(source.getBytes());
            System.out.println("sha256\u52a0\u5bc6\u5bc6\u7801\uff1a" + bytes);
            byte[] var = bytes;
            int n = bytes.length;
            for (int i = 0; i < n; ++i) {
                byte item = var[i];
                sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private static String UrlEncodeSpecial(String str) {
        String newsource = null;
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        try {
            newsource = URLEncoder.encode(str, "UTF8");
            newsource = newsource.replace("+", "%20");
            newsource = newsource.replace("*", "%2A");
            newsource = newsource.replace("~", "%7E");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        System.out.println("urlencode : " + newsource);
        return newsource;
    }

    public static void main(String[] args) {
        JSONObject param = new JSONObject();
        param.put("id", null);
        System.out.println(param);
    }
}

