/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.rpa.RPAException;
import com.kingdee.eas.fm.rpa.RPALogCollection;
import com.kingdee.eas.fm.rpa.RPALogFactory;
import com.kingdee.eas.fm.rpa.RPALogInfo;
import com.kingdee.eas.fm.rpa.RPAStatusEnum;
import com.kingdee.eas.fm.rpa.SolutionSettingEntryABsCollection;
import com.kingdee.eas.fm.rpa.SolutionSettingEntryABsFactory;
import com.kingdee.eas.fm.rpa.SolutionSettingEntryABsInfo;
import com.kingdee.eas.fm.rpa.SolutionSettingEntryCollection;
import com.kingdee.eas.fm.rpa.SolutionSettingEntryFactory;
import com.kingdee.eas.fm.rpa.SolutionSettingEntryInfo;
import com.kingdee.eas.fm.rpa.SolutionSettingFactory;
import com.kingdee.eas.fm.rpa.app.AbstractRPALogControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import org.apache.log4j.Logger;

public class RPALogControllerBean
extends AbstractRPALogControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.rpa.app.RPALogControllerBean");

    @Override
    protected void _updateState(Context ctx, String billId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(currentCompany.getId().toString()), "rpaLog_updateState");
        RPALogInfo info = this.getRPALogInfo(ctx, (IObjectPK)new ObjectUuidPK(billId));
        Date executeStratTime = info.getExecuteStratTime();
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(executeStratTime);
        cal.add(12, 5);
        executeStratTime = cal.getTime();
        if (executeStratTime.compareTo(date) > 0) {
            throw new RPAException(RPAException.NOT_UPDATESTATE);
        }
        String flag = ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1022_RPALogControllerBean", (Locale)ctx.getLocale());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ukey.id", (Object)info.getUkey().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("solutionSetting.id", (Object)info.getSolutionSetting().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("executeStratTime", (Object)info.getExecuteStratTime()));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1)));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        view.setSelector(sic);
        RPALogCollection coll = this.getRPALogCollection(ctx, view);
        CoreBaseCollection newColl = new CoreBaseCollection();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
            for (int i = 0; i < coll.size(); ++i) {
                RPALogInfo logInfo = coll.get(i);
                logInfo.setState(RPAStatusEnum.FAILED);
                logInfo.setFailedCause(flag);
                logInfo.setExecuteEndTime(new Date());
                newColl.add((CoreBaseInfo)logInfo);
            }
            String sql = "update T_RPA_SolutionSetting set fsolutionStatus=2 where Fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getSolutionSetting().getId().toString()});
            this.update(ctx, newColl);
        }
    }

    @Override
    protected Map _getAccountBanks(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("parent.id");
        view.setFilter(filter);
        view.setSelector(sic);
        SolutionSettingEntryCollection entryColl = SolutionSettingEntryFactory.getLocalInstance(ctx).getSolutionSettingEntryCollection(view);
        HashMap<String, String> idMap = new HashMap<String, String>();
        HashSet<String> entryIdSet = new HashSet<String>();
        if (entryColl != null && entryColl.size() > 0) {
            for (int i = 0; i < entryColl.size(); ++i) {
                SolutionSettingEntryInfo entry = entryColl.get(i);
                entryIdSet.add(entry.getId().toString());
                idMap.put(entry.getId().toString(), entry.getParent().getId().toString());
            }
        }
        EntityViewInfo abView = new EntityViewInfo();
        FilterInfo abfilter = new FilterInfo();
        abfilter.getFilterItems().add(new FilterItemInfo("solutionSettingEntry.id", entryIdSet, CompareType.INCLUDE));
        SelectorItemCollection absic = new SelectorItemCollection();
        absic.add("solutionSettingEntry.id");
        absic.add("accountBank.id");
        absic.add("accountBank.name");
        absic.add("accountBank.number");
        absic.add("id");
        absic.add("solutionSettingEntry.ukey.id");
        abView.setFilter(abfilter);
        abView.setSelector(absic);
        SolutionSettingEntryABsCollection absColl = SolutionSettingEntryABsFactory.getLocalInstance(ctx).getSolutionSettingEntryABsCollection(abView);
        HashMap<String, ArrayList<String>> entryId_AcctBankMap = new HashMap<String, ArrayList<String>>();
        HashSet<String> keySet = new HashSet<String>();
        if (absColl != null && absColl.size() > 0) {
            for (int i = 0; i < absColl.size(); ++i) {
                SolutionSettingEntryABsInfo solutionSettingEntryABsInfo = absColl.get(i);
                String key = (String)idMap.get(solutionSettingEntryABsInfo.getSolutionSettingEntry().getId().toString()) + solutionSettingEntryABsInfo.getSolutionSettingEntry().getUkey().getId().toString();
                String acctBankName = solutionSettingEntryABsInfo.getAccountBank().getName();
                ArrayList<String> acctBankList = (ArrayList<String>)entryId_AcctBankMap.get(key);
                if (acctBankList == null) {
                    acctBankList = new ArrayList<String>();
                    entryId_AcctBankMap.put(key, acctBankList);
                    keySet.add(key);
                }
                acctBankList.add(acctBankName);
            }
            for (Object e : keySet) {
                List acctBankList = (List)entryId_AcctBankMap.get(e);
                String acctBanks = this.listToString(acctBankList);
                map.put(e.toString(), acctBanks);
            }
        }
        return map;
    }

    private String listToString(List list) {
        String names = "";
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                names = names + (String)list.get(i);
                if (i >= list.size() - 1) continue;
                names = names + "\u3002";
            }
        }
        return names;
    }

    @Override
    protected void _updateLog(Context ctx, String jsonStr) throws BOSException, EASBizException {
        if (!EmptyUtil.isEmpty((String)jsonStr)) {
            JSONArray log = JSONArray.fromObject((Object)jsonStr);
            String solutionSettingId = null;
            CoreBaseCollection newColl = new CoreBaseCollection();
            for (int i = 0; i < log.size(); ++i) {
                Map map = (Map)log.get(i);
                String solutionSettingNumber = (String)map.get("solutionSettingNumber");
                String ukeyNumber = (String)map.get("ukeyNumber");
                int state = (Integer)map.get("state");
                String failedCause = (String)map.get("failedCause");
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("solutionSetting.number", (Object)solutionSettingNumber.trim()));
                filter.getFilterItems().add(new FilterItemInfo("ukey.number", (Object)ukeyNumber.trim()));
                filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1)));
                view.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                view.setSelector(sic);
                RPALogCollection coll = RPALogFactory.getLocalInstance(ctx).getRPALogCollection(view);
                if (EmptyUtil.isEmpty((AbstractObjectCollection)coll)) continue;
                RPALogInfo logInfo = coll.get(0);
                solutionSettingId = logInfo.getSolutionSetting().getId().toString();
                logInfo.setState(RPAStatusEnum.getEnum(state));
                if (!EmptyUtil.isEmpty((String)failedCause)) {
                    logInfo.setFailedCause(failedCause);
                }
                logInfo.setExecuteEndTime(new Date());
                newColl.add((CoreBaseInfo)logInfo);
            }
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)newColl)) {
                this.update(ctx, newColl);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("solutionSetting.id", solutionSettingId));
                filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1)));
                view.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                view.setSelector(sic);
                RPALogCollection coll = RPALogFactory.getLocalInstance(ctx).getRPALogCollection(view);
                if (EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
                    String sql = "update T_RPA_SolutionSetting set fsolutionStatus=2 where Fid = ? ";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{solutionSettingId});
                }
            }
        }
    }

    @Override
    protected void _againDoRobot(Context ctx, Set idSet) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(currentCompany.getId().toString()), "rpaLog_againDoRobot");
        HashMap map = new HashMap();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(3)));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        view.setSelector(sic);
        RPALogCollection coll = this.getRPALogCollection(ctx, view);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
            for (int i = 0; i < coll.size(); ++i) {
                Set<String> solutionSettingIdSet = new HashSet<String>();
                RPALogInfo info = coll.get(i);
                String key = format.format(info.getQueryStratDate()) + "&" + format.format(info.getQueryEndDate());
                if (!map.containsKey(key)) {
                    solutionSettingIdSet.add(info.getSolutionSetting().getId().toString());
                    map.put(key, solutionSettingIdSet);
                    continue;
                }
                solutionSettingIdSet = (Set)map.get(key);
                solutionSettingIdSet.add(info.getSolutionSetting().getId().toString());
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            String[] date = key.split("&");
            Set solutionSettingIdSet = (Set)entry.getValue();
            try {
                Date startDate = format.parse(date[0]);
                Date endDate = format.parse(date[1]);
                SolutionSettingFactory.getLocalInstance(ctx).doRobot(solutionSettingIdSet, startDate, endDate);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1023_RPALogControllerBean", (Locale)ctx.getLocale()) + e));
                throw new RPAException(RPAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"Solution_DoRobot_fail", (String[])new String[]{e.getMessage()})});
            }
        }
    }
}

