/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpa.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.rpa.RPAAddressCollection;
import com.kingdee.eas.fm.rpa.RPAAddressFactory;
import com.kingdee.eas.fm.rpa.RPAAddressInfo;
import com.kingdee.eas.fm.rpa.RPAProcessCollection;
import com.kingdee.eas.fm.rpa.RPAProcessFactory;
import com.kingdee.eas.fm.rpa.RPAProcessInfo;
import com.kingdee.eas.fm.rpa.app.AbstractRPAProcessControllerBean;
import com.kingdee.eas.fm.rpa.app.service.IRpaInvoker;
import com.kingdee.eas.fm.rpa.app.service.RpaGetProcess;
import com.kingdee.eas.fm.rpa.app.service.RpaInvokerFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RPAProcessControllerBean
extends AbstractRPAProcessControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.rpa.app.RPAProcessControllerBean");
    protected static int size = 100;

    @Override
    protected Map _syncProcess(Context ctx, Set processIdSet, Set rpaaddressIdSet) throws BOSException, EASBizException {
        RPAAddressCollection rpaaddressColl = new RPAAddressCollection();
        if (!EmptyUtil.isEmpty((Collection)processIdSet) && processIdSet.size() > 0) {
            RPAProcessCollection processColl = this.getRPAProcess(ctx, processIdSet);
            if (processColl != null && processColl.size() > 0) {
                for (int i = 0; i < processColl.size(); ++i) {
                    RPAProcessInfo info = processColl.get(i);
                    RPAAddressInfo rpaaddress = info.getRPAAdd();
                    rpaaddressColl.add(rpaaddress);
                }
            }
        } else if (!EmptyUtil.isEmpty((Collection)rpaaddressIdSet) && rpaaddressIdSet.size() > 0) {
            rpaaddressColl = this.getRPAAddress(ctx, rpaaddressIdSet);
        }
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)rpaaddressColl) && rpaaddressColl.size() > 0) {
            CoreBaseCollection coll = new CoreBaseCollection();
            CoreBaseCollection coll4Update = new CoreBaseCollection();
            Map curRobotsMap = this.getCurProcessMap(ctx);
            for (int i = 0; i < rpaaddressColl.size(); ++i) {
                RPAAddressInfo rpaaddress = rpaaddressColl.get(i);
                RpaGetProcess rpa = new RpaGetProcess();
                rpa.setParams(1, 1);
                rpa.setToken(rpaaddress.getToken());
                rpa.setUrl(rpaaddress.getAddress());
                rpa.setAppkey(rpaaddress.getAppkey());
                String simpleName = rpaaddress.getSimpleName();
                rpa.setIsaType(simpleName);
                IRpaInvoker iRpainvoker = RpaInvokerFactory.getRpaInvoker(ctx, simpleName);
                JSONObject result1 = iRpainvoker.request(rpa);
                Integer code = (Integer)result1.get((Object)"code");
                if (!code.equals(0)) continue;
                JSONObject items = result1.getJSONObject("result");
                Integer total = (Integer)items.get((Object)"total");
                int page = (total - 1) / size + 1;
                for (int n = 1; n <= page; ++n) {
                    rpa.setParams(n, size);
                    JSONObject result = iRpainvoker.request(rpa);
                    coll.addCollection(iRpainvoker.parseProcess(rpaaddress, result, curRobotsMap));
                    coll4Update.addCollection(this.processExistingProcess(result, curRobotsMap));
                }
            }
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)coll) && coll.size() > 0) {
                RPAProcessFactory.getLocalInstance(ctx).addnew(coll);
            }
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)coll4Update)) {
                RPAProcessFactory.getLocalInstance(ctx).updateBatchData(coll4Update);
            }
        }
        return null;
    }

    private CoreBaseCollection processExistingProcess(JSONObject result, Map curProcessMap) throws BOSException {
        CoreBaseCollection coll = new CoreBaseCollection();
        JSONObject items = result.getJSONObject("result");
        JSONArray processList = (JSONArray)items.get((Object)"items");
        int size = processList.size();
        for (int i = 0; i < size; ++i) {
            JSONObject processItem = processList.getJSONObject(i);
            String name = (String)processItem.get((Object)"procCode");
            if (!curProcessMap.containsKey(name)) continue;
            RPAProcessInfo info = (RPAProcessInfo)curProcessMap.get(name);
            info.setVersion((String)processItem.get((Object)"procVer"));
            coll.add((CoreBaseInfo)info);
        }
        return coll;
    }

    private Map getCurProcessMap(Context ctx) throws BOSException {
        HashMap<String, RPAProcessInfo> curMap = new HashMap<String, RPAProcessInfo>();
        RPAProcessCollection curColl = RPAProcessFactory.getLocalInstance(ctx).getRPAProcessCollection();
        for (int i = 0; i < curColl.size(); ++i) {
            RPAProcessInfo curInfo = curColl.get(i);
            curMap.put(curInfo.getNumber(), curInfo);
        }
        return curMap;
    }

    private RPAProcessCollection getRPAProcess(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("RPAAdd.*"));
        view.setSelector(sic);
        RPAProcessCollection coll = RPAProcessFactory.getLocalInstance(ctx).getRPAProcessCollection(view);
        return coll;
    }

    private RPAAddressCollection getRPAAddress(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        view.setSelector(sic);
        RPAAddressCollection coll = RPAAddressFactory.getLocalInstance(ctx).getRPAAddressCollection(view);
        return coll;
    }
}

