/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpa.app;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.rpa.RPAAddressCollection;
import com.kingdee.eas.fm.rpa.RPAAddressFactory;
import com.kingdee.eas.fm.rpa.RPAAddressInfo;
import com.kingdee.eas.fm.rpa.RPARobotsCollection;
import com.kingdee.eas.fm.rpa.RPARobotsFactory;
import com.kingdee.eas.fm.rpa.RPARobotsInfo;
import com.kingdee.eas.fm.rpa.app.AbstractRPARobotsControllerBean;
import com.kingdee.eas.fm.rpa.app.service.IRpaInvoker;
import com.kingdee.eas.fm.rpa.app.service.RpaGetRobots;
import com.kingdee.eas.fm.rpa.app.service.RpaInvokerFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RPARobotsControllerBean
extends AbstractRPARobotsControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.rpa.app.RPARobotsControllerBean");

    @Override
    protected Map _syncRobot(Context ctx, Set robotsIdSet, Set rpaaddressIdSet) throws BOSException, EASBizException {
        int i;
        RPAAddressCollection rpaaddressColl = new RPAAddressCollection();
        if (!EmptyUtil.isEmpty((Collection)robotsIdSet) && robotsIdSet.size() > 0) {
            RPARobotsCollection robotsColl = this.getRPARobot(ctx, robotsIdSet);
            if (robotsColl != null && robotsColl.size() > 0) {
                for (i = 0; i < robotsColl.size(); ++i) {
                    RPARobotsInfo robot = robotsColl.get(i);
                    RPAAddressInfo rpaaddress = robot.getRPAAdd();
                    rpaaddressColl.add(rpaaddress);
                }
            }
        } else if (!EmptyUtil.isEmpty((Collection)rpaaddressIdSet) && rpaaddressIdSet.size() > 0) {
            rpaaddressColl = this.getRPAAddress(ctx, rpaaddressIdSet);
        }
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)rpaaddressColl) && rpaaddressColl.size() > 0) {
            CoreBaseCollection coll = new CoreBaseCollection();
            for (i = 0; i < rpaaddressColl.size(); ++i) {
                RPAAddressInfo rpaaddress = rpaaddressColl.get(i);
                RpaGetRobots rpa = new RpaGetRobots();
                rpa.setToken(rpaaddress.getToken());
                rpa.setUrl(rpaaddress.getAddress());
                rpa.setAppkey(rpaaddress.getAppkey());
                String simpleName = rpaaddress.getSimpleName();
                rpa.setIsaType(simpleName);
                IRpaInvoker iRpainvoker = RpaInvokerFactory.getRpaInvoker(ctx, simpleName);
                JSONObject result = iRpainvoker.request(rpa);
                Map curRobotsMap = this.getCurRobotsMap(ctx);
                coll.addCollection(iRpainvoker.parseRobots(rpaaddress, result, curRobotsMap));
            }
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)coll) && coll.size() > 0) {
                RPARobotsFactory.getLocalInstance(ctx).addnew(coll);
            }
        }
        return null;
    }

    private Map getCurRobotsMap(Context ctx) throws BOSException {
        HashMap<String, RPARobotsInfo> curMap = new HashMap<String, RPARobotsInfo>();
        RPARobotsCollection curColl = RPARobotsFactory.getLocalInstance(ctx).getRPARobotsCollection();
        for (int i = 0; i < curColl.size(); ++i) {
            RPARobotsInfo curInfo = curColl.get(i);
            curMap.put(curInfo.getTerminator(), curInfo);
        }
        return curMap;
    }

    private RPARobotsCollection getRPARobot(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("RPAAdd.*"));
        view.setSelector(sic);
        RPARobotsCollection coll = RPARobotsFactory.getLocalInstance(ctx).getRPARobotsCollection(view);
        return coll;
    }

    private RPAAddressCollection getRPAAddress(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        view.setSelector(sic);
        RPAAddressCollection coll = RPAAddressFactory.getLocalInstance(ctx).getRPAAddressCollection(view);
        return coll;
    }
}

