/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpa.app;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.rpa.ProcessTypeEnum;
import com.kingdee.eas.fm.rpa.RPAAddressInfo;
import com.kingdee.eas.fm.rpa.RPAException;
import com.kingdee.eas.fm.rpa.RPALogFactory;
import com.kingdee.eas.fm.rpa.RPALogInfo;
import com.kingdee.eas.fm.rpa.RPAStatusEnum;
import com.kingdee.eas.fm.rpa.SolutionSettingCollection;
import com.kingdee.eas.fm.rpa.SolutionSettingEntryABsCollection;
import com.kingdee.eas.fm.rpa.SolutionSettingEntryABsFactory;
import com.kingdee.eas.fm.rpa.SolutionSettingEntryABsInfo;
import com.kingdee.eas.fm.rpa.SolutionSettingEntryCollection;
import com.kingdee.eas.fm.rpa.SolutionSettingEntryFactory;
import com.kingdee.eas.fm.rpa.SolutionSettingEntryInfo;
import com.kingdee.eas.fm.rpa.SolutionSettingFactory;
import com.kingdee.eas.fm.rpa.SolutionSettingInfo;
import com.kingdee.eas.fm.rpa.SolutionStatusEnum;
import com.kingdee.eas.fm.rpa.UkeyAccountBankCollection;
import com.kingdee.eas.fm.rpa.UkeyAccountBankFactory;
import com.kingdee.eas.fm.rpa.UkeyAccountBankInfo;
import com.kingdee.eas.fm.rpa.UkeyInfo;
import com.kingdee.eas.fm.rpa.app.AbstractSolutionSettingControllerBean;
import com.kingdee.eas.fm.rpa.app.service.BaseIsaRpa;
import com.kingdee.eas.fm.rpa.app.service.IRpaInvoker;
import com.kingdee.eas.fm.rpa.app.service.RpaInvokerFactory;
import com.kingdee.eas.fm.rpa.app.service.RpaStartJob;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SolutionSettingControllerBean
extends AbstractSolutionSettingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.rpa.app.SolutionSettingControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SolutionSettingInfo info = (SolutionSettingInfo)model;
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"name");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"RPARobots");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"address");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"RPAProcess");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        boolean isNumberDup = this.exists(ctx, filter);
        if (isNumberDup) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{info.getNumber(), ""});
        }
        SolutionSettingEntryCollection entryColl = info.getEntry();
        if (entryColl == null || entryColl.size() == 0) {
            throw new RPAException(RPAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"ENTRY_NUll")});
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < entryColl.size(); ++i) {
            SolutionSettingEntryInfo entryInfo = entryColl.get(i);
            UkeyInfo ukey = entryInfo.getUkey();
            if (ukey == null) {
                throw new RPAException(RPAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"ENTRY_UKEY_NUll")});
            }
            String seq = (String)map.get(ukey.getId().toString());
            if (seq != null) {
                throw new RPAException(RPAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"ENTRY_UKEY_DUP")});
            }
            map.put(ukey.getId().toString(), String.valueOf(i + 1));
        }
        UserInfo user = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        Timestamp currentTime = new Timestamp(Calendar.getInstance().getTimeInMillis());
        if (info.getCreator() == null) {
            info.setCreator(user);
            info.setCreateTime(currentTime);
        } else {
            info.setLastUpdateUser(user);
            info.setLastUpdateTime(currentTime);
        }
        if (info.getSolutionStatus() != null && info.getSolutionStatus() != SolutionStatusEnum.disable) {
            throw new RPAException(RPAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"SOLUTION_STATUSERR_NOTUPDATE")});
        }
        if (info.getSolutionStatus() == null) {
            info.setSolutionStatus(SolutionStatusEnum.enable);
        }
        IObjectPK pk = super._save(ctx, model);
        return pk;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SolutionSettingInfo info = this.getSolutionSettingInfo(ctx, pk);
        if (info.getSolutionStatus() != null && info.getSolutionStatus() != SolutionStatusEnum.disable) {
            throw new RPAException(RPAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"SOLUTION_STATUSERR_NOTDELETE")});
        }
        super._delete(ctx, pk);
    }

    @Override
    protected Map _getAccountBanks(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        view.setFilter(filter);
        view.setSelector(sic);
        SolutionSettingEntryCollection entryColl = SolutionSettingEntryFactory.getLocalInstance(ctx).getSolutionSettingEntryCollection(view);
        HashSet<String> entryIdSet = new HashSet<String>();
        if (entryColl != null && entryColl.size() > 0) {
            for (int i = 0; i < entryColl.size(); ++i) {
                entryIdSet.add(entryColl.get(i).getId().toString());
            }
        }
        EntityViewInfo abView = new EntityViewInfo();
        FilterInfo abfilter = new FilterInfo();
        abfilter.getFilterItems().add(new FilterItemInfo("solutionSettingEntry.id", entryIdSet, CompareType.INCLUDE));
        SelectorItemCollection absic = new SelectorItemCollection();
        absic.add("solutionSettingEntry.id");
        absic.add("solutionSettingEntry.ukey");
        absic.add("accountBank.id");
        absic.add("accountBank.name");
        absic.add("accountBank.number");
        absic.add("accountBank.bankAccountNumber");
        abView.setFilter(abfilter);
        abView.setSelector(absic);
        SolutionSettingEntryABsCollection absColl = SolutionSettingEntryABsFactory.getLocalInstance(ctx).getSolutionSettingEntryABsCollection(abView);
        HashMap<String, ArrayList<String>> entryId_AcctBankMap = new HashMap<String, ArrayList<String>>();
        HashMap<String, ArrayList<String>> entryId_AcctBankNumberMap = new HashMap<String, ArrayList<String>>();
        HashMap entryId_AcctUsageMap = new HashMap();
        HashSet<String> acctIDSet = new HashSet<String>();
        String ukeyId = null;
        String solutionEntryId = null;
        if (absColl != null && absColl.size() > 0) {
            List acctBankNumberList;
            ukeyId = absColl.get(0).getSolutionSettingEntry().getUkey().getId().toString();
            solutionEntryId = absColl.get(0).getSolutionSettingEntry().getId().toString();
            for (int i = 0; i < absColl.size(); ++i) {
                SolutionSettingEntryABsInfo absinfo = absColl.get(i);
                String string = absinfo.getSolutionSettingEntry().getId().toString();
                String acctBankName = absinfo.getAccountBank().getName();
                ArrayList<String> acctBankList = (ArrayList<String>)entryId_AcctBankMap.get(string);
                if (acctBankList == null) {
                    acctBankList = new ArrayList<String>();
                    entryId_AcctBankMap.put(string, acctBankList);
                }
                acctBankList.add(acctBankName);
                String acctBankNumber = absinfo.getAccountBank().getBankAccountNumber();
                acctIDSet.add(absinfo.getAccountBank().getId().toString());
                ArrayList<String> acctBankNumberList2 = (ArrayList<String>)entryId_AcctBankNumberMap.get(string);
                if (acctBankNumberList2 == null) {
                    acctBankNumberList2 = new ArrayList<String>();
                    entryId_AcctBankNumberMap.put(string, acctBankNumberList2);
                }
                acctBankNumberList2.add(acctBankNumber);
            }
            ArrayList<String> usageList = new ArrayList<String>();
            if (ukeyId != null && !EmptyUtil.isEmpty(acctIDSet)) {
                EntityViewInfo ubview = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("ukey.id", (Object)ukeyId, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("bankAccount.id", acctIDSet, CompareType.INCLUDE));
                SelectorItemCollection sics = new SelectorItemCollection();
                sics.add("usage");
                sics.add("acctBankNumber");
                ubview.setFilter(filterInfo);
                ubview.setSelector(sics);
                UkeyAccountBankCollection ubColl = UkeyAccountBankFactory.getLocalInstance(ctx).getUkeyAccountBankCollection(ubview);
                if (!(EmptyUtil.isEmpty((AbstractObjectCollection)ubColl) || EmptyUtil.isEmpty(entryId_AcctBankNumberMap) || entryId_AcctBankNumberMap.get(solutionEntryId) == null || EmptyUtil.isEmpty((AbstractObjectCollection)ubColl))) {
                    acctBankNumberList = (List)entryId_AcctBankNumberMap.get(solutionEntryId);
                    for (int i = 0; i < acctBankNumberList.size(); ++i) {
                        String acctBankNumber = (String)acctBankNumberList.get(i);
                        for (int j = 0; j < ubColl.size(); ++j) {
                            UkeyAccountBankInfo info = ubColl.get(j);
                            if (acctBankNumber == null || !acctBankNumber.equals(info.getAcctBankNumber())) continue;
                            usageList.add(info.getUsage());
                        }
                    }
                    entryId_AcctUsageMap.put(solutionEntryId, usageList);
                }
            }
            for (Object e : entryIdSet) {
                List acctBankList = (List)entryId_AcctBankMap.get(e);
                String acctBanks = this.listToString(acctBankList);
                map.put(e.toString(), acctBanks);
                acctBankNumberList = (List)entryId_AcctBankNumberMap.get(e);
                String acctBankNumber = this.listToString(acctBankNumberList);
                map.put(e.toString() + "acctBankNo", acctBankNumber);
                List usagerList = (List)entryId_AcctUsageMap.get(e);
                String usages = this.listToString(usagerList);
                map.put(e.toString() + "usages", usages);
            }
        }
        return map;
    }

    private String listToString(List list) {
        String names = "";
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                names = names + (String)list.get(i);
                if (i >= list.size() - 1) continue;
                names = names + "\u3002";
            }
        }
        return names;
    }

    @Override
    protected Map _getExportData(Context ctx, Set idSet) throws BOSException, EASBizException {
        int i;
        Map<String, Object> map;
        BatchExecuteResult result = new BatchExecuteResult();
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fm.rpa.app.SolutionSettingQuery"));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        entityViewInfo.getSorter().add(sorterItemInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("ukey.id"));
        sic.add(new SelectorItemInfo("ukey.number"));
        sic.add(new SelectorItemInfo("ukey.name"));
        sic.add(new SelectorItemInfo("ukey.userName"));
        sic.add(new SelectorItemInfo("ukey.userPassWord"));
        sic.add(new SelectorItemInfo("ukey.keyPassWord"));
        sic.add(new SelectorItemInfo("ukey.usbhub"));
        sic.add(new SelectorItemInfo("ukey.usbNumber"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("EASClientAddress"));
        sic.add(new SelectorItemInfo("EASuser"));
        sic.add(new SelectorItemInfo("processType"));
        sic.add(new SelectorItemInfo("solutionStatus"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("RPARobots.add"));
        sic.add(new SelectorItemInfo("RPARobots.name"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("address.address"));
        sic.add(new SelectorItemInfo("address.name"));
        sic.add(new SelectorItemInfo("address.number"));
        sic.add(new SelectorItemInfo("RPAProcess.status"));
        sic.add(new SelectorItemInfo("RPAProcess.name"));
        sic.add(new SelectorItemInfo("RPAProcess.number"));
        sic.add(new SelectorItemInfo("EASDataCenter"));
        sic.add(new SelectorItemInfo("RPABank.name"));
        entityViewInfo.setSelector(sic);
        exec.setObjectView(entityViewInfo);
        IRowSet rowSet = exec.executeQuery();
        ArrayList dataList = new ArrayList();
        try {
            IRowSetMetaData md = rowSet.getRowSetMetaData();
            while (rowSet.next()) {
                map = new HashMap();
                int count = md.getColumnCount();
                for (i = 1; i <= count; ++i) {
                    String columnName = md.getColumnName(i);
                    Object value = rowSet.getObject(i);
                    if (columnName.equals("solutionStatus")) {
                        value = SolutionStatusEnum.getEnum(Integer.parseInt(value.toString())).getAlias();
                    } else if (columnName.equals("processType")) {
                        value = ProcessTypeEnum.getEnum(Integer.parseInt(value.toString())).getAlias();
                    }
                    map.put(columnName, value);
                }
                dataList.add(map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (dataList.size() > 0) {
            map = this.getAccountBanks(ctx, idSet);
            for (i = 0; i < dataList.size(); ++i) {
                Map row;
                if (dataList.get(i) == null || !(dataList.get(i) instanceof Map) || !(row = (Map)dataList.get(i)).containsKey("entry.id") || row.get("entry.id") == null) continue;
                String entryId = (String)row.get("entry.id");
                row.put("accountBanks", map.get(entryId));
            }
        }
        result.put((Object)"exportData", dataList);
        return result;
    }

    @Override
    protected void _doRobot(Context ctx, Set idSet, Date startDate, Date endDate) throws BOSException, EASBizException {
        this.verifiySolution(ctx, idSet);
        this.startDoRobot(ctx, idSet, startDate, endDate);
    }

    protected void startDoRobot(Context ctx, Set idSet, Date startDate, Date endDate) throws BOSException, EASBizException {
        try {
            String ids = FMHelper.setTran2String((Set)idSet);
            String sql = "UPDATE T_RPA_SolutionSetting SET  FSTARTDATE = ? ,FENDDATE = ? ,FSOLUTIONSTATUS = ? ,FLastUpdateUserID = ? ,FLastUpdateTime = ?  WHERE FID IN " + ids;
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(startDate.getTime()), new Timestamp(endDate.getTime()), 3, userInfo.getId().toString(), new Timestamp(Calendar.getInstance().getTimeInMillis())});
            for (Object id : idSet) {
                SolutionSettingInfo solution = this.getSolutionInfo(ctx, (String)id);
                RPAAddressInfo rpaaddress = solution.getAddress();
                CoreBaseCollection logColl = this.parseSolutionLog(ctx, solution);
                String simpleName = rpaaddress.getSimpleName();
                JSONObject allParams = this.getAllParams(solution);
                logger.error((Object)("startDoRobot:" + allParams));
                BaseIsaRpa rpa = this.getBaseIsaRpa(rpaaddress, simpleName);
                rpa.setParams(allParams);
                IRpaInvoker iRpainvoker = RpaInvokerFactory.getRpaInvoker(ctx, simpleName);
                logger.error((Object)("startDoRobot:+iRpainvoker is " + iRpainvoker));
                rpa.setParams(iRpainvoker.getStartJobParam(rpa));
                JSONObject result = iRpainvoker.request(rpa);
                Integer code = (Integer)result.get((Object)"code");
                if (code.equals(0)) {
                    iRpainvoker.parseStartResult(ctx, logColl, result);
                    continue;
                }
                String msg = (String)result.get((Object)"msg");
                logger.error((Object)("\u6267\u884c\u62a5\u9519:" + msg));
                throw new RPAException(RPAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"Solution_DoRobot_fail", (String[])new String[]{msg})});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("\u6267\u884c\u62a5\u9519:" + e));
            throw new RPAException(RPAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"Solution_DoRobot_fail", (String[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1033_SolutionSettingControllerBean", (Locale)ctx.getLocale())})});
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(new ArrayList(idSet));
        }
    }

    private BaseIsaRpa getBaseIsaRpa(RPAAddressInfo rpaaddress, String simpleName) {
        RpaStartJob rpa = new RpaStartJob();
        rpa.setToken(rpaaddress.getToken());
        rpa.setUrl(rpaaddress.getAddress());
        rpa.setAppkey(rpaaddress.getAppkey());
        rpa.setIsaType(simpleName);
        return rpa;
    }

    private JSONObject getAllParams(SolutionSettingInfo solution) {
        JSONObject param = new JSONObject();
        param.put("procCode", (Object)solution.getRPAProcess().getName());
        param.put("robot_no", (Object)solution.getRPARobots().getTerminator());
        param.put("robotId", (Object)solution.getRPARobots().getSimpleName());
        logger.error((Object)("=====getAllParams=111111111111====" + param));
        if (solution.getRPAScheJob() != null) {
            param.put("id", (Object)new Integer(solution.getRPAScheJob().getScheID()));
        }
        return param;
    }

    private SolutionSettingInfo getSolutionInfo(Context ctx, String id) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("RPARobots.*"));
        sic.add(new SelectorItemInfo("address.*"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("RPAProcess.*"));
        sic.add(new SelectorItemInfo("RPAScheJob.*"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        view.setFilter(filter);
        SolutionSettingCollection coll = SolutionSettingFactory.getLocalInstance(ctx).getSolutionSettingCollection(view);
        SolutionSettingInfo solution = null;
        if (coll != null && coll.size() > 0) {
            solution = coll.get(0);
        }
        return solution;
    }

    private CoreBaseCollection parseSolutionLog(Context ctx, SolutionSettingInfo solution) throws BOSException, EASBizException {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        SolutionSettingEntryCollection entryColl = solution.getEntry();
        CoreBaseCollection logColl = new CoreBaseCollection();
        for (int i = 0; i < entryColl.size(); ++i) {
            SolutionSettingEntryInfo entryInfo = entryColl.get(i);
            RPALogInfo logInfo = new RPALogInfo();
            logInfo.setState(RPAStatusEnum.RUNNING);
            logInfo.setExecuteStratTime(new Date());
            logInfo.setExecutor(user);
            logInfo.setTaskName(solution.getName());
            logInfo.setSolutionSetting(solution);
            logInfo.setUkey(entryInfo.getUkey());
            logInfo.setQueryStratDate(solution.getStartDate());
            logInfo.setQueryEndDate(solution.getEndDate());
            logColl.add((CoreBaseInfo)logInfo);
        }
        RPALogFactory.getLocalInstance(ctx).addnew(logColl);
        return logColl;
    }

    private void verifiySolution(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("RPARobots.*"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SolutionSettingCollection coll = this.getSolutionSettingCollection(ctx, view);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        HashMap<String, String> map = new HashMap<String, String>();
        HashSet<String> successIdset = new HashSet<String>();
        try {
            for (int i = 0; i < coll.size(); ++i) {
                SolutionSettingInfo info = coll.get(i);
                if (info.getSolutionStatus() != SolutionStatusEnum.enable) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"Solution_DoRobot_statusErr", (String[])new String[]{info.getNumber()}));
                }
                String name = info.getRPARobots().getName();
                String number = (String)map.get(name);
                if (number != null) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"Solution_DoRobot_TerminatorDup", (String[])new String[]{info.getNumber(), number}));
                }
                map.put(name, info.getNumber());
                FilterInfo dupFilter = new FilterInfo();
                dupFilter.getFilterItems().add(new FilterItemInfo("RPARobots.name", (Object)name));
                dupFilter.getFilterItems().add(new FilterItemInfo("solutionStatus", (Object)3));
                if (this.exists(ctx, dupFilter)) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"Solution_DoRobot_TerminatorError", (String[])new String[]{info.getNumber(), info.getRPARobots().getName()}));
                }
                boolean b = iMutex.requestObjIDForUpdate(info.getId().toString());
                if (!b) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"Solution_DoRobot_lock", (String[])new String[]{info.getNumber()}));
                }
                successIdset.add(info.getId().toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("\u6267\u884c\u62a5\u9519:" + e));
            throw new RPAException(RPAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"Solution_DoRobot_fail", (String[])new String[]{e.getMessage()})});
        }
        finally {
            if (successIdset.size() < idSet.size()) {
                iMutex.batchReleaseObjIDForUpdate(new ArrayList(successIdset));
            }
        }
    }

    @Override
    protected Map _enable(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{idSet.size() + ""});
        int success = 0;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        SolutionSettingCollection coll = this.getSolutionSettingCollection(ctx, view);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        HashSet<String> successIdset = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            SolutionSettingInfo info = coll.get(i);
            try {
                SolutionStatusEnum satus = info.getSolutionStatus();
                if (satus != SolutionStatusEnum.disable) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"Solution_Enable_statusErr", (String[])new String[]{satus.getAlias()}));
                }
                boolean b = iMutex.requestObjIDForUpdate(info.getId().toString());
                if (!b) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"Solution_Enable_lock"));
                }
                ++success;
                successIdset.add(info.getId().toString());
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"Solution_Enable_FAIL", (String[])new String[]{info.getNumber()}) + e.getMessage());
            }
        }
        if (successIdset.size() > 0) {
            try {
                String successids = FMHelper.setTran2String(successIdset);
                String sql = "UPDATE T_RPA_SolutionSetting SET FSolutionStatus = ? , FLastUpdateUserID = ? ,FLastUpdateTime = ?  WHERE FID IN " + successids;
                Integer status = new Integer(2);
                UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{status, userInfo.getId().toString(), new Timestamp(Calendar.getInstance().getTimeInMillis())});
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)("\u542f\u7528\u62a5\u9519:" + e));
                throw new RPAException(RPAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"BATCHEnable_FAIL")});
            }
            finally {
                iMutex.batchReleaseObjIDForUpdate(new ArrayList(successIdset));
            }
        }
        summary = success == idSet.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"ALL_Enable_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"Enable_result", (String[])new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _disable(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{idSet.size() + ""});
        int success = 0;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        SolutionSettingCollection coll = this.getSolutionSettingCollection(ctx, view);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        HashSet<String> successIdset = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            SolutionSettingInfo info = coll.get(i);
            try {
                SolutionStatusEnum satus = info.getSolutionStatus();
                if (satus != SolutionStatusEnum.enable) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"Solution_Disable_statusErr", (String[])new String[]{satus.getAlias()}));
                }
                boolean b = iMutex.requestObjIDForUpdate(info.getId().toString());
                if (!b) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"Solution_Disable_lock"));
                }
                ++success;
                successIdset.add(info.getId().toString());
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"Solution_Disable_FAIL", (String[])new String[]{info.getNumber()}) + e.getMessage());
            }
        }
        if (successIdset.size() > 0) {
            try {
                String successids = FMHelper.setTran2String(successIdset);
                String sql = "UPDATE T_RPA_SolutionSetting SET FSolutionStatus = ? , FLastUpdateUserID = ? ,FLastUpdateTime = ?  WHERE FID IN " + successids;
                Integer status = new Integer(1);
                UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{status, userInfo.getId().toString(), new Timestamp(Calendar.getInstance().getTimeInMillis())});
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)("\u7981\u7528\u62a5\u9519:" + e));
                throw new RPAException(RPAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"BATCHDisable_FAIL")});
            }
            finally {
                iMutex.batchReleaseObjIDForUpdate(new ArrayList(successIdset));
            }
        }
        summary = success == idSet.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"ALL_Disable_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpa.RPAWebResource", (String)"Disable_result", (String[])new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _getSolutionByTerminator(Context ctx, String detailString) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String RPARobotsName = "";
        String RPAProcessName = "";
        logger.error((Object)("detailString===" + detailString));
        if (!EmptyUtil.isEmpty((String)detailString)) {
            Map map1 = (Map)JSON.parse((String)detailString);
            if (map1 != null) {
                RPARobotsName = map1.get("RPARobotsName") + "";
                RPAProcessName = map1.get("RPAProcessName") + "";
            }
        } else {
            map.put("error", ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1036_SolutionSettingControllerBean", (Locale)ctx.getLocale()) + detailString + "===");
            return map;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entry.ukey.*"));
        sic.add(new SelectorItemInfo("entry.ukey.RPABank.*"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("RPARobots.name", (Object)RPARobotsName));
        filter.getFilterItems().add(new FilterItemInfo("RPAProcess.name", (Object)RPAProcessName));
        filter.getFilterItems().add(new FilterItemInfo("solutionStatus", (Object)3));
        view.setFilter(filter);
        SolutionSettingCollection coll = this.getSolutionSettingCollection(ctx, view);
        if (coll == null || coll.size() == 0) {
            map.put("error", ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1037_SolutionSettingControllerBean", (Locale)ctx.getLocale()));
            return map;
        }
        logger.error((Object)("coll===" + coll.size()));
        SolutionSettingInfo info = coll.get(0);
        String id = info.getId().toString();
        String number = info.getNumber();
        String EASuser = info.getEASuser();
        String EASPassword = info.getEASPassword();
        String EASClientAddress = info.getEASClientAddress();
        String EASDataCenter = info.getEASDataCenter();
        String startDate = DateTimeUtils.format((Date)info.getStartDate(), (String)"yyyy-MM-dd");
        String endDate = DateTimeUtils.format((Date)info.getEndDate(), (String)"yyyy-MM-dd");
        SolutionSettingEntryCollection entry = coll.get(0).getEntry();
        if (entry == null || entry.size() == 0) {
            map.put("error", ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1038_SolutionSettingControllerBean", (Locale)ctx.getLocale()));
            return map;
        }
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        Map acctBankMap = this.getAccountBanks(ctx, idSet);
        ArrayList ukeyList = new ArrayList();
        for (int i = 0; i < entry.size(); ++i) {
            SolutionSettingEntryInfo entryInfo = entry.get(i);
            UkeyInfo ukey = entryInfo.getUkey();
            if (ukey.getExpireDate() != null && ukey.getExpireDate().before(new Date())) {
                logger.error((Object)("Ukey" + ukey.getNumber() + "\u5df2\u7ecf\u8fc7\u671f\u4e86"));
                continue;
            }
            HashMap<String, Object> ukeyMap = new HashMap<String, Object>();
            ukeyMap.put("id", ukey.getId().toString());
            ukeyMap.put("number", ukey.getNumber());
            ukeyMap.put("name", ukey.getName() == null ? "" : ukey.getName());
            ukeyMap.put("bank", ukey.getRPABank() == null ? "" : ukey.getRPABank().getName());
            ukeyMap.put("userName", ukey.getUserName() == null ? "" : ukey.getUserName());
            ukeyMap.put("userPassWord", ukey.getUserPassWord() == null ? "" : ukey.getUserPassWord());
            ukeyMap.put("keyPassWord", ukey.getKeyPassWord() == null ? "" : ukey.getKeyPassWord());
            ukeyMap.put("usbhub", ukey.getUsbhub() == null ? "" : ukey.getUsbhub());
            ukeyMap.put("usbNumber", ukey.getUsbNumber() == null ? "" : ukey.getUsbNumber());
            ukeyMap.put("entpriseNo", ukey.getEntpriseNo() == null ? "" : ukey.getEntpriseNo());
            ukeyMap.put("loginRetryTime", ukey.getLoginRetryTime());
            ukeyMap.put("acctBanks", acctBankMap.get(entryInfo.getId().toString()) == null ? "" : acctBankMap.get(entryInfo.getId().toString()));
            ukeyMap.put("acctBankNo", acctBankMap.get(entryInfo.getId().toString() + "acctBankNo") == null ? "" : acctBankMap.get(entryInfo.getId().toString() + "acctBankNo"));
            ukeyMap.put("usages", acctBankMap.get(entryInfo.getId().toString() + "usages") == null ? "" : acctBankMap.get(entryInfo.getId().toString() + "usages"));
            ukeyMap.put("version", ukey.getVersion());
            ukeyList.add(ukeyMap);
        }
        if (EmptyUtil.isEmpty(ukeyList)) {
            map.put("error", ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1040_SolutionSettingControllerBean", (Locale)ctx.getLocale()));
            return map;
        }
        map.put("id", id);
        map.put("number", number);
        map.put("EASuser", EASuser == null ? "" : EASuser);
        map.put("EASPassword", EASPassword == null ? "" : EASPassword);
        map.put("EASClientAddress", EASClientAddress == null ? "" : EASClientAddress);
        map.put("EASDataCenter", EASDataCenter == null ? "" : EASDataCenter);
        map.put("startDate", startDate == null ? "" : startDate);
        map.put("endDate", endDate == null ? "" : endDate);
        map.put("Ukey", ukeyList == null ? "" : ukeyList);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _autoDoRobot(Context ctx, String days, String solutionList) throws BOSException, EASBizException {
        logger.info((Object)"---------------------  \u5f00\u59cb\u81ea\u52a8\u6267\u884c\u65b9\u6848     ---------------------------");
        logger.error((Object)("\u81ea\u52a8\u6267\u884cRPA\u65b9\u6848 solutionList=" + solutionList));
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isLock = iMutex.requestObjIDForUpdate("autoDoRobot");
        Date endDate = DateUtil.getDayBegin();
        int d = 30;
        if (!EmptyUtil.isEmpty((String)days)) {
            d = Integer.parseInt(days);
        }
        if (d > 30) {
            d = 30;
        } else if (d < 0) {
            d = 0;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(endDate);
        ((Calendar)cal).add(5, -d);
        Date beginDate = cal.getTime();
        HashSet<String> numberSet = null;
        if (!EmptyUtil.isEmpty((String)solutionList)) {
            String[] numbers = solutionList.split(",");
            numberSet = new HashSet<String>(Arrays.asList(numbers));
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solutionStatus", (Object)2));
        if (!EmptyUtil.isEmpty(numberSet)) {
            filter.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        SolutionSettingCollection coll = SolutionSettingFactory.getLocalInstance(ctx).getSolutionSettingCollection(view);
        logger.info((Object)("---------------------  \u542f\u7528\u4e2d\u65b9\u6848\u7684\u6570\u91cf\u4e3a\uff1a " + coll.size()));
        logger.error((Object)("\u81ea\u52a8\u6267\u884cRPA\u65b9\u6848 filter" + filter.toSql()));
        try {
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
                HashSet<String> solutionSettingIdSet = new HashSet<String>();
                for (int i = 0; i < coll.size(); ++i) {
                    SolutionSettingInfo info = coll.get(i);
                    solutionSettingIdSet.add(info.getId().toString());
                }
                logger.info((Object)("---------------------  \u81ea\u52a8\u6267\u884c\u65b9\u6848\u7684\u6570\u91cf\u4e3a \uff1a " + solutionSettingIdSet.size() + "\u5f00\u59cb\u65e5\u671f\u4e3a\uff1a " + beginDate.toString() + "\u7ed3\u675f\u65e5\u671f\u4e3a\uff1a " + endDate.toString()));
                this.startDoRobot(ctx, solutionSettingIdSet, beginDate, endDate);
            }
        }
        catch (Exception e) {
            logger.info((Object)("--------------------- \u6267\u884c\u5f02\u5e38\uff1a " + e.getMessage()));
        }
        finally {
            if (isLock) {
                iMutex.releaseObjIDForUpdate("autoDoRobot");
            }
        }
    }

    public static void main(String[] args) {
        String jsonStr = "{\"RPARobotsName\":\"G4568100013755C\",\"RPAProcessName\":\"111\"}";
        Map map1 = (Map)JSON.parse((String)jsonStr);
        if (map1 != null) {
            String RPARobotsName = map1.get("RPARobotsName") + "";
            String RPAProcessName = map1.get("RPAProcessName") + "";
            System.out.println(RPARobotsName + "==" + RPAProcessName);
        }
    }
}

