/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.AccountBankBalanceCollection;
import com.kingdee.eas.fm.be.AccountBankBalanceFactory;
import com.kingdee.eas.fm.be.AccountBankBalanceInfo;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.ITransDetail;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.be.app.TransDetailDataImport;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.rpa.app.AbstractTransDetailAndBalanceFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import net.sf.json.JSONArray;
import org.apache.log4j.Logger;

public class TransDetailAndBalanceFacadeControllerBean
extends AbstractTransDetailAndBalanceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.rpa.app.TransDetailAndBalanceFacadeControllerBean");

    @Override
    protected String _addNewTransDetail(Context ctx, String jsonStr) throws BOSException, EASBizException {
        String result = "";
        if (!EmptyUtil.isEmpty((String)jsonStr)) {
            JSONArray transDetails = JSONArray.fromObject((Object)jsonStr);
            ITransDetail iTransDetail = TransDetailFactory.getLocalInstance((Context)ctx);
            TransDetailDataImport transDetailDataImport = new TransDetailDataImport();
            transDetailDataImport.getContextParameter().put("DATATASKMODE", new Integer(8));
            for (int i = 0; i < transDetails.size(); ++i) {
                Hashtable dataMap = new Hashtable();
                Map map = (Map)transDetails.get(i);
                for (Object key : map.keySet()) {
                    DataToken dt = new DataToken();
                    dt.data = map.get(key);
                    dt.name = (String)key;
                    dataMap.put(key, dt);
                }
                try {
                    boolean BE018;
                    CoreBaseInfo info = transDetailDataImport.transmit(dataMap, ctx);
                    iTransDetail.addnew(info);
                    TransDetailInfo transDetailInfo = (TransDetailInfo)info;
                    if (EmptyUtil.isEmpty((Object)transDetailInfo.getTransBalance()) || !(BE018 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("BE018", (IObjectPK)new ObjectUuidPK(transDetailInfo.getCompany().getId())))) continue;
                    this.addBalanceByTransDetail(ctx, transDetailInfo);
                    continue;
                }
                catch (Exception e) {
                    String accountBank = (String)map.get("FBankAccount_bankAccountNumber");
                    Object debitAmount = map.get("FDebitAmount");
                    Object creditAmount = map.get("FCreditAmount");
                    result = result + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1019_RPAFunctionFacadeControllerBean", (Locale)ctx.getLocale()) + accountBank + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1049_TransDetailAndBalanceFacadeControllerBean", (Locale)ctx.getLocale()) + debitAmount + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1050_TransDetailAndBalanceFacadeControllerBean", (Locale)ctx.getLocale()) + creditAmount + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1051_TransDetailAndBalanceFacadeControllerBean", (Locale)ctx.getLocale()) + e.getMessage() + "; ";
                    logger.error((Object)("\u8d26\u53f7" + accountBank + "\u4ed8\u6b3e\u91d1\u989d" + debitAmount + "\u6536\u6b3e\u91d1\u989d" + creditAmount + ":\u5bfc\u5165\u4ea4\u6613\u660e\u7ec6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String _addNewBalance(Context ctx, String jsonStr) throws BOSException, EASBizException {
        String result = "";
        int number = 0;
        int n = 0;
        if (EmptyUtil.isEmpty((String)jsonStr)) return result;
        JSONArray balances = JSONArray.fromObject((Object)jsonStr);
        for (int i = 0; i < balances.size(); ++i) {
            n = balances.size();
            Map map = (Map)balances.get(i);
            try {
                Date curDate = FMConstants.FORMAT_DAY.parse(FMConstants.FORMAT_DAY.format(new Date()));
                AccountBankBalanceInfo balanceInfo = new AccountBankBalanceInfo();
                String accountBankNumber = (String)map.get("FBankAccount_bankAccountNumber");
                if (accountBankNumber == null || accountBankNumber.trim().length() <= 0) throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1052_TransDetailAndBalanceFacadeControllerBean", (Locale)ctx.getLocale()) + accountBankNumber + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1059_TransDetailAndBalanceFacadeControllerBean", (Locale)ctx.getLocale()));
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)accountBankNumber.trim()));
                filter.getFilterItems().add(new FilterItemInfo("shareType", (Object)2, CompareType.NOTEQUALS));
                view.setFilter(filter);
                AccountBankCollection accountBankCol = new AccountBankCollection();
                accountBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
                if (accountBankCol == null || accountBankCol.size() < 1) {
                    result = result + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1052_TransDetailAndBalanceFacadeControllerBean", (Locale)ctx.getLocale()) + accountBankNumber + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1053_TransDetailAndBalanceFacadeControllerBean", (Locale)ctx.getLocale());
                } else {
                    if (accountBankCol.get(0).isIsClosed()) {
                        throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1052_TransDetailAndBalanceFacadeControllerBean", (Locale)ctx.getLocale()) + accountBankNumber + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1054_TransDetailAndBalanceFacadeControllerBean", (Locale)ctx.getLocale()));
                    }
                    balanceInfo.setAccountBank(accountBankCol.get(0));
                    balanceInfo.setCompany(accountBankCol.get(0).getCompany());
                    if (EmptyUtil.isEmpty((CoreBaseInfo)accountBankCol.get(0).getCurrency())) {
                        String currency = (String)map.get("FCurrency_number");
                        if (currency == null || currency.toString().trim().length() <= 0) throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1007_EReceiptDataImport", (Locale)ctx.getLocale()) + accountBankNumber + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1055_TransDetailAndBalanceFacadeControllerBean", (Locale)ctx.getLocale()));
                        EntityViewInfo currencyView = new EntityViewInfo();
                        FilterInfo currencyFilter = new FilterInfo();
                        currencyFilter.getFilterItems().add(new FilterItemInfo("number", (Object)currency.toString().trim()));
                        currencyView.setFilter(currencyFilter);
                        CurrencyCollection currencyCol = null;
                        try {
                            currencyCol = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(currencyView);
                        }
                        catch (BOSException e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                        if (currencyCol == null || currencyCol.size() < 1) {
                            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1014_EReceiptDataImport", (Locale)ctx.getLocale()) + currency + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1005_EReceiptDataImport", (Locale)ctx.getLocale()));
                        }
                        balanceInfo.setCurrency(currencyCol.get(0));
                    } else {
                        balanceInfo.setCurrency(accountBankCol.get(0).getCurrency());
                    }
                    String bizDate = (String)map.get("FBizDate");
                    if (bizDate == null || bizDate.toString().trim().length() <= 0) {
                        throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1052_TransDetailAndBalanceFacadeControllerBean", (Locale)ctx.getLocale()) + accountBankNumber + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1056_TransDetailAndBalanceFacadeControllerBean", (Locale)ctx.getLocale()));
                    }
                    balanceInfo.setBizDate((Date)TypeConversionUtils.objToDate((Object)bizDate));
                    String bizTime = (String)map.get("FBizTime");
                    if (bizTime == null || bizTime.toString().trim().length() <= 0) {
                        throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1052_TransDetailAndBalanceFacadeControllerBean", (Locale)ctx.getLocale()) + accountBankNumber + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1057_TransDetailAndBalanceFacadeControllerBean", (Locale)ctx.getLocale()));
                    }
                    balanceInfo.setBizDate((Date)TypeConversionUtils.objToDate((Object)bizTime));
                    String balance = (String)map.get("FTransBalance");
                    if (balance == null || balance.toString().trim().length() <= 0) {
                        throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1052_TransDetailAndBalanceFacadeControllerBean", (Locale)ctx.getLocale()) + accountBankNumber + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1058_TransDetailAndBalanceFacadeControllerBean", (Locale)ctx.getLocale()));
                    }
                    balanceInfo.setBalance(TypeConversionUtils.objToBigDecimal((Object)balance));
                    balanceInfo.setValiBalance(TypeConversionUtils.objToBigDecimal((Object)balance));
                    balanceInfo.setLstBalance(BigDecimal.ZERO);
                }
                boolean isTodayBal = true;
                if (balanceInfo.getBizDate().compareTo(curDate) != 0) {
                    isTodayBal = false;
                }
                FmBeHelper.addnewOrUpdateBalance((Context)ctx, (AccountBankBalanceInfo)balanceInfo, (boolean)isTodayBal);
                ++number;
                continue;
            }
            catch (Exception e) {
                result = result + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1060_TransDetailAndBalanceFacadeControllerBean", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1061_TransDetailAndBalanceFacadeControllerBean", (Locale)ctx.getLocale()) + (n - number) + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1062_TransDetailAndBalanceFacadeControllerBean", (Locale)ctx.getLocale()) + e.getMessage() + "; ";
                e.printStackTrace();
            }
        }
        return result;
    }

    private void addBalanceByTransDetail(Context ctx, TransDetailInfo info) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)info.getBizDate()));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)info.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountBank", (Object)info.getBankAccount().getId().toString()));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("balance");
        sic.add("valiBalance");
        sic.add("accurateBizDate");
        view.setSelector(sic);
        AccountBankBalanceInfo acctInfo = null;
        AccountBankBalanceInfo balanceInfo = new AccountBankBalanceInfo();
        try {
            AccountBankBalanceCollection coll = AccountBankBalanceFactory.getLocalInstance((Context)ctx).getAccountBankBalanceCollection(view);
            if (EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
                balanceInfo.setCompany(info.getCompany());
                balanceInfo.setCurrency(info.getCurrency());
                balanceInfo.setBizDate(info.getBizDate());
                balanceInfo.setAccurateBizDate((Date)info.getBizTime());
                balanceInfo.setAccountBank(info.getBankAccount());
                balanceInfo.setBalance(info.getTransBalance());
                balanceInfo.setValiBalance(info.getTransBalance());
                AccountBankBalanceFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)balanceInfo);
            } else {
                acctInfo = coll.get(0);
                if (acctInfo.getAccurateBizDate().compareTo(info.getBizTime()) < 0) {
                    acctInfo.setBalance(info.getTransBalance());
                    acctInfo.setValiBalance(info.getTransBalance());
                    acctInfo.setAccurateBizDate((Date)info.getBizTime());
                    AccountBankBalanceFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)acctInfo, sic);
                } else if (acctInfo.getAccurateBizDate().compareTo(info.getBizTime()) == 0 && acctInfo.getBalance().compareTo(info.getTransBalance()) < 0) {
                    acctInfo.setBalance(info.getTransBalance());
                    acctInfo.setValiBalance(info.getTransBalance());
                    acctInfo.setAccurateBizDate((Date)info.getBizTime());
                    AccountBankBalanceFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)acctInfo, sic);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

