/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpa.app.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.util.BASE64Util;
import com.kingdee.eas.fm.rpa.RPAAddressInfo;
import com.kingdee.eas.fm.rpa.RPALogFactory;
import com.kingdee.eas.fm.rpa.RPALogInfo;
import com.kingdee.eas.fm.rpa.RPAProcessInfo;
import com.kingdee.eas.fm.rpa.RPARobotsInfo;
import com.kingdee.eas.fm.rpa.RPAScheJobInfo;
import com.kingdee.eas.fm.rpa.RobotStatusEnum;
import com.kingdee.eas.fm.rpa.StatusEnum;
import com.kingdee.eas.fm.rpa.app.service.BaseIsaRpa;
import com.kingdee.eas.fm.rpa.app.service.IRpaInvoker;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class IsaRpaApiInvoker
implements IRpaInvoker {
    @Override
    public JSONObject doPost(BaseIsaRpa rpa) throws BOSException {
        String action = rpa.getAction();
        String token = rpa.getToken();
        String param = rpa.getParams().toString();
        String url = rpa.getUrl();
        String timestamp = String.valueOf(System.currentTimeMillis());
        JSONObject paramsign = new JSONObject();
        paramsign.put("timestamp", (Object)timestamp);
        paramsign.put("action", (Object)action);
        paramsign.put("param", (Object)param);
        paramsign.put("sign", (Object)this.assembleSign(action, param, timestamp));
        paramsign.put("token", (Object)token);
        String pattern = "http://{0}/rapi/rcall.action";
        return this.doPost(MessageFormat.format(pattern, url), paramsign);
    }

    public String assembleRequUrl(String ip, String port) {
        String pattern = "http://{0}:{1}/rapi/rcall.action";
        return MessageFormat.format(pattern, ip, port);
    }

    public String assembleSign(String restType, String param, String timestamp) {
        String pattern = "action={0}&param={1}&timestamp={2}";
        String str = MessageFormat.format(pattern, restType, param, timestamp);
        String strEncode = "";
        try {
            strEncode = URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String secret = "isearch";
        String shra256 = this.sha256_HMAC(strEncode, secret);
        shra256 = shra256.replaceAll("\\s*", "");
        String sign = BASE64Util.encode((byte[])shra256.getBytes());
        sign = sign.replaceAll("\\s*", "");
        return sign;
    }

    private String sha256_HMAC(String message, String secret) {
        String hash = "";
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(secret.getBytes(), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] bytes = sha256_HMAC.doFinal(message.getBytes());
            hash = this.byteArrayToHexString(bytes);
        }
        catch (Exception e) {
            System.out.println("Error HmacSHA256 ===========" + e.getMessage());
        }
        return hash;
    }

    private String byteArrayToHexString(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (int n = 0; b != null && n < b.length; ++n) {
            String stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append('0');
            }
            hs.append(stmp);
        }
        return hs.toString().toLowerCase();
    }

    public JSONObject doPost(String url, JSONObject params) throws BOSException {
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        Set paramsSet = params.keySet();
        for (Object key : paramsSet) {
            String key0 = key.toString();
            parameters.add(new BasicNameValuePair(key0, String.valueOf(params.get((Object)key0))));
        }
        return this.doPost0(url, parameters);
    }

    public JSONObject doPost0(String url, List<BasicNameValuePair> parameters) throws BOSException {
        HttpPost post = new HttpPost(url);
        RequestConfig config = RequestConfig.custom().setConnectTimeout(3000).build();
        post.setConfig(config);
        try {
            CloseableHttpClient client = HttpClients.createDefault();
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
            HttpResponse response = client.execute((HttpUriRequest)post);
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            System.out.println(result);
            return (JSONObject)JSONObject.parse((String)result);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (ConnectTimeoutException e) {
            e.printStackTrace();
            throw new BOSException("\u8fde\u63a5\u8d85\u65f6,\u8fde\u63a5\u4fe1\u606f\uff1a" + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public JSONObject request(BaseIsaRpa rpa) throws BOSException {
        return this.doPost(rpa);
    }

    public CoreBaseCollection parseProcess(RPAAddressInfo rpaaddress, JSONObject result, Map curProcessMap) throws BOSException {
        CoreBaseCollection coll = new CoreBaseCollection();
        Integer code = (Integer)result.get((Object)"code");
        if (code.equals(0)) {
            JSONArray processList = (JSONArray)result.get((Object)"result");
            int size = processList.size();
            for (int i = 0; i < size; ++i) {
                JSONObject processItem = processList.getJSONObject(i);
                String name = (String)processItem.get((Object)"proc_code");
                if (curProcessMap.containsKey(name)) continue;
                RPAProcessInfo info = new RPAProcessInfo();
                info.setName(name);
                info.setNumber((String)processItem.get((Object)"proc_ver"));
                info.setDescription((String)processItem.get((Object)"proc_desc"));
                String status = (String)processItem.get((Object)"proc_status");
                if (status.equals("enable")) {
                    info.setStatus(StatusEnum.ENABLE);
                } else {
                    info.setStatus(StatusEnum.DISNABLE);
                }
                info.setRPAAdd(rpaaddress);
                coll.add((CoreBaseInfo)info);
            }
        } else {
            String msg = (String)result.get((Object)"msg");
            throw new BOSException(msg);
        }
        return coll;
    }

    public CoreBaseCollection parseRobotInfos(RPAAddressInfo rpaaddress, JSONObject result, Map<String, RPARobotsInfo> curRobotsMap) throws BOSException {
        CoreBaseCollection coll = new CoreBaseCollection();
        Integer code = (Integer)result.get((Object)"code");
        if (code.equals(0)) {
            JSONArray rpaRobotList = (JSONArray)result.get((Object)"result");
            int size = rpaRobotList.size();
            for (int i = 0; i < size; ++i) {
                JSONObject rpaRobotItem = rpaRobotList.getJSONObject(i);
                String agentNo = (String)rpaRobotItem.get((Object)"agent_no");
                if (curRobotsMap.containsKey(agentNo)) continue;
                RPARobotsInfo info = new RPARobotsInfo();
                info.setAdd(rpaRobotItem.get((Object)"agent_ip") + ":10080");
                info.setName((String)rpaRobotItem.get((Object)"agent_name"));
                info.setUserName((String)rpaRobotItem.get((Object)"agent_alias"));
                info.setTerminator((String)rpaRobotItem.get((Object)"agent_no"));
                info.setOperSys((String)rpaRobotItem.get((Object)"agent_os"));
                String status = (String)rpaRobotItem.get((Object)"data_status");
                if (status.equals("free")) {
                    info.setStatus(RobotStatusEnum.FREE);
                } else {
                    info.setStatus(RobotStatusEnum.BUSY);
                }
                info.setNumber((String)rpaRobotItem.get((Object)"agent_no"));
                info.setRPAAdd(rpaaddress);
                coll.add((CoreBaseInfo)info);
            }
        } else {
            String msg = (String)result.get((Object)"msg");
            throw new BOSException(msg);
        }
        return coll;
    }

    @Override
    public CoreBaseCollection parseRobots(RPAAddressInfo rpaaddress, JSONObject result, Map<String, RPARobotsInfo> curRobotsMap) throws BOSException {
        CoreBaseCollection coll = new CoreBaseCollection();
        Integer code = (Integer)result.get((Object)"code");
        if (code.equals(0)) {
            JSONArray rpaRobotList = (JSONArray)result.get((Object)"result");
            int size = rpaRobotList.size();
            for (int i = 0; i < size; ++i) {
                JSONObject rpaRobotItem = rpaRobotList.getJSONObject(i);
                String agentNo = (String)rpaRobotItem.get((Object)"agent_no");
                if (curRobotsMap.containsKey(agentNo)) continue;
                RPARobotsInfo info = new RPARobotsInfo();
                info.setAdd(rpaRobotItem.get((Object)"agent_ip") + ":10080");
                info.setName((String)rpaRobotItem.get((Object)"agent_name"));
                info.setUserName((String)rpaRobotItem.get((Object)"agent_alias"));
                info.setTerminator((String)rpaRobotItem.get((Object)"agent_no"));
                info.setOperSys((String)rpaRobotItem.get((Object)"agent_os"));
                String status = (String)rpaRobotItem.get((Object)"data_status");
                if (status.equals("free")) {
                    info.setStatus(RobotStatusEnum.FREE);
                } else {
                    info.setStatus(RobotStatusEnum.BUSY);
                }
                info.setNumber((String)rpaRobotItem.get((Object)"agent_no"));
                info.setRPAAdd(rpaaddress);
                coll.add((CoreBaseInfo)info);
            }
        } else {
            String msg = (String)result.get((Object)"msg");
            throw new BOSException(msg);
        }
        return coll;
    }

    @Override
    public void parseStartResult(Context ctx, CoreBaseCollection logColl, JSONObject result) throws BOSException, EASBizException {
        Map jobMap = (Map)result.get((Object)"result");
        String jobNo = (String)jobMap.get("job_no");
        for (int i = 0; i < logColl.size(); ++i) {
            RPALogInfo logInfo = (RPALogInfo)logColl.get(i);
            logInfo.setJobNo(jobNo);
        }
        RPALogFactory.getLocalInstance(ctx).update(logColl);
    }

    @Override
    public JSONObject getProcessParam(BaseIsaRpa rpa) {
        JSONObject params = new JSONObject();
        params.put("page", (Object)1);
        params.put("size", (Object)10);
        return params;
    }

    @Override
    public JSONObject getRobotParam(BaseIsaRpa rpa) {
        JSONObject params = new JSONObject();
        params.put("page", (Object)1);
        params.put("size", (Object)10);
        return params;
    }

    @Override
    public JSONObject getStartJobParam(BaseIsaRpa rpa) {
        JSONObject param = new JSONObject();
        param.put("procCode", rpa.getParams().get((Object)"procCode"));
        param.put("robot_no", rpa.getParams().get((Object)"robot_no"));
        return param;
    }

    @Override
    public CoreBaseCollection parseScheJob(RPAAddressInfo rpaaddress, JSONObject result, Map<String, RPAScheJobInfo> curScheJobMap) throws BOSException {
        return null;
    }
}

