/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpa.app.service.util;

import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class HttpUtils {
    private static Logger logger = Logger.getLogger(HttpUtils.class);

    public static String request(String url) {
        return HttpUtils.request(url, "GET");
    }

    public static String request(String url, boolean replaceSpace) {
        return HttpUtils.request(url, "GET", null, replaceSpace);
    }

    public static String request(String url, String requestType) {
        return HttpUtils.request(url, requestType, null);
    }

    public static String request(String url, String requestType, Map<String, String> header) {
        return HttpUtils.request(url, requestType, header, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String request(String url, String requestType, Map<String, String> header, boolean replaceSpace) {
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException("request url can't be null");
        }
        StringBuilder sb = new StringBuilder();
        BufferedInputStream reader = null;
        InputStream raw = null;
        try {
            int size;
            URL httpUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)httpUrl.openConnection();
            connection.setRequestMethod(requestType.toUpperCase());
            if (header != null) {
                for (Map.Entry<String, String> item : header.entrySet()) {
                    connection.setRequestProperty(item.getKey(), item.getValue());
                }
            }
            raw = connection.getInputStream();
            reader = new BufferedInputStream(raw);
            byte[] buffer = new byte[1024];
            String encoding = connection.getContentEncoding();
            if (StringUtils.isEmpty((String)encoding)) {
                encoding = "UTF-8";
            } else {
                boolean support = Charset.isSupported(encoding);
                if (!support) {
                    encoding = "UTF-8";
                }
            }
            Charset charset = Charset.forName(encoding);
            boolean var12 = false;
            while ((size = reader.read(buffer, 0, buffer.length)) != -1) {
                if (size <= 0) continue;
                sb.append(new String(buffer, 0, size, charset));
            }
            String result = sb.toString();
            String string = replaceSpace && result.indexOf("\n") != -1 ? result.replaceAll("\\s*|\t|\r|\n", "") : result;
            return string;
        }
        catch (IOException var14) {
            logger.error((Object)var14);
            String string = "";
            return string;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (raw != null) {
                    raw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String post(String url) {
        return HttpUtils.request(url, "POST");
    }

    public static String post(String url, Map<String, String> header) {
        return HttpUtils.request(url, "POST", header);
    }

    public static String post(String url, Map<String, String> header, String argument) {
        return HttpUtils.post(url, header, argument, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, Map<String, String> header, String argument, boolean replaceSpace) {
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException("post url can't be null");
        }
        StringBuilder sb = new StringBuilder();
        OutputStream write = null;
        InputStream raw = null;
        BufferedInputStream reader = null;
        try {
            int size;
            URL httpUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)httpUrl.openConnection();
            connection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            connection.setRequestMethod("POST");
            if (header != null) {
                for (Map.Entry<String, String> item : header.entrySet()) {
                    connection.setRequestProperty(item.getKey(), item.getValue());
                }
            }
            if (!StringUtils.isEmpty((String)argument)) {
                connection.setDoOutput(true);
                write = connection.getOutputStream();
                write.write(argument.getBytes());
            }
            raw = connection.getInputStream();
            reader = new BufferedInputStream(raw);
            byte[] buffer = new byte[1024];
            String encoding = connection.getContentEncoding();
            if (StringUtils.isEmpty((String)encoding)) {
                encoding = "UTF-8";
            } else {
                boolean support = Charset.isSupported(encoding);
                if (!support) {
                    encoding = "UTF-8";
                }
            }
            Charset charset = Charset.forName(encoding);
            boolean var12 = false;
            while ((size = reader.read(buffer, 0, buffer.length)) != -1) {
                if (size <= 0) continue;
                sb.append(new String(buffer, 0, size, charset));
            }
            String result = sb.toString();
            String string = replaceSpace && result.indexOf("\n") != -1 ? result.replaceAll("\\s*|\t|\r|\n", "") : result;
            return string;
        }
        catch (IOException var14) {
            logger.error((Object)var14);
            String string = "";
            return string;
        }
        finally {
            try {
                if (write != null) {
                    write.close();
                }
                if (raw != null) {
                    raw.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, Map<String, String> header, InputStream in, boolean replaceSpace) {
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException("post url can't be null");
        }
        StringBuilder sb = new StringBuilder();
        OutputStream write = null;
        InputStream raw = null;
        BufferedInputStream reader = null;
        try {
            int size;
            byte[] buffer;
            URL httpUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)httpUrl.openConnection();
            connection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            connection.setRequestMethod("POST");
            if (header != null) {
                for (Map.Entry<String, String> item : header.entrySet()) {
                    connection.setRequestProperty(item.getKey(), item.getValue());
                }
            }
            if (in != null) {
                int size2;
                connection.setDoOutput(true);
                write = connection.getOutputStream();
                buffer = new byte[1024];
                boolean var9 = false;
                while ((size2 = in.read(buffer, 0, buffer.length)) != -1) {
                    if (size2 <= 0) continue;
                    write.write(buffer, 0, size2);
                }
            }
            raw = connection.getInputStream();
            reader = new BufferedInputStream(raw);
            buffer = new byte[1024];
            String encoding = connection.getContentEncoding();
            if (StringUtils.isEmpty((String)encoding)) {
                encoding = "UTF-8";
            } else {
                boolean support = Charset.isSupported(encoding);
                if (!support) {
                    encoding = "UTF-8";
                }
            }
            Charset charset = Charset.forName(encoding);
            boolean var12 = false;
            while ((size = reader.read(buffer, 0, buffer.length)) != -1) {
                if (size <= 0) continue;
                sb.append(new String(buffer, 0, size, charset));
            }
            String result = sb.toString();
            String string = replaceSpace && result.indexOf("\n") != -1 ? result.replaceAll("\\s*|\t|\r|\n", "") : result;
            return string;
        }
        catch (IOException var14) {
            logger.error((Object)var14);
            String string = "";
            return string;
        }
        finally {
            try {
                if (write != null) {
                    write.close();
                }
                if (raw != null) {
                    raw.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJsonRequest(HttpServletRequest request) throws IOException {
        BufferedInputStream reader = null;
        InputStream raw = null;
        try {
            String result;
            int size;
            String charset = request.getCharacterEncoding();
            if (StringUtils.isEmpty((String)charset)) {
                charset = "UTF-8";
            }
            raw = request.getInputStream();
            reader = new BufferedInputStream(raw);
            StringBuilder sb = new StringBuilder();
            byte[] buffer = new byte[1024];
            boolean var6 = false;
            while ((size = reader.read(buffer, 0, buffer.length)) != -1) {
                if (size <= 0) continue;
                sb.append(new String(buffer, 0, size, charset));
            }
            String string = result = sb.toString();
            return string;
        }
        catch (Exception e) {
            String string = "";
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (raw != null) {
                raw.close();
            }
        }
    }
}

