/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpa.app.service.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.eas.fm.rpa.app.service.util.HttpUtils;
import com.kingdee.eas.fm.rpa.app.service.util.Sign5Util;
import com.kingdee.util.StringUtils;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public class IsaHttpUtil {
    private static Logger logger = Logger.getLogger(IsaHttpUtil.class);

    public static String get(String url, String action, Map<String, Object> paramMap, String type, String token, String appkey) {
        String accessToken;
        if (StringUtils.isEmpty((String)url)) {
            logger.debug((Object)"url \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)(accessToken = IsaHttpUtil.getAccessToken(url, appkey, token)))) {
            return null;
        }
        String timestamp = IsaHttpUtil.genCurrTimestamp();
        String sign = Sign5Util.genGetSignStr(paramMap, accessToken, timestamp);
        if (StringUtils.isEmpty((String)sign)) {
            return null;
        }
        Map<String, String> param = IsaHttpUtil.generateHeader(accessToken, timestamp, sign);
        StringBuilder urlSB = new StringBuilder();
        urlSB.append(url).append(action);
        String postUrlstr = Sign5Util.getUrlParamStr(paramMap);
        if (!StringUtils.isEmpty((String)postUrlstr)) {
            urlSB.append("?").append(postUrlstr);
        }
        return IsaHttpUtil.HttpGetReq(urlSB.toString(), type, param);
    }

    public static String post(String url, String action, Map<String, Object> paramMap, String type, String token, String appkey) {
        String accessToken;
        if (StringUtils.isEmpty((String)url)) {
            logger.debug((Object)"url \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)(accessToken = IsaHttpUtil.getAccessToken(url, appkey, token)))) {
            return null;
        }
        String timestamp = IsaHttpUtil.genCurrTimestamp();
        String sign = Sign5Util.genPostSignStr(paramMap, accessToken, timestamp);
        if (StringUtils.isEmpty((String)sign)) {
            return null;
        }
        Map<String, String> param = IsaHttpUtil.generateHeader(accessToken, timestamp, sign);
        StringBuilder urlSB = new StringBuilder();
        urlSB.append(url).append(action);
        return IsaHttpUtil.HttpPostReq(urlSB.toString(), type, param, Sign5Util.getPostParamStr(paramMap));
    }

    public static String getAccessToken(String url, String appkey, String appSecret) {
        Map resultObj;
        StringBuilder sb = new StringBuilder(url).append("/oapi/v1/token");
        sb.append("?accessKey=").append(appkey).append("&secretKey=").append(appSecret);
        String raw = null;
        try {
            IsaHttpUtil.cancleSSLValid();
            raw = HttpUtils.request(sb.toString(), Boolean.TRUE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (StringUtils.isEmpty(raw)) {
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)raw);
        boolean flag = jsonObject != null && jsonObject.get((Object)"code") != null && (Integer)jsonObject.get((Object)"code") == 0;
        String accessToken = null;
        if (flag && (resultObj = (Map)jsonObject.get((Object)"result")) != null) {
            accessToken = resultObj.get("access_token").toString();
            String refreshToken = resultObj.get("refresh_token").toString();
            String string = resultObj.get("expires_in").toString();
        }
        return accessToken;
    }

    public static void cancleSSLValid() throws Exception {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private static String genCurrTimestamp() {
        return String.valueOf(System.currentTimeMillis());
    }

    private static Map<String, String> generateHeader(String accessToken, String timestamp, String sign) {
        HashMap<String, String> param = new HashMap<String, String>(20);
        param.put("accesstoken", accessToken);
        param.put("timestamp", timestamp);
        param.put("signature", sign);
        return param;
    }

    private static String HttpGetReq(String url, String type, Map<String, String> header) {
        return HttpUtils.request(url, type, header);
    }

    private static String HttpPostReq(String url, String type, Map<String, String> header, String bodystr) {
        return HttpUtils.post(url, header, bodystr);
    }
}

