/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountBillFactory;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillFactory;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.IBizAccountBill;
import com.kingdee.eas.cp.bc.IBizAccountOutBill;
import com.kingdee.eas.cp.bc.IDailyLoanBill;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.app.service.PayPayService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillFactory;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillInfo;
import com.kingdee.eas.fm.cl.IConsignmentLoanBill;
import com.kingdee.eas.fm.cl.OperationTypeEnum;
import com.kingdee.eas.fm.fin.GenPayRecordFactory;
import com.kingdee.eas.fm.fin.GenPayRecordInfo;
import com.kingdee.eas.fm.fin.IGenPayRecord;
import com.kingdee.eas.fm.fin.ILoanInterest;
import com.kingdee.eas.fm.fin.IRepayment;
import com.kingdee.eas.fm.fin.LoanInterestCollection;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.LoanInterestInfo;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.StatusExtEnum;
import com.kingdee.eas.fm.ft.FundTransferBillFactory;
import com.kingdee.eas.fm.ft.FundTransferBillInfo;
import com.kingdee.eas.fm.ft.FundTransferBillStatusEnum;
import com.kingdee.eas.fm.ft.IFundTransferBill;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.fm.ivt.FinancingAccountFactory;
import com.kingdee.eas.fm.ivt.FinancingAccountInfo;
import com.kingdee.eas.fm.ivt.FinancingStateEnum;
import com.kingdee.eas.fm.ivt.IFinancingAccount;
import com.kingdee.eas.fm.nt.IPayableBill;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.PayableBillStateEnum;
import com.kingdee.eas.fm.rpm.BillClaimStatusEnum;
import com.kingdee.eas.fm.rpm.CommonHelper;
import com.kingdee.eas.fm.rpm.PayBillClaimCollection;
import com.kingdee.eas.fm.rpm.PayBillClaimFactory;
import com.kingdee.eas.fm.rpm.PayBillClaimInfo;
import com.kingdee.eas.fm.rpm.PayClaimBillTypeEnum;
import com.kingdee.eas.fm.rpm.app.AbstractPayBillClaimControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PayBillClaimControllerBean
extends AbstractPayBillClaimControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.rpm.app.PayBillClaimControllerBean");
    private CommonHelper helper = new CommonHelper();

    @Override
    protected Map _submitClaim(Context ctx, PayBillClaimCollection col) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String sql = "update t_cas_paymentbill set FBillClaimStatus=? , FPayBillClaim=? where fid=? ";
        StringBuffer sbFail = new StringBuffer();
        HashSet<IObjectPK> success = new HashSet<IObjectPK>();
        HashMap<String, Boolean> permission = new HashMap<String, Boolean>();
        Boolean isPermission = false;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("company.name");
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        for (int i = 0; i < col.size(); ++i) {
            PayBillClaimInfo info = col.get(i);
            String payId = info.getPaymentBillID();
            PaymentBillInfo payInfo = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(payId), sic);
            if (permission.containsKey(payInfo.getCompany().getId().toString())) {
                isPermission = (Boolean)permission.get(payInfo.getCompany().getId().toString());
            } else {
                isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(payInfo.getCompany().getId()), (String)"rpm_payClaim_02submit");
                permission.put(payInfo.getCompany().getId().toString(), isPermission);
            }
            if (isPermission.booleanValue()) {
                if (payInfo.getBillClaimStatus().equals((Object)BillClaimStatusEnum.AUDIT)) {
                    sbFail.append(info.getNumber()).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaimStatusIsAudit"));
                    continue;
                }
                info.setSubmiter(userInfo);
                Timestamp ts = new Timestamp(System.currentTimeMillis());
                info.setSubmitTime(ts);
                IObjectPK pk = this.save(ctx, (CoreBaseInfo)info);
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{20, pk.toString(), payId});
                success.add(pk);
                IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"submitClaim", (BOSObjectType)info.getBOSType(), (IObjectPK)new ObjectUuidPK(payInfo.getId()), (String)payInfo.getNumber(), (String)"rpm_payClaim_submit", (String)ctx.get((Object)"CurCompanyId").toString(), null);
                LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
                continue;
            }
            sbFail.append(info.getNumber()).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"WithoutPaySubmitPermission", (String[])new String[]{payInfo.getCompany().getName()}));
        }
        result.put("all", col.size());
        result.put("success", success);
        result.put("failDetail", sbFail.toString());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _auditClaim(Context ctx, PayBillClaimCollection col) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuffer sb = new StringBuffer();
        HashSet success = new HashSet();
        Boolean lock1 = false;
        Boolean lock2 = false;
        HashMap<String, Boolean> permission = new HashMap<String, Boolean>();
        Boolean isPermission = false;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("company.name");
        sic.add("SettlementType.*");
        sic.add("SettlementType.nttype.*");
        sic.add("entries.*");
        SelectorItemCollection claimSic = new SelectorItemCollection();
        claimSic.add("*");
        claimSic.add("payType.sourceSysType");
        for (int i = 0; i < col.size(); ++i) {
            PayBillClaimInfo info = col.get(i);
            PaymentBillInfo payInfo = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(info.getPaymentBillID()), sic);
            if (!payInfo.getBillClaimStatus().equals((Object)BillClaimStatusEnum.SUBMIT)) {
                sb.append(payInfo.getNumber()).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaimStatusIsNotSubmit"));
                continue;
            }
            info = PayBillClaimFactory.getLocalInstance(ctx).getPayBillClaimInfo((IObjectPK)new ObjectUuidPK(payInfo.getPayBillClaim().getId()), claimSic);
            if (permission.containsKey(payInfo.getCompany().getId().toString())) {
                isPermission = (Boolean)permission.get(payInfo.getCompany().getId().toString());
            } else {
                isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(payInfo.getCompany().getId()), (String)"rpm_payClaim_03audit");
                permission.put(payInfo.getCompany().getId().toString(), isPermission);
            }
            if (!isPermission.booleanValue()) {
                sb.append(payInfo.getNumber()).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"WithoutPayAuditPermission", (String[])new String[]{payInfo.getCompany().getName()}));
                continue;
            }
            IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            try {
                lock1 = iMutex.requestObjIDForUpdate(payInfo.getId().toString());
                lock2 = iMutex.requestObjIDForUpdate(info.getSrcBillID());
                if (lock1 & lock2) {
                    PayBillClaimFactory.getLocalInstance(ctx).auditOne(info, payInfo, sb, success);
                    continue;
                }
                sb.append(payInfo.getNumber()).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"PayBillIsLocked"));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
                sb.append(payInfo.getNumber()).append(String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"0_PayBillClaimControllerBean", (Locale)ctx.getLocale()), e.getMessage()));
                continue;
            }
            finally {
                if (lock1.booleanValue()) {
                    iMutex.releaseObjIDForUpdate(payInfo.getId().toString());
                }
                if (lock2.booleanValue()) {
                    iMutex.releaseObjIDForUpdate(info.getSrcBillID());
                }
            }
        }
        result.put("all", col.size());
        result.put("success", success);
        result.put("failDetail", sb.toString());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _antiAuditClaim(Context ctx, PayBillClaimCollection col) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuffer sb = new StringBuffer();
        HashSet success = new HashSet();
        Boolean lock1 = false;
        Boolean lock2 = false;
        HashMap<String, Boolean> permission = new HashMap<String, Boolean>();
        Boolean isPermission = false;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("company.name");
        sic.add("SettlementType.*");
        sic.add("SettlementType.nttype.*");
        sic.add("entries.*");
        for (int i = 0; i < col.size(); ++i) {
            PayBillClaimInfo info = col.get(i);
            PaymentBillInfo payInfo = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(info.getPaymentBillID()), sic);
            if (!payInfo.getBillClaimStatus().equals((Object)BillClaimStatusEnum.AUDIT)) {
                sb.append(payInfo.getNumber()).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaimStatusIsNotAudit"));
                continue;
            }
            info = PayBillClaimFactory.getLocalInstance(ctx).getPayBillClaimInfo((IObjectPK)new ObjectUuidPK(payInfo.getPayBillClaim().getId()));
            if (permission.containsKey(payInfo.getCompany().getId().toString())) {
                isPermission = (Boolean)permission.get(payInfo.getCompany().getId().toString());
            } else {
                isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(payInfo.getCompany().getId()), (String)"rpm_payClaim_04antiAudit");
                permission.put(payInfo.getCompany().getId().toString(), isPermission);
            }
            if (!isPermission.booleanValue()) {
                sb.append(payInfo.getNumber()).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"WithoutPayAntiAuditPermission", (String[])new String[]{payInfo.getCompany().getName()}));
                continue;
            }
            IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            try {
                lock1 = iMutex.requestObjIDForUpdate(payInfo.getId().toString());
                lock2 = iMutex.requestObjIDForUpdate(info.getSrcBillID());
                if (lock1 & lock2) {
                    PayBillClaimFactory.getLocalInstance(ctx).antiAuditOne(info, payInfo, sb, success);
                    continue;
                }
                sb.append(payInfo.getNumber()).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"PayBillIsLocked"));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
                sb.append(payInfo.getNumber()).append(String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"0_PayBillClaimControllerBean", (Locale)ctx.getLocale()), e.getMessage()));
                continue;
            }
            finally {
                if (lock1.booleanValue()) {
                    iMutex.releaseObjIDForUpdate(payInfo.getId().toString());
                }
                if (lock2.booleanValue()) {
                    iMutex.releaseObjIDForUpdate(info.getSrcBillID());
                }
            }
        }
        result.put("all", col.size());
        result.put("success", success);
        result.put("failDetail", sb.toString());
        return result;
    }

    @Override
    protected void _auditOne(Context ctx, PayBillClaimInfo info, PaymentBillInfo payInfo, StringBuffer sb, Set success) throws BOSException, EASBizException {
        if (!payInfo.getBillClaimStatus().equals((Object)BillClaimStatusEnum.SUBMIT)) {
            sb.append(payInfo.getNumber()).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaimStatusIsNotSubmit"));
            return;
        }
        String claimSql = "UPDATE T_RPM_PayBillClaim SET fauditor=?,faudittime=GETDATE()  WHERE fid=? ";
        StringBuilder saveSql = new StringBuilder();
        saveSql.append("update t_cas_paymentbill set ");
        StringBuilder entrySql = new StringBuilder();
        entrySql.append("update t_cas_paymentbillentry set ");
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<String> entryParams = new ArrayList<String>();
        if (info.getPayType() != null) {
            saveSql.append(" FPayBillTypeId=?, ");
            params.add(info.getPayType().getId().toString());
            saveSql.append(" FSourceType=?, ");
            params.add(info.getPayType().getSourceSysType().getValue());
        }
        if (info.getFundFlowItem() != null) {
            saveSql.append(" FFundFlowItemId=?, ");
            params.add(info.getFundFlowItem().getId().toString());
            entrySql.append(" FFUNDFLOWITEMID=?, ");
            entryParams.add(info.getFundFlowItem().getId().toString());
        }
        if (info.getOppAccount() != null) {
            saveSql.append(" FOppAccountId=?, ");
            params.add(info.getOppAccount().getId().toString());
            entrySql.append(" FOPPACCOUNTID=?, ");
            entryParams.add(info.getOppAccount().getId().toString());
        }
        if (EmptyUtil.isEmpty((String)info.getSrcBillID()) || EmptyUtil.isEmpty((Object)((Object)info.getPayClaimBillType()))) {
            saveSql.append(" fbillclaimstatus=? where  fid=?");
            params.add(30);
            params.add(payInfo.getId().toString());
            DbUtil.execute((Context)ctx, (String)saveSql.toString(), (Object[])params.toArray());
            entrySql.append(" FPAYMENTBILLID=? where FPAYMENTBILLID =?");
            entryParams.add(info.getPaymentBillID());
            entryParams.add(info.getPaymentBillID());
            DbUtil.execute((Context)ctx, (String)entrySql.toString(), (Object[])entryParams.toArray());
            success.add(payInfo.getId().toString());
            DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"auditOne", (BOSObjectType)info.getBOSType(), (IObjectPK)new ObjectUuidPK(payInfo.getId()), (String)payInfo.getNumber(), (String)"rpm_payClaim_audit", (String)ctx.get((Object)"CurCompanyId").toString(), null);
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            return;
        }
        saveSql.append(" fbillclaimstatus=?, ");
        params.add(30);
        int billType = info.getPayClaimBillType().getValue();
        String srcBillID = info.getSrcBillID();
        String srcBillNumber = info.getSrcBillNumber();
        String destBillID = info.getPaymentBillID();
        String destBillNumber = payInfo.getNumber();
        String description = payInfo.getDescription() == null ? "" : payInfo.getDescription();
        ServiceHandler serviceHandler = new ServiceHandler();
        switch (billType) {
            case 10: {
                BigDecimal checkInterest;
                IRepayment iRepay = RepaymentFactory.getLocalInstance((Context)ctx);
                if (!iRepay.exists((IObjectPK)new ObjectUuidPK(srcBillID))) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaim_CheckBillExist"));
                    return;
                }
                RepaymentInfo repay = iRepay.getRepaymentInfo((IObjectPK)new ObjectUuidPK(srcBillID));
                if (!repay.getStatusExtEnum().equals((Object)StatusExtEnum.AUDIT) || repay.isIsPayCompleted() || !EmptyUtil.isEmpty((CoreBaseInfo)repay.getCashier()) || repay.getPayment().subtract(repay.getTotalPayedAmt() == null ? BigDecimal.ZERO : repay.getTotalPayedAmt()).compareTo(payInfo.getActPayAmt()) == -1) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"PayClaim_RepaymentTip"));
                    return;
                }
                BigDecimal bigDecimal = checkInterest = info.getInterest() == null ? repay.getInterest() : info.getInterest();
                if (checkInterest.compareTo(payInfo.getActPayAmt()) == 1) {
                    sb.append(destBillNumber).append(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"1_PayBillClaimControllerBean", (Locale)ctx.getLocale()));
                    return;
                }
                if ((description = description + String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"2_PayBillClaimControllerBean", (Locale)ctx.getLocale()), srcBillNumber)).length() > 255) {
                    description = description.substring(0, 255);
                }
                saveSql.append(" fdescription=?,fSourceBillId=? where fid=?");
                params.add(description);
                params.add(srcBillID);
                params.add(payInfo.getId().toString());
                DbUtil.execute((Context)ctx, (String)saveSql.toString(), (Object[])params.toArray());
                entrySql.append(" FSOURCEBILLID =? where FPAYMENTBILLID =? ");
                entryParams.add(srcBillID);
                entryParams.add(destBillID);
                DbUtil.execute((Context)ctx, (String)entrySql.toString(), (Object[])entryParams.toArray());
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("repayment.id", (Object)repay.getId().toString()));
                evi.setFilter(filter);
                LoanInterestCollection loanInterest = LoanInterestFactory.getLocalInstance((Context)ctx).getLoanInterestCollection(evi);
                BigDecimal amt = repay.getTotalPayedAmt() == null ? BigDecimal.ZERO : repay.getTotalPayedAmt();
                BigDecimal payment = repay.getPayment() == null ? BigDecimal.ZERO : repay.getPayment();
                BigDecimal locLoanAccrual = BigDecimal.ZERO;
                if (info.getInterest() == null) {
                    for (int j = 0; j < loanInterest.size(); ++j) {
                        String interestSql = "update T_FIN_LoanInterest set FIsGenPayBill=1 where fid=?";
                        DbUtil.execute((Context)ctx, (String)interestSql, (Object[])new Object[]{loanInterest.get(j).getId().toString()});
                        this.helper.createBotpRelation(ctx, loanInterest.get(j).getId().toString(), destBillID);
                    }
                    String repaySql = "update T_FIN_Repayment set FTotalPayedAmt=?,FIsGenPayBill=1 where fid=?";
                    if (payment.compareTo(amt.add(payInfo.getActPayAmt())) == 0) {
                        repaySql = "update T_FIN_Repayment set FTotalPayedAmt=?,FIsGenPayBill=1,FISPAYCOMPLETED = 1 where fid=?";
                    }
                    DbUtil.execute((Context)ctx, (String)repaySql, (Object[])new Object[]{amt.add(payInfo.getActPayAmt()), srcBillID});
                } else {
                    BigDecimal interest = info.getInterest();
                    for (int j = 0; j < loanInterest.size(); ++j) {
                        locLoanAccrual = interest.multiply(loanInterest.get(j).getIntCurrencyRate());
                        String interestSql = "update T_FIN_LoanInterest set FRealInterest=?,FINTCURRENCYAMT=?,FIsGenPayBill=1 where fid=?";
                        DbUtil.execute((Context)ctx, (String)interestSql, (Object[])new Object[]{interest, locLoanAccrual, loanInterest.get(j).getId().toString()});
                        this.helper.createBotpRelation(ctx, loanInterest.get(j).getId().toString(), destBillID);
                    }
                    String repaySql = "update T_FIN_Repayment set FInterest=?,FTotalPayedAmt=?,FPAYMENT=?,FIsGenPayBill=1 where fid=?";
                    if (repay.getSourceAmount().add(locLoanAccrual).compareTo(amt.add(payInfo.getActPayAmt())) == 0) {
                        repaySql = "update T_FIN_Repayment set FInterest=?,FTotalPayedAmt=?,FPAYMENT=?,FIsGenPayBill=1,FISPAYCOMPLETED = 1 where fid=?";
                    }
                    DbUtil.execute((Context)ctx, (String)repaySql, (Object[])new Object[]{locLoanAccrual, amt.add(payInfo.getActPayAmt()), repay.getSourceAmount().add(locLoanAccrual), srcBillID});
                }
                IGenPayRecord iGenPayRec = GenPayRecordFactory.getLocalInstance((Context)ctx);
                GenPayRecordInfo genPayRecordInfo = new GenPayRecordInfo();
                genPayRecordInfo.setRepayment(repay);
                genPayRecordInfo.setPaymentBillId(payInfo.getId());
                genPayRecordInfo.setPayedAmount(payInfo.getActPayAmt());
                iGenPayRec.addnew(genPayRecordInfo);
                this.helper.createBotpRelation(ctx, srcBillID, destBillID);
                success.add(payInfo.getId().toString());
                break;
            }
            case 20: {
                IConsignmentLoanBill iConloan = ConsignmentLoanBillFactory.getLocalInstance((Context)ctx);
                if (!iConloan.exists((IObjectPK)new ObjectUuidPK(srcBillID))) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaim_CheckBillExist"));
                    return;
                }
                ConsignmentLoanBillInfo conloan = iConloan.getConsignmentLoanBillInfo((IObjectPK)new ObjectUuidPK(srcBillID));
                if (!conloan.getState().equals((Object)com.kingdee.eas.fm.cl.StateEnum.EAA) || conloan.isIsCreateCpayment() || !conloan.getOperationType().equals((Object)OperationTypeEnum.CONSIGN)) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"PayClaim_ConsignmentBillTip"));
                    return;
                }
                if ((description = description + String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"3_PayBillClaimControllerBean", (Locale)ctx.getLocale()), srcBillNumber)).length() > 255) {
                    description = description.substring(0, 255);
                }
                saveSql.append(" fdescription=?,fSourceBillId=? where fid=?");
                params.add(description);
                params.add(srcBillID);
                params.add(payInfo.getId().toString());
                DbUtil.execute((Context)ctx, (String)saveSql.toString(), (Object[])params.toArray());
                entrySql.append(" FSOURCEBILLID =? where FPAYMENTBILLID =? ");
                entryParams.add(srcBillID);
                entryParams.add(destBillID);
                DbUtil.execute((Context)ctx, (String)entrySql.toString(), (Object[])entryParams.toArray());
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
                String conloanSql = "update T_CL_ConsignmentLoanBill set FIsCreateCPayment=1 where fid=?";
                DbUtil.execute((Context)ctx, (String)conloanSql, (Object[])new Object[]{srcBillID});
                this.helper.createBotpRelation(ctx, srcBillID, destBillID);
                success.add(payInfo.getId().toString());
                break;
            }
            case 30: {
                IFundTransferBill iFund = FundTransferBillFactory.getLocalInstance((Context)ctx);
                if (!iFund.exists((IObjectPK)new ObjectUuidPK(srcBillID))) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaim_CheckBillExist"));
                    return;
                }
                FundTransferBillInfo fund = iFund.getFundTransferBillInfo((IObjectPK)new ObjectUuidPK(srcBillID));
                if (!fund.getStatus().equals((Object)FundTransferBillStatusEnum.AUDITED) || fund.isIsGenPayBill() || !EmptyUtil.isEmpty((CoreBaseInfo)fund.getCashier())) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"PayClaim_FundtransferBillTip"));
                    return;
                }
                if ((description = description + String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"4_PayBillClaimControllerBean", (Locale)ctx.getLocale()), srcBillNumber)).length() > 255) {
                    description = description.substring(0, 255);
                }
                saveSql.append(" fdescription=? ,fSourceBillId=? where fid=?");
                params.add(description);
                params.add(srcBillID);
                params.add(payInfo.getId().toString());
                DbUtil.execute((Context)ctx, (String)saveSql.toString(), (Object[])params.toArray());
                entrySql.append(" FSOURCEBILLID =? where FPAYMENTBILLID =? ");
                entryParams.add(srcBillID);
                entryParams.add(destBillID);
                DbUtil.execute((Context)ctx, (String)entrySql.toString(), (Object[])entryParams.toArray());
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
                String fundSql = "update T_FT_FundTransferBill set FIsGenPayBill=1 , FPaymentBillID=? where fid=?";
                DbUtil.execute((Context)ctx, (String)fundSql, (Object[])new Object[]{destBillID, srcBillID});
                this.helper.createBotpRelation(ctx, srcBillID, destBillID);
                success.add(payInfo.getId().toString());
                break;
            }
            case 40: {
                boolean isAutoVerifyPayableBill;
                IPayableBill iPayable = PayableBillFactory.getLocalInstance((Context)ctx);
                if (!iPayable.exists((IObjectPK)new ObjectUuidPK(srcBillID))) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaim_CheckBillExist"));
                    return;
                }
                PayableBillInfo payable = iPayable.getPayableBillInfo((IObjectPK)new ObjectUuidPK(srcBillID));
                if (!payable.getBillState().equals((Object)PayableBillStateEnum.SUBMIT) && !payable.getBillState().equals((Object)PayableBillStateEnum.Audit) || payable.getAmount().compareTo(payInfo.getActPayAmt()) != 0) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"PayClaim_PayableBillTip"));
                    return;
                }
                if ((description = description + String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"5_PayBillClaimControllerBean", (Locale)ctx.getLocale()), payable.getDraftNumber())).length() > 255) {
                    description = description.substring(0, 255);
                }
                saveSql.append(" fdescription=?,fsettlementnumber=? ,fSourceBillId=?  where fid=?");
                params.add(description);
                params.add(payable.getDraftNumber());
                params.add(srcBillID);
                params.add(payInfo.getId().toString());
                payInfo.setSettlementNumber(payable.getDraftNumber());
                if (payInfo.getBillStatus().equals((Object)BillStatusEnum.PAYED) && (isAutoVerifyPayableBill = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS070_01", (IObjectPK)new ObjectUuidPK(payInfo.getCompany().getId())))) {
                    PayPayService service = new PayPayService();
                    service.WriteOffPayableBill(ctx, payInfo, payInfo.getCompany().getId().toString());
                    this.helper.createBotpRelation(ctx, srcBillID, destBillID);
                }
                DbUtil.execute((Context)ctx, (String)saveSql.toString(), (Object[])params.toArray());
                entrySql.append(" FSOURCEBILLID =? where FPAYMENTBILLID =? ");
                entryParams.add(srcBillID);
                entryParams.add(destBillID);
                DbUtil.execute((Context)ctx, (String)entrySql.toString(), (Object[])entryParams.toArray());
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
                success.add(payInfo.getId().toString());
                break;
            }
            case 50: {
                IFinancingAccount iFinance = FinancingAccountFactory.getLocalInstance((Context)ctx);
                if (!iFinance.exists((IObjectPK)new ObjectUuidPK(srcBillID))) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaim_CheckBillExist"));
                    return;
                }
                FinancingAccountInfo finance = iFinance.getFinancingAccountInfo((IObjectPK)new ObjectUuidPK(srcBillID));
                if (!finance.getState().equals((Object)FinancingStateEnum.AUDIT) || finance.isIsBook() || finance.isIsGenePayBill() || finance.getFinanceAmount().compareTo(payInfo.getActPayAmt()) == -1) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"PayClaim_FinancingAccountTip"));
                    return;
                }
                if ((description = description + String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"6_PayBillClaimControllerBean", (Locale)ctx.getLocale()), srcBillNumber)).length() > 255) {
                    description = description.substring(0, 255);
                }
                saveSql.append(" fdescription=? ,fSourceBillId=? where fid=?");
                params.add(description);
                params.add(finance.getId().toString());
                params.add(payInfo.getId().toString());
                DbUtil.execute((Context)ctx, (String)saveSql.toString(), (Object[])params.toArray());
                entrySql.append(" FSOURCEBILLID =? where FPAYMENTBILLID =? ");
                entryParams.add(srcBillID);
                entryParams.add(destBillID);
                DbUtil.execute((Context)ctx, (String)entrySql.toString(), (Object[])entryParams.toArray());
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
                String financeSql = "update T_IVT_FinancingAccount set fisGenePayBill=1 where fid=?";
                DbUtil.execute((Context)ctx, (String)financeSql, (Object[])new Object[]{srcBillID});
                this.helper.createBotpRelation(ctx, srcBillID, destBillID);
                success.add(payInfo.getId().toString());
                break;
            }
            case 60: {
                IBizAccountBill iBizAccount = BizAccountBillFactory.getLocalInstance((Context)ctx);
                if (!iBizAccount.exists((IObjectPK)new ObjectUuidPK(srcBillID))) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaim_CheckBillExist"));
                    return;
                }
                BizAccountBillInfo bizAccount = iBizAccount.getBizAccountBillInfo((IObjectPK)new ObjectUuidPK(srcBillID));
                if (!bizAccount.getState().equals((Object)StateEnum.CHECKED) && !bizAccount.getState().equals((Object)StateEnum.ISPAYBILL) || bizAccount.getAmountNotPaid().compareTo(BigDecimal.ZERO) == -1) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"PayClaim_BizAccountBillTip"));
                    return;
                }
                String sumsql = "SELECT sum(b.FACTUALPAYAMOUNT ) FROM T_BOT_Relation a, t_cas_paymentbill b where a.FDESTOBJECTID =b.fid and a.FSRCOBJECTID =? and a.FDESTENTITYID =? and  b.FBILLSTATUS !=10";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sumsql, (Object[])new Object[]{srcBillID, "40284E81"});
                try {
                    if (rs.next()) {
                        BigDecimal sumAmount = rs.getBigDecimal(1) == null ? BigDecimal.ZERO : rs.getBigDecimal(1);
                        BigDecimal result = bizAccount.getAmountApproved().subtract(sumAmount);
                        if (payInfo.getActPayAmt().compareTo(result) == 1) {
                            sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"PayClaim_BizAccountBillTipExt"));
                            return;
                        }
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
                description = description + String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"7_PayBillClaimControllerBean", (Locale)ctx.getLocale()), srcBillNumber);
                if (description.length() > 255) {
                    description = description.substring(0, 255);
                }
                saveSql.append(" fdescription=?,FSOURCEBILLID=? where fid=?");
                params.add(description);
                params.add(bizAccount.getId().toString());
                params.add(payInfo.getId().toString());
                payInfo.setSourceBillId(srcBillID);
                DbUtil.execute((Context)ctx, (String)saveSql.toString(), (Object[])params.toArray());
                entrySql.append(" FSOURCEBILLID =? where FPAYMENTBILLID =? ");
                entryParams.add(srcBillID);
                entryParams.add(destBillID);
                for (int i = 0; i < payInfo.getEntries().size(); ++i) {
                    payInfo.getEntries().get(i).setSourceBillId(srcBillID);
                }
                DbUtil.execute((Context)ctx, (String)entrySql.toString(), (Object[])entryParams.toArray());
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
                if (!bizAccount.isIsCreatePayBill()) {
                    DbUtil.execute((Context)ctx, (String)"update T_BC_BizAccountBill set fiscreatepaybill=1,FSTATE=65 where fid=?", (Object[])new Object[]{srcBillID});
                }
                if (payInfo.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
                    serviceHandler.dispose(ctx, payInfo, DisposerActionEnum.PAY);
                }
                this.helper.createBotpRelation(ctx, srcBillID, destBillID);
                success.add(payInfo.getId().toString());
                break;
            }
            case 61: {
                IDailyLoanBill iDailyLoanBill = DailyLoanBillFactory.getLocalInstance((Context)ctx);
                if (!iDailyLoanBill.exists((IObjectPK)new ObjectUuidPK(srcBillID))) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaim_CheckBillExist"));
                    return;
                }
                DailyLoanBillInfo dailyLoan = iDailyLoanBill.getDailyLoanBillInfo((IObjectPK)new ObjectUuidPK(srcBillID));
                if (!dailyLoan.getState().equals((Object)StateEnum.CHECKED) && !dailyLoan.getState().equals((Object)StateEnum.ISPAYBILL) || dailyLoan.getAmountNotPaid().compareTo(BigDecimal.ZERO) == -1) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"PayClaim_DailyLoanBillTip"));
                    return;
                }
                String dailySumSql = "SELECT sum(b.FACTUALPAYAMOUNT ) FROM T_BOT_Relation a, t_cas_paymentbill b where a.FDESTOBJECTID =b.fid and a.FSRCOBJECTID =? and a.FDESTENTITYID =? and  b.FBILLSTATUS !=10";
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)dailySumSql, (Object[])new Object[]{srcBillID, "40284E81"});
                try {
                    if (rowSet.next()) {
                        BigDecimal sumAmount = rowSet.getBigDecimal(1) == null ? BigDecimal.ZERO : rowSet.getBigDecimal(1);
                        BigDecimal result = dailyLoan.getAmountApproved().subtract(sumAmount);
                        if (payInfo.getActPayAmt().compareTo(result) == 1) {
                            sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"PayClaim_DailyLoanBillTipExt"));
                            return;
                        }
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
                description = description + String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"8_PayBillClaimControllerBean", (Locale)ctx.getLocale()), srcBillNumber);
                if (description.length() > 255) {
                    description = description.substring(0, 255);
                }
                saveSql.append(" fdescription=?,FSOURCEBILLID=? where fid=?");
                params.add(description);
                params.add(dailyLoan.getId().toString());
                params.add(payInfo.getId().toString());
                payInfo.setSourceBillId(srcBillID);
                DbUtil.execute((Context)ctx, (String)saveSql.toString(), (Object[])params.toArray());
                entrySql.append(" FSOURCEBILLID =? where FPAYMENTBILLID =? ");
                entryParams.add(srcBillID);
                entryParams.add(destBillID);
                for (int i = 0; i < payInfo.getEntries().size(); ++i) {
                    payInfo.getEntries().get(i).setSourceBillId(srcBillID);
                }
                DbUtil.execute((Context)ctx, (String)entrySql.toString(), (Object[])entryParams.toArray());
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
                if (!dailyLoan.isIsCreatePayBill()) {
                    DbUtil.execute((Context)ctx, (String)"update T_BC_DailyLoanBill set fiscreatepaybill=1,FSTATE=65 where fid=?", (Object[])new Object[]{srcBillID});
                }
                if (payInfo.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
                    serviceHandler.dispose(ctx, payInfo, DisposerActionEnum.PAY);
                }
                this.helper.createBotpRelation(ctx, srcBillID, destBillID);
                success.add(payInfo.getId().toString());
                break;
            }
            case 70: {
                IRepayment iRepay4credit = RepaymentFactory.getLocalInstance((Context)ctx);
                if (!iRepay4credit.exists((IObjectPK)new ObjectUuidPK(srcBillID))) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaim_CheckBillExist"));
                    return;
                }
                RepaymentInfo repay4credit = iRepay4credit.getRepaymentInfo((IObjectPK)new ObjectUuidPK(srcBillID));
                if (!repay4credit.getStatusExtEnum().equals((Object)StatusExtEnum.AUDIT) || repay4credit.isIsPayCompleted() || !EmptyUtil.isEmpty((CoreBaseInfo)repay4credit.getCashier()) || repay4credit.getAmount().subtract(repay4credit.getTotalPayedAmt() == null ? BigDecimal.ZERO : repay4credit.getTotalPayedAmt()).compareTo(payInfo.getActPayAmt()) == -1) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"PayClaim_RepaymentTipElse"));
                    return;
                }
                if ((description = description + String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"9_PayBillClaimControllerBean", (Locale)ctx.getLocale()), srcBillNumber)).length() > 255) {
                    description = description.substring(0, 255);
                }
                saveSql.append(" fdescription=?,fSourceBillId=? where fid=?");
                params.add(description);
                params.add(srcBillID);
                params.add(payInfo.getId().toString());
                DbUtil.execute((Context)ctx, (String)saveSql.toString(), (Object[])params.toArray());
                entrySql.append(" FSOURCEBILLID =? where FPAYMENTBILLID =? ");
                entryParams.add(srcBillID);
                entryParams.add(destBillID);
                DbUtil.execute((Context)ctx, (String)entrySql.toString(), (Object[])entryParams.toArray());
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
                payInfo.setSourceBillId(srcBillID);
                serviceHandler.dispose(ctx, payInfo, DisposerActionEnum.SAVE);
                this.helper.createBotpRelation(ctx, srcBillID, destBillID);
                success.add(payInfo.getId().toString());
                break;
            }
            case 80: {
                IRepayment iRepay4guarntee = RepaymentFactory.getLocalInstance((Context)ctx);
                if (!iRepay4guarntee.exists((IObjectPK)new ObjectUuidPK(srcBillID))) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaim_CheckBillExist"));
                    return;
                }
                RepaymentInfo repay4guarntee = iRepay4guarntee.getRepaymentInfo((IObjectPK)new ObjectUuidPK(srcBillID));
                if (!repay4guarntee.getStatusExtEnum().equals((Object)StatusExtEnum.AUDIT) || repay4guarntee.isIsPayCompleted() || repay4guarntee.getAmount().subtract(repay4guarntee.getTotalPayedAmt() == null ? BigDecimal.ZERO : repay4guarntee.getTotalPayedAmt()).compareTo(payInfo.getActPayAmt()) == -1) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"PayClaim_RepaymentTipElse"));
                    return;
                }
                if ((description = description + String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"10_PayBillClaimControllerBean", (Locale)ctx.getLocale()), srcBillNumber)).length() > 255) {
                    description = description.substring(0, 255);
                }
                saveSql.append(" fdescription=?,fSourceBillId=? where fid=?");
                params.add(description);
                params.add(srcBillID);
                params.add(payInfo.getId().toString());
                DbUtil.execute((Context)ctx, (String)saveSql.toString(), (Object[])params.toArray());
                entrySql.append(" FSOURCEBILLID =? where FPAYMENTBILLID =? ");
                entryParams.add(srcBillID);
                entryParams.add(destBillID);
                DbUtil.execute((Context)ctx, (String)entrySql.toString(), (Object[])entryParams.toArray());
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
                payInfo.setSourceBillId(srcBillID);
                serviceHandler.dispose(ctx, payInfo, DisposerActionEnum.SAVE);
                this.helper.createBotpRelation(ctx, srcBillID, destBillID);
                success.add(payInfo.getId().toString());
                break;
            }
            case 90: {
                IBizAccountOutBill iBizAccountOut = BizAccountOutBillFactory.getLocalInstance((Context)ctx);
                if (!iBizAccountOut.exists((IObjectPK)new ObjectUuidPK(srcBillID))) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaim_CheckBillExist"));
                    return;
                }
                BizAccountOutBillInfo bizAccountOut = iBizAccountOut.getBizAccountOutBillInfo((IObjectPK)new ObjectUuidPK(srcBillID));
                if (!bizAccountOut.getState().equals((Object)StateEnum.CHECKED) && !bizAccountOut.getState().equals((Object)StateEnum.ISPAYBILL) || bizAccountOut.getAmountNotPaid().compareTo(BigDecimal.ZERO) == -1) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"PayClaim_BizAccountOutBillTip"));
                    return;
                }
                String sumSql = "SELECT sum(b.FACTUALPAYAMOUNT ) FROM T_BOT_Relation a, t_cas_paymentbill b where a.FDESTOBJECTID =b.fid and a.FSRCOBJECTID =? and a.FDESTENTITYID =? and  b.FBILLSTATUS !=10";
                IRowSet rS = DbUtil.executeQuery((Context)ctx, (String)sumSql, (Object[])new Object[]{srcBillID, "40284E81"});
                try {
                    if (rS.next()) {
                        BigDecimal sumAmount = rS.getBigDecimal(1) == null ? BigDecimal.ZERO : rS.getBigDecimal(1);
                        BigDecimal result = bizAccountOut.getAmountApproved().subtract(sumAmount);
                        if (payInfo.getActPayAmt().compareTo(result) == 1) {
                            sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"PayClaim_BizAccountOutBillTipExt"));
                            return;
                        }
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
                description = description + String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"11_PayBillClaimControllerBean", (Locale)ctx.getLocale()), srcBillNumber);
                if (description.length() > 255) {
                    description = description.substring(0, 255);
                }
                saveSql.append(" fdescription=?,fSourceBillId=? where fid=?");
                params.add(description);
                params.add(srcBillID);
                params.add(payInfo.getId().toString());
                payInfo.setSourceBillId(srcBillID);
                DbUtil.execute((Context)ctx, (String)saveSql.toString(), (Object[])params.toArray());
                entrySql.append(" FSOURCEBILLID =? where FPAYMENTBILLID =? ");
                entryParams.add(srcBillID);
                entryParams.add(destBillID);
                for (int i = 0; i < payInfo.getEntries().size(); ++i) {
                    payInfo.getEntries().get(i).setSourceBillId(srcBillID);
                }
                DbUtil.execute((Context)ctx, (String)entrySql.toString(), (Object[])entryParams.toArray());
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
                if (!bizAccountOut.isIsCreatePayBill()) {
                    DbUtil.execute((Context)ctx, (String)"update T_BC_BizAccountOutBill set fiscreatepaybill=1,FSTATE=65 where fid=?", (Object[])new Object[]{srcBillID});
                }
                if (payInfo.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
                    serviceHandler.dispose(ctx, payInfo, DisposerActionEnum.PAY);
                }
                this.helper.createBotpRelation(ctx, srcBillID, destBillID);
                success.add(payInfo.getId().toString());
                break;
            }
            case 100: {
                ILoanInterest iLoanInt = LoanInterestFactory.getLocalInstance((Context)ctx);
                if (!iLoanInt.exists((IObjectPK)new ObjectUuidPK(srcBillID))) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaim_CheckBillExist"));
                    return;
                }
                LoanInterestInfo loanIntInfo = iLoanInt.getLoanInterestInfo((IObjectPK)new ObjectUuidPK(srcBillID));
                if (loanIntInfo.getInterestType() != IntCalTypeEnum.PAY_INT && loanIntInfo.getInterestType() != IntCalTypeEnum.REPAY_INT || loanIntInfo.getCashier() != null || loanIntInfo.isIsGenPayBill() || loanIntInfo.getStatusExtEnum() != StatusExtEnum.AUDIT || loanIntInfo.getRealInterest().compareTo(BigDecimal.ZERO) == 0 && loanIntInfo.getPunishInterest().compareTo(BigDecimal.ZERO) == 0 || loanIntInfo.getIntCurrencyAmt().compareTo(payInfo.getActPayAmt()) != 0) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"PayClaim_LoanIntTip"));
                    return;
                }
                if ((description = description + String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"12_PayBillClaimControllerBean", (Locale)ctx.getLocale()), srcBillNumber)).length() > 255) {
                    description = description.substring(0, 255);
                }
                saveSql.append(" fdescription=? ,fSourceBillId=? where fid=?");
                params.add(description);
                params.add(loanIntInfo.getId().toString());
                params.add(payInfo.getId().toString());
                DbUtil.execute((Context)ctx, (String)saveSql.toString(), (Object[])params.toArray());
                entrySql.append(" FSOURCEBILLID =? where FPAYMENTBILLID =? ");
                entryParams.add(srcBillID);
                entryParams.add(destBillID);
                DbUtil.execute((Context)ctx, (String)entrySql.toString(), (Object[])entryParams.toArray());
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
                String loanIntSql = "update T_FIN_LoanInterest set FIsGenPayBill=1 where fid=?";
                DbUtil.execute((Context)ctx, (String)loanIntSql, (Object[])new Object[]{srcBillID});
                this.helper.createBotpRelation(ctx, srcBillID, destBillID);
                success.add(payInfo.getId().toString());
            }
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"auditOne", (BOSObjectType)info.getBOSType(), (IObjectPK)new ObjectUuidPK(payInfo.getId()), (String)payInfo.getNumber(), (String)"rpm_payClaim_audit", (String)ctx.get((Object)"CurCompanyId").toString(), null);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _antiAuditOne(Context ctx, PayBillClaimInfo info, PaymentBillInfo payInfo, StringBuffer sb, Set success) throws BOSException, EASBizException {
        String srcObjectId = info.getSrcBillID();
        String srcNumber = info.getSrcBillNumber();
        String destObjectId = info.getPaymentBillID();
        String destNumber = payInfo.getNumber();
        String paySql = "update t_cas_paymentbill set fbillclaimstatus=?, fdescription=null, fSourceBillId=null where fid=?";
        String entrySql = "update t_cas_paymentbillentry set FSOURCEBILLID =? where FPAYMENTBILLID =? and FSOURCEBILLID=?";
        String claimSql = "UPDATE T_RPM_PayBillClaim SET fauditor=null,faudittime=null  WHERE fid=? ";
        Object[] payParams = new Object[]{20, destObjectId};
        Object[] entryParams = new Object[]{null, destObjectId, srcObjectId};
        if (!payInfo.getBillClaimStatus().equals((Object)BillClaimStatusEnum.AUDIT)) {
            sb.append(destNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaimStatusIsNotAudit"));
            return;
        }
        if (EmptyUtil.isEmpty((String)srcObjectId)) {
            DbUtil.execute((Context)ctx, (String)paySql, (Object[])new Object[]{20, destObjectId});
            DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{info.getId().toString()});
            success.add(destObjectId);
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"antiAuditOne", (BOSObjectType)info.getBOSType(), (IObjectPK)new ObjectUuidPK(payInfo.getId()), (String)payInfo.getNumber(), (String)"rpm_payClaim_antiAudit", (String)ctx.get((Object)"CurCompanyId").toString(), null);
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            return;
        }
        ServiceHandler serviceHandler = new ServiceHandler();
        String billType = info.getPayClaimBillType().getAlias();
        IBOTRelation iBotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        BOTRelationInfo botInfo = null;
        if (!info.getPayClaimBillType().equals((Object)PayClaimBillTypeEnum.PayableBill)) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("srcObjectId", (Object)srcObjectId));
            filter.getFilterItems().add(new FilterItemInfo("destObjectId", (Object)destObjectId));
            evi.setFilter(filter);
            BOTRelationCollection botCol = iBotRelation.getCollection(evi);
            if (botCol.size() == 0) {
                sb.append(String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"13_PayBillClaimControllerBean", (Locale)ctx.getLocale()), destNumber, billType, srcNumber));
                return;
            }
            if (botCol.size() == 1) {
                botInfo = botCol.get(0);
            } else {
                sb.append(String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"14_PayBillClaimControllerBean", (Locale)ctx.getLocale()), destNumber, billType, srcNumber));
                return;
            }
        }
        switch (info.getPayClaimBillType().getValue()) {
            case 10: {
                EntityViewInfo conevi = new EntityViewInfo();
                FilterInfo confilter = new FilterInfo();
                confilter.getFilterItems().add(new FilterItemInfo("repayment.id", (Object)srcObjectId));
                conevi.setFilter(confilter);
                LoanInterestCollection loanInterest = LoanInterestFactory.getLocalInstance((Context)ctx).getLoanInterestCollection(conevi);
                String btpSql = "delete from t_bot_relation where fsrcobjectid=? and fdestobjectid=?";
                String interestSql = "update T_FIN_LoanInterest set FRealInterest=?,FINTCURRENCYAMT=?,FIsGenPayBill=0 where fid=?";
                BigDecimal loanAccrual = BigDecimal.ZERO;
                BigDecimal locLoanAccrual = BigDecimal.ZERO;
                for (int i = 0; i < loanInterest.size(); ++i) {
                    loanAccrual = loanInterest.get(i).getInterest();
                    locLoanAccrual = loanAccrual.multiply(loanInterest.get(i).getIntCurrencyRate());
                    DbUtil.execute((Context)ctx, (String)btpSql, (Object[])new Object[]{loanInterest.get(i).getId().toString(), destObjectId});
                    DbUtil.execute((Context)ctx, (String)interestSql, (Object[])new Object[]{loanAccrual, locLoanAccrual, loanInterest.get(i).getId().toString()});
                }
                RepaymentInfo repay = RepaymentFactory.getLocalInstance((Context)ctx).getRepaymentInfo((IObjectPK)new ObjectUuidPK(srcObjectId));
                iBotRelation.delete((IObjectPK)new ObjectUuidPK(botInfo.getId()));
                DbUtil.execute((Context)ctx, (String)paySql, (Object[])payParams);
                DbUtil.execute((Context)ctx, (String)entrySql, (Object[])entryParams);
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{info.getId().toString()});
                String repaySql = "update T_FIN_Repayment set FTotalPayedAmt=?,FISPAYCOMPLETED = 0,FINTEREST=?,FPAYMENT=? where fid=?";
                if (repay.getTotalPayedAmt().subtract(payInfo.getActPayAmt()).compareTo(BigDecimal.ZERO) <= 0) {
                    repaySql = "update T_FIN_Repayment set FTotalPayedAmt=?,FIsGenPayBill=0,FISPAYCOMPLETED = 0,FINTEREST=?,FPAYMENT=? where fid=?";
                }
                DbUtil.execute((Context)ctx, (String)repaySql, (Object[])new Object[]{repay.getTotalPayedAmt().subtract(payInfo.getActPayAmt()), locLoanAccrual, locLoanAccrual.add(repay.getSourceAmount()), srcObjectId});
                IGenPayRecord iGenPayRec = GenPayRecordFactory.getLocalInstance((Context)ctx);
                FilterInfo filterRecord = new FilterInfo();
                filterRecord.getFilterItems().add(new FilterItemInfo("repayment", (Object)repay.getId().toString()));
                filterRecord.getFilterItems().add(new FilterItemInfo("paymentbillid", (Object)payInfo.getId().toString()));
                iGenPayRec.delete(filterRecord);
                success.add(destObjectId);
                break;
            }
            case 20: {
                iBotRelation.delete((IObjectPK)new ObjectUuidPK(botInfo.getId()));
                DbUtil.execute((Context)ctx, (String)paySql, (Object[])payParams);
                DbUtil.execute((Context)ctx, (String)entrySql, (Object[])entryParams);
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{info.getId().toString()});
                String conloanSql = "update T_CL_ConsignmentLoanBill set FIsCreateCPayment=0 where fid=?";
                DbUtil.execute((Context)ctx, (String)conloanSql, (Object[])new Object[]{srcObjectId});
                success.add(destObjectId);
                break;
            }
            case 30: {
                iBotRelation.delete((IObjectPK)new ObjectUuidPK(botInfo.getId()));
                DbUtil.execute((Context)ctx, (String)paySql, (Object[])payParams);
                DbUtil.execute((Context)ctx, (String)entrySql, (Object[])entryParams);
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{info.getId().toString()});
                String fundSql = "update T_FT_FundTransferBill set FIsGenPayBill=0 , FPaymentBillID=? where fid=?";
                DbUtil.execute((Context)ctx, (String)fundSql, (Object[])new Object[]{null, srcObjectId});
                success.add(destObjectId);
                break;
            }
            case 40: {
                boolean isAutoVerifyPaymentBill = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS070_01", (IObjectPK)new ObjectUuidPK(payInfo.getCompany().getId()));
                if (isAutoVerifyPaymentBill) {
                    EntityViewInfo evi = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("srcObjectId", (Object)srcObjectId));
                    filter.getFilterItems().add(new FilterItemInfo("destObjectId", (Object)destObjectId));
                    evi.setFilter(filter);
                    BOTRelationCollection botCol = iBotRelation.getCollection(evi);
                    if (botCol.size() != 0) {
                        if (botCol.size() == 1) {
                            botInfo = botCol.get(0);
                            iBotRelation.delete((IObjectPK)new ObjectUuidPK(botInfo.getId()));
                        } else {
                            sb.append(String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"14_PayBillClaimControllerBean", (Locale)ctx.getLocale()), destNumber, billType, srcNumber));
                            return;
                        }
                    }
                    if (RepaymentFactory.getLocalInstance((Context)ctx).exists("where sourcebillid = '" + srcObjectId + "'")) {
                        RepaymentInfo repayInfo = RepaymentFactory.getLocalInstance((Context)ctx).getRepaymentInfo("where sourcebillid = '" + srcObjectId + "'");
                        String sql = " delete from T_BOT_Relation where fsrcObjectId=? and fdestObjectId=? ";
                        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{destObjectId, repayInfo.getId().toString()});
                    }
                }
                DbUtil.execute((Context)ctx, (String)paySql, (Object[])payParams);
                DbUtil.execute((Context)ctx, (String)entrySql, (Object[])entryParams);
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{info.getId().toString()});
                success.add(destObjectId);
                break;
            }
            case 50: {
                DbUtil.execute((Context)ctx, (String)paySql, (Object[])payParams);
                DbUtil.execute((Context)ctx, (String)entrySql, (Object[])entryParams);
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{info.getId().toString()});
                String financeSql = "update T_IVT_FinancingAccount set fisGenePayBill=0 where fid=?";
                DbUtil.execute((Context)ctx, (String)financeSql, (Object[])new Object[]{srcObjectId});
                iBotRelation.delete((IObjectPK)new ObjectUuidPK(botInfo.getId()));
                success.add(destObjectId);
                break;
            }
            case 60: {
                if (payInfo.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
                    serviceHandler.dispose(ctx, payInfo, DisposerActionEnum.CANCEL_PAY);
                }
                serviceHandler.dispose(ctx, payInfo, DisposerActionEnum.DELETE);
                iBotRelation.delete((IObjectPK)new ObjectUuidPK(botInfo.getId()));
                DbUtil.execute((Context)ctx, (String)paySql, (Object[])payParams);
                DbUtil.execute((Context)ctx, (String)entrySql, (Object[])entryParams);
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{info.getId().toString()});
                String sumsql = "SELECT * FROM T_BOT_Relation where FSRCOBJECTID =? and FDESTENTITYID =? and FDESTOBJECTID!=?";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sumsql, (Object[])new Object[]{srcObjectId, "40284E81", destObjectId});
                try {
                    if (!rs.next()) {
                        DbUtil.execute((Context)ctx, (String)"update\tT_BC_BizAccountBill set fiscreatepaybill=0 where fid=? ", (Object[])new Object[]{srcObjectId});
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
                success.add(destObjectId);
                break;
            }
            case 61: {
                if (payInfo.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
                    serviceHandler.dispose(ctx, payInfo, DisposerActionEnum.CANCEL_PAY);
                }
                serviceHandler.dispose(ctx, payInfo, DisposerActionEnum.DELETE);
                iBotRelation.delete((IObjectPK)new ObjectUuidPK(botInfo.getId()));
                DbUtil.execute((Context)ctx, (String)paySql, (Object[])payParams);
                DbUtil.execute((Context)ctx, (String)entrySql, (Object[])entryParams);
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{info.getId().toString()});
                String getDailyLoan = "SELECT * FROM T_BOT_Relation where FSRCOBJECTID =? and FDESTENTITYID =? and FDESTOBJECTID!=?";
                IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)getDailyLoan, (Object[])new Object[]{srcObjectId, "40284E81", destObjectId});
                try {
                    if (!rows.next()) {
                        DbUtil.execute((Context)ctx, (String)"update\tT_BC_DailyLoanBill set fiscreatepaybill=0 where fid=? ", (Object[])new Object[]{srcObjectId});
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
                success.add(destObjectId);
                break;
            }
            case 70: {
                RepaymentInfo repay4credit = RepaymentFactory.getLocalInstance((Context)ctx).getRepaymentInfo((IObjectPK)new ObjectUuidPK(srcObjectId));
                serviceHandler.dispose(ctx, payInfo, DisposerActionEnum.DELETE);
                DbUtil.execute((Context)ctx, (String)paySql, (Object[])payParams);
                DbUtil.execute((Context)ctx, (String)entrySql, (Object[])entryParams);
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{info.getId().toString()});
                iBotRelation.delete((IObjectPK)new ObjectUuidPK(botInfo.getId()));
                success.add(destObjectId);
                break;
            }
            case 80: {
                RepaymentInfo repay4guarantee = RepaymentFactory.getLocalInstance((Context)ctx).getRepaymentInfo((IObjectPK)new ObjectUuidPK(srcObjectId));
                serviceHandler.dispose(ctx, payInfo, DisposerActionEnum.DELETE);
                DbUtil.execute((Context)ctx, (String)paySql, (Object[])payParams);
                DbUtil.execute((Context)ctx, (String)entrySql, (Object[])entryParams);
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{info.getId().toString()});
                iBotRelation.delete((IObjectPK)new ObjectUuidPK(botInfo.getId()));
                success.add(destObjectId);
                break;
            }
            case 90: {
                if (payInfo.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
                    serviceHandler.dispose(ctx, payInfo, DisposerActionEnum.CANCEL_PAY);
                }
                serviceHandler.dispose(ctx, payInfo, DisposerActionEnum.DELETE);
                iBotRelation.delete((IObjectPK)new ObjectUuidPK(botInfo.getId()));
                DbUtil.execute((Context)ctx, (String)paySql, (Object[])payParams);
                DbUtil.execute((Context)ctx, (String)entrySql, (Object[])entryParams);
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{info.getId().toString()});
                String sumSql = "SELECT * FROM T_BOT_Relation where FSRCOBJECTID =? and FDESTENTITYID =? and FDESTOBJECTID!=?";
                IRowSet rS = DbUtil.executeQuery((Context)ctx, (String)sumSql, (Object[])new Object[]{srcObjectId, "40284E81", destObjectId});
                try {
                    if (!rS.next()) {
                        DbUtil.execute((Context)ctx, (String)"update\tT_BC_BizAccountOutBill set fiscreatepaybill=0 where fid=? ", (Object[])new Object[]{srcObjectId});
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
                success.add(destObjectId);
                break;
            }
            case 100: {
                iBotRelation.delete((IObjectPK)new ObjectUuidPK(botInfo.getId()));
                DbUtil.execute((Context)ctx, (String)paySql, (Object[])payParams);
                DbUtil.execute((Context)ctx, (String)entrySql, (Object[])entryParams);
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{info.getId().toString()});
                String loanIntSql = "update T_FIN_LoanInterest set FIsGenPayBill=0 where fid=?";
                DbUtil.execute((Context)ctx, (String)loanIntSql, (Object[])new Object[]{srcObjectId});
                success.add(destObjectId);
            }
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"antiAuditOne", (BOSObjectType)info.getBOSType(), (IObjectPK)new ObjectUuidPK(payInfo.getId()), (String)payInfo.getNumber(), (String)"rpm_payClaim_antiAudit", (String)ctx.get((Object)"CurCompanyId").toString(), null);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }
}

