/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.rpm.RPDMatchSettingCollection;
import com.kingdee.eas.fm.rpm.RPMException;
import com.kingdee.eas.fm.rpm.app.AbstractRPDMatchSettingControllerBean;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RPDMatchSettingControllerBean
extends AbstractRPDMatchSettingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.rpm.app.RPDMatchSettingControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _enable(Context ctx, String number, String asstObjectID) throws BOSException, EASBizException {
        Set companySet = this.getCompanysByNumber(ctx, number, asstObjectID);
        ArrayList<String> idList = new ArrayList<String>();
        for (Object companyId : companySet) {
            idList.add(companyId + asstObjectID + "enable");
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList appliedList = new ArrayList();
        try {
            Map resultRequest = iMutex.batchRequestObjIDForUpdate(idList);
            this.checkMutex(ctx, resultRequest, idList, appliedList);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companySet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("asstEntityID", (Object)asstObjectID));
            filter.getFilterItems().add(new FilterItemInfo("isEnable", (Object)true));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("company.id"));
            selector.add(new SelectorItemInfo("company.name"));
            view.setFilter(filter);
            view.setSelector(selector);
            RPDMatchSettingCollection coll = this.getRPDMatchSettingCollection(ctx, view);
            if (coll != null && coll.size() > 0) {
                StringBuffer companyNameString = new StringBuffer();
                for (int i = 0; i < coll.size(); ++i) {
                    if (i > 0) {
                        companyNameString.append(",");
                    }
                    companyNameString = companyNameString.append(coll.get(i).getCompany().getName());
                }
                throw new RPMException(RPMException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpm.RpmResources", (String)"28_OtherHasEnable", (String[])new String[]{companyNameString.toString()})});
            }
            String updateSql = "update T_RPM_RPDMatchSetting set FIsEnable = ?  where FNumber = ? and FAsstEntityID = ?";
            DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{new Integer(1), number, asstObjectID});
        }
        finally {
            if (appliedList.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(appliedList);
            }
        }
    }

    @Override
    protected void _disEnable(Context ctx, String number, String asstObjectID) throws BOSException, EASBizException {
        String updateSql = "update T_RPM_RPDMatchSetting set FIsEnable = ?  where FNumber = ? and FAsstEntityID = ?";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{new Integer(0), number, asstObjectID});
    }

    private Set getCompanysByNumber(Context ctx, String number, String asstObjectID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("asstEntityID", (Object)asstObjectID));
        filter.getFilterItems().add(new FilterItemInfo("company.id", null, CompareType.NOTEQUALS));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("company.id"));
        view.setSelector(selector);
        RPDMatchSettingCollection coll = this.getRPDMatchSettingCollection(ctx, view);
        HashSet<String> companySet = new HashSet<String>();
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                companySet.add(coll.get(i).getCompany().getId().toString());
            }
        }
        return companySet;
    }

    protected void checkMutex(Context ctx, Map resultRequest, List idList, List appliedList) throws RPMException {
        Boolean boolResult;
        int i;
        for (i = 0; i < idList.size(); ++i) {
            boolResult = (Boolean)resultRequest.get(idList.get(i));
            if (!boolResult.booleanValue()) continue;
            appliedList.add(idList.get(i));
        }
        for (i = 0; i < idList.size(); ++i) {
            boolResult = (Boolean)resultRequest.get(idList.get(i));
            if (boolResult.booleanValue()) continue;
            throw new RPMException(RPMException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.rpm.RpmResources", (String)"35_Enable_Lock")});
        }
    }
}

