/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kds.model.util.DateHelper;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.rpm.RPDMatchInfo;
import com.kingdee.eas.fm.rpm.RPDMatchResultCollection;
import com.kingdee.eas.fm.rpm.RPDMatchResultFactory;
import com.kingdee.eas.fm.rpm.RPDMatchResultInfo;
import com.kingdee.eas.fm.rpm.RPDMatchResultType;
import com.kingdee.eas.fm.rpm.RPDMatchSettingCollection;
import com.kingdee.eas.fm.rpm.RPDMatchSettingFactory;
import com.kingdee.eas.fm.rpm.RPDMatchSettingInfo;
import com.kingdee.eas.fm.rpm.RPMException;
import com.kingdee.eas.fm.rpm.app.AbstractRecDetailMatchFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RecDetailMatchFacadeControllerBean
extends AbstractRecDetailMatchFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.rpm.app.RecDetailMatchFacadeControllerBean");
    private final String BO_COMPANYID = "FCOMPANYID";
    private final String BO_ACCOUNTBANK_NUMBER = "FBANKACCOUNTNUMBER";
    private final String BO_CURRENCYID = "FCURRENCYID";
    private final String BO_BIZDATE = "FBIZDATE";
    private final String BO_DESCRIPTION = "FDESCRIPTION";
    private final String TRANSDETAIL = "com.kingdee.eas.fm.be.app.TransDetail";
    private final String DEL_AMOUNT = "FCREDITAMOUNT";
    private final String DEL_ACCOUNTBANK_ID = "FBANKACCOUNTID";
    private final String DEL_BIZTIME = "FBIZTIME";
    private final String DEL_NAME = "FNAME";
    private final String DEL_OPPUNIT = "FOPPUNIT";
    private final String DEL_OPPBANKNUMBER = "FOPPBANKNUMBER";
    private final String DEL_OPPBANK = "FOPPBANK";
    private final String DEL_AGENTACCNO = "FAGENTACCNO";
    private final String DEL_AGENTACCNAME = "FAGENTACCNAME";
    private final String DEL_AGENTACCBKNAME = "FAGENTACCBKNAME";
    private final String DEL_NUMBER = "FNUMBER";
    private final String DEL_TRANPACKAGEID = "FTRANPACKAGEID";
    private final String RECBILL = "com.kingdee.eas.fi.cas.app.ReceivingBill";
    private final String REC_AMOUNT = "FACTRECAMT";
    private final String REC_ACCOUNTBANK_ID = "FPAYEEACCOUNTBANKID";
    private final String REC_RECBILLTYPE_ID = "FRECBILLTYPEID";
    private final String REC_RECBILLTYPE_NAME = "FRECBILLTYPENAME";
    private final String REC_RECBILLTYPE_TABLE_NAME = "FNAME";
    private final String REC_SETTLEMENTTYPE_ID = "FSETTLEMENTTYPEID";
    private final String REC_SETTLEMENTTYPE_NAME = "FSETTLEMENTTYPENAME";
    private final String REC_SETTLEMENTTYPE_TABLE_NAME = "FNAME";
    private final String REC_SETTLEMENTNUMBER = "FSETTLEMENTNUMBER";
    private final String REC_PAYERNAME = "FPAYERNAME_l2";
    private final String REC_PAYERACCOUNTBANK = "FPAYERACCOUNTBANK";
    private final String REC_PAYACCOUNTBANK = "FPAYACCOUNTBANK";
    private final String REC_PAYERBANK = "FPAYERACCOUNTNUMBER";
    private final String REC_FEETYPE_ID = "FFEETYPEID";
    private final String REC_FEETYPE_NAME = "FFEETYPENAME";
    private final String REC_FEETYPE_TABLE_NAME = "FNAME";
    private final String REC_NUMBER = "FNUMBER";
    private final String AUTO = "auto";
    private final String MANUAL = "manual";
    private final String ANTIMATCH = "antiMatch";
    private final String RECDETAIL = "RECDETAIL";
    private final String MAINTABLENAME = "X0";
    private final String ASSTTABLENAME = "X1";
    String[] DEL_FIELDS = new String[]{"FCOMPANYID", "FBANKACCOUNTNUMBER", "FCURRENCYID", "FBIZDATE", "FDESCRIPTION", "FCREDITAMOUNT", "FBANKACCOUNTID", "FBIZTIME", "FNAME", "FOPPUNIT", "FOPPBANKNUMBER", "FOPPBANK", "FAGENTACCNO", "FAGENTACCNAME", "FAGENTACCBKNAME", "FNUMBER", "FTRANPACKAGEID"};
    String[] REC_FIELDS = new String[]{"FCOMPANYID", "FBANKACCOUNTNUMBER", "FCURRENCYID", "FBIZDATE", "FDESCRIPTION", "FACTRECAMT", "FPAYEEACCOUNTBANKID", "FRECBILLTYPEID", "FRECBILLTYPENAME", "FSETTLEMENTTYPEID", "FSETTLEMENTTYPENAME", "FSETTLEMENTNUMBER", "FPAYERNAME_l2", "FPAYERACCOUNTBANK", "FPAYERACCOUNTNUMBER", "FFEETYPEID", "FFEETYPENAME", "FNUMBER", "FPAYACCOUNTBANK"};
    private final String resPath = "com.kingdee.eas.fm.rpm.RpmResources";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectCollection _autoMatch(Context ctx, Map comMapIdList, Set acctBankIdSet, Map matchSettingMap, boolean isCheckPermission) throws BOSException, EASBizException {
        if (isCheckPermission) {
            this.checkPermission(ctx, comMapIdList.keySet(), "auto");
        }
        logger.error((Object)("--------\u6536\u6b3e\u5339\u914d-----------comMapIdList\uff1a" + comMapIdList + "----------------------"));
        logger.error((Object)("--------\u6536\u6b3e\u5339\u914d-----------acctBankIdSet\uff1a" + acctBankIdSet + "----------------------"));
        ArrayList<String> idList = new ArrayList<String>();
        for (Object value : acctBankIdSet) {
            idList.add(value + "RECDETAIL");
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList appliedList = new ArrayList();
        try {
            Map resultRequest = iMutex.batchRequestObjIDForUpdate(idList);
            this.checkMutex(resultRequest, idList, appliedList);
            RPDMatchResultCollection resultColl = null;
            long startTime = System.currentTimeMillis();
            resultColl = this.matchProcess(ctx, comMapIdList, "auto", matchSettingMap);
            long endTime = System.currentTimeMillis();
            logger.error((Object)("--------\u6536\u6b3e\u5339\u914d-----------\u81ea\u52a8\u5339\u914d\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L + "----------------------"));
            this.submitResult(ctx, resultColl, comMapIdList.keySet(), matchSettingMap);
            RPDMatchResultCollection rPDMatchResultCollection = resultColl;
            return rPDMatchResultCollection;
        }
        finally {
            if (appliedList.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(appliedList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectCollection _manualMatch(Context ctx, Map idListMap, Set companyIdSet, Set acctBankIdSet, Map matchSettingMap) throws BOSException, EASBizException {
        this.checkPermission(ctx, companyIdSet, "manual");
        logger.error((Object)("--------\u6536\u6b3e\u5339\u914d-----------idListMap\uff1a" + idListMap + "----------------------"));
        logger.error((Object)("--------\u6536\u6b3e\u5339\u914d-----------companyIdSet\uff1a" + companyIdSet + "----------------------"));
        logger.error((Object)("--------\u6536\u6b3e\u5339\u914d-----------acctBankIdSet\uff1a" + acctBankIdSet + "----------------------"));
        ArrayList<String> idList = new ArrayList<String>();
        for (Object value : acctBankIdSet) {
            idList.add(value + "RECDETAIL");
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList appliedList = new ArrayList();
        try {
            Map resultRequest = iMutex.batchRequestObjIDForUpdate(idList);
            this.checkMutex(resultRequest, idList, appliedList);
            RPDMatchResultCollection resultColl = null;
            long startTime = System.currentTimeMillis();
            resultColl = this.matchProcess(ctx, idListMap, "manual", matchSettingMap);
            long endTime = System.currentTimeMillis();
            logger.error((Object)("-------\u6536\u6b3e\u5339\u914d------------\u624b\u5de5\u5bf9\u8d26\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L + "----------------------"));
            this.submitResult(ctx, resultColl, companyIdSet, matchSettingMap);
            RPDMatchResultCollection rPDMatchResultCollection = resultColl;
            return rPDMatchResultCollection;
        }
        finally {
            if (appliedList.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(appliedList);
            }
        }
    }

    protected void submitResult(Context ctx, RPDMatchResultCollection resultColl, Set companyIdSet, Map matchSettingMap) throws EASBizException, BOSException {
        long startTime = System.currentTimeMillis();
        CoreBaseCollection rpdColl = new CoreBaseCollection();
        BOTRelationCollection botColl = new BOTRelationCollection();
        ArrayList<String> bathSql = new ArrayList<String>();
        HashMap botRelationMap = new HashMap();
        HashMap<String, String> numberMap = new HashMap<String, String>();
        Map<Object, Object> companySetMap = new HashMap();
        companySetMap = this.getCompanyMap(companyIdSet, matchSettingMap);
        HashSet<String> enteredRecBillIdSet = new HashSet<String>();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)resultColl)) {
            for (int index = 0; index < resultColl.size(); ++index) {
                RPDMatchResultInfo resultInfo = resultColl.get(index);
                rpdColl.add((CoreBaseInfo)resultInfo);
                String key = resultInfo.getKey();
                String objectId = resultInfo.getBizObjectId() == null ? null : resultInfo.getBizObjectId().toString();
                String objectFullName = resultInfo.getBizObjectFullName();
                if (botRelationMap.containsKey(key)) {
                    ((List)((Map)botRelationMap.get(key)).get(objectFullName)).add(objectId);
                } else {
                    HashMap idMap = new HashMap();
                    ArrayList<String> mainIdList = new ArrayList<String>();
                    ArrayList<String> asstIdList = new ArrayList<String>();
                    if ("com.kingdee.eas.fm.be.app.TransDetail".equals(objectFullName)) {
                        mainIdList.add(objectId);
                    } else if ("com.kingdee.eas.fi.cas.app.ReceivingBill".equals(objectFullName)) {
                        asstIdList.add(objectId);
                    }
                    idMap.put("com.kingdee.eas.fm.be.app.TransDetail", mainIdList);
                    idMap.put("com.kingdee.eas.fi.cas.app.ReceivingBill", asstIdList);
                    botRelationMap.put(key, idMap);
                }
                if (!"com.kingdee.eas.fi.cas.app.ReceivingBill".equals(objectFullName)) continue;
                numberMap.put(objectId, resultInfo.getBillNumber());
                String companyId = resultInfo.getCompany().getId().toString();
                if (!companySetMap.containsKey(companyId) || !((Boolean)companySetMap.get(companyId)).booleanValue()) continue;
                enteredRecBillIdSet.add(objectId);
            }
        } else {
            return;
        }
        long endTime = System.currentTimeMillis();
        logger.error((Object)("------\u6536\u6b3e\u5339\u914d-------------\u5faa\u73af\u83b7\u53d6\u5bf9\u8d26\u7ed3\u679c\u4e1a\u52a1id\u96c6\u5408\u8d26\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L + "----------------------"));
        startTime = System.currentTimeMillis();
        for (String key : botRelationMap.keySet()) {
            Map idMap = (Map)botRelationMap.get(key);
            List mainIdList = (List)idMap.get("com.kingdee.eas.fm.be.app.TransDetail");
            List asstIdList = (List)idMap.get("com.kingdee.eas.fi.cas.app.ReceivingBill");
            for (int i = 0; i < mainIdList.size(); ++i) {
                String recBillNumber = "";
                for (int j = 0; j < asstIdList.size(); ++j) {
                    if (mainIdList.size() > 1 && asstIdList.size() > 1) {
                        throw new RPMException(RPMException.MULTOMULMATCH);
                    }
                    botColl.add(this.parseBOTRelation((String)mainIdList.get(i), (String)asstIdList.get(j)));
                    recBillNumber = recBillNumber + (String)numberMap.get(asstIdList.get(j));
                    if (j == asstIdList.size() - 1) continue;
                    recBillNumber = recBillNumber + ";";
                }
                bathSql.add(this.updateTransDetail((String)mainIdList.get(i), recBillNumber));
                if (mainIdList.size() != 1) continue;
                bathSql.add(this.updateRecBill((String)mainIdList.get(i), FMHelper.list2Set((List)asstIdList)));
                bathSql.add(this.updateJournal(ctx, (String)mainIdList.get(i), FMHelper.list2Set((List)asstIdList)));
            }
        }
        endTime = System.currentTimeMillis();
        logger.error((Object)("-------\u6536\u6b3e\u5339\u914d------------\u5faa\u73af\u5904\u7406\u6570\u636e\u8d26\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L + "----------------------"));
        startTime = System.currentTimeMillis();
        RPDMatchResultFactory.getLocalInstance(ctx).addnewBatchData(rpdColl);
        endTime = System.currentTimeMillis();
        logger.error((Object)("--------\u6536\u6b3e\u5339\u914d-----------\u65b0\u589e\u5339\u914d\u7ed3\u679c\u8d26\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L + "----------------------"));
        startTime = System.currentTimeMillis();
        BTPManagerFactory.getLocalInstance((Context)ctx).submitRelations(botColl);
        endTime = System.currentTimeMillis();
        logger.error((Object)("--------\u6536\u6b3e\u5339\u914d-----------\u5efa\u7acbBOTP\u5173\u7cfb\u8d26\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L + "----------------------"));
        startTime = System.currentTimeMillis();
        com.kingdee.eas.base.core.util.DbUtil.executeBatch((Context)ctx, bathSql);
        endTime = System.currentTimeMillis();
        logger.error((Object)("--------\u6536\u6b3e\u5339\u914d-----------\u6279\u91cf\u53cd\u5199\u5355\u636e\u72b6\u6001\u8d26\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L + "----------------------"));
        startTime = System.currentTimeMillis();
        Iterator recBillIt = enteredRecBillIdSet.iterator();
        IReceivingBill iReceivingBill = ReceivingBillFactory.getLocalInstance((Context)ctx);
        while (recBillIt.hasNext()) {
            try {
                String key = (String)recBillIt.next();
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(key);
                iReceivingBill.rec(idSet);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage());
            }
        }
        endTime = System.currentTimeMillis();
        logger.error((Object)("-------\u6536\u6b3e\u5339\u914d------------\u6536\u6b3e\u5355\u6536\u6b3e\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L + "----------------------"));
    }

    protected RPDMatchResultCollection matchProcess(Context ctx, Map<String, Map<String, List<String>>> comMapIdList, String matchType, Map matchSettingMap) throws BOSException, EASBizException {
        RPDMatchResultCollection resultColl = new RPDMatchResultCollection();
        RPDMatchInfo matchInfo = new RPDMatchInfo();
        matchInfo.setId(BOSUuid.create((BOSObjectType)matchInfo.getBOSType()));
        long startTime = System.currentTimeMillis();
        HashMap<String, String> tableName = new HashMap<String, String>();
        ITableManagerFacade mang = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String table = mang.getTableName("rpdTran");
        tableName.put("com.kingdee.eas.fm.be.app.TransDetail", this.createTempTable(ctx, table, "com.kingdee.eas.fm.be.app.TransDetail"));
        table = mang.getTableName("rpdRec");
        tableName.put("com.kingdee.eas.fi.cas.app.ReceivingBill", this.createTempTable(ctx, table, "com.kingdee.eas.fi.cas.app.ReceivingBill"));
        long endTime = System.currentTimeMillis();
        logger.error((Object)("-------\u6536\u6b3e\u5339\u914d------------\u751f\u6210\u4e34\u65f6\u8868\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L + "----------------------"));
        ArrayList<Integer> group = new ArrayList<Integer>();
        int i = 0;
        try {
            for (String key : comMapIdList.keySet()) {
                Map<String, List<String>> mapIdList = comMapIdList.get(key);
                if (mapIdList.get("com.kingdee.eas.fm.be.app.TransDetail") != null && mapIdList.get("com.kingdee.eas.fi.cas.app.ReceivingBill") != null && (mapIdList.get("com.kingdee.eas.fm.be.app.TransDetail").size() == 0 || mapIdList.get("com.kingdee.eas.fi.cas.app.ReceivingBill").size() == 0)) continue;
                logger.error((Object)("------\u6536\u6b3e\u5339\u914d-------------\u5339\u914d\u4e3b\u65b9\u5355\u636eid\uff1a" + mapIdList.get("com.kingdee.eas.fm.be.app.TransDetail") + "----------------------"));
                logger.error((Object)("------\u6536\u6b3e\u5339\u914d-------------\u5339\u914d\u8f85\u65b9\u5355\u636eid\uff1a" + mapIdList.get("com.kingdee.eas.fi.cas.app.ReceivingBill") + "----------------------"));
                HashMap mapBoInfo = new HashMap();
                for (String boInfo : mapIdList.keySet()) {
                    this.insertTempTable(ctx, (String)tableName.get(boInfo), boInfo, mapIdList.get(boInfo));
                    mapBoInfo.put(boInfo, tableName.get(boInfo));
                }
                group.clear();
                group.add((i++ + 1) * 100000);
                if ("auto".equals(matchType)) {
                    String sqlMatch = this.getDefMatchColl();
                    String sqlCompanyMatch = this.getCompanyMatchColl(key, matchSettingMap);
                    if (!EmptyUtil.isEmpty((String)sqlCompanyMatch)) {
                        sqlMatch = sqlMatch + " and " + sqlCompanyMatch;
                    }
                    String orderBy = this.getBizDateOrder();
                    String sqlFormula = this.getTableFormula(ctx, tableName);
                    String sqlResult = sqlFormula + " and " + sqlMatch + orderBy;
                    logger.error((Object)("------\u6536\u6b3e\u5339\u914d-------------\u81ea\u52a8\u5339\u914dsqlResult\uff1a" + sqlResult + "----------------------"));
                    RPDMatchResultCollection coll = this.excuteSQLResult(ctx, matchInfo.getId().toString(), sqlResult, group);
                    resultColl.addCollection(coll);
                } else {
                    String sqlResult = this.getSumBizMatchFormula(tableName);
                    Integer groupNumber = (Integer)group.get(0);
                    RPDMatchResultCollection coll = this.excuteSQLResultSum(ctx, matchInfo.getId().toString(), sqlResult, groupNumber, tableName);
                    resultColl.addCollection(coll);
                }
                this.delTempTableData(ctx, (String)tableName.get("com.kingdee.eas.fi.cas.app.ReceivingBill"));
                this.delTempTableData(ctx, (String)tableName.get("com.kingdee.eas.fm.be.app.TransDetail"));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            for (String tab : tableName.keySet()) {
                mang.releaseTableName((String)tableName.get(tab));
            }
        }
        return resultColl;
    }

    protected String getSumBizMatchFormula(Map<String, String> tableName) {
        String mainTable = tableName.get("com.kingdee.eas.fm.be.app.TransDetail");
        String asstTable = tableName.get("com.kingdee.eas.fi.cas.app.ReceivingBill");
        StringBuffer select = new StringBuffer();
        select.append("Select (");
        select.append("(Select isnull(sum(FCREDITAMOUNT) ,0) from " + mainTable + " where " + "FCREDITAMOUNT" + " <> 0) ");
        select.append(" - (Select isnull(sum(FACTRECAMT) ,0) from " + asstTable + " where " + "FACTRECAMT" + " <> 0) ");
        select.append(")");
        return select.toString();
    }

    protected RPDMatchResultCollection excuteSQLResultSum(Context ctx, String matchInfoId, String sqlResult, Integer groupNumber, Map<String, String> tableName) throws BOSException {
        RPDMatchResultCollection coll = new RPDMatchResultCollection();
        try {
            BigDecimal value;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlResult);
            if (rs.next() && (value = rs.getBigDecimal(1)) != null && value.compareTo(Constants.ZERO) == 0) {
                String sSQL = " select * from " + tableName.get("com.kingdee.eas.fm.be.app.TransDetail");
                IRowSet delRs = DbUtil.executeQuery((Context)ctx, (String)sSQL);
                while (delRs.next()) {
                    String matchId = delRs.getString("Fid");
                    RPDMatchResultInfo mainResultInfo = this.parseRPDMatchResult((ResultSet)delRs, "", matchId, groupNumber, matchInfoId, "com.kingdee.eas.fm.be.app.TransDetail");
                    coll.add(mainResultInfo);
                }
                sSQL = " select * from " + tableName.get("com.kingdee.eas.fi.cas.app.ReceivingBill");
                IRowSet recRs = DbUtil.executeQuery((Context)ctx, (String)sSQL);
                while (recRs.next()) {
                    String matchId = recRs.getString("Fid");
                    RPDMatchResultInfo asstResultInfo = this.parseRPDMatchResult((ResultSet)recRs, "", matchId, groupNumber, matchInfoId, "com.kingdee.eas.fi.cas.app.ReceivingBill");
                    coll.add(asstResultInfo);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return coll;
    }

    protected RPDMatchResultCollection excuteSQLResult(Context ctx, String matchInfoId, String sqlResult, List group) throws BOSException {
        RPDMatchResultCollection coll = new RPDMatchResultCollection();
        int groupNumber = (Integer)group.get(0);
        group.clear();
        group.add(new Integer(groupNumber));
        try {
            long startTime = System.currentTimeMillis();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlResult);
            long endTime = System.currentTimeMillis();
            logger.error((Object)("------\u6536\u6b3e\u5339\u914d-------------\u83b7\u53d6\u5bf9\u8d26\u5339\u914d\u7ed3\u679c\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L + "----------------------"));
            HashSet<String> tmpIDSet = new HashSet<String>();
            HashSet<String> tmpIDSet1 = new HashSet<String>();
            while (rs.next()) {
                ++groupNumber;
                String x0Id = rs.getString("X0Fid");
                String x1Id = rs.getString("X1Fid");
                if (tmpIDSet.contains(x0Id) || tmpIDSet1.contains(x1Id)) continue;
                tmpIDSet.add(x0Id);
                tmpIDSet1.add(x1Id);
                String matchId = rs.getString("X0Fid");
                RPDMatchResultInfo mainResultInfo = this.parseRPDMatchResult((ResultSet)rs, "X0", matchId, groupNumber, matchInfoId, "com.kingdee.eas.fm.be.app.TransDetail");
                coll.add(mainResultInfo);
                matchId = rs.getString("X1Fid");
                RPDMatchResultInfo asstResultInfo = this.parseRPDMatchResult((ResultSet)rs, "X1", matchId, groupNumber, matchInfoId, "com.kingdee.eas.fi.cas.app.ReceivingBill");
                coll.add(asstResultInfo);
            }
            endTime = System.currentTimeMillis();
            logger.error((Object)("------\u6536\u6b3e\u5339\u914d-------------\u5faa\u73af\u5bf9\u8d26\u5339\u914d\u62fc\u63a5\u7ed3\u679c\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L + "----------------------"));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return coll;
    }

    protected RPDMatchResultInfo parseRPDMatchResult(ResultSet rs, String colName, String matchId, int groupNumber, String matchInfoId, String billPath) throws UuidException, SQLException {
        RPDMatchResultInfo info = new RPDMatchResultInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setGroup(groupNumber);
        info.setKey(matchInfoId + groupNumber);
        info.setBizObjectId(BOSUuid.read((String)matchId));
        info.setCreateDate(DateHelper.truncateDate((Date)new Date()));
        info.setCreateTime(new Timestamp(new Date().getTime()));
        info.setBizDate(rs.getDate(colName + "FBIZDATE"));
        info.setDescription(rs.getString(colName + "FDESCRIPTION"));
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)rs.getString(colName + "FCOMPANYID")));
        info.setCompany(company);
        CurrencyInfo currency = new CurrencyInfo();
        currency.setId(BOSUuid.read((String)rs.getString(colName + "FCURRENCYID")));
        info.setCurrency(currency);
        if ("com.kingdee.eas.fm.be.app.TransDetail".equals(billPath)) {
            info.setBizObjectFullName("com.kingdee.eas.fm.be.app.TransDetail");
            AccountBankInfo bankAcct = new AccountBankInfo();
            bankAcct.setId(BOSUuid.read((String)rs.getString(colName + "FBANKACCOUNTID")));
            info.setAccountBank(bankAcct);
            info.setOppUnit(rs.getString(colName + "FOPPUNIT"));
            info.setOppAcctBank(rs.getString(colName + "FOPPBANKNUMBER"));
            info.setBillNumber(rs.getString(colName + "FNUMBER"));
            info.setAmount(rs.getBigDecimal(colName + "FCREDITAMOUNT"));
            info.setTranPackageID(rs.getString(colName + "FTRANPACKAGEID"));
        } else {
            info.setBizObjectFullName("com.kingdee.eas.fi.cas.app.ReceivingBill");
            AccountBankInfo bankAcct = new AccountBankInfo();
            bankAcct.setId(BOSUuid.read((String)rs.getString(colName + "FPAYEEACCOUNTBANKID")));
            info.setAccountBank(bankAcct);
            info.setBillNumber(rs.getString(colName + "FNUMBER"));
            info.setSettlementNumber(rs.getString(colName + "FSETTLEMENTNUMBER"));
            info.setAmount(rs.getBigDecimal(colName + "FACTRECAMT"));
            if (!EmptyUtil.isEmpty((String)rs.getString(colName + "FRECBILLTYPEID"))) {
                ReceivingBillTypeInfo recBillType = new ReceivingBillTypeInfo();
                recBillType.setId(BOSUuid.read((String)rs.getString(colName + "FRECBILLTYPEID")));
                info.setRecBillType(recBillType);
            }
            info.setOppAcctBank(rs.getString(colName + "FPAYERACCOUNTBANK"));
            info.setOppUnit(rs.getString(colName + "FPAYERNAME_l2"));
            if (!EmptyUtil.isEmpty((String)rs.getString(colName + "FSETTLEMENTTYPEID"))) {
                SettlementTypeInfo settleInfo = new SettlementTypeInfo();
                settleInfo.setId(BOSUuid.read((String)rs.getString(colName + "FSETTLEMENTTYPEID")));
                info.setSettlementType(settleInfo);
            }
        }
        info.setResultType(RPDMatchResultType.recBill);
        return info;
    }

    protected String getBizDateOrder() {
        StringBuffer orderBy = new StringBuffer(" ");
        orderBy.append("ORDER BY X0.FBIZDATE ASC ");
        orderBy.append(", X1.FBIZDATE ASC ");
        return orderBy.toString();
    }

    protected String getTableFormula(Context ctx, Map<String, String> tableName) {
        String select = "Select X0.Fid X0Fid, X1.Fid X1Fid";
        String mainTable = tableName.get("com.kingdee.eas.fm.be.app.TransDetail");
        for (int i = 0; i < this.DEL_FIELDS.length; ++i) {
            select = select + ", X0." + this.DEL_FIELDS[i] + " " + "X0" + this.DEL_FIELDS[i];
        }
        String asstTable = tableName.get("com.kingdee.eas.fi.cas.app.ReceivingBill");
        for (int i = 0; i < this.REC_FIELDS.length; ++i) {
            select = select + ", X1." + this.REC_FIELDS[i] + " " + "X1" + this.REC_FIELDS[i];
        }
        select = select + " from " + mainTable + " " + "X0" + ", " + asstTable + " " + "X1" + " ";
        select = select + " where X0.FCREDITAMOUNT <> 0 and X1.FACTRECAMT <> 0 ";
        return select;
    }

    protected String getCompanyMatchColl(String companyId, Map matchSettingMap) throws BOSException, EASBizException {
        String companyMatchSql = null;
        EntityViewInfo view = new EntityViewInfo();
        RPDMatchSettingInfo info = (RPDMatchSettingInfo)matchSettingMap.get(companyId);
        companyMatchSql = info != null ? info.getSQLFilter("X0", "X1") : this.getDefCompanyMatchSql();
        return companyMatchSql;
    }

    protected String getDefCompanyMatchSql() {
        StringBuffer sb = new StringBuffer();
        sb.append("X0").append(".").append("FOPPUNIT");
        sb.append("=");
        sb.append("X1").append(".").append("FPAYERNAME_l2").append(" ");
        sb.append(" and ");
        sb.append("X0").append(".").append("FOPPBANKNUMBER");
        sb.append("=");
        sb.append("X1").append(".").append("FPAYERACCOUNTBANK").append(" ");
        return sb.toString();
    }

    protected String getDefMatchColl() {
        StringBuffer sbMatch = new StringBuffer();
        sbMatch.append("X0").append(".").append("FBANKACCOUNTNUMBER");
        sbMatch.append("=");
        sbMatch.append("X1").append(".").append("FBANKACCOUNTNUMBER").append(" ");
        sbMatch.append(" and ");
        sbMatch.append("X0").append(".").append("FCOMPANYID");
        sbMatch.append("=");
        sbMatch.append("X1").append(".").append("FCOMPANYID").append(" ");
        sbMatch.append(" and ");
        sbMatch.append("X0").append(".").append("FCURRENCYID");
        sbMatch.append("=");
        sbMatch.append("X1").append(".").append("FCURRENCYID").append(" ");
        sbMatch.append(" and ");
        sbMatch.append("X0").append(".").append("FCREDITAMOUNT");
        sbMatch.append("=");
        sbMatch.append("X1").append(".").append("FACTRECAMT").append(" ");
        return sbMatch.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertTempTable(Context ctx, String destTableName, String boInfo, List idList) throws EASBizException, BOSException {
        if (idList.size() == 0) {
            return;
        }
        EntityObjectInfo meta = this.getMetaByBizObject(ctx, boInfo);
        long startTime = System.currentTimeMillis();
        String tempTableName = this.createIdTempTable(ctx, idList);
        long endTime = System.currentTimeMillis();
        logger.error((Object)("--------\u6536\u6b3e\u5339\u914d-----------\u751f\u6210\u4e34\u65f6\u8868(" + idList.size() + ")\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L + "-----------------------"));
        startTime = System.currentTimeMillis();
        StringBuffer sbInsert = new StringBuffer("insert into ");
        sbInsert.append(destTableName);
        sbInsert.append(" ( ");
        StringBuffer sbSelect = new StringBuffer(" select ");
        StringBuffer sbFrom = new StringBuffer(" from ");
        StringBuffer sbWhere = new StringBuffer(" where ");
        String sourceTableName = meta.getTable().getName();
        sbSelect.append(sourceTableName).append(".").append("FID").append(" ");
        sbInsert.append(" FID ");
        sbSelect.append(",").append(sourceTableName).append(".").append("FCOMPANYID").append(" ");
        sbInsert.append(",").append("FCOMPANYID").append(" ");
        sbSelect.append(",").append("T_BD_ACCOUNTBANKS").append(".").append("FBANKACCOUNTNUMBER").append(" ");
        sbInsert.append(",").append("FBANKACCOUNTNUMBER").append(" ");
        sbSelect.append(",").append(sourceTableName).append(".").append("FCURRENCYID").append(" ");
        sbInsert.append(",").append("FCURRENCYID").append(" ");
        sbSelect.append(",").append(sourceTableName).append(".").append("FDESCRIPTION").append(" ");
        sbInsert.append(",").append("FDESCRIPTION").append(" ");
        sbSelect.append(",").append(sourceTableName).append(".").append("FBIZDATE").append(" ");
        sbInsert.append(",").append("FBIZDATE").append(" ");
        if (boInfo.equals("com.kingdee.eas.fm.be.app.TransDetail")) {
            sbSelect.append(",").append(sourceTableName).append(".").append("FCREDITAMOUNT").append(" ");
            sbInsert.append(",").append("FCREDITAMOUNT").append(" ");
            sbSelect.append(",").append(sourceTableName).append(".").append("FBANKACCOUNTID").append(" ");
            sbInsert.append(",").append("FBANKACCOUNTID").append(" ");
            sbSelect.append(",").append(sourceTableName).append(".").append("FBIZTIME").append(" ");
            sbInsert.append(",").append("FBIZTIME").append(" ");
            sbSelect.append(",").append(sourceTableName).append(".").append("FNAME").append("_").append(ctx.getLocale().toString()).append(" ");
            sbInsert.append(",").append("FNAME").append(" ");
            sbSelect.append(",").append(sourceTableName).append(".").append("FOPPUNIT").append(" ");
            sbInsert.append(",").append("FOPPUNIT").append(" ");
            sbSelect.append(",").append(sourceTableName).append(".").append("FOPPBANK").append(" ");
            sbInsert.append(",").append("FOPPBANK").append(" ");
            sbSelect.append(",").append(sourceTableName).append(".").append("FOPPBANKNUMBER").append(" ");
            sbInsert.append(",").append("FOPPBANKNUMBER").append(" ");
            sbSelect.append(",").append(sourceTableName).append(".").append("FAGENTACCNO").append(" ");
            sbInsert.append(",").append("FAGENTACCNO").append(" ");
            sbSelect.append(",").append(sourceTableName).append(".").append("FAGENTACCNAME").append(" ");
            sbInsert.append(",").append("FAGENTACCNAME").append(" ");
            sbSelect.append(",").append(sourceTableName).append(".").append("FAGENTACCBKNAME").append(" ");
            sbInsert.append(",").append("FAGENTACCBKNAME").append(" ");
            sbSelect.append(",").append(sourceTableName).append(".").append("FNUMBER").append(" ");
            sbInsert.append(",").append("FNUMBER").append(" ");
            sbSelect.append(",").append(sourceTableName).append(".").append("FTRANPACKAGEID").append(" ");
            sbInsert.append(",").append("FTRANPACKAGEID").append(" ");
            sbFrom.append(" ").append(sourceTableName).append(" ");
            sbFrom.append(" ").append("left join T_BD_ACCOUNTBANKS on ").append(sourceTableName).append(".").append("FBANKACCOUNTID").append(" = T_BD_ACCOUNTBANKS.FID ");
            sbWhere.append(" exists (Select Fid From " + tempTableName + " temp where " + sourceTableName + ".Fid = temp.Fid  and " + sourceTableName + ".fcreditAmount <> 0  and " + sourceTableName + ".fisReced = " + 0 + " and " + sourceTableName + ".fisTransUp = 0  and " + sourceTableName + ".fisBankWithHolding = 0 and " + sourceTableName + ".fisKDRetFlag = 0 )");
        } else if (boInfo.equals("com.kingdee.eas.fi.cas.app.ReceivingBill")) {
            sbSelect.append(",").append(sourceTableName).append(".").append("FACTRECAMT").append(" ");
            sbInsert.append(",").append("FACTRECAMT").append(" ");
            sbSelect.append(",").append(sourceTableName).append(".").append("FPAYEEACCOUNTBANKID").append(" ");
            sbInsert.append(",").append("FPAYEEACCOUNTBANKID").append(" ");
            sbSelect.append(",").append(sourceTableName).append(".").append("FRECBILLTYPEID").append(" ");
            sbInsert.append(",").append("FRECBILLTYPEID").append(" ");
            sbSelect.append(",").append("T_CAS_ReceivingBillType").append(".").append("FNAME").append("_").append(ctx.getLocale().toString()).append(" ");
            sbInsert.append(",").append("FRECBILLTYPENAME").append(" ");
            sbSelect.append(",").append(sourceTableName).append(".").append("FSETTLEMENTTYPEID").append(" ");
            sbInsert.append(",").append("FSETTLEMENTTYPEID").append(" ");
            sbSelect.append(",").append("T_BD_SettlementType").append(".").append("FNAME").append("_").append(ctx.getLocale().toString()).append(" ");
            sbInsert.append(",").append("FSETTLEMENTTYPENAME").append(" ");
            sbSelect.append(",").append(sourceTableName).append(".").append("FSETTLEMENTNUMBER").append(" ");
            sbInsert.append(",").append("FSETTLEMENTNUMBER").append(" ");
            sbSelect.append(",").append(sourceTableName).append(".").append("FPAYERNAME_l2").append(" ");
            sbInsert.append(",").append("FPAYERNAME_l2").append(" ");
            sbSelect.append(",").append(sourceTableName).append(".").append("FPAYERACCOUNTBANK").append(" ");
            sbInsert.append(",").append("FPAYERACCOUNTBANK").append(" ");
            sbSelect.append(",").append(sourceTableName).append(".").append("FPAYERACCOUNTNUMBER").append(" ");
            sbInsert.append(",").append("FPAYERACCOUNTNUMBER").append(" ");
            sbSelect.append(",").append(sourceTableName).append(".").append("FFEETYPEID").append(" ");
            sbInsert.append(",").append("FFEETYPEID").append(" ");
            sbSelect.append(",").append("T_CAS_FeeType").append(".").append("FNAME").append("_").append(ctx.getLocale().toString()).append(" ");
            sbInsert.append(",").append("FFEETYPENAME").append(" ");
            sbSelect.append(",").append(sourceTableName).append(".").append("FNUMBER").append(" ");
            sbInsert.append(",").append("FNUMBER").append(" ");
            sbSelect.append(",").append(sourceTableName).append(".").append("FPAYACCOUNTBANK").append(" ");
            sbInsert.append(",").append("FPAYACCOUNTBANK").append(" ");
            sbFrom.append(" ").append(sourceTableName).append(" ");
            sbFrom.append("  left join T_BD_ACCOUNTBANKS on ").append(sourceTableName).append(".").append("FPAYEEACCOUNTBANKID").append(" = T_BD_ACCOUNTBANKS.FID ");
            sbFrom.append("  left join T_BD_SettlementType on ").append(sourceTableName).append(".").append("FSETTLEMENTTYPEID").append(" = T_BD_SettlementType.FID ");
            sbFrom.append("  left join T_CAS_ReceivingBillType on ").append(sourceTableName).append(".").append("FRECBILLTYPEID").append(" = T_CAS_ReceivingBillType.FID ");
            sbFrom.append("  left join T_CAS_FeeType on ").append(sourceTableName).append(".").append("FFEETYPEID").append(" = T_CAS_FeeType.FID ");
            sbFrom.append(" inner join " + tempTableName + " temp on ").append(sourceTableName + ".FID = temp.Fid ");
            sbWhere.append(" ( " + sourceTableName + ".FBillStatus = 12 or " + sourceTableName + ".FBillStatus = 14 ) ").append(" and NOT EXISTS (SELECT FDESTOBJECTID FROM T_BOT_Relation WHERE FSRCENTITYID = '380D4F63' AND " + sourceTableName + ".fid = FDESTOBJECTID) ");
        }
        sbInsert.append(" ) ");
        try {
            String sql = sbInsert.toString() + sbSelect.toString() + sbFrom.toString();
            if (!sbWhere.toString().trim().endsWith("where")) {
                sql = sql + sbWhere.toString();
            }
            DbUtil.execute((Context)ctx, (String)sql);
            endTime = System.currentTimeMillis();
            logger.error((Object)("--------\u6536\u6b3e\u5339\u914d-----------sql\uff1a" + sql + "----------------------"));
            logger.error((Object)("--------\u6536\u6b3e\u5339\u914d-----------\u63d2\u5165\u6570\u636e\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L + "----------------------"));
        }
        finally {
            ITableManagerFacade tbl = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
            tbl.releaseTableName(tempTableName);
        }
    }

    protected String createIdTempTable(Context ctx, List idList) throws BOSException {
        ITableManagerFacade mang = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String table = mang.getTableName("rpd");
        String sSQL = "Create Table " + table + "(Fid varchar(44))";
        DbUtil.execute((Context)ctx, (String)sSQL);
        Iterator it = idList.iterator();
        sSQL = "Insert Into " + table + "(Fid) values(?)";
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sSQL);
            while (it.hasNext()) {
                String id = (String)it.next();
                ps.setString(1, id);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
        return table;
    }

    protected EntityObjectInfo getMetaByBizObject(Context ctx, String boInfo) throws BOSException, EASBizException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo meta = loader.getEntity((IMetaDataPK)new MetaDataPK(boInfo));
        return meta;
    }

    protected String createTempTable(Context ctx, String tableName, String entity) throws BOSException {
        StringBuffer sbCreate = new StringBuffer("create table ");
        sbCreate.append(tableName);
        sbCreate.append(" ( ");
        sbCreate.append(" FID varchar (44) NOT NULL ");
        sbCreate.append(", ").append("FCOMPANYID").append(" varchar (44) ");
        sbCreate.append(", ").append("FBANKACCOUNTNUMBER").append(" nvarchar (80) ");
        sbCreate.append(", ").append("FCURRENCYID").append(" varchar (44) ");
        sbCreate.append(", ").append("FDESCRIPTION").append(" nvarchar (1000) ");
        sbCreate.append(", ").append("FBIZDATE").append(" datetime ");
        if (entity.equals("com.kingdee.eas.fm.be.app.TransDetail")) {
            sbCreate.append(", ").append("FCREDITAMOUNT").append(" NUMERIC (17,4) ");
            sbCreate.append(", ").append("FBANKACCOUNTID").append(" varchar (44) ");
            sbCreate.append(", ").append("FBIZTIME").append(" datetime ");
            sbCreate.append(", ").append("FNAME").append(" nvarchar (80) ");
            sbCreate.append(", ").append("FOPPUNIT").append("  nvarchar (80)");
            sbCreate.append(", ").append("FOPPBANK").append(" nvarchar (80) ");
            sbCreate.append(", ").append("FOPPBANKNUMBER").append(" nvarchar (80) ");
            sbCreate.append(", ").append("FAGENTACCNO").append(" nvarchar (80) ");
            sbCreate.append(", ").append("FAGENTACCNAME").append(" nvarchar (80) ");
            sbCreate.append(", ").append("FAGENTACCBKNAME").append(" nvarchar (80) ");
            sbCreate.append(", ").append("FNUMBER").append(" nvarchar (255) ");
            sbCreate.append(", ").append("FTRANPACKAGEID").append(" nvarchar (255) ");
        } else if (entity.equals("com.kingdee.eas.fi.cas.app.ReceivingBill")) {
            sbCreate.append(", ").append("FACTRECAMT").append(" NUMERIC (17,4) ");
            sbCreate.append(", ").append("FPAYEEACCOUNTBANKID").append(" varchar (44) ");
            sbCreate.append(", ").append("FRECBILLTYPEID").append(" varchar (44) ");
            sbCreate.append(", ").append("FRECBILLTYPENAME").append(" nvarchar (255) ");
            sbCreate.append(", ").append("FSETTLEMENTTYPEID").append(" varchar (44) ");
            sbCreate.append(", ").append("FSETTLEMENTTYPENAME").append(" nvarchar (80) ");
            sbCreate.append(", ").append("FSETTLEMENTNUMBER").append(" nvarchar (800) ");
            sbCreate.append(", ").append("FPAYERNAME_l2").append(" nvarchar (80) ");
            sbCreate.append(", ").append("FPAYERACCOUNTBANK").append(" nvarchar (250) ");
            sbCreate.append(", ").append("FPAYERACCOUNTNUMBER").append(" nvarchar (80) ");
            sbCreate.append(", ").append("FFEETYPEID").append(" varchar (44) ");
            sbCreate.append(", ").append("FFEETYPENAME").append(" nvarchar (255) ");
            sbCreate.append(", ").append("FNUMBER").append(" nvarchar (255) ");
            sbCreate.append(", ").append("FPAYACCOUNTBANK").append(" nvarchar (250) ");
        }
        sbCreate.append(")");
        DbUtil.execute((Context)ctx, (String)sbCreate.toString());
        return tableName;
    }

    protected void delTempTableData(Context ctx, String tableName) throws BOSException, EASBizException {
        String sSQL = "DELETE FROM " + tableName;
        DbUtil.execute((Context)ctx, (String)sSQL);
    }

    protected BOTRelationInfo parseBOTRelation(String srcObjectID, String destObjectID) {
        BOTRelationInfo botInfo = new BOTRelationInfo();
        botInfo.setSrcEntityID(BOSUuid.read((String)srcObjectID).getType().toString());
        botInfo.setDestEntityID(BOSUuid.read((String)destObjectID).getType().toString());
        botInfo.setSrcObjectID(srcObjectID);
        botInfo.setDestObjectID(destObjectID);
        botInfo.setDate(new Date());
        botInfo.setOperatorID("unknown");
        botInfo.setIsEffected(true);
        botInfo.setType(0);
        return botInfo;
    }

    protected Map<String, Boolean> getCompanyMap(Context ctx, Set companyIdSet) throws BOSException, EASBizException {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isEnable", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("asstEntityID", (Object)new ReceivingBillInfo().getBOSType().toString()));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("isAutoEntered"));
        view.setSelector(selector);
        RPDMatchSettingCollection coll = RPDMatchSettingFactory.getLocalInstance(ctx).getRPDMatchSettingCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            RPDMatchSettingInfo info = coll.get(i);
            map.put(info.getCompany().getId().toString(), info.isIsAutoEntered());
        }
        Iterator it = companyIdSet.iterator();
        RPDMatchSettingCollection temp = new RPDMatchSettingCollection();
        while (it.hasNext()) {
            String companyId = (String)it.next();
            if (map.containsKey(companyId)) continue;
            map.put(companyId, true);
        }
        return map;
    }

    protected Map<String, Boolean> getCompanyMap(Set companyIdSet, Map matchSettingMap) throws BOSException, EASBizException {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (String companyId : companyIdSet) {
            RPDMatchSettingInfo info = (RPDMatchSettingInfo)matchSettingMap.get(companyId);
            if (info != null) {
                map.put(companyId, info.isIsAutoEntered());
                continue;
            }
            map.put(companyId, true);
        }
        return map;
    }

    protected RPDMatchSettingCollection getShareSetting(Context ctx) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", null));
        filter.getFilterItems().add(new FilterItemInfo("isCUShare", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("asstEntityID", (Object)new ReceivingBillInfo().getBOSType().toString()));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("isAutoEntered"));
        selector.add(new SelectorItemInfo("entrys.*"));
        view.setSelector(selector);
        RPDMatchSettingCollection coll = RPDMatchSettingFactory.getLocalInstance(ctx).getRPDMatchSettingCollection(view);
        return coll;
    }

    protected String updateTransDetail(String transDetailId, String recBillNumber) {
        if (recBillNumber.length() > 2000) {
            recBillNumber = recBillNumber.substring(0, 1995);
        }
        String sql = "UPDATE T_BE_TRANSDETAIL SET FisReced = 1 , FrecedBillType = 'FA44FD5B' , FRecedBillNumber = '" + recBillNumber + "' WHERE FID = '" + transDetailId + "'";
        return sql;
    }

    protected String updateRecBill(String transDetailId, Set recBillIdSet) {
        String ids = FMHelper.setTran2String((Set)recBillIdSet);
        String sql = "UPDATE T_CAS_RECEIVINGBILL  SET FBANKCHECKFLAG =(SELECT FBANKCHECKFLAG  FROM T_BE_TRANSDETAIL  WHERE FID = '" + transDetailId + "')  WHERE  FID in " + ids;
        return sql;
    }

    protected String updateJournal(Context ctx, String transDetailId, Set recBillIdSet) throws BOSException {
        String ids = FMHelper.setTran2String((Set)recBillIdSet);
        String actSql = "SELECT FDESTOBJECTID  FROM T_BOT_RELATION where FSRCOBJECTID in " + ids + " and FDESTENTITYID ='" + new VoucherInfo().getBOSType().toString() + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)actSql);
        HashSet<String> vouIdSet = new HashSet<String>();
        try {
            while (rs.next()) {
                vouIdSet.add(rs.getString("FDESTOBJECTID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String sql = "";
        if (vouIdSet.size() > 0) {
            String voucherIds = FMHelper.setTran2String(vouIdSet);
            String entrySql = "SELECT FID FROM T_GL_VOUCHERENTRY WHERE FBILLID IN " + voucherIds;
            IRowSet entryRS = DbUtil.executeQuery((Context)ctx, (String)entrySql);
            try {
                while (entryRS.next()) {
                    vouIdSet.add(entryRS.getString("FID"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            voucherIds = FMHelper.setTran2String(vouIdSet);
            sql = "UPDATE T_CAS_JOURNAL  SET FBANKCHECKFLAG =(SELECT FBANKCHECKFLAG  FROM T_BE_TRANSDETAIL  WHERE FID = '" + transDetailId + "')  WHERE ( FBILLID in " + ids + "   AND FBILLTYPE = " + 15 + ") OR ( FBILLID in " + voucherIds + " AND ( FBILLTYPE = " + 10 + "  OR FBILLTYPE = " + 21 + " )) ";
        } else {
            sql = "UPDATE T_CAS_JOURNAL  SET FBANKCHECKFLAG =(SELECT FBANKCHECKFLAG  FROM T_BE_TRANSDETAIL  WHERE FID = '" + transDetailId + "')  WHERE  FBILLID in " + ids + "   AND FBILLTYPE = " + 15;
        }
        return sql;
    }

    protected void checkMutex(Map resultRequest, List idList, List appliedList) throws RPMException {
        Boolean boolResult;
        int i;
        for (i = 0; i < idList.size(); ++i) {
            boolResult = (Boolean)resultRequest.get(idList.get(i));
            if (!boolResult.booleanValue()) continue;
            appliedList.add(idList.get(i));
        }
        for (i = 0; i < idList.size(); ++i) {
            boolResult = (Boolean)resultRequest.get(idList.get(i));
            if (boolResult.booleanValue()) continue;
            throw new RPMException(RPMException.NOMUTEX);
        }
    }

    @Override
    protected Map _antiMatch(Context ctx, Set keySet, Map keyComMap) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        int fail = 0;
        int billSum = keySet.size();
        String summary = ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RpmResources", (String)"16_BILL_SUM", (Locale)ctx.getLocale(), (Object[])new String[]{billSum + ""});
        long startTime = System.currentTimeMillis();
        Map<Object, Object> companySetMap = new HashMap();
        Iterator keyComMapIt = keyComMap.keySet().iterator();
        HashSet<String> companyIdSet = new HashSet<String>();
        while (keyComMapIt.hasNext()) {
            String key = (String)keyComMapIt.next();
            companyIdSet.add((String)keyComMap.get(key));
        }
        companySetMap = this.getCompanyMap(ctx, companyIdSet);
        this.checkPermission(ctx, companyIdSet, "antiMatch");
        ArrayList bathSql = new ArrayList();
        HashSet<String> enteredRecBillIdSet = new HashSet<String>();
        HashSet hasEnteredRecBillIdSet = new HashSet();
        HashMap botRelationMap = new HashMap();
        HashSet mainIdSet = new HashSet();
        HashSet asstIdSet = new HashSet();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("key", (Object)keySet, CompareType.INCLUDE));
        RPDMatchResultCollection resultColl = RPDMatchResultFactory.getLocalInstance(ctx).getRPDMatchResultCollection(view);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)resultColl)) {
            for (int index = 0; index < resultColl.size(); ++index) {
                String companyId;
                RPDMatchResultInfo resultInfo = resultColl.get(index);
                String key = resultInfo.getKey();
                String objectId = resultInfo.getBizObjectId() == null ? null : resultInfo.getBizObjectId().toString();
                String objectFullName = resultInfo.getBizObjectFullName();
                if (botRelationMap.containsKey(key)) {
                    ((List)((Map)botRelationMap.get(key)).get(objectFullName)).add(objectId);
                } else {
                    HashMap idMap = new HashMap();
                    ArrayList<String> mainIdList = new ArrayList<String>();
                    ArrayList<String> asstIdList = new ArrayList<String>();
                    if ("com.kingdee.eas.fm.be.app.TransDetail".equals(objectFullName)) {
                        mainIdList.add(objectId);
                    } else if ("com.kingdee.eas.fi.cas.app.ReceivingBill".equals(objectFullName)) {
                        asstIdList.add(objectId);
                    }
                    idMap.put("com.kingdee.eas.fm.be.app.TransDetail", mainIdList);
                    idMap.put("com.kingdee.eas.fi.cas.app.ReceivingBill", asstIdList);
                    botRelationMap.put(key, idMap);
                }
                if (!"com.kingdee.eas.fi.cas.app.ReceivingBill".equals(objectFullName) || !companySetMap.containsKey(companyId = resultInfo.getCompany().getId().toString()) || !((Boolean)companySetMap.get(companyId)).booleanValue()) continue;
                enteredRecBillIdSet.add(objectId);
            }
        } else {
            return result;
        }
        long endTime = System.currentTimeMillis();
        logger.error((Object)("------\u6536\u6b3e\u53cd\u5339\u914d-------------\u5faa\u73af\u83b7\u53d6\u5bf9\u8d26\u7ed3\u679c\u4e1a\u52a1id\u96c6\u5408\u8d26\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L + "----------------------"));
        startTime = System.currentTimeMillis();
        HashSet failKeySet = new HashSet();
        Boolean flag = true;
        for (String key : botRelationMap.keySet()) {
            Map idMap = (Map)botRelationMap.get(key);
            List mainIdList = (List)idMap.get("com.kingdee.eas.fm.be.app.TransDetail");
            List asstIdList = (List)idMap.get("com.kingdee.eas.fi.cas.app.ReceivingBill");
            flag = true;
            ArrayList<String> tmpBathSql = new ArrayList<String>();
            HashSet<String> tmpAsstIdSet = new HashSet<String>();
            HashSet<String> tmpMainIdSet = new HashSet<String>();
            for (int i = 0; i < mainIdList.size() && flag.booleanValue(); ++i) {
                String mainId = (String)mainIdList.get(i);
                tmpMainIdSet.add(mainId);
                for (int j = 0; j < asstIdList.size() && flag.booleanValue(); ++j) {
                    String asstId = (String)asstIdList.get(j);
                    tmpBathSql.add(this.deleteBotpRelation(mainId, asstId));
                    tmpAsstIdSet.add(asstId);
                }
            }
            if (!flag.booleanValue()) continue;
            mainIdSet.addAll(tmpMainIdSet);
            asstIdSet.addAll(tmpAsstIdSet);
            bathSql.addAll(tmpBathSql);
        }
        endTime = System.currentTimeMillis();
        logger.error((Object)("-------\u6536\u6b3e\u53cd\u5339\u914d------------\u5faa\u73af\u5904\u7406\u6570\u636e\u8d26\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L + "----------------------"));
        startTime = System.currentTimeMillis();
        filter = new FilterInfo();
        view.setFilter(filter);
        keySet.removeAll(failKeySet);
        filter.getFilterItems().add(new FilterItemInfo("key", (Object)keySet, CompareType.INCLUDE));
        RPDMatchResultFactory.getLocalInstance(ctx).delete(filter);
        endTime = System.currentTimeMillis();
        logger.error((Object)("-------\u6536\u6b3e\u53cd\u5339\u914d------------\u5220\u9664\u5339\u914d\u7ed3\u679c\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L + "----------------------"));
        startTime = System.currentTimeMillis();
        bathSql.add(this.rwTransDetail(mainIdSet));
        bathSql.add(this.rwRecBill(asstIdSet));
        bathSql.add(this.rwJournal(ctx, asstIdSet));
        com.kingdee.eas.base.core.util.DbUtil.executeBatch((Context)ctx, bathSql);
        endTime = System.currentTimeMillis();
        logger.error((Object)("-------\u6536\u6b3e\u53cd\u5339\u914d------------\u7b2c2-4\u6b65\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L + "----------------------"));
        summary = fail == 0 ? summary + ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RpmResources", (String)"18_ALL_ANTIMATCH_SUCC", (Locale)ctx.getLocale()) : summary + ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RpmResources", (String)"19_ANTIMATCH_TITLE", (Locale)ctx.getLocale(), (Object[])new String[]{String.valueOf(billSum - fail), String.valueOf(fail)});
        result.setSummaryMsg(summary);
        return result;
    }

    protected String deleteBotpRelation(String srcObjectId, String destObjectId) throws BOSException {
        String sql = "delete T_BOT_Relation WHERE FSrcObjectID  = '" + srcObjectId + "' and FDestObjectID = '" + destObjectId + "'";
        return sql;
    }

    protected String rwTransDetail(Set transDetailIds) {
        String ids = FMHelper.setTran2String((Set)transDetailIds);
        String sql = "UPDATE T_BE_TRANSDETAIL SET FisReced = 0 , FrecedBillType = '' , FRecedBillNumber = '' WHERE FID IN " + ids;
        return sql;
    }

    protected String rwRecBill(Set recBillIdSet) {
        String ids = FMHelper.setTran2String((Set)recBillIdSet);
        String sql = "UPDATE T_CAS_RECEIVINGBILL  SET FBANKCHECKFLAG = '' WHERE  FID in " + ids;
        return sql;
    }

    protected String rwJournal(Context ctx, Set recBillIdSet) throws BOSException {
        String ids = FMHelper.setTran2String((Set)recBillIdSet);
        String actSql = "SELECT FDESTOBJECTID  FROM T_BOT_RELATION where FSRCOBJECTID in " + ids + " and FDESTENTITYID ='" + new VoucherInfo().getBOSType().toString() + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)actSql);
        HashSet<String> vouIdSet = new HashSet<String>();
        try {
            while (rs.next()) {
                vouIdSet.add(rs.getString("FDESTOBJECTID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String sql = "";
        if (vouIdSet.size() > 0) {
            String voucherIds = FMHelper.setTran2String(vouIdSet);
            String entrySql = "SELECT FID FROM T_GL_VOUCHERENTRY WHERE FBILLID IN " + voucherIds;
            IRowSet entryRS = DbUtil.executeQuery((Context)ctx, (String)entrySql);
            try {
                while (entryRS.next()) {
                    vouIdSet.add(entryRS.getString("FID"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            voucherIds = FMHelper.setTran2String(vouIdSet);
            sql = "UPDATE T_CAS_JOURNAL  SET FBANKCHECKFLAG = '' WHERE ( FBILLID in " + ids + "   AND FBILLTYPE = " + 15 + " )  OR ( FBILLID in " + voucherIds + " AND ( FBILLTYPE = " + 10 + "  OR FBILLTYPE = " + 21 + " )) ";
        } else {
            sql = "UPDATE T_CAS_JOURNAL  SET FBANKCHECKFLAG = '' WHERE  FBILLID in " + ids + "   AND FBILLTYPE = " + 15;
        }
        return sql;
    }

    protected void checkPermission(Context ctx, Set companyIdSet, String type) throws EASBizException, BOSException {
        String prmitItem = "";
        NumericExceptionSubItem ex = null;
        if ("auto".equals(type)) {
            prmitItem = "rpm_recDetail_03autoMatch";
            ex = RPMException.NOAUTOPERM;
        } else if ("manual".equals(type)) {
            prmitItem = "rpm_recDetail_04manualMatch";
            ex = RPMException.NOMANUALPERM;
        } else if ("antiMatch".equals(type)) {
            prmitItem = "rpm_recDeatil_05antiMatch";
            ex = RPMException.NOANTIMATCHPERM;
        } else {
            return;
        }
        UserInfo curUser = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Set permissionIdSet = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrgIds((IObjectPK)new ObjectUuidPK(curUser.getId()), OrgType.Company, null, prmitItem);
        for (Object companyId : companyIdSet) {
            if (permissionIdSet.contains((String)companyId)) continue;
            CompanyOrgUnitInfo companyInfo = this.getCompanyInfoById(ctx, (String)companyId);
            throw new RPMException(ex, new String[]{companyInfo.getName()});
        }
    }

    protected CompanyOrgUnitInfo getCompanyInfoById(Context ctx, String companyId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("cu.id"));
        CompanyOrgUnitInfo info = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
        return info;
    }
}

