/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.TransDetailCollection;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.be.TransdetailSourceEnum;
import com.kingdee.eas.fm.sa.AcctBankTransDetailCollection;
import com.kingdee.eas.fm.sa.AcctBankTransDetailFactory;
import com.kingdee.eas.fm.sa.AcctBankTransDetailInfo;
import com.kingdee.eas.fm.sa.IAcctBankTransDetail;
import com.kingdee.eas.fm.sa.ReportOrgSolutionSettingInfo;
import com.kingdee.eas.fm.sa.app.AbstractAcctBankTransDetailControllerBean;
import com.kingdee.eas.fm.sa.app.util.AcctBankTransDetailDBUtils;
import com.kingdee.eas.fm.sa.app.util.SAConstants;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class AcctBankTransDetailControllerBean
extends AbstractAcctBankTransDetailControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.sa.app.AcctBankTransDetailControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _autoReportAcctBankTransDetail(Context ctx, ReportOrgSolutionSettingInfo info, Date payDate) throws BOSException, EASBizException {
        AccountBankCollection acctBankCol = this.initReportOrgSol2AcctBankCol(ctx, info);
        IAcctBankTransDetail iAcctBankTransDetail = AcctBankTransDetailFactory.getLocalInstance(ctx);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < acctBankCol.size(); ++i) {
            boolean isLocked = false;
            AccountBankInfo acctBankInfo = acctBankCol.get(i);
            String lockId = SAConstants.getSATransDetailMutexId(acctBankInfo.getId().toString());
            try {
                isLocked = iMutex.requestBizObjIDForUpdate(lockId);
                if (isLocked) {
                    logger.info((Object)("\u8d26\u6237\uff1a" + acctBankInfo.getBankAccountNumber() + "\u6267\u884c\u62a5\u9001\u94f6\u884c\u4ea4\u6613\u660e\u7ec6\u6570\u636e  begin"));
                    iAcctBankTransDetail.reportTransDetailByAcctBank(info, acctBankInfo.getId().toString(), payDate);
                    logger.info((Object)("\u8d26\u6237Id\uff1a" + acctBankInfo.getId().toString() + "\uff0c\u8d26\u53f7\uff1a" + acctBankInfo.getBankAccountNumber() + "\u6267\u884c\u62a5\u9001\u94f6\u884c\u4ea4\u6613\u660e\u7ec6\u6570\u636e  end"));
                    continue;
                }
                logger.error((Object)("\u8d26\u6237\uff1a" + acctBankInfo.getBankAccountNumber() + "\u6ca1\u6709\u7533\u8bf7\u5230\u3010\u6267\u884c\u62a5\u9001\u94f6\u884c\u4ea4\u6613\u660e\u7ec6\u6570\u636e\u3011\u7684\u4e92\u65a5\u9501"));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("\u8d26\u6237\uff1a" + acctBankInfo.getBankAccountNumber() + "\u6267\u884c\u62a5\u9001\u94f6\u884c\u4ea4\u6613\u660e\u7ec6\u6570\u636e\u5931\u8d25"));
                logger.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            finally {
                if (isLocked) {
                    iMutex.releaseObjIDForUpdate(lockId);
                }
            }
        }
    }

    private AccountBankCollection initReportOrgSol2AcctBankCol(Context ctx, ReportOrgSolutionSettingInfo info) throws BOSException {
        HashSet<String> companyIds = new HashSet<String>();
        for (int i = 0; i < info.getReportOrgEntrys().size(); ++i) {
            companyIds.add(info.getReportOrgEntrys().get(i).getReportOrg().getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setFilter(filter);
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bankAccountNumber"));
        sic.add(new SelectorItemInfo("isonlyread"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("openArea.id"));
        sic.add(new SelectorItemInfo("openArea.number"));
        sic.add(new SelectorItemInfo("openArea.*"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.isoCode"));
        HashSet<Integer> shareTypeEnumSet = new HashSet<Integer>();
        shareTypeEnumSet.add(0);
        shareTypeEnumSet.add(1);
        filter.getFilterItems().add(new FilterItemInfo("shareType", shareTypeEnumSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bank.isBank", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("company.id", companyIds, CompareType.INCLUDE));
        logger.info((Object)("AccountBank's Collection Sql:" + view.toString()));
        AccountBankCollection acctBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        return acctBankCol;
    }

    @Override
    protected void _reportTransDetailByAcctBank(Context ctx, ReportOrgSolutionSettingInfo info, String acctBankIds, Date beginDate) throws BOSException, EASBizException {
        TransDetailCollection detailColl = this.getAcctTransDetailColByAcctIds(ctx, acctBankIds, beginDate);
        TransDetailCollection addNewDetailCol = this.getAddNewDetailColl(ctx, detailColl);
        if (EmptyUtil.isEmpty((AbstractObjectCollection)addNewDetailCol)) {
            logger.error((Object)("\u8d26\u6237Id:" + acctBankIds + ", \u589e\u91cf\u7684\u4ea4\u6613\u660e\u7ec6\u6570\u636e\u4e3a\u7a7a"));
            return;
        }
        AcctBankTransDetailCollection updateColls = this.genAcctBankTransDetailColls(ctx, addNewDetailCol);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)updateColls)) {
            this._addnewBatchData(ctx, (IObjectCollection)updateColls);
            AcctBankTransDetailDBUtils dBUtils = new AcctBankTransDetailDBUtils();
            dBUtils.addNewAcctTransDetailFromDB(ctx, info, updateColls);
        }
    }

    private TransDetailCollection getAddNewDetailColl(Context ctx, TransDetailCollection detailColl) throws BOSException {
        if (EmptyUtil.isEmpty((AbstractObjectCollection)detailColl)) {
            return detailColl;
        }
        HashMap<String, TransDetailInfo> detailMap = new HashMap<String, TransDetailInfo>();
        for (int i = 0; i < detailColl.size(); ++i) {
            if (detailColl.get(i).getIsDataImport().equals((Object)TransdetailSourceEnum.IMPORT)) {
                detailMap.put(detailColl.get(i).getId().toString(), detailColl.get(i));
                continue;
            }
            detailMap.put(detailColl.get(i).getTranPackageID(), detailColl.get(i));
        }
        Set transDetailIds = detailMap.keySet();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection selector = view.getSelector();
        selector.add("transDetailID");
        filter.getFilterItems().add(new FilterItemInfo("transDetailID", transDetailIds, CompareType.INCLUDE));
        AcctBankTransDetailCollection exitColls = this.getAcctBankTransDetailCollection(ctx, view);
        if (EmptyUtil.isEmpty((AbstractObjectCollection)exitColls)) {
            return detailColl;
        }
        for (int i = 0; i < exitColls.size(); ++i) {
            detailColl.remove((TransDetailInfo)detailMap.get(exitColls.get(i).getTransDetailID()));
        }
        return detailColl;
    }

    private AcctBankTransDetailCollection genAcctBankTransDetailColls(Context ctx, TransDetailCollection detailColl) throws BOSException, BTPException {
        AcctBankTransDetailCollection colls = new AcctBankTransDetailCollection();
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        IBOTMapping botMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        for (int i = 0; i < detailColl.size(); ++i) {
            TransDetailInfo detaiInfo = detailColl.get(i);
            CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
            sourceBillCollection.add((CoreBillBaseInfo)detaiInfo);
            AcctBankTransDetailInfo info = new AcctBankTransDetailInfo();
            BOTMappingCollection btps = null;
            try {
                HashMap<String, CtrlUnitInfo> transmitContext = new HashMap<String, CtrlUnitInfo>();
                transmitContext.put("TRANSMITCU", detaiInfo.getCU());
                btps = botMapping.getMappingCollectionForSelectUseRuleFilter(TransDetailInfo.BOSTypeString(), AcctBankTransDetailInfo.BOSTYPE.toString(), DefineSysEnum.BTP, transmitContext, null, null, null, null);
            }
            catch (BOTPException e) {
                e.printStackTrace();
            }
            if (EmptyUtil.isEmpty(btps)) {
                logger.error((Object)"Botp\u8f6c\u6362\u5173\u7cfb\u4e3a\u7a7a\uff01");
            } else {
                BTPTransformResult btpResult = iBTPManager.transform(sourceBillCollection, btps.get(0));
                AcctBankTransDetailCollection botpCol = (AcctBankTransDetailCollection)btpResult.getBills();
                if (!EmptyUtil.isEmpty((AbstractObjectCollection)botpCol)) {
                    info = botpCol.get(0);
                }
            }
            if (detailColl.get(i).getIsDataImport().equals((Object)TransdetailSourceEnum.IMPORT)) {
                info.setTransDetailID(detaiInfo.getId().toString());
            } else {
                info.setTransDetailID(detaiInfo.getTranPackageID());
            }
            if (EmptyUtil.isEmpty((Object)info.getBizTime())) {
                info.setBizTime(detaiInfo.getBizTime());
            }
            if (EmptyUtil.isEmpty((String)info.getAcctBankName())) {
                info.setAcctBankName(detaiInfo.getBankAccount().getName());
            }
            if (EmptyUtil.isEmpty((String)info.getAcctBankNumber())) {
                info.setAcctBankNumber(detaiInfo.getBankAccount().getBankAccountNumber());
            }
            if (EmptyUtil.isEmpty((String)info.getBankName())) {
                info.setBankName(detaiInfo.getBankAccount().getBank().getName());
            }
            if (EmptyUtil.isEmpty((String)info.getOppAcctName())) {
                info.setOppAcctName(detaiInfo.getOppUnit());
            }
            if (EmptyUtil.isEmpty((String)info.getOppAcctNumber())) {
                info.setOppAcctNumber(detaiInfo.getOppBankNumber());
            }
            if (EmptyUtil.isEmpty((String)info.getOppBankName())) {
                info.setOppBankName(detaiInfo.getOppBank());
            }
            info.setIsDebit(detaiInfo.isIsDebit());
            if (EmptyUtil.isEmpty((Object)info.getAmount())) {
                BigDecimal amount = Constants.ZERO;
                if (!EmptyUtil.isEmpty((Object)detaiInfo.getCreditAmount())) {
                    amount = amount.add(detaiInfo.getCreditAmount());
                }
                if (!EmptyUtil.isEmpty((Object)detaiInfo.getDebitAmount())) {
                    amount = amount.add(detaiInfo.getDebitAmount());
                }
                info.setAmount(amount);
            }
            Timestamp time = new Timestamp(Calendar.getInstance().getTimeInMillis());
            info.setCreateTime(time);
            info.setCreator(user);
            info.setLastUpdateTime(time);
            info.setLastUpdateUser(user);
            colls.add(info);
        }
        return colls;
    }

    private TransDetailCollection getAcctTransDetailColByAcctIds(Context ctx, String acctBankIds, Date beginDate) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getTransDetailSelector());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)acctBankIds));
        filter.getFilterItems().add(new FilterItemInfo("bizTime", (Object)beginDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizTime", (Object)DateUtil.getNextDay((Date)DateUtil.getDayBegin()), CompareType.LESS));
        view.setFilter(filter);
        logger.info((Object)("TransDetail's Collection Sql:" + view.toString()));
        TransDetailCollection detailColl = TransDetailFactory.getLocalInstance((Context)ctx).getTransDetailCollection(view);
        return detailColl;
    }

    private SelectorItemCollection getTransDetailSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("recedBillNumber");
        selector.add("name");
        selector.add("transBalance");
        selector.add("description");
        selector.add("bizTime");
        selector.add("rawTransTime");
        selector.add("oppBankNumber");
        selector.add("oppUnit");
        selector.add("oppBank");
        selector.add("isDataImport");
        selector.add("creditAmount");
        selector.add("debitAmount");
        selector.add("isDebit");
        selector.add("tranPackageID");
        selector.add("bankinterfaceId");
        selector.add("bankInterface");
        selector.add("bankAccount.id");
        selector.add("bankAccount.name");
        selector.add("bankAccount.bankAccountNumber");
        selector.add("bankAccount.bank.id");
        selector.add("bankAccount.bank.name");
        selector.add("bankAccount.bank.number");
        selector.add("company.id");
        selector.add("company.name");
        selector.add("company.number");
        selector.add("cu.id");
        selector.add("cu.name");
        selector.add("cu.number");
        return selector;
    }
}

