/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.sa.AccessSourceEnum;
import com.kingdee.eas.fm.sa.AutoGenLargeAndDebtDetaillFacadeFactory;
import com.kingdee.eas.fm.sa.DebtDetailBillCollection;
import com.kingdee.eas.fm.sa.DebtDetailBillFactory;
import com.kingdee.eas.fm.sa.DebtDetailBillInfo;
import com.kingdee.eas.fm.sa.FundUseInfo;
import com.kingdee.eas.fm.sa.FundUseMatchSolutionEntryCollection;
import com.kingdee.eas.fm.sa.FundUseMatchSolutionEntryFactory;
import com.kingdee.eas.fm.sa.IAutoGenLargeAndDebtDetaillFacade;
import com.kingdee.eas.fm.sa.LargeDetailBillCollection;
import com.kingdee.eas.fm.sa.LargeDetailBillFactory;
import com.kingdee.eas.fm.sa.LargeDetailBillInfo;
import com.kingdee.eas.fm.sa.LargeThresholdSettingEntryCollection;
import com.kingdee.eas.fm.sa.LargeThresholdSettingEntryFactory;
import com.kingdee.eas.fm.sa.MatchPropertyEnum;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryOrgCollection;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryOrgFactory;
import com.kingdee.eas.fm.sa.ReportOrgSolutionSettingInfo;
import com.kingdee.eas.fm.sa.SAException;
import com.kingdee.eas.fm.sa.app.AbstractAutoGenLargeAndDebtDetaillFacadeControllerBean;
import com.kingdee.eas.fm.sa.app.handler.ITransDebtDetailHandler;
import com.kingdee.eas.fm.sa.app.handler.ITransLargeDetailHandler;
import com.kingdee.eas.fm.sa.app.handler.TransDebtDetailHandlerFacatory;
import com.kingdee.eas.fm.sa.app.handler.TransLargeDetailHandlerFacatory;
import com.kingdee.eas.fm.sa.app.util.DateUtils;
import com.kingdee.eas.fm.sa.app.util.SAConstants;
import com.kingdee.eas.fm.sa.app.util.ThreadLocalDateUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AutoGenLargeAndDebtDetaillFacadeControllerBean
extends AbstractAutoGenLargeAndDebtDetaillFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.sa.app.AutoGenLargeAndDebtDetaillFacadeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _autoGenLargeDetail(Context ctx, int retraceDays) throws BOSException, EASBizException {
        logger.error((Object)"\u5f00\u59cb\u6267\u884c\u751f\u6210\u5927\u989d\u8d44\u91d1\u660e\u7ec6_autoGenLargeDetail\u7684\u540e\u53f0\u4e8b\u52a1");
        Set<Date> dateSet = this.getPayDateSet(retraceDays);
        Set<String> companyIdSet = this.getCompanyIds(ctx);
        if (companyIdSet.size() == 0) {
            logger.error((Object)"\u6ca1\u6709\u7b26\u5408\u751f\u6210\u5927\u989d\u8d44\u91d1\u660e\u7ec6\u6761\u4ef6\u7684\u516c\u53f8");
            return;
        }
        Set<String> companyDateSet = this.getCompanyDateSet(ctx, companyIdSet, dateSet);
        if (companyDateSet.size() == 0) {
            logger.error((Object)"\u6ca1\u6709\u7b26\u5408\u751f\u6210\u5927\u989d\u8d44\u91d1\u660e\u7ec6\u6761\u4ef6\u7684\u516c\u53f8\u548c\u65e5\u671f\u7ec4\u5408");
            return;
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        IAutoGenLargeAndDebtDetaillFacade iAutoGenLargeAndDebtDetaillFacade = AutoGenLargeAndDebtDetaillFacadeFactory.getLocalInstance(ctx);
        for (String key : companyDateSet) {
            String companyId = key.split("#")[0];
            Date payDate = null;
            try {
                payDate = ThreadLocalDateUtil.parse(key.split("#")[1]);
            }
            catch (ParseException e) {
                logger.error((Object)e);
                continue;
            }
            boolean b = false;
            try {
                b = iMutex.requestObjIDForUpdate(SAConstants.getSALargeMutexId(companyId, payDate));
                if (!b) {
                    throw new SAException(SAException.EXISTS_REPORTING_DATA, new Object[]{companyId, ThreadLocalDateUtil.formatDate(payDate)});
                }
                iAutoGenLargeAndDebtDetaillFacade.genLargeDetail(companyId, payDate);
            }
            catch (Exception e) {
                logger.error((Object)("\u4e0a\u62a5\u7ec4\u7ec7\uff1a" + companyId + "\u652f\u4ed8\u65e5\u671f\uff1a" + ThreadLocalDateUtil.formatDate(payDate) + "\u7684\u5927\u989d\u8d44\u91d1\u660e\u7ec6\u751f\u6210\u5931\u8d25\uff1a"));
                logger.error((Object)e);
            }
            finally {
                if (!b) continue;
                iMutex.releaseObjIDForUpdate(SAConstants.getSALargeMutexId(companyId, payDate));
            }
        }
        logger.error((Object)"\u5927\u989d\u8d44\u91d1\u660e\u7ec6_autoGenLargeDetail\u540e\u53f0\u4e8b\u52a1\u6267\u884c\u5b8c\u6210");
    }

    @Override
    protected void _genLargeDetail(Context ctx, String companyId, Date payDate) throws BOSException, EASBizException {
        ReportOrgSolutionSettingInfo reportOrgSolution = this.getReportOrgSolution(ctx, companyId);
        BigDecimal minAmount = this.getMinAmount(ctx, companyId);
        Map<String, FundUseInfo> matchId_fundUseMap = this.initMatchFundUse(ctx, MatchPropertyEnum.FundFlowItem_Large);
        List list = AccessSourceEnum.getEnumList();
        for (int i = 0; i < list.size(); ++i) {
            AccessSourceEnum source = (AccessSourceEnum)((Object)list.get(i));
            ITransLargeDetailHandler transLargeHandler = TransLargeDetailHandlerFacatory.getInstance(source);
            if (transLargeHandler == null) continue;
            transLargeHandler.genLargeDetailColl(ctx, companyId, payDate, minAmount, source, reportOrgSolution, matchId_fundUseMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _autoGenDebtDetail(Context ctx) throws BOSException, EASBizException {
        logger.error((Object)"\u5f00\u59cb\u6267\u884c\u751f\u6210\u5230\u671f\u503a\u52a1\u660e\u7ec6_autoGenDebtDetail\u7684\u540e\u53f0\u4e8b\u52a1");
        Set<String> companyIdSet = this.getCompanyIds(ctx);
        if (companyIdSet.size() == 0) {
            logger.error((Object)"\u6ca1\u6709\u7b26\u5408\u751f\u6210\u5230\u671f\u503a\u52a1\u660e\u7ec6\u6761\u4ef6\u7684\u516c\u53f8");
            return;
        }
        Date startDate = DateUtil.getFirstDayOfMonth((Date)new Date());
        this.removeReportCompany(ctx, companyIdSet, startDate);
        if (companyIdSet.size() == 0) {
            logger.error((Object)"\u6ca1\u6709\u7b26\u5408\u751f\u6210\u5230\u671f\u503a\u52a1\u660e\u7ec6\u6761\u4ef6\u7684\u516c\u53f8");
            return;
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        IAutoGenLargeAndDebtDetaillFacade iAutoGenLargeAndDebtDetaillFacade = AutoGenLargeAndDebtDetaillFacadeFactory.getLocalInstance(ctx);
        for (String companyId : companyIdSet) {
            boolean b = false;
            try {
                b = iMutex.requestObjIDForUpdate(SAConstants.getSADebtMutexId(companyId, startDate));
                if (!b) {
                    throw new SAException(SAException.EXISTS_REPORTING_DEBT, new Object[]{companyId, ThreadLocalDateUtil.formatDate(startDate)});
                }
                iAutoGenLargeAndDebtDetaillFacade.genDebtDetail(companyId, startDate);
            }
            catch (Exception e) {
                logger.error((Object)("\u4e0a\u62a5\u7ec4\u7ec7\uff1a" + companyId + "\u62a5\u9001\u8d77\u671f\uff1a" + ThreadLocalDateUtil.formatDate(startDate) + "\u7684\u5230\u671f\u503a\u52a1\u660e\u7ec6\u751f\u6210\u5931\u8d25\uff1a"));
                logger.error((Object)e);
            }
            finally {
                if (!b) continue;
                iMutex.releaseObjIDForUpdate(SAConstants.getSADebtMutexId(companyId, startDate));
            }
        }
        logger.error((Object)"\u5230\u671f\u503a\u52a1\u660e\u7ec6_autoGenDebtDetail\u7684\u540e\u53f0\u4e8b\u52a1\u6267\u884c\u5b8c\u6210");
    }

    @Override
    protected void _genDebtDetail(Context ctx, String companyId, Date startDate) throws BOSException, EASBizException {
        ReportOrgSolutionSettingInfo reportOrgSolution = this.getReportOrgSolution(ctx, companyId);
        Map<String, FundUseInfo> matchId_fundUseMap = this.initMatchFundUse(ctx, MatchPropertyEnum.FinancingProducts_Claim);
        List list = AccessSourceEnum.getEnumList();
        for (int i = 0; i < list.size(); ++i) {
            AccessSourceEnum source = (AccessSourceEnum)((Object)list.get(i));
            ITransDebtDetailHandler transDebtHandler = TransDebtDetailHandlerFacatory.getInstance(source);
            if (transDebtHandler == null) continue;
            transDebtHandler.genDebtDetailColl(ctx, companyId, startDate, source, reportOrgSolution, matchId_fundUseMap);
        }
    }

    private Map<String, FundUseInfo> initMatchFundUse(Context ctx, MatchPropertyEnum matchProperty) throws BOSException {
        HashMap<String, FundUseInfo> matchId_fundUseMap = new HashMap<String, FundUseInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.state", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("parent.matchProperty", (Object)matchProperty.getValue()));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("fundFlowItem.id");
        selector.add("financingProducts.id");
        selector.add("fundUse.id");
        selector.add("fundUse.name");
        view.setSelector(selector);
        FundUseMatchSolutionEntryCollection coll = FundUseMatchSolutionEntryFactory.getLocalInstance(ctx).getFundUseMatchSolutionEntryCollection(view);
        block4: for (int i = 0; i < coll.size(); ++i) {
            switch (matchProperty.getValue()) {
                case 1: {
                    matchId_fundUseMap.put(coll.get(i).getFundFlowItem().getId().toString(), coll.get(i).getFundUse());
                    continue block4;
                }
                case 2: {
                    matchId_fundUseMap.put(coll.get(i).getFinancingProducts().getId().toString(), coll.get(i).getFundUse());
                }
            }
        }
        return matchId_fundUseMap;
    }

    private Set<String> getCompanyDateSet(Context ctx, Set<String> companyIdSet, Set<Date> dateSet) throws BOSException {
        HashSet<String> companyDateSet = new HashSet<String>();
        for (String companyId : companyIdSet) {
            for (Date payDate : dateSet) {
                companyDateSet.add(companyId + "#" + ThreadLocalDateUtil.formatDate(payDate));
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("reportOrg.id", companyIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("payDate", dateSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)4));
        view.setFilter(filter);
        LargeDetailBillCollection coll = LargeDetailBillFactory.getLocalInstance(ctx).getLargeDetailBillCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            LargeDetailBillInfo info = coll.get(i);
            String companyId = info.getReportOrg().getId().toString();
            Date payDate = info.getPayDate();
            String key = companyId + "#" + ThreadLocalDateUtil.formatDate(payDate);
            if (!companyDateSet.contains(key)) continue;
            companyDateSet.remove(key);
        }
        return companyDateSet;
    }

    private void removeReportCompany(Context ctx, Set<String> companyIdSet, Date startDate) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("reportOrg.id", companyIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("startDate", (Object)startDate));
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)4));
        view.setFilter(filter);
        DebtDetailBillCollection coll = DebtDetailBillFactory.getLocalInstance(ctx).getDebtDetailBillCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            DebtDetailBillInfo info = coll.get(i);
            String companyId = info.getReportOrg().getId().toString();
            if (!companyIdSet.contains(companyId)) continue;
            companyIdSet.remove(companyId);
        }
    }

    private Set<Date> getPayDateSet(int retraceDays) {
        HashSet<Date> dateSet = new HashSet<Date>();
        if (retraceDays <= 0) {
            retraceDays = 0;
        }
        if (retraceDays > 30) {
            retraceDays = 30;
        }
        for (int i = 0; i <= retraceDays; ++i) {
            dateSet.add(DateUtils.getBeforeDay(i));
        }
        return dateSet;
    }

    private Set<String> getCompanyIds(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.state", (Object)1));
        view.setFilter(filter);
        ReportOrgSSEntryOrgCollection coll = ReportOrgSSEntryOrgFactory.getLocalInstance(ctx).getReportOrgSSEntryOrgCollection(view);
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            idSet.add(coll.get(i).getReportOrg().getId().toString());
        }
        return idSet;
    }

    private ReportOrgSolutionSettingInfo getReportOrgSolution(Context ctx, String companyId) throws BOSException {
        ReportOrgSolutionSettingInfo reportOrgSolution = new ReportOrgSolutionSettingInfo();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("reportOrg.id", (Object)companyId));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("parent.*");
        view.setFilter(filter);
        view.setSelector(selector);
        ReportOrgSSEntryOrgCollection coll = ReportOrgSSEntryOrgFactory.getLocalInstance(ctx).getReportOrgSSEntryOrgCollection(view);
        if (coll != null && coll.size() > 0) {
            reportOrgSolution = coll.get(0).getParent();
        }
        return reportOrgSolution;
    }

    private BigDecimal getMinAmount(Context ctx, String companyId) throws BOSException {
        BigDecimal minAmount = SAConstants.MINAMOUNT;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("parent.status", (Object)1));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("parent.amount"));
        view.setFilter(filter);
        view.setSelector(selector);
        LargeThresholdSettingEntryCollection coll = LargeThresholdSettingEntryFactory.getLocalInstance(ctx).getLargeThresholdSettingEntryCollection(view);
        if (coll != null && coll.size() > 0) {
            minAmount = coll.get(0).getParent().getAmount();
        }
        return minAmount;
    }
}

