/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.be.BankPayingBillCollection;
import com.kingdee.eas.fm.be.BankPayingBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.sa.AccessSourceEnum;
import com.kingdee.eas.fm.sa.BillStatusEnum;
import com.kingdee.eas.fm.sa.FundUseInfo;
import com.kingdee.eas.fm.sa.FundUseMatchSolutionEntryCollection;
import com.kingdee.eas.fm.sa.FundUseMatchSolutionEntryFactory;
import com.kingdee.eas.fm.sa.LargeAccessSourceSettingEntryCollection;
import com.kingdee.eas.fm.sa.LargeAccessSourceSettingEntryFactory;
import com.kingdee.eas.fm.sa.LargeDetailBillCollection;
import com.kingdee.eas.fm.sa.LargeDetailBillFactory;
import com.kingdee.eas.fm.sa.LargeDetailBillInfo;
import com.kingdee.eas.fm.sa.LargeThresholdSettingEntryCollection;
import com.kingdee.eas.fm.sa.LargeThresholdSettingEntryFactory;
import com.kingdee.eas.fm.sa.PayTypeEnum;
import com.kingdee.eas.fm.sa.ReportContentEnum;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryOrgCollection;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryOrgFactory;
import com.kingdee.eas.fm.sa.ReportOrgSolutionSettingInfo;
import com.kingdee.eas.fm.sa.SAException;
import com.kingdee.eas.fm.sa.app.AbstractAutoGenLargeDetailBillFacadeControllerBean;
import com.kingdee.eas.fm.sa.app.util.SAConstants;
import com.kingdee.eas.fm.sa.app.util.Sequence;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class AutoGenLargeDetailBillFacadeControllerBean
extends AbstractAutoGenLargeDetailBillFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.sa.app.AutoGenLargeDetailBillFacadeControllerBean");

    @Override
    protected void _addNewLargeDetailBill(Context ctx, String companyId, Date payDate) throws BOSException, EASBizException {
        HashMap<String, FundUseInfo> fundflow_fundUseMap = new HashMap<String, FundUseInfo>();
        EntityViewInfo fmView = new EntityViewInfo();
        FilterInfo fmFilter = new FilterInfo();
        fmFilter.getFilterItems().add(new FilterItemInfo("parent.state", (Object)1));
        fmFilter.getFilterItems().add(new FilterItemInfo("parent.matchProperty", (Object)1));
        fmView.setFilter(fmFilter);
        SelectorItemCollection fmSelector = new SelectorItemCollection();
        fmSelector.add("fundFlowItem.id");
        fmSelector.add("fundUse.id");
        fmSelector.add("fundUse.name");
        fmView.setSelector(fmSelector);
        FundUseMatchSolutionEntryCollection fmColl = FundUseMatchSolutionEntryFactory.getLocalInstance(ctx).getFundUseMatchSolutionEntryCollection(fmView);
        for (int i = 0; i < fmColl.size(); ++i) {
            fundflow_fundUseMap.put(fmColl.get(i).getFundFlowItem().getId().toString(), fmColl.get(i).getFundUse());
        }
        ReportOrgSolutionSettingInfo reportOrgSolution = new ReportOrgSolutionSettingInfo();
        EntityViewInfo reView = new EntityViewInfo();
        SelectorItemCollection reSelector = new SelectorItemCollection();
        reSelector.add("parent.*");
        FilterInfo reFilter = new FilterInfo();
        reFilter.getFilterItems().add(new FilterItemInfo("reportOrg.id", (Object)companyId));
        reView.setFilter(reFilter);
        reView.setSelector(reSelector);
        ReportOrgSSEntryOrgCollection reColl = ReportOrgSSEntryOrgFactory.getLocalInstance(ctx).getReportOrgSSEntryOrgCollection(reView);
        if (reColl != null && reColl.size() > 0) {
            reportOrgSolution = reColl.get(0).getParent();
        }
        EntityViewInfo largeDetailView = new EntityViewInfo();
        FilterInfo largeDetailFilter = new FilterInfo();
        largeDetailFilter.getFilterItems().add(new FilterItemInfo("reportOrg.id", (Object)companyId));
        largeDetailFilter.getFilterItems().add(new FilterItemInfo("payDate", (Object)payDate, CompareType.GREATER_EQUALS));
        largeDetailFilter.getFilterItems().add(new FilterItemInfo("payDate", (Object)this.getAfterDay(payDate, 1), CompareType.LESS));
        SelectorItemCollection largeDetailSelector = new SelectorItemCollection();
        largeDetailSelector.add(new SelectorItemInfo("sourceBillId"));
        largeDetailView.setFilter(largeDetailFilter);
        largeDetailView.setSelector(largeDetailSelector);
        LargeDetailBillCollection largeDetailColl = LargeDetailBillFactory.getLocalInstance(ctx).getLargeDetailBillCollection(largeDetailView);
        HashSet<String> sourceBillIdSet = new HashSet<String>();
        for (int i = 0; i < largeDetailColl.size(); ++i) {
            sourceBillIdSet.add(largeDetailColl.get(i).getSourceBillId());
        }
        EntityViewInfo largePayView = new EntityViewInfo();
        FilterInfo largePayFilter = new FilterInfo();
        largePayFilter.getFilterItems().add(new FilterItemInfo("parent.reportOrg.id", (Object)companyId));
        largePayFilter.getFilterItems().add(new FilterItemInfo("parent.state", (Object)1));
        largePayFilter.getFilterItems().add(new FilterItemInfo("accessSource", (Object)2));
        SelectorItemCollection largePaySelector = new SelectorItemCollection();
        largePaySelector.add(new SelectorItemInfo("accountBank.id"));
        largePayView.setSelector(largePaySelector);
        largePayView.setFilter(largePayFilter);
        LargeAccessSourceSettingEntryCollection largePayColl = LargeAccessSourceSettingEntryFactory.getLocalInstance(ctx).getLargeAccessSourceSettingEntryCollection(largePayView);
        HashSet<String> payAcctBankIdSet = new HashSet<String>();
        for (int i = 0; i < largePayColl.size(); ++i) {
            payAcctBankIdSet.add(largePayColl.get(i).getAccountBank().getId().toString());
        }
        if (payAcctBankIdSet.size() == 0) {
            logger.error((Object)"");
        }
        EntityViewInfo largeSettleView = new EntityViewInfo();
        FilterInfo largeSettleFilter = new FilterInfo();
        largeSettleFilter.getFilterItems().add(new FilterItemInfo("parent.reportOrg.id", (Object)companyId));
        largeSettleFilter.getFilterItems().add(new FilterItemInfo("parent.state", (Object)1));
        largeSettleFilter.getFilterItems().add(new FilterItemInfo("accessSource", (Object)1));
        SelectorItemCollection largeSettleSelector = new SelectorItemCollection();
        largeSettleSelector.add(new SelectorItemInfo("accountBank.id"));
        largeSettleView.setSelector(largeSettleSelector);
        largeSettleView.setFilter(largeSettleFilter);
        LargeAccessSourceSettingEntryCollection largeSettleColl = LargeAccessSourceSettingEntryFactory.getLocalInstance(ctx).getLargeAccessSourceSettingEntryCollection(largeSettleView);
        HashSet<String> settleAcctBankIdSet = new HashSet<String>();
        for (int i = 0; i < largeSettleColl.size(); ++i) {
            settleAcctBankIdSet.add(largeSettleColl.get(i).getAccountBank().getId().toString());
        }
        if (settleAcctBankIdSet.size() == 0) {
            logger.error((Object)"");
        }
        EntityViewInfo ltView = new EntityViewInfo();
        FilterInfo ltFilter = new FilterInfo();
        ltFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        ltFilter.getFilterItems().add(new FilterItemInfo("parent.status", (Object)1));
        SelectorItemCollection ltSelector = new SelectorItemCollection();
        ltSelector.add(new SelectorItemInfo("parent.amount"));
        ltView.setFilter(ltFilter);
        ltView.setSelector(ltSelector);
        LargeThresholdSettingEntryCollection ltColl = LargeThresholdSettingEntryFactory.getLocalInstance(ctx).getLargeThresholdSettingEntryCollection(ltView);
        BigDecimal defaultAmount = SAConstants.MINAMOUNT;
        if (ltColl != null && ltColl.size() > 0) {
            defaultAmount = ltColl.get(0).getParent().getAmount();
        }
        EntityViewInfo payView = new EntityViewInfo();
        FilterInfo payFilter = new FilterInfo();
        payFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        payFilter.getFilterItems().add(new FilterItemInfo("payDate", (Object)payDate, CompareType.GREATER_EQUALS));
        payFilter.getFilterItems().add(new FilterItemInfo("payDate", (Object)this.getAfterDay(payDate, 1), CompareType.LESS));
        payFilter.getFilterItems().add(new FilterItemInfo("payerAccountBank.id", payAcctBankIdSet, CompareType.INCLUDE));
        payFilter.getFilterItems().add(new FilterItemInfo("actPayLocAmt", (Object)defaultAmount, CompareType.GREATER_EQUALS));
        payFilter.getFilterItems().add(new FilterItemInfo("isCBPay", (Object)false));
        payFilter.getFilterItems().add(new FilterItemInfo("isNeedPay", (Object)true));
        payFilter.getFilterItems().add(new FilterItemInfo("isInitializeBill", (Object)false));
        SelectorItemCollection paySelector = new SelectorItemCollection();
        paySelector.add(new SelectorItemInfo("id"));
        payView.setSelector(paySelector);
        payView.setFilter(payFilter);
        PaymentBillCollection payColl = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection(payView);
        HashSet<String> payIdSet = new HashSet<String>();
        for (int i = 0; i < payColl.size(); ++i) {
            String payId = payColl.get(i).getId().toString();
            if (sourceBillIdSet.contains(payId)) continue;
            payIdSet.add(payId);
        }
        HashSet<Integer> typeSet = new HashSet<Integer>();
        typeSet.add(2);
        typeSet.add(100);
        EntityViewInfo settleView = new EntityViewInfo();
        FilterInfo settleFilter = new FilterInfo();
        settleFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        settleFilter.getFilterItems().add(new FilterItemInfo("settleDate", (Object)payDate));
        settleFilter.getFilterItems().add(new FilterItemInfo("payerBankAcct.id", settleAcctBankIdSet, CompareType.INCLUDE));
        settleFilter.getFilterItems().add(new FilterItemInfo("localAmt", (Object)defaultAmount, CompareType.GREATER_EQUALS));
        settleFilter.getFilterItems().add(new FilterItemInfo("type", typeSet, CompareType.INCLUDE));
        SelectorItemCollection settleSelector = new SelectorItemCollection();
        settleSelector.add(new SelectorItemInfo("id"));
        settleView.setSelector(settleSelector);
        settleView.setFilter(settleFilter);
        SettlementBillCollection settleColl = SettlementBillFactory.getLocalInstance((Context)ctx).getSettlementBillCollection(settleView);
        HashSet<String> settleIdSet = new HashSet<String>();
        for (int i = 0; i < settleColl.size(); ++i) {
            String settleId = settleColl.get(i).getId().toString();
            if (sourceBillIdSet.contains(settleId)) continue;
            settleIdSet.add(settleId);
        }
        HashMap<String, Boolean> pay_isPersonPayMap = new HashMap<String, Boolean>();
        EntityViewInfo bpView = new EntityViewInfo();
        FilterInfo bpFilter = new FilterInfo();
        bpFilter.getFilterItems().add(new FilterItemInfo("sourceBillId", payIdSet, CompareType.INCLUDE));
        SelectorItemCollection bpSelector = new SelectorItemCollection();
        bpSelector.add(new SelectorItemInfo("isPersonPay"));
        bpSelector.add(new SelectorItemInfo("sourceBillId"));
        bpView.setFilter(bpFilter);
        bpView.setSelector(bpSelector);
        BankPayingBillCollection bpColl = BankPayingBillFactory.getLocalInstance((Context)ctx).getBankPayingBillCollection(bpView);
        for (int i = 0; i < bpColl.size(); ++i) {
            pay_isPersonPayMap.put(bpColl.get(i).getSourceBillId(), bpColl.get(i).isIsPersonPay());
        }
        CoreBaseCollection newLargeDetailBillColl = new CoreBaseCollection();
        EntityViewInfo pView = new EntityViewInfo();
        FilterInfo pFilter = new FilterInfo();
        pFilter.getFilterItems().add(new FilterItemInfo("id", payIdSet, CompareType.INCLUDE));
        pView.setFilter(pFilter);
        SelectorItemCollection pSelector = new SelectorItemCollection();
        pSelector.add(new SelectorItemInfo("*"));
        pSelector.add(new SelectorItemInfo("entries.fundFlowItem.id"));
        pSelector.add(new SelectorItemInfo("payerAccountBank.acctName"));
        pSelector.add(new SelectorItemInfo("payerAccountBank.name"));
        pSelector.add(new SelectorItemInfo("company.name"));
        pView.setSelector(pSelector);
        PaymentBillCollection pColl = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection(pView);
        for (int i = 0; i < pColl.size(); ++i) {
            PaymentBillInfo paymentBill = pColl.get(i);
            BTPTransformResult btpResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform((CoreBillBaseInfo)paymentBill, new LargeDetailBillInfo().getBOSType().toString());
            LargeDetailBillCollection largeColl = (LargeDetailBillCollection)btpResult.getBills();
            LargeDetailBillInfo info = null;
            if (largeColl.size() <= 0) continue;
            info = largeColl.get(0);
            info.setSourceBillId(paymentBill.getId().toString());
            info.setAccessSource(AccessSourceEnum.PaymentBill);
            info.setSourceBillNumber(paymentBill.getNumber());
            info.setReportedType(ReportContentEnum.USE_OF_LARGE_FUNDS);
            this.initBillNumber(ctx, info);
            info.setSerialId(Sequence.gen18Sequence());
            info.setFillInOrgUnitName(reportOrgSolution.getFillInOrgUnitName());
            info.setFillInOrgUnitCode(reportOrgSolution.getFillInOrgUnitCode());
            if (!EmptyUtil.isEmpty((CoreBaseInfo)paymentBill.getPayerAccountBank()) && !EmptyUtil.isEmpty((String)paymentBill.getPayerAccountBank().getAcctName())) {
                info.setPayName(paymentBill.getPayerAccountBank().getAcctName());
            }
            if (EmptyUtil.isEmpty((String)info.getPayName()) && !EmptyUtil.isEmpty((CoreBaseInfo)paymentBill.getPayerAccountBank())) {
                info.setPayName(paymentBill.getPayerAccountBank().getName());
            }
            if (EmptyUtil.isEmpty((String)info.getPayName())) {
                info.setPayName(paymentBill.getCompany().getName());
            }
            if (!EmptyUtil.isEmpty((CoreBaseInfo)paymentBill.getFundFlowItem())) {
                info.setFundUse((FundUseInfo)fundflow_fundUseMap.get(paymentBill.getFundFlowItem().getId().toString()));
            } else {
                PaymentBillEntryCollection entries = paymentBill.getEntries();
                if (!EmptyUtil.isEmpty((CoreBaseInfo)entries.get(0).getFundFlowItem())) {
                    info.setFundUse((FundUseInfo)fundflow_fundUseMap.get(entries.get(0).getFundFlowItem().getId().toString()));
                }
            }
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getFundUse())) {
                info.setFundUseName(info.getFundUse().getName());
            }
            info.setPayType(PayTypeEnum.ToPublic);
            if (Boolean.valueOf(pay_isPersonPayMap.get(paymentBill.getId().toString()) + "").booleanValue()) {
                info.setPayType(PayTypeEnum.ToPrivate);
            }
            info.setIsCBRecName(false);
            info.setIsTradeBusiness(true);
            info.setBillStatus(BillStatusEnum.SAVE);
            if (EmptyUtil.isEmpty((Object)info.getAmount())) {
                info.setAmount(BigDecimal.ZERO);
            }
            if (!EmptyUtil.isEmpty((Object)info.getPayDate())) {
                info.setPayDate(DateTimeUtils.truncateDate((Date)info.getPayDate()));
            }
            newLargeDetailBillColl.add((CoreBaseInfo)info);
        }
        HashMap<String, Boolean> settle_isPersonPayMap = new HashMap<String, Boolean>();
        EntityViewInfo spView = new EntityViewInfo();
        FilterInfo spFilter = new FilterInfo();
        spFilter.getFilterItems().add(new FilterItemInfo("sourceBillId", settleIdSet, CompareType.INCLUDE));
        SelectorItemCollection spSelector = new SelectorItemCollection();
        spSelector.add(new SelectorItemInfo("isPersonPay"));
        spSelector.add(new SelectorItemInfo("sourceBillId"));
        spView.setFilter(spFilter);
        spView.setSelector(spSelector);
        BankPayingBillCollection spColl = BankPayingBillFactory.getLocalInstance((Context)ctx).getBankPayingBillCollection(spView);
        for (int i = 0; i < spColl.size(); ++i) {
            settle_isPersonPayMap.put(spColl.get(i).getSourceBillId(), spColl.get(i).isIsPersonPay());
        }
        EntityViewInfo sView = new EntityViewInfo();
        FilterInfo sFilter = new FilterInfo();
        sFilter.getFilterItems().add(new FilterItemInfo("id", settleIdSet, CompareType.INCLUDE));
        sView.setFilter(sFilter);
        SelectorItemCollection sSelector = new SelectorItemCollection();
        sSelector.add(new SelectorItemInfo("*"));
        sSelector.add(new SelectorItemInfo("payerBankAcct.acctName"));
        sSelector.add(new SelectorItemInfo("payerBankAcct.name"));
        sSelector.add(new SelectorItemInfo("company.name"));
        sView.setSelector(sSelector);
        SettlementBillCollection sColl = SettlementBillFactory.getLocalInstance((Context)ctx).getSettlementBillCollection(sView);
        for (int i = 0; i < sColl.size(); ++i) {
            SettlementBillInfo settlementBill = sColl.get(i);
            BTPTransformResult btpResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform((CoreBillBaseInfo)settlementBill, new LargeDetailBillInfo().getBOSType().toString());
            LargeDetailBillCollection largeColl = (LargeDetailBillCollection)btpResult.getBills();
            LargeDetailBillInfo info = null;
            if (largeColl.size() <= 0) continue;
            info = largeColl.get(0);
            info.setSourceBillId(settlementBill.getId().toString());
            info.setAccessSource(AccessSourceEnum.SettlementBill);
            info.setSourceBillNumber(settlementBill.getNumber());
            info.setReportedType(ReportContentEnum.USE_OF_LARGE_FUNDS);
            this.initBillNumber(ctx, info);
            info.setSerialId(Sequence.gen18Sequence());
            info.setFillInOrgUnitName(reportOrgSolution.getFillInOrgUnitName());
            info.setFillInOrgUnitCode(reportOrgSolution.getFillInOrgUnitCode());
            if (!EmptyUtil.isEmpty((CoreBaseInfo)settlementBill.getPayerBankAcct()) && !EmptyUtil.isEmpty((String)settlementBill.getPayerBankAcct().getAcctName())) {
                info.setPayName(settlementBill.getPayerBankAcct().getAcctName());
            }
            if (EmptyUtil.isEmpty((String)info.getPayName()) && !EmptyUtil.isEmpty((CoreBaseInfo)settlementBill.getPayerBankAcct())) {
                info.setPayName(settlementBill.getPayerBankAcct().getName());
            }
            if (EmptyUtil.isEmpty((String)info.getPayName())) {
                info.setPayName(settlementBill.getCompany().getName());
            }
            if (!EmptyUtil.isEmpty((CoreBaseInfo)settlementBill.getFundFlowItemOut())) {
                info.setFundUse((FundUseInfo)fundflow_fundUseMap.get(settlementBill.getFundFlowItemOut().getId().toString()));
            }
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getFundUse())) {
                info.setFundUseName(info.getFundUse().getName());
            }
            info.setPayType(PayTypeEnum.ToPublic);
            if (Boolean.valueOf(settle_isPersonPayMap.get(settlementBill.getId().toString()) + "").booleanValue()) {
                info.setPayType(PayTypeEnum.ToPrivate);
            }
            info.setIsCBRecName(false);
            info.setIsTradeBusiness(true);
            info.setBillStatus(BillStatusEnum.SAVE);
            if (EmptyUtil.isEmpty((Object)info.getAmount())) {
                info.setAmount(BigDecimal.ZERO);
            }
            if (!EmptyUtil.isEmpty((Object)info.getPayDate())) {
                info.setPayDate(DateTimeUtils.truncateDate((Date)info.getPayDate()));
            }
            info.setCreator(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
            newLargeDetailBillColl.add((CoreBaseInfo)info);
        }
        LargeDetailBillFactory.getLocalInstance(ctx).addnewBatchData(newLargeDetailBillColl);
    }

    private Date getAfterDay(Date thisDate, int afterDays) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(thisDate);
        ((Calendar)cal).add(5, afterDays);
        return cal.getTime();
    }

    private void initBillNumber(Context ctx, LargeDetailBillInfo info) throws BOSException, EASBizException {
        FilterInfo filter;
        if (!EmptyUtil.isEmpty((String)info.getNumber())) {
            return;
        }
        int i = 0;
        do {
            String numberSilent = null;
            try {
                numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getReportOrg().getId().toString());
            }
            catch (CodingRuleException e) {
                logger.info((Object)e);
                throw new SAException(SAException.COMMON, new String[]{e.getMessage()});
            }
            if (EmptyUtil.isEmpty((String)numberSilent)) {
                return;
            }
            info.setNumber(numberSilent);
            filter = AutoGenLargeDetailBillFacadeControllerBean.getCheckNumberDupFilter(info);
            ++i;
        } while (LargeDetailBillFactory.getLocalInstance(ctx).exists(filter));
    }

    public static FilterInfo getCheckNumberDupFilter(LargeDetailBillInfo info) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("reportOrg.id", (Object)info.getReportOrg().getId()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        return filter;
    }
}

