/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.sa.BillStatusEnum;
import com.kingdee.eas.fm.sa.DebtDetailBillFactory;
import com.kingdee.eas.fm.sa.DebtDetailBillInfo;
import com.kingdee.eas.fm.sa.SAException;
import com.kingdee.eas.fm.sa.app.AbstractDebtDetailBillControllerBean;
import com.kingdee.eas.fm.sa.app.util.DateUtils;
import com.kingdee.eas.fm.sa.app.util.SAConstants;
import com.kingdee.eas.fm.sa.app.util.Sequence;
import com.kingdee.eas.fm.sa.app.util.ThreadLocalDateUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DebtDetailBillControllerBean
extends AbstractDebtDetailBillControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.sa.app.DebtDetailBillControllerBean");
    private static String resource = "com.kingdee.eas.fm.sa.SAResource";

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DebtDetailBillInfo info = (DebtDetailBillInfo)model;
        this.initNumber(ctx, info);
        this.checkNumberDup(ctx, info);
        this.initAmount(info);
        this.verifyReport(ctx, info);
        info.setSerialId(Sequence.gen18Sequence());
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean b = false;
        try {
            b = iMutex.requestObjIDForUpdate(SAConstants.getSADebtMutexId(info.getReportOrg().getId().toString(), info.getStartDate()));
            if (!b) {
                throw new SAException(SAException.EXISTS_REPORTING_DEBT, new Object[]{info.getReportOrg().getName(), ThreadLocalDateUtil.formatDate(info.getStartDate())});
            }
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_debtDetailBill_addnew");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            IObjectPK iObjectPK = super._addnew(ctx, model);
            return iObjectPK;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new SAException(SAException.COMMON, new Object[]{e.getMessage()});
        }
        finally {
            if (b) {
                iMutex.releaseObjIDForUpdate(SAConstants.getSADebtMutexId(info.getReportOrg().getId().toString(), info.getStartDate()));
            }
        }
    }

    private void initNumber(Context ctx, DebtDetailBillInfo info) throws BOSException, EASBizException {
        FilterInfo filter;
        if (!EmptyUtil.isEmpty((String)info.getNumber())) {
            return;
        }
        int i = 0;
        do {
            String numberSilent = null;
            try {
                numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getReportOrg().getId().toString());
            }
            catch (CodingRuleException e) {
                logger.info((Object)e);
                throw new SAException(SAException.COMMON, new Object[]{e.getMessage()});
            }
            if (EmptyUtil.isEmpty((String)numberSilent)) {
                return;
            }
            info.setNumber(numberSilent);
            filter = this.getCheckNumberDupFilter(info, true);
            ++i;
        } while (DebtDetailBillFactory.getLocalInstance(ctx).exists(filter));
    }

    public void verifyReport(Context ctx, DebtDetailBillInfo info) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("reportOrg.id", (Object)info.getReportOrg().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("startDate", (Object)info.getStartDate()));
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)4));
        if (this.exists(ctx, filter)) {
            throw new SAException(SAException.EXISTS_REPORTED_DEBT, new Object[]{info.getReportOrg().getName(), ThreadLocalDateUtil.formatDate(info.getStartDate())});
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DebtDetailBillInfo info = (DebtDetailBillInfo)model;
        this.checkNumberDup(ctx, info);
        this.verifyNotNull(ctx, info, "save");
        if (info.getBillStatus() == null) {
            info.setBillStatus(BillStatusEnum.SAVE);
        }
        if (BillStatusEnum.CONFIRMED.equals((Object)info.getBillStatus()) || BillStatusEnum.REPORTED.equals((Object)info.getBillStatus())) {
            throw new SAException(SAException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"30_DebtDetailBillControllerBean", (Locale)ctx.getLocale())});
        }
        info.setStartDate(DateTimeUtils.truncateDate((Date)info.getStartDate()));
        info.setEndDate(DateTimeUtils.truncateDate((Date)info.getEndDate()));
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_debtDetailBill_save");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DebtDetailBillInfo info = (DebtDetailBillInfo)model;
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getReportOrg().getId()), (String)"debtDetailBill_submit_05");
        if (!isPermission) {
            throw new SAException(SAException.NOT_SUBMIT_PERMISSION, new Object[]{info.getReportOrg().getName()});
        }
        this.checkNumberDup(ctx, info);
        this.verifyNotNull(ctx, info, "submit");
        if (info.getBillStatus() == null || info.getBillStatus() == BillStatusEnum.SAVE) {
            info.setBillStatus(BillStatusEnum.SUBMIT);
        }
        if (info.getBillStatus() != BillStatusEnum.SAVE && info.getBillStatus() != BillStatusEnum.SUBMIT) {
            throw new SAException(SAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"Status_Not_Submit")});
        }
        if (!EmptyUtil.isEmpty((Object)info.getDueDateMonth()) && info.getLoanDate().after(info.getDueDateMonth())) {
            throw new SAException(SAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"LoanDate_After_DueDateMonth")});
        }
        if (!EmptyUtil.isEmpty((Object)info.getDueDateMonth()) && info.getDueDateMonth().after(info.getDueDate())) {
            throw new SAException(SAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"DueDateMonth_After_DueDate")});
        }
        if (!EmptyUtil.isEmpty((Object)info.getDueAmtMonth()) && info.getDueAmtMonth().compareTo(info.getDebtPrinAmt()) > 0) {
            throw new SAException(SAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"DueAmtMonth_Bigger_DebtPrinAmt")});
        }
        info.setStartDate(DateTimeUtils.truncateDate((Date)info.getStartDate()));
        info.setEndDate(DateTimeUtils.truncateDate((Date)info.getEndDate()));
        if (!DateUtils.isFirstDayOfMonth(info.getStartDate())) {
            throw new SAException(SAException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"31_DebtDetailBillControllerBean", (Locale)ctx.getLocale())});
        }
        if (!DateUtils.isEndDateOfMonth(info.getEndDate())) {
            throw new SAException(SAException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"32_DebtDetailBillControllerBean", (Locale)ctx.getLocale())});
        }
        if (!DateUtils.isTheSameOfMonth(info.getStartDate(), info.getEndDate())) {
            throw new SAException(SAException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"33_DebtDetailBillControllerBean", (Locale)ctx.getLocale())});
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_debtDetailBill_submit");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return super._submit(ctx, model);
    }

    public void checkNumberDup(Context ctx, DebtDetailBillInfo info) throws BOSException, EASBizException {
        String number = info.getNumber();
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        info.setNumber(info.getNumber().trim());
        FilterInfo filter = this.getCheckNumberDupFilter(info, false);
        if (this.exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{info.getNumber(), ""});
        }
    }

    public FilterInfo getCheckNumberDupFilter(DebtDetailBillInfo info, boolean addnew) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        filter.getFilterItems().add(new FilterItemInfo("reportOrg.id", (Object)info.getReportOrg().getId()));
        if (!addnew) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        }
        return filter;
    }

    public void verifyNotNull(Context ctx, DebtDetailBillInfo info, String methodName) throws BOSException, EASBizException {
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"reportOrg");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"startDate");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"endDate");
        if ("submit".equalsIgnoreCase(methodName)) {
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"fillInOrgUnitName");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"fillInOrgUnitCode");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"fundUse");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"debtPrinAmt");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"debtAnnlRate");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"loanDate");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"dueDate");
        }
    }

    private void initAmount(DebtDetailBillInfo info) {
        if (EmptyUtil.isEmpty((Object)info.getDebtPrinAmt())) {
            info.setDebtPrinAmt(BigDecimal.ZERO);
        }
        if (EmptyUtil.isEmpty((Object)info.getDebtAnnlRate())) {
            info.setDebtAnnlRate(BigDecimal.ZERO);
        }
        if (EmptyUtil.isEmpty((Object)info.getDueAmtMonth())) {
            info.setDueAmtMonth(BigDecimal.ZERO);
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("reportOrg.id");
        sic.add("reportOrg.name");
        DebtDetailBillInfo info = this.getDebtDetailBillInfo(ctx, pk, sic);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getReportOrg().getId()), (String)"debtDetailBill_update_03");
        if (!isPermission) {
            throw new SAException(SAException.NOT_UPDATE_PERMISSION, new Object[]{info.getReportOrg().getName()});
        }
        super._update(ctx, pk, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("reportOrg.id");
        sic.add("reportOrg.name");
        DebtDetailBillInfo info = this.getDebtDetailBillInfo(ctx, pk, sic);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getReportOrg().getId()), (String)"debtDetailBill_delete_04");
        if (!isPermission) {
            throw new SAException(SAException.NOT_DELETE_PERMISSION, new Object[]{info.getReportOrg().getName()});
        }
        if (info.getBillStatus() != BillStatusEnum.SAVE && info.getBillStatus() != BillStatusEnum.SUBMIT) {
            throw new SAException(SAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"Status_Not_Delete")});
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_debtDetailBill_delete");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        super._delete(ctx, pk);
    }

    @Override
    protected void _confirm(Context ctx, String id) throws BOSException, EASBizException {
        DebtDetailBillInfo info = this.getDebtDetailBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        if (info.getBillStatus() != BillStatusEnum.SUBMIT) {
            throw new SAException(SAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"Status_Not_Confirm")});
        }
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        Integer status = new Integer(3);
        String sql = "UPDATE T_SA_DebtDetailBill SET FBillStatus = ? , FLastUpdateUserID=? , FLastUpdateTime=?  WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{status, userInfo.getId().toString(), currTime, id});
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_debtDetailBill_confirm");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _unConfirm(Context ctx, String id) throws BOSException, EASBizException {
        DebtDetailBillInfo info = this.getDebtDetailBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        if (info.getBillStatus() != BillStatusEnum.CONFIRMED) {
            throw new SAException(SAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"Status_Not_UnConfirm")});
        }
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        Integer status = new Integer(2);
        String sql = "UPDATE T_SA_DebtDetailBill SET FBillStatus = ? , FLastUpdateUserID=? , FLastUpdateTime=?  WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{status, userInfo.getId().toString(), currTime, id});
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_debtDetailBill_unConfirm");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }
}

