/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.sa.LargeAccessSourceSettingEntryCollection;
import com.kingdee.eas.fm.sa.LargeAccessSourceSettingEntryInfo;
import com.kingdee.eas.fm.sa.LargeAccessSourceSettingInfo;
import com.kingdee.eas.fm.sa.LargeDetailBillFactory;
import com.kingdee.eas.fm.sa.ReportContentEnum;
import com.kingdee.eas.fm.sa.SAException;
import com.kingdee.eas.fm.sa.StatusEnum;
import com.kingdee.eas.fm.sa.app.AbstractLargeAccessSourceSettingControllerBean;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class LargeAccessSourceSettingControllerBean
extends AbstractLargeAccessSourceSettingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.sa.app.LargeAccessSourceSettingControllerBean");
    private static String resource = "com.kingdee.eas.fm.sa.SAResource";

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LargeAccessSourceSettingInfo info = (LargeAccessSourceSettingInfo)model;
        info.setState(StatusEnum.enable);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_largeAccessSourceSetting_addnew");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return super._addnew(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LargeAccessSourceSettingInfo info = (LargeAccessSourceSettingInfo)model;
        this.checkNumberDup(ctx, info);
        this.verifyNotNull(ctx, info);
        this.verifyOnlyOrg(ctx, info);
        return super._save(ctx, model);
    }

    public void checkNumberDup(Context ctx, LargeAccessSourceSettingInfo info) throws BOSException, EASBizException {
        String number = info.getNumber();
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        info.setNumber(info.getNumber().trim());
        FilterInfo filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)info, (boolean)false);
        if (this.exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{info.getNumber(), ""});
        }
    }

    public void verifyNotNull(Context ctx, LargeAccessSourceSettingInfo info) throws BOSException, EASBizException {
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"name");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"reportOrg");
        LargeAccessSourceSettingEntryCollection entrys = info.getEntrys();
        if (entrys == null || entrys.size() == 0) {
            throw new SAException(SAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"Entrys_Not_Null")});
        }
        HashMap<String, Integer> entryMap = new HashMap<String, Integer>();
        for (int i = 0; i < entrys.size(); ++i) {
            LargeAccessSourceSettingEntryInfo entry = entrys.get(i);
            if (entry.getAccountBank() == null) {
                throw new SAException(SAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"AccountBank_Not_Null")});
            }
            String acctBankId = entry.getAccountBank().getId().toString();
            int source = entry.getAccessSource().getValue();
            String key = acctBankId + source;
            Integer seq = (Integer)entryMap.get(key);
            if (seq != null) {
                throw new SAException(SAException.ENTRYREPEAT, new Object[]{seq, i + 1});
            }
            entryMap.put(key, i + 1);
        }
    }

    public void verifyOnlyOrg(Context ctx, LargeAccessSourceSettingInfo info) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("reportOrg.id", (Object)info.getReportOrg().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("reportedType", (Object)info.getReportedType().getValue(), CompareType.EQUALS));
        if (this.exists(ctx, filter)) {
            throw new SAException(SAException.EXISTS_SOURCE_REPORTORG, new Object[]{info.getReportOrg().getName(), info.getReportedType().getAlias()});
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("reportOrg.id");
        sic.add("reportOrg.name");
        LargeAccessSourceSettingInfo info = this.getLargeAccessSourceSettingInfo(ctx, pk, sic);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getReportOrg().getId()), (String)"largeAccessSourceSetting_update_03");
        if (!isPermission) {
            throw new SAException(SAException.NOT_UPDATE_PERMISSION, new Object[]{info.getReportOrg().getName()});
        }
        if (info.getState() == StatusEnum.enable) {
            throw new SAException(SAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"solution_enable_notUpdate")});
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_largeAccessSourceSetting_update");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        super._update(ctx, pk, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("reportOrg.id");
        sic.add("reportOrg.name");
        sic.add("entrys.accountBank.id");
        LargeAccessSourceSettingInfo info = this.getLargeAccessSourceSettingInfo(ctx, pk, sic);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getReportOrg().getId()), (String)"largeAccessSourceSetting_delete_04");
        if (!isPermission) {
            throw new SAException(SAException.NOT_DELETE_PERMISSION, new Object[]{info.getReportOrg().getName()});
        }
        if (info.getState() != StatusEnum.disable) {
            throw new SAException(SAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"solution_disable_delete")});
        }
        HashSet<String> acctBankIdSet = new HashSet<String>();
        LargeAccessSourceSettingEntryCollection entrys = info.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            acctBankIdSet.add(entrys.get(i).getAccountBank().getId().toString());
        }
        FilterInfo largeFilter = new FilterInfo();
        largeFilter.getFilterItems().add(new FilterItemInfo("accountBank.id", acctBankIdSet, CompareType.INCLUDE));
        if (LargeDetailBillFactory.getLocalInstance(ctx).exists(largeFilter) && info.getReportedType() == ReportContentEnum.USE_OF_LARGE_FUNDS) {
            throw new SAException(SAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"LargeAccessSource_reference_LargeDetail")});
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_largeAccessSourceSetting_delete");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        super._delete(ctx, pk);
    }
}

