/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.sa.BillStatusEnum;
import com.kingdee.eas.fm.sa.LargeDetailBillFactory;
import com.kingdee.eas.fm.sa.LargeDetailBillInfo;
import com.kingdee.eas.fm.sa.LargeThresholdSettingEntryCollection;
import com.kingdee.eas.fm.sa.LargeThresholdSettingEntryFactory;
import com.kingdee.eas.fm.sa.SAException;
import com.kingdee.eas.fm.sa.app.AbstractLargeDetailBillControllerBean;
import com.kingdee.eas.fm.sa.app.util.SAConstants;
import com.kingdee.eas.fm.sa.app.util.Sequence;
import com.kingdee.eas.fm.sa.app.util.ThreadLocalDateUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class LargeDetailBillControllerBean
extends AbstractLargeDetailBillControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.sa.app.LargeDetailBillControllerBean");
    private static String resource = "com.kingdee.eas.fm.sa.SAResource";

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LargeDetailBillInfo info = (LargeDetailBillInfo)model;
        this.initNumber(ctx, info);
        this.checkNumberDup(ctx, info);
        this.verifyReport(ctx, info);
        info.setSerialId(Sequence.gen18Sequence());
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean b = false;
        try {
            b = iMutex.requestObjIDForUpdate(SAConstants.getSALargeMutexId(info.getReportOrg().getId().toString(), info.getPayDate()));
            if (!b) {
                throw new SAException(SAException.EXISTS_REPORTING_DATA, new Object[]{info.getReportOrg().getName(), ThreadLocalDateUtil.formatDate(info.getPayDate())});
            }
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_largeDetailBill_addnew");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            IObjectPK iObjectPK = super._addnew(ctx, model);
            return iObjectPK;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new SAException(SAException.COMMON, new Object[]{e.getMessage()});
        }
        finally {
            if (b) {
                iMutex.releaseObjIDForUpdate(SAConstants.getSALargeMutexId(info.getReportOrg().getId().toString(), info.getPayDate()));
            }
        }
    }

    private void initNumber(Context ctx, LargeDetailBillInfo info) throws BOSException, EASBizException {
        FilterInfo filter;
        if (!EmptyUtil.isEmpty((String)info.getNumber())) {
            return;
        }
        int i = 0;
        do {
            String numberSilent = null;
            try {
                numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getReportOrg().getId().toString());
            }
            catch (CodingRuleException e) {
                logger.info((Object)e);
                throw new SAException(SAException.COMMON, new Object[]{e.getMessage()});
            }
            if (EmptyUtil.isEmpty((String)numberSilent)) {
                return;
            }
            info.setNumber(numberSilent);
            filter = this.getCheckNumberDupFilter(info, true);
            ++i;
        } while (LargeDetailBillFactory.getLocalInstance(ctx).exists(filter));
    }

    public void verifyReport(Context ctx, LargeDetailBillInfo info) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("reportOrg.id", (Object)info.getReportOrg().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("payDate", (Object)info.getPayDate()));
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)4));
        if (this.exists(ctx, filter)) {
            throw new SAException(SAException.EXISTS_REPORTED_DATA, new Object[]{info.getReportOrg().getName(), ThreadLocalDateUtil.formatDate(info.getPayDate())});
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LargeDetailBillInfo info = (LargeDetailBillInfo)model;
        this.checkNumberDup(ctx, info);
        this.verifyNotNull(ctx, info, "save");
        if (info.getBillStatus() == null) {
            info.setBillStatus(BillStatusEnum.SAVE);
        }
        if (BillStatusEnum.CONFIRMED.equals((Object)info.getBillStatus()) || BillStatusEnum.REPORTED.equals((Object)info.getBillStatus())) {
            throw new SAException(SAException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"30_DebtDetailBillControllerBean", (Locale)ctx.getLocale())});
        }
        info.setPayDate(DateTimeUtils.truncateDate((Date)info.getPayDate()));
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_largeDetailBill_save");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LargeDetailBillInfo info = (LargeDetailBillInfo)model;
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getReportOrg().getId()), (String)"largeDetailBill_submit_05");
        if (!isPermission) {
            throw new SAException(SAException.NOT_SUBMIT_PERMISSION, new Object[]{info.getReportOrg().getName()});
        }
        this.checkNumberDup(ctx, info);
        this.verifyNotNull(ctx, info, "submit");
        this.verifyAmount(ctx, info);
        if (info.getBillStatus() == null || info.getBillStatus() == BillStatusEnum.SAVE) {
            info.setBillStatus(BillStatusEnum.SUBMIT);
        }
        if (info.getBillStatus() != BillStatusEnum.SAVE && info.getBillStatus() != BillStatusEnum.SUBMIT) {
            throw new SAException(SAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"Status_Not_Submit")});
        }
        info.setPayDate(DateTimeUtils.truncateDate((Date)info.getPayDate()));
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_largeDetailBill_submit");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return super._submit(ctx, model);
    }

    public void checkNumberDup(Context ctx, LargeDetailBillInfo info) throws BOSException, EASBizException {
        String number = info.getNumber();
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        info.setNumber(info.getNumber().trim());
        FilterInfo filter = this.getCheckNumberDupFilter(info, false);
        if (this.exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{info.getNumber(), ""});
        }
    }

    public void verifyNotNull(Context ctx, LargeDetailBillInfo info, String methodName) throws BOSException, EASBizException {
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"reportOrg");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"payDate");
        if ("submit".equals(methodName)) {
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"amount");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"accountBank");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"fillInOrgUnitName");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"fillInOrgUnitCode");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"payName");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"recName");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"fundUse");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"fundUseName");
        }
        if (EmptyUtil.isEmpty((Object)info.getAmount())) {
            info.setAmount(BigDecimal.ZERO);
        }
    }

    private void verifyAmount(Context ctx, LargeDetailBillInfo info) throws BOSException, EASBizException {
        EntityViewInfo ltView = new EntityViewInfo();
        FilterInfo ltFilter = new FilterInfo();
        ltFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getReportOrg().getId().toString()));
        ltFilter.getFilterItems().add(new FilterItemInfo("parent.status", (Object)1));
        SelectorItemCollection ltSelector = new SelectorItemCollection();
        ltSelector.add(new SelectorItemInfo("parent.amount"));
        ltView.setFilter(ltFilter);
        ltView.setSelector(ltSelector);
        LargeThresholdSettingEntryCollection ltColl = LargeThresholdSettingEntryFactory.getLocalInstance(ctx).getLargeThresholdSettingEntryCollection(ltView);
        BigDecimal minAmount = SAConstants.MINAMOUNT;
        if (ltColl != null && ltColl.size() > 0) {
            minAmount = ltColl.get(0).getParent().getAmount();
        }
        if (info.getAmount().compareTo(minAmount) < 0) {
            throw new SAException(SAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"Amount_Less_10Million")});
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("reportOrg.id");
        sic.add("reportOrg.name");
        LargeDetailBillInfo info = this.getLargeDetailBillInfo(ctx, pk, sic);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getReportOrg().getId()), (String)"largeDetailBill_update_03");
        if (!isPermission) {
            throw new SAException(SAException.NOT_UPDATE_PERMISSION, new Object[]{info.getReportOrg().getName()});
        }
        super._update(ctx, pk, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("reportOrg.id");
        sic.add("reportOrg.name");
        LargeDetailBillInfo info = this.getLargeDetailBillInfo(ctx, pk, sic);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getReportOrg().getId()), (String)"largeDetailBill_delete_04");
        if (!isPermission) {
            throw new SAException(SAException.NOT_DELETE_PERMISSION, new Object[]{info.getReportOrg().getName()});
        }
        if (info.getBillStatus() != BillStatusEnum.SAVE && info.getBillStatus() != BillStatusEnum.SUBMIT) {
            throw new SAException(SAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"Status_Not_Delete")});
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_largeDetailBill_delete");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        super._delete(ctx, pk);
    }

    @Override
    protected void _confirm(Context ctx, String id) throws BOSException, EASBizException {
        LargeDetailBillInfo info = this.getLargeDetailBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        if (info.getBillStatus() != BillStatusEnum.SUBMIT) {
            throw new SAException(SAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"Status_Not_Confirm")});
        }
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        Integer status = new Integer(3);
        String sql = "UPDATE T_SA_LargeDetailBill SET FBillStatus = ? , FLastUpdateUserID=? , FLastUpdateTime=?  WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{status, userInfo.getId().toString(), currTime, id});
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_largeDetailBill_confirm");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _unConfirm(Context ctx, String id) throws BOSException, EASBizException {
        LargeDetailBillInfo info = this.getLargeDetailBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        if (info.getBillStatus() != BillStatusEnum.CONFIRMED) {
            throw new SAException(SAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"Status_Not_UnConfirm")});
        }
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        Integer status = new Integer(2);
        String sql = "UPDATE T_SA_LargeDetailBill SET FBillStatus = ? , FLastUpdateUserID=? , FLastUpdateTime=?  WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{status, userInfo.getId().toString(), currTime, id});
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_largeDetailBill_unConfirm");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    public FilterInfo getCheckNumberDupFilter(LargeDetailBillInfo info, boolean addnew) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        filter.getFilterItems().add(new FilterItemInfo("reportOrg.id", (Object)info.getReportOrg().getId()));
        if (!addnew) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        }
        return filter;
    }
}

