/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.sa.BillState;
import com.kingdee.eas.fm.sa.BillStatusEnum;
import com.kingdee.eas.fm.sa.ILargeDetailBill;
import com.kingdee.eas.fm.sa.LargeDetailBillCollection;
import com.kingdee.eas.fm.sa.LargeDetailBillInfo;
import com.kingdee.eas.fm.sa.LargeDetailMergeBillFactory;
import com.kingdee.eas.fm.sa.LargeDetailMergeBillInfo;
import com.kingdee.eas.fm.sa.ReportContentEnum;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryOrgInfo;
import com.kingdee.eas.fm.sa.ReportOrgSolutionSettingInfo;
import com.kingdee.eas.fm.sa.SAException;
import com.kingdee.eas.fm.sa.app.AbstractLargeDetailMergeBillControllerBean;
import com.kingdee.eas.fm.sa.app.util.ThreadLocalDateUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class LargeDetailMergeBillControllerBean
extends AbstractLargeDetailMergeBillControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)LargeDetailMergeBillControllerBean.class.getName());

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LargeDetailMergeBillInfo info = (LargeDetailMergeBillInfo)model;
        if (EmptyUtil.isEmpty((String)info.getNumber()) && FMHelper.hasNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getReportCompany().getId().toString())) {
            try {
                info.setNumber(FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getReportCompany().getId().toString()));
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                info.setNumber(this.getDefaultNumber(info));
            }
        } else {
            info.setNumber(this.getDefaultNumber(info));
        }
        return super._addnew(ctx, (IObjectValue)info);
    }

    private String getDefaultNumber(LargeDetailMergeBillInfo info) {
        String number = "DESB-";
        java.util.Date payDate = info.getBizDate();
        number = number + ThreadLocalDateUtil.formatDate(payDate);
        number = number + "-" + beServiceHelper.getSerialNumber((int)1)[0].substring(10, 17);
        return number;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LargeDetailMergeBillInfo info = (LargeDetailMergeBillInfo)model;
        if (!info.getState().equals((Object)BillState.SAVED) && !info.getState().equals((Object)BillState.SUBMIT)) {
            throw new SAException(SAException.NOT_ALLOW_SAVE);
        }
        boolean isNeedDispose = false;
        HashSet<String> ids = new HashSet<String>();
        if (!info.getState().equals((Object)BillState.SUBMIT)) {
            BigDecimal LargeTotalAmt = info.getLargeTotalAmt();
            BigDecimal largeDetailTotalAmt = Constants.ZERO;
            try {
                StringBuffer sb = new StringBuffer();
                sb.append("select FID, FAMOUNT from T_SA_LargeDetailBill where FREPORTORGID = ? and FPAYDATE = ?");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{info.getReportCompany().getId().toString(), info.getBizDate()});
                while (rs.next()) {
                    if (EmptyUtil.isEmpty((Object)rs.getBigDecimal("FAMOUNT"))) continue;
                    largeDetailTotalAmt = largeDetailTotalAmt.add(rs.getBigDecimal("FAMOUNT"));
                    if (EmptyUtil.isEmpty((String)rs.getString("FID"))) continue;
                    ids.add(rs.getString("FID"));
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            if (!LargeTotalAmt.equals(largeDetailTotalAmt)) {
                throw new SAException(SAException.SUBMIT_CHECK_CACULATE);
            }
            info.setState(BillState.SUBMIT);
            info.setLargeTotalAmt(LargeTotalAmt);
            info.setLargeTotalCount(ids.size());
            isNeedDispose = true;
        } else {
            isNeedDispose = false;
        }
        IObjectPK pk = super._submit(ctx, (IObjectValue)info);
        if (isNeedDispose) {
            this.disposeLargeDetailInfo(ctx, ids, info);
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_largeDetailMergeBill_submit");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return pk;
    }

    @Override
    protected void _caculate(Context ctx, LargeDetailMergeBillInfo info) throws BOSException, EASBizException {
        if (!info.getState().equals((Object)BillState.SAVED)) {
            throw new SAException(SAException.NOT_ALLOW_CACULATE);
        }
        BigDecimal largeDetailTotalAmt = Constants.ZERO;
        HashSet<String> ids = new HashSet<String>();
        HashSet<String> completedIds = new HashSet<String>();
        try {
            String stateSql = "select FID, FAMOUNT, FBILLSTATUS from T_SA_LargeDetailBill where FREPORTORGID = ? and FPAYDATE = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)stateSql, (Object[])new Object[]{info.getReportCompany().getId().toString(), info.getBizDate()});
            while (rs.next()) {
                String id;
                if (!EmptyUtil.isEmpty((Object)rs.getInt("FBILLSTATUS")) && 3 == rs.getInt("FBILLSTATUS")) {
                    if (!EmptyUtil.isEmpty((String)rs.getString("FID"))) {
                        id = rs.getString("FID");
                        ids.add(id);
                        completedIds.add(id);
                    }
                } else if (!EmptyUtil.isEmpty((String)rs.getString("FID"))) {
                    id = rs.getString("FID");
                    ids.add(id);
                }
                if (EmptyUtil.isEmpty((Object)rs.getBigDecimal("FAMOUNT"))) continue;
                largeDetailTotalAmt = largeDetailTotalAmt.add(rs.getBigDecimal("FAMOUNT"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (ids.size() != completedIds.size()) {
            throw new SAException(SAException.RECACULATE_CHECK_CACULATE);
        }
        info.setAmount(this.parseLargeTotalAmount(ctx, info.getReportCompany(), info.getBizDate()));
        info.setLargeTotalAmt(largeDetailTotalAmt);
        info.setLargeTotalCount(completedIds.size());
        info.setState(BillState.SUBMIT);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("amount"));
        selector.add(new SelectorItemInfo("largeTotalAmt"));
        selector.add(new SelectorItemInfo("largeTotalCount"));
        selector.add(new SelectorItemInfo("state"));
        LargeDetailMergeBillFactory.getLocalInstance(ctx).updatePartial(info, selector);
        this.disposeLargeDetailInfo(ctx, completedIds, info);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_largeDetailMergeBill_caculate");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    protected BigDecimal parseLargeTotalAmount(Context ctx, CompanyOrgUnitInfo companyInfo, java.util.Date payDate) {
        BigDecimal amount = Constants.ZERO;
        try {
            String sql = "select sum(FDebitAmount) AS FTotalAmount from T_BE_TransDetail where FCOMPANYID = ? and FBIZDATE = ? and FDebitAmount > 0";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{companyInfo.getId().toString(), new Date(payDate.getTime())});
            if (rs.next() && !EmptyUtil.isEmpty((Object)rs.getBigDecimal("FTotalAmount"))) {
                amount = rs.getBigDecimal("FTotalAmount");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return amount;
    }

    private void disposeLargeDetailInfo(Context ctx, Set<String> ids, LargeDetailMergeBillInfo info) throws BOSException {
        if (ids.isEmpty()) {
            return;
        }
        try {
            String sql = "update T_SA_LargeDetailBill set FBILLSTATUS = ?, FMergeBillNumber = ? where FID in " + FMHelper.setTran2String(ids);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{4, info.getSerialId()});
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _cancel(Context ctx, LargeDetailMergeBillInfo info) throws BOSException, EASBizException {
        if (!info.getState().equals((Object)BillState.SUBMIT)) {
            throw new SAException(SAException.NOT_ALLOW_CANCEL);
        }
        info.setState(BillState.SAVED);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("state"));
        LargeDetailMergeBillFactory.getLocalInstance(ctx).updatePartial(info, selector);
        StringBuffer sb = new StringBuffer();
        sb.append("update T_SA_LargeDetailBill set FBillStatus = ?, FMergeBillNumber = null where FMergeBillNumber = ?");
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{3, info.getSerialId()});
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_largeDetailMergeBill_cancel");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _genLargeDetailMergeBill(Context ctx, ReportOrgSolutionSettingInfo info, ReportOrgSSEntryOrgInfo orgSSEntryInfo, java.util.Date payDate, ILargeDetailBill iLargeDetailBill) throws BOSException, EASBizException {
        HashSet<String> detailIds = new HashSet<String>();
        FilterInfo detailMergeFilter = new FilterInfo();
        detailMergeFilter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)payDate, CompareType.EQUALS));
        detailMergeFilter.getFilterItems().add(new FilterItemInfo("reportCompany.id", (Object)orgSSEntryInfo.getReportOrg().getId().toString(), CompareType.EQUALS));
        if (super.exists(ctx, detailMergeFilter)) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        FilterInfo filter = new FilterInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        sic.add(new SelectorItemInfo("*"));
        filter.getFilterItems().add(new FilterItemInfo("payDate", (Object)payDate, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("reportOrg.id", (Object)orgSSEntryInfo.getReportOrg().getId().toString(), CompareType.EQUALS));
        LargeDetailBillCollection detailCols = iLargeDetailBill.getLargeDetailBillCollection(view);
        LargeDetailMergeBillInfo detailMergeInfo = new LargeDetailMergeBillInfo();
        if (EmptyUtil.isEmpty((Object)detailMergeInfo.getId())) {
            detailMergeInfo.setId(BOSUuid.create((BOSObjectType)detailMergeInfo.getBOSType()));
        }
        detailMergeInfo.setReportCompany(orgSSEntryInfo.getReportOrg());
        detailMergeInfo.setFillInCompany(info.getFillInOrgUnit());
        detailMergeInfo.setReportContect(ReportContentEnum.USE_OF_LARGE_FUNDS);
        detailMergeInfo.setSerialId(detailMergeInfo.getId().toString());
        detailMergeInfo.setBizDate(payDate);
        detailMergeInfo.setReportOrgSolution(info);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)detailCols)) {
            BigDecimal largeTotalAmt = Constants.ZERO;
            int largeTotalCount = 0;
            LargeDetailBillCollection completedDetailCols = new LargeDetailBillCollection();
            for (int index = 0; index < detailCols.size(); ++index) {
                LargeDetailBillInfo detailInfo = detailCols.get(index);
                if (!BillStatusEnum.CONFIRMED.equals((Object)detailInfo.getBillStatus())) continue;
                largeTotalAmt = largeTotalAmt.add(detailInfo.getAmount());
                completedDetailCols.add(detailInfo);
                ++largeTotalCount;
                detailIds.add(detailInfo.getId().toString());
            }
            detailMergeInfo.setLargeTotalAmt(largeTotalAmt);
            detailMergeInfo.setLargeTotalCount(largeTotalCount);
            if (detailCols.size() == completedDetailCols.size()) {
                detailMergeInfo.setState(BillState.SUBMIT);
            } else {
                detailMergeInfo.setState(BillState.SAVED);
            }
        } else {
            detailMergeInfo.setLargeTotalAmt(Constants.ZERO);
            detailMergeInfo.setLargeTotalCount(0);
            detailMergeInfo.setState(BillState.SAVED);
        }
        detailMergeInfo.setAmount(this.parseLargeTotalAmount(ctx, orgSSEntryInfo.getReportOrg(), payDate));
        this._addnew(ctx, (IObjectValue)detailMergeInfo);
        if (BillState.SUBMIT.equals((Object)detailMergeInfo.getState())) {
            this.disposeLargeDetailInfo(ctx, detailIds, detailMergeInfo);
        }
    }
}

