/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.sa.ReportContentEnum;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryContentCollection;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryContentInfo;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryOrgCollection;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryOrgInfo;
import com.kingdee.eas.fm.sa.ReportOrgSolutionSettingCollection;
import com.kingdee.eas.fm.sa.ReportOrgSolutionSettingFactory;
import com.kingdee.eas.fm.sa.ReportOrgSolutionSettingInfo;
import com.kingdee.eas.fm.sa.app.AbstractLargeFundOutFlowFacadeControllerBean;
import com.kingdee.eas.fm.sa.app.handler.DetailMergeBillHandlerFacatory;
import com.kingdee.eas.fm.sa.app.handler.IDetailMergeHandler;
import com.kingdee.eas.fm.sa.app.handler.ITotalHandler;
import com.kingdee.eas.fm.sa.app.handler.TotalBillHandlerFacatory;
import com.kingdee.eas.fm.sa.app.service.AutoReportServiceFacatory;
import com.kingdee.eas.fm.sa.app.service.IAutoReportService;
import com.kingdee.eas.fm.sa.app.util.SAConstants;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LargeFundOutFlowFacadeControllerBean
extends AbstractLargeFundOutFlowFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)LargeFundOutFlowFacadeControllerBean.class.getName());
    private Map<String, ReportOrgSolutionSettingInfo> com_orgSolutionMap = new HashMap<String, ReportOrgSolutionSettingInfo>();
    private Map<ReportContentEnum, ReportOrgSSEntryOrgCollection> reportEnum_orgSSEntryColMap = new HashMap<ReportContentEnum, ReportOrgSSEntryOrgCollection>();
    private Map<ReportContentEnum, ReportOrgSolutionSettingCollection> reportEnum_reportOrgSolutionColMap = new HashMap<ReportContentEnum, ReportOrgSolutionSettingCollection>();
    private Map<String, String> solutionEnum_personMap = new HashMap<String, String>();

    @Override
    protected void _Sum(Context ctx, String retraceDays, int reportContect) throws BOSException, EASBizException {
        IDetailMergeHandler largeDetailMergeHandler;
        Date payDate = this.getPayDate(retraceDays);
        ReportOrgSolutionSettingCollection reportOrgSolutionCol = this.getEnableReportOrgSolutionSettingCollection(ctx);
        this.initReportCompanySolution(reportOrgSolutionCol);
        ReportContentEnum reportContentEnum = ReportContentEnum.USE_OF_LARGE_FUNDS;
        if (reportContect == 1 || reportContect == 3) {
            reportContentEnum = ReportContentEnum.getEnum(reportContect);
        }
        if ((largeDetailMergeHandler = DetailMergeBillHandlerFacatory.getInstance(reportContentEnum)) != null) {
            largeDetailMergeHandler.dealDetailMergeBillHandler(ctx, payDate, this.reportEnum_orgSSEntryColMap, this.com_orgSolutionMap);
        } else {
            logger.error((Object)"LargeFundOutFlowFacadeControllerBean._Sum\u6ca1\u6709\u5bf9\u5e94\u5904\u7406\u7c7b\uff0c\u8bf7\u914d\u7f6e\u76f8\u5173\u7684\u5904\u7406\u7c7b");
        }
    }

    private void initReportCompanySolution(ReportOrgSolutionSettingCollection reportOrgSolutionCol) {
        for (int index = 0; index < reportOrgSolutionCol.size(); ++index) {
            int i;
            ReportOrgSolutionSettingInfo info = reportOrgSolutionCol.get(index);
            ReportOrgSSEntryOrgCollection orgSSEntryCol = info.getReportOrgEntrys();
            ReportOrgSSEntryContentCollection conSSEntryCol = info.getReportContentEntrys();
            for (i = 0; i < conSSEntryCol.size(); ++i) {
                ReportOrgSSEntryOrgCollection orgEntryCol;
                ReportContentEnum reportContentEnum = conSSEntryCol.get(i).getReportContentEnum();
                if (!this.reportEnum_orgSSEntryColMap.containsKey((Object)reportContentEnum)) {
                    orgEntryCol = new ReportOrgSSEntryOrgCollection();
                    orgEntryCol.addCollection(orgSSEntryCol);
                    this.reportEnum_orgSSEntryColMap.put(reportContentEnum, orgEntryCol);
                    continue;
                }
                orgEntryCol = this.reportEnum_orgSSEntryColMap.get((Object)reportContentEnum);
                orgEntryCol.addCollection(orgSSEntryCol);
            }
            for (i = 0; i < orgSSEntryCol.size(); ++i) {
                ReportOrgSSEntryOrgInfo orgSSEntryInfo = orgSSEntryCol.get(i);
                if (!this.com_orgSolutionMap.containsKey(orgSSEntryInfo.getReportOrg().getId().toString())) {
                    this.com_orgSolutionMap.put(orgSSEntryInfo.getReportOrg().getId().toString(), info);
                    continue;
                }
                logger.error((Object)("\u4e0a\u62a5\u65b9\u6848\u8bbe\u7f6e\u4e2d\u7684\u4e0a\u62a5\u4fe1\u606f\u5b58\u5728\u76f8\u540c\u7684\u4e0a\u62a5\u7ec4\u7ec7\uff0c\u5bf9\u5e94\u7ec4\u7ec7\u540d\u79f0\u4e3a\uff1a" + orgSSEntryInfo.getReportOrg().getName() + ", \u5bf9\u5e94\u7ec4\u7ec7ID\u4e3a\uff1a" + orgSSEntryInfo.getReportOrg().getId().toString()));
            }
        }
    }

    @Override
    protected void _SumReport(Context ctx, String retraceDays, int reportContect) throws BOSException, EASBizException {
        ITotalHandler largeTotalBillHandler;
        Date payDate = this.getPayDate(retraceDays);
        ReportOrgSolutionSettingCollection reportOrgSolutionCol = this.getEnableReportOrgSolutionSettingCollection(ctx);
        this.initFillCompanySolution(reportOrgSolutionCol);
        ReportContentEnum reportContentEnum = ReportContentEnum.USE_OF_LARGE_FUNDS;
        if (reportContect == 1 || reportContect == 3) {
            reportContentEnum = ReportContentEnum.getEnum(reportContect);
        }
        if ((largeTotalBillHandler = TotalBillHandlerFacatory.getInstance(reportContentEnum)) != null) {
            largeTotalBillHandler.dealTotalBillHandler(ctx, payDate, reportOrgSolutionCol, this.reportEnum_reportOrgSolutionColMap, this.solutionEnum_personMap);
        } else {
            logger.error((Object)"LargeFundOutFlowFacadeControllerBean._SumReport\u6ca1\u6709\u5bf9\u5e94\u5904\u7406\u7c7b\uff0c\u8bf7\u914d\u7f6e\u76f8\u5173\u7684\u5904\u7406\u7c7b");
        }
    }

    @Override
    protected void _FundAutoReport(Context ctx, String retraceDays, int reportContect) throws BOSException, EASBizException {
        IAutoReportService autoReportService;
        Date payDate = this.getPayDate(retraceDays, reportContect);
        ReportOrgSolutionSettingCollection reportOrgSolutionCol = this.getEnableReportOrgSolutionSettingCollection(ctx);
        this.initFillCompanySolution(reportOrgSolutionCol);
        ReportContentEnum reportContentEnum = ReportContentEnum.USE_OF_LARGE_FUNDS;
        if (reportContect == 1 || reportContect == 2 || reportContect == 3 || reportContect == 4) {
            reportContentEnum = ReportContentEnum.getEnum(reportContect);
        }
        if ((autoReportService = AutoReportServiceFacatory.getInstance(reportContentEnum)) != null) {
            autoReportService.dealAutoReport(ctx, payDate, reportOrgSolutionCol, this.reportEnum_reportOrgSolutionColMap, this.solutionEnum_personMap);
        } else {
            logger.error((Object)"LargeFundOutFlowFacadeControllerBean._FundAutoReport \u6ca1\u6709\u5bf9\u5e94\u670d\u52a1\u7c7b\uff0c\u8bf7\u914d\u7f6e\u76f8\u5173\u7684\u670d\u52a1\u7c7b");
        }
    }

    private void initFillCompanySolution(ReportOrgSolutionSettingCollection reportOrgSolutionCol) {
        for (int index = 0; index < reportOrgSolutionCol.size(); ++index) {
            int i;
            ReportOrgSolutionSettingInfo info = reportOrgSolutionCol.get(index);
            ReportOrgSSEntryOrgCollection orgSSEntryCol = info.getReportOrgEntrys();
            ReportOrgSSEntryContentCollection conSSEntryCol = info.getReportContentEntrys();
            for (i = 0; i < conSSEntryCol.size(); ++i) {
                ReportOrgSolutionSettingCollection solutionCol;
                ReportOrgSSEntryContentInfo entryIfno = conSSEntryCol.get(i);
                ReportContentEnum reportContentEnum = entryIfno.getReportContentEnum();
                String person = entryIfno.getFillInPerson();
                String key = SAConstants.getSolutionEnum2personMapKey(info, reportContentEnum);
                if (!this.solutionEnum_personMap.containsKey(key)) {
                    this.solutionEnum_personMap.put(key, person);
                }
                if (!this.reportEnum_reportOrgSolutionColMap.containsKey((Object)reportContentEnum)) {
                    solutionCol = new ReportOrgSolutionSettingCollection();
                    solutionCol.add(info);
                    this.reportEnum_reportOrgSolutionColMap.put(reportContentEnum, solutionCol);
                    continue;
                }
                solutionCol = this.reportEnum_reportOrgSolutionColMap.get((Object)reportContentEnum);
                solutionCol.add(info);
            }
            for (i = 0; i < orgSSEntryCol.size(); ++i) {
                ReportOrgSSEntryOrgInfo orgSSEntryInfo = orgSSEntryCol.get(i);
                if (!this.com_orgSolutionMap.containsKey(orgSSEntryInfo.getReportOrg().getId().toString())) {
                    this.com_orgSolutionMap.put(orgSSEntryInfo.getReportOrg().getId().toString(), info);
                    continue;
                }
                logger.error((Object)("\u4e0a\u62a5\u65b9\u6848\u8bbe\u7f6e\u4e2d\u7684\u4e0a\u62a5\u4fe1\u606f\u5b58\u5728\u76f8\u540c\u7684\u4e0a\u62a5\u7ec4\u7ec7\uff0c\u5bf9\u5e94\u7ec4\u7ec7\u540d\u79f0\u4e3a\uff1a" + orgSSEntryInfo.getReportOrg().getName() + ", \u5bf9\u5e94\u7ec4\u7ec7ID\u4e3a\uff1a" + orgSSEntryInfo.getReportOrg().getId().toString()));
            }
        }
    }

    private Date getPayDate(String retraceDays) {
        Date endDate = DateUtil.getDayBegin();
        int d = !EmptyUtil.isEmpty((String)retraceDays) ? Integer.parseInt(retraceDays) : 1;
        if (d < 1) {
            d = 1;
        }
        if (d > 10) {
            d = 10;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(endDate);
        ((Calendar)cal).add(5, -d);
        Date beginDate = cal.getTime();
        return beginDate;
    }

    private Date getPayDate(String retraceDays, int reportContect) {
        int d;
        Date endDate = DateUtil.getDayBegin();
        if (reportContect == 4) {
            d = !EmptyUtil.isEmpty((String)retraceDays) ? Integer.parseInt(retraceDays) : 0;
            if (d < 0) {
                d = 0;
            }
            if (d > 10) {
                d = 10;
            }
        } else {
            d = !EmptyUtil.isEmpty((String)retraceDays) ? Integer.parseInt(retraceDays) : 1;
            if (d < 1) {
                d = 1;
            }
            if (d > 100) {
                d = 100;
            }
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(endDate);
        ((Calendar)cal).add(5, -d);
        Date beginDate = cal.getTime();
        return beginDate;
    }

    private ReportOrgSolutionSettingCollection getEnableReportOrgSolutionSettingCollection(Context ctx) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        FilterInfo filter = new FilterInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("fillInOrgUnit.id"));
        sic.add(new SelectorItemInfo("fillInOrgUnit.name"));
        sic.add(new SelectorItemInfo("fillInOrgUnit.number"));
        sic.add(new SelectorItemInfo("fillInOrgGroup.id"));
        sic.add(new SelectorItemInfo("fillInOrgGroup.name"));
        sic.add(new SelectorItemInfo("fillInOrgGroup.number"));
        sic.add(new SelectorItemInfo("fillInOrgUnitName"));
        sic.add(new SelectorItemInfo("fillInOrgUnitCode"));
        sic.add(new SelectorItemInfo("fillInOrgGroupName"));
        sic.add(new SelectorItemInfo("fillInOrgGroupCode"));
        sic.add(new SelectorItemInfo("reportOrgEntrys.id"));
        sic.add(new SelectorItemInfo("reportOrgEntrys.reportOrgNumber"));
        sic.add(new SelectorItemInfo("reportOrgEntrys.reportOrgCode"));
        sic.add(new SelectorItemInfo("reportOrgEntrys.reportOrg.id"));
        sic.add(new SelectorItemInfo("reportOrgEntrys.reportOrg.name"));
        sic.add(new SelectorItemInfo("reportOrgEntrys.reportOrg.number"));
        sic.add(new SelectorItemInfo("reportContentEntrys.id"));
        sic.add(new SelectorItemInfo("reportContentEntrys.reportContentEnum"));
        sic.add(new SelectorItemInfo("reportContentEntrys.fillInPerson"));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        ReportOrgSolutionSettingCollection col = ReportOrgSolutionSettingFactory.getLocalInstance(ctx).getReportOrgSolutionSettingCollection(view);
        return col;
    }
}

