/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.sa.BillState;
import com.kingdee.eas.fm.sa.BillStatusEnum;
import com.kingdee.eas.fm.sa.DebtDetailBillCollection;
import com.kingdee.eas.fm.sa.DebtDetailBillInfo;
import com.kingdee.eas.fm.sa.IDebtDetailBill;
import com.kingdee.eas.fm.sa.MaturedDebtDetailMergeBillFactory;
import com.kingdee.eas.fm.sa.MaturedDebtDetailMergeBillInfo;
import com.kingdee.eas.fm.sa.ReportContentEnum;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryOrgInfo;
import com.kingdee.eas.fm.sa.ReportOrgSolutionSettingInfo;
import com.kingdee.eas.fm.sa.SAException;
import com.kingdee.eas.fm.sa.app.AbstractMaturedDebtDetailMergeBillControllerBean;
import com.kingdee.eas.fm.sa.app.util.DateUtils;
import com.kingdee.eas.fm.sa.app.util.ThreadLocalDateUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class MaturedDebtDetailMergeBillControllerBean
extends AbstractMaturedDebtDetailMergeBillControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.sa.app.MaturedDebtDetailMergeBillControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaturedDebtDetailMergeBillInfo info = (MaturedDebtDetailMergeBillInfo)model;
        if (EmptyUtil.isEmpty((String)info.getNumber()) && FMHelper.hasNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getReportCompany().getId().toString())) {
            try {
                info.setNumber(FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getReportCompany().getId().toString()));
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                info.setNumber(this.getDefaultNumber(info));
            }
        } else {
            info.setNumber(this.getDefaultNumber(info));
        }
        return super._addnew(ctx, (IObjectValue)info);
    }

    private String getDefaultNumber(MaturedDebtDetailMergeBillInfo info) {
        String number = "MDRP-";
        Date payDate = info.getBeginDate();
        number = number + ThreadLocalDateUtil.formatDate(payDate);
        number = number + "-" + beServiceHelper.getSerialNumber((int)1)[0].substring(10, 17);
        return number;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaturedDebtDetailMergeBillInfo info = (MaturedDebtDetailMergeBillInfo)model;
        if (!info.getState().equals((Object)BillState.SAVED) && !info.getState().equals((Object)BillState.SUBMIT)) {
            throw new SAException(SAException.NOT_ALLOW_SAVE);
        }
        boolean isNeedDispose = false;
        HashSet<String> ids = new HashSet<String>();
        HashSet<String> completedIds = new HashSet<String>();
        int totalCount = 0;
        BigDecimal maturedAmt = new BigDecimal(0);
        BigDecimal maturedMonAmt = new BigDecimal(0);
        if (!info.getState().equals((Object)BillState.SUBMIT)) {
            try {
                String stateSql = "select FID, FBILLSTATUS, FDebtPrinAmt, FDueAmtMonth from T_SA_DebtDetailBill where FREPORTORGID = ? and FStartDate = ?";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)stateSql, (Object[])new Object[]{info.getReportCompany().getId().toString(), info.getBeginDate()});
                while (rs.next()) {
                    String id;
                    if (!EmptyUtil.isEmpty((Object)rs.getInt("FBILLSTATUS")) && 3 == rs.getInt("FBILLSTATUS")) {
                        if (!EmptyUtil.isEmpty((String)rs.getString("FID"))) {
                            id = rs.getString("FID");
                            ids.add(id);
                            completedIds.add(id);
                        }
                        if (!EmptyUtil.isEmpty((Object)rs.getBigDecimal("FDebtPrinAmt"))) {
                            BigDecimal debtPrinAmt = rs.getBigDecimal("FDebtPrinAmt");
                            maturedAmt = maturedAmt.add(debtPrinAmt);
                        }
                        if (!EmptyUtil.isEmpty((Object)rs.getBigDecimal("FDueAmtMonth"))) {
                            BigDecimal dueAmtMonth = rs.getBigDecimal("FDueAmtMonth");
                            maturedMonAmt = maturedMonAmt.add(dueAmtMonth);
                        }
                        ++totalCount;
                        continue;
                    }
                    if (EmptyUtil.isEmpty((String)rs.getString("FID"))) continue;
                    id = rs.getString("FID");
                    ids.add(id);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            if (ids.size() != completedIds.size()) {
                throw new SAException(SAException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"120_MaturedDebtDetailMergeBillControllerBean", (Locale)ctx.getLocale())});
            }
            isNeedDispose = true;
        }
        info.setTotalCount(totalCount);
        info.setMaturedAmt(maturedAmt);
        info.setMaturedMonAmt(maturedMonAmt);
        info.setState(BillState.SUBMIT);
        IObjectPK pk = super._submit(ctx, (IObjectValue)info);
        if (isNeedDispose) {
            this.disposeMaturedDebtDetailInfo(ctx, ids, info);
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_maturedDetailMergeBill_submit");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return pk;
    }

    @Override
    protected void _caculate(Context ctx, MaturedDebtDetailMergeBillInfo info) throws BOSException, EASBizException {
        if (!info.getState().equals((Object)BillState.SAVED)) {
            throw new SAException(SAException.NOT_ALLOW_CACULATE);
        }
        HashSet<String> ids = new HashSet<String>();
        HashSet<String> completedIds = new HashSet<String>();
        int totalCount = 0;
        BigDecimal maturedAmt = new BigDecimal(0);
        BigDecimal maturedMonAmt = new BigDecimal(0);
        try {
            String stateSql = "select FID, FBILLSTATUS, FDebtPrinAmt, FDueAmtMonth from T_SA_DebtDetailBill where FREPORTORGID = ? and FStartDate = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)stateSql, (Object[])new Object[]{info.getReportCompany().getId().toString(), info.getBeginDate()});
            while (rs.next()) {
                String id;
                if (!EmptyUtil.isEmpty((Object)rs.getInt("FBILLSTATUS")) && 3 == rs.getInt("FBILLSTATUS")) {
                    if (!EmptyUtil.isEmpty((String)rs.getString("FID"))) {
                        id = rs.getString("FID");
                        ids.add(id);
                        completedIds.add(id);
                    }
                    if (!EmptyUtil.isEmpty((Object)rs.getBigDecimal("FDebtPrinAmt"))) {
                        BigDecimal debtPrinAmt = rs.getBigDecimal("FDebtPrinAmt");
                        maturedAmt = maturedAmt.add(debtPrinAmt);
                    }
                    if (!EmptyUtil.isEmpty((Object)rs.getBigDecimal("FDueAmtMonth"))) {
                        BigDecimal dueAmtMonth = rs.getBigDecimal("FDueAmtMonth");
                        maturedMonAmt = maturedMonAmt.add(dueAmtMonth);
                    }
                    ++totalCount;
                    continue;
                }
                if (EmptyUtil.isEmpty((String)rs.getString("FID"))) continue;
                id = rs.getString("FID");
                ids.add(id);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (ids.size() != completedIds.size()) {
            throw new SAException(SAException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"121_MaturedDebtDetailMergeBillControllerBean", (Locale)ctx.getLocale())});
        }
        info.setState(BillState.SUBMIT);
        info.setTotalCount(totalCount);
        info.setMaturedAmt(maturedAmt);
        info.setMaturedMonAmt(maturedMonAmt);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("totalCount"));
        selector.add(new SelectorItemInfo("maturedAmt"));
        selector.add(new SelectorItemInfo("maturedMonAmt"));
        MaturedDebtDetailMergeBillFactory.getLocalInstance(ctx).updatePartial(info, selector);
        this.disposeMaturedDebtDetailInfo(ctx, completedIds, info);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_maturedDetailMergeBill_caculate");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    private void disposeMaturedDebtDetailInfo(Context ctx, Set<String> ids, MaturedDebtDetailMergeBillInfo info) throws BOSException {
        if (ids.isEmpty()) {
            return;
        }
        try {
            String sql = "update T_SA_DebtDetailBill set FBILLSTATUS = ?, FMergeBillNumber = ? where FID in " + FMHelper.setTran2String(ids);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{4, info.getSerialId()});
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _cancel(Context ctx, MaturedDebtDetailMergeBillInfo info) throws BOSException, EASBizException {
        if (!info.getState().equals((Object)BillState.SUBMIT)) {
            throw new SAException(SAException.NOT_ALLOW_CANCEL);
        }
        info.setState(BillState.SAVED);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("state"));
        MaturedDebtDetailMergeBillFactory.getLocalInstance(ctx).updatePartial(info, selector);
        StringBuffer sb = new StringBuffer();
        sb.append("update T_SA_DebtDetailBill set FBillStatus = ?, FMergeBillNumber = null where FMergeBillNumber = ?");
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{3, info.getSerialId()});
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_maturedDetailMergeBill_cancel");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _genMaturedDebtDetailMergeBill(Context ctx, ReportOrgSolutionSettingInfo info, ReportOrgSSEntryOrgInfo orgSSEntryInfo, Date payDate, IDebtDetailBill iDebtDetailBill) throws BOSException, EASBizException {
        HashSet<String> detailIds = new HashSet<String>();
        FilterInfo detailMergeFilter = new FilterInfo();
        detailMergeFilter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)DateUtils.getMonthOfFirstDay(payDate), CompareType.EQUALS));
        detailMergeFilter.getFilterItems().add(new FilterItemInfo("reportCompany.id", (Object)orgSSEntryInfo.getReportOrg().getId().toString(), CompareType.EQUALS));
        if (super.exists(ctx, detailMergeFilter)) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        FilterInfo filter = new FilterInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        sic.add(new SelectorItemInfo("*"));
        filter.getFilterItems().add(new FilterItemInfo("startDate", (Object)DateUtils.getMonthOfFirstDay(payDate), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("reportOrg.id", (Object)orgSSEntryInfo.getReportOrg().getId().toString(), CompareType.EQUALS));
        DebtDetailBillCollection detailCols = iDebtDetailBill.getDebtDetailBillCollection(view);
        MaturedDebtDetailMergeBillInfo detailMergeInfo = new MaturedDebtDetailMergeBillInfo();
        if (EmptyUtil.isEmpty((Object)detailMergeInfo.getId())) {
            detailMergeInfo.setId(BOSUuid.create((BOSObjectType)detailMergeInfo.getBOSType()));
        }
        detailMergeInfo.setReportCompany(orgSSEntryInfo.getReportOrg());
        detailMergeInfo.setFillInCompany(info.getFillInOrgUnit());
        detailMergeInfo.setReportContect(ReportContentEnum.MATURECLAIM_AND_REPAYPLAN);
        detailMergeInfo.setSerialId(detailMergeInfo.getId().toString());
        detailMergeInfo.setReportOrgSolution(info);
        detailMergeInfo.setBeginDate(DateUtils.getMonthOfFirstDay(payDate));
        detailMergeInfo.setEndDate(DateUtils.getMonthOfLastDay(payDate));
        int totalCount = 0;
        BigDecimal maturedAmt = new BigDecimal(0);
        BigDecimal maturedMonAmt = new BigDecimal(0);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)detailCols)) {
            DebtDetailBillCollection completedDetailCols = new DebtDetailBillCollection();
            for (int index = 0; index < detailCols.size(); ++index) {
                DebtDetailBillInfo detailInfo = detailCols.get(index);
                if (!BillStatusEnum.CONFIRMED.equals((Object)detailInfo.getBillStatus())) continue;
                completedDetailCols.add(detailInfo);
                detailIds.add(detailInfo.getId().toString());
                ++totalCount;
                maturedAmt = maturedAmt.add(detailInfo.getDebtPrinAmt());
                maturedMonAmt = maturedMonAmt.add(detailInfo.getDueAmtMonth());
            }
            if (detailCols.size() == completedDetailCols.size()) {
                detailMergeInfo.setState(BillState.SUBMIT);
            } else {
                detailMergeInfo.setState(BillState.SAVED);
            }
        } else {
            detailMergeInfo.setState(BillState.SUBMIT);
        }
        detailMergeInfo.setTotalCount(totalCount);
        detailMergeInfo.setMaturedAmt(maturedAmt);
        detailMergeInfo.setMaturedMonAmt(maturedMonAmt);
        this._addnew(ctx, (IObjectValue)detailMergeInfo);
        if (BillState.SUBMIT.equals((Object)detailMergeInfo.getState())) {
            this.disposeMaturedDebtDetailInfo(ctx, detailIds, detailMergeInfo);
        }
    }
}

