/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.sa.BillState;
import com.kingdee.eas.fm.sa.IMaturedDebtDetailMergeBill;
import com.kingdee.eas.fm.sa.MaturedDebtDetailMergeBillCollection;
import com.kingdee.eas.fm.sa.MaturedDebtDetailMergeBillFactory;
import com.kingdee.eas.fm.sa.MaturedDebtDetailMergeBillInfo;
import com.kingdee.eas.fm.sa.MaturedDebtTotalBillFactory;
import com.kingdee.eas.fm.sa.MaturedDebtTotalBillInfo;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryOrgCollection;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryOrgFactory;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryOrgInfo;
import com.kingdee.eas.fm.sa.ReportOrgSolutionSettingInfo;
import com.kingdee.eas.fm.sa.SAException;
import com.kingdee.eas.fm.sa.app.AbstractMaturedDebtTotalBillControllerBean;
import com.kingdee.eas.fm.sa.app.service.ILargeTotalCancelReportService;
import com.kingdee.eas.fm.sa.app.service.ILargeTotalReportService;
import com.kingdee.eas.fm.sa.app.service.LargeTotalCancelReportServiceFactory;
import com.kingdee.eas.fm.sa.app.service.LargeTotalReportServiceFactory;
import com.kingdee.eas.fm.sa.app.util.DateUtils;
import com.kingdee.eas.fm.sa.app.util.ThreadLocalDateUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class MaturedDebtTotalBillControllerBean
extends AbstractMaturedDebtTotalBillControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.sa.app.MaturedDebtTotalBillControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaturedDebtTotalBillInfo info = (MaturedDebtTotalBillInfo)model;
        if (EmptyUtil.isEmpty((String)info.getNumber()) && FMHelper.hasNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString())) {
            try {
                info.setNumber(FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString()));
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                info.setNumber(this.getDefaultNumber(info));
            }
        } else {
            info.setNumber(this.getDefaultNumber(info));
        }
        return super._addnew(ctx, (IObjectValue)info);
    }

    private String getDefaultNumber(MaturedDebtTotalBillInfo info) {
        String number = "MDSMRP-";
        Date payDate = info.getBeginDate();
        number = number + ThreadLocalDateUtil.formatDate(payDate);
        number = number + "-" + beServiceHelper.getSerialNumber((int)1)[0].substring(10, 17);
        return number;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaturedDebtTotalBillInfo info = (MaturedDebtTotalBillInfo)model;
        if (!info.getBillstatus().equals((Object)BillState.SAVED) && !info.getBillstatus().equals((Object)BillState.SUBMIT)) {
            throw new SAException(SAException.LARGETOTAL_NOTALLOW_SUBMIT);
        }
        boolean isNeedDispose = false;
        HashSet<String> ids = new HashSet<String>();
        HashSet<String> serialIds = new HashSet<String>();
        HashSet<String> completedIds = new HashSet<String>();
        if (!info.getBillstatus().equals((Object)BillState.SUBMIT)) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            FilterInfo filter = new FilterInfo();
            view.setSelector(sic);
            view.setFilter(filter);
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("state"));
            sic.add(new SelectorItemInfo("serialId"));
            sic.add(new SelectorItemInfo("reportCompany.name"));
            filter.getFilterItems().add(new FilterItemInfo("fillInCompany.id", (Object)info.getCompany().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)info.getBeginDate(), CompareType.EQUALS));
            MaturedDebtDetailMergeBillCollection col = MaturedDebtDetailMergeBillFactory.getLocalInstance(ctx).getMaturedDebtDetailMergeBillCollection(view);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)col)) {
                for (int i = 0; i < col.size(); ++i) {
                    MaturedDebtDetailMergeBillInfo detailMerInfo = col.get(i);
                    String id = detailMerInfo.getId().toString();
                    ids.add(id);
                    if (!BillState.SUBMIT.equals((Object)detailMerInfo.getState())) continue;
                    completedIds.add(id);
                    serialIds.add(detailMerInfo.getSerialId());
                }
                if (ids.size() != completedIds.size()) {
                    throw new SAException(SAException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"122_MaturedDebtTotalBillControllerBean", (Locale)ctx.getLocale()) + info.getBeginDate() + ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"123_MaturedDebtTotalBillControllerBean", (Locale)ctx.getLocale())});
                }
                info.setBillstatus(BillState.SUBMIT);
                isNeedDispose = true;
            }
        }
        IObjectPK pk = super._submit(ctx, (IObjectValue)info);
        if (isNeedDispose) {
            this.disposeMaturedDebtMergeDetailInfo(ctx, ids, serialIds, info);
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_maturedTotalBill_submit");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return pk;
    }

    @Override
    protected void _caculate(Context ctx, MaturedDebtTotalBillInfo info) throws BOSException, EASBizException {
        if (!info.getBillstatus().equals((Object)BillState.SAVED)) {
            throw new SAException(SAException.LARGETOTAL_NOTALLOW_CACULATE);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        FilterInfo filter = new FilterInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("reportOrg.id"));
        sic.add(new SelectorItemInfo("reportOrg.name"));
        sic.add(new SelectorItemInfo("reportOrg.name"));
        sic.add(new SelectorItemInfo("reportOrgNumber"));
        sic.add(new SelectorItemInfo("reportOrgCode"));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getReportOrgSolution().getId().toString(), CompareType.EQUALS));
        ReportOrgSSEntryOrgCollection reportOrgEntryCol = ReportOrgSSEntryOrgFactory.getLocalInstance(ctx).getReportOrgSSEntryOrgCollection(view);
        HashMap<String, ReportOrgSSEntryOrgInfo> orgMap = new HashMap<String, ReportOrgSSEntryOrgInfo>();
        for (int i = 0; i < reportOrgEntryCol.size(); ++i) {
            ReportOrgSSEntryOrgInfo orgEntryInfo = reportOrgEntryCol.get(i);
            if (orgMap.containsKey(orgEntryInfo.getReportOrg().getId().toString())) continue;
            orgMap.put(orgEntryInfo.getReportOrg().getId().toString(), orgEntryInfo);
        }
        view = new EntityViewInfo();
        sic = new SelectorItemCollection();
        filter = new FilterInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("serialId"));
        sic.add(new SelectorItemInfo("reportCompany.name"));
        filter.getFilterItems().add(new FilterItemInfo("fillInCompany.id", (Object)info.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)info.getBeginDate(), CompareType.EQUALS));
        MaturedDebtDetailMergeBillCollection col = MaturedDebtDetailMergeBillFactory.getLocalInstance(ctx).getMaturedDebtDetailMergeBillCollection(view);
        StringBuffer sb = new StringBuffer();
        if (col.size() != reportOrgEntryCol.size()) {
            int i;
            ReportOrgSSEntryOrgCollection noReportOrgCol = reportOrgEntryCol;
            for (i = 0; i < col.size(); ++i) {
                MaturedDebtDetailMergeBillInfo detailMegInfo = col.get(i);
                if (!orgMap.containsKey(detailMegInfo.getReportCompany().getId().toString())) continue;
                noReportOrgCol.remove((ReportOrgSSEntryOrgInfo)orgMap.get(detailMegInfo.getReportCompany().getId().toString()));
            }
            for (i = 0; i < noReportOrgCol.size(); ++i) {
                ReportOrgSSEntryOrgInfo orgEntryInfo = noReportOrgCol.get(i);
                if (i != noReportOrgCol.size() - 1) {
                    sb.append("[").append(orgEntryInfo.getReportOrg().getName()).append("],");
                    continue;
                }
                sb.append("[").append(orgEntryInfo.getReportOrg().getName()).append("]");
            }
        }
        HashSet<String> ids = new HashSet<String>();
        HashSet<String> completedIds = new HashSet<String>();
        HashSet<String> serialIds = new HashSet<String>();
        StringBuffer retSb = new StringBuffer();
        for (int i = 0; i < col.size(); ++i) {
            MaturedDebtDetailMergeBillInfo detailInfo = col.get(i);
            String id = detailInfo.getId().toString();
            ids.add(id);
            if (BillState.SUBMIT.equals((Object)detailInfo.getState())) {
                completedIds.add(id);
            } else if (i != col.size() - 1) {
                retSb.append("[").append(detailInfo.getReportCompany().getName()).append("],");
            } else {
                retSb.append("[").append(detailInfo.getReportCompany().getName()).append("]");
            }
            if (EmptyUtil.isEmpty((String)detailInfo.getSerialId())) continue;
            serialIds.add(detailInfo.getSerialId());
        }
        if (!EmptyUtil.isEmpty((String)sb.toString()) || !EmptyUtil.isEmpty((String)retSb.toString())) {
            if (!EmptyUtil.isEmpty((String)retSb.toString())) {
                sb = sb.append(",").append(retSb);
            }
            throw new SAException(SAException.COMMON, new Object[]{sb.toString() + ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"124_MaturedDebtTotalBillControllerBean", (Locale)ctx.getLocale()) + info.getBeginDate() + ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"125_MaturedDebtTotalBillControllerBean", (Locale)ctx.getLocale())});
        }
        info.setBillstatus(BillState.SUBMIT);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("billstatus"));
        MaturedDebtTotalBillFactory.getLocalInstance(ctx).updatePartial(info, selector);
        this.disposeMaturedDebtMergeDetailInfo(ctx, completedIds, serialIds, info);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_maturedTotalBill_caculate");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    private void disposeMaturedDebtMergeDetailInfo(Context ctx, Set<String> ids, Set<String> mergeBillNumberSet, MaturedDebtTotalBillInfo info) throws BOSException {
        if (ids.isEmpty()) {
            return;
        }
        String sql = "update T_SA_MaturedDebtDetailMerBill set FState = ?, FBatchSeqId = ? where FID in " + FMHelper.setTran2String(ids);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{40, info.getBatchSeqId()});
        sql = "update T_SA_DebtDetailBill set FTotalBillNumber = ? where FMergeBillNumber in " + FMHelper.setTran2String(mergeBillNumberSet);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getBatchSeqId()});
    }

    @Override
    protected void _cancel(Context ctx, MaturedDebtTotalBillInfo info) throws BOSException, EASBizException {
        if (!info.getBillstatus().equals((Object)BillState.SUBMIT)) {
            throw new SAException(SAException.LARGETOTAL_NOTALLOW_CANCEL);
        }
        info.setBillstatus(BillState.SAVED);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("BillStatus"));
        MaturedDebtTotalBillFactory.getLocalInstance(ctx).updatePartial(info, selector);
        String detailMergeSql = "update T_SA_MaturedDebtDetailMerBill set FState = ?, FBatchSeqId = null where FBatchSeqId = ?";
        DbUtil.execute((Context)ctx, (String)detailMergeSql, (Object[])new Object[]{20, info.getBatchSeqId()});
        String detailBillSql = "update T_SA_DebtDetailBill set FTotalBillNumber = null where FTotalBillNumber = ?";
        DbUtil.execute((Context)ctx, (String)detailBillSql, (Object[])new Object[]{info.getBatchSeqId()});
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_maturedTotalBill_cancel");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _confirm(Context ctx, MaturedDebtTotalBillInfo info) throws BOSException, EASBizException {
        if (!info.getBillstatus().equals((Object)BillState.SUBMIT)) {
            throw new SAException(SAException.LARGETOTAL_NOTALLOW_CONFIRM);
        }
        info.setBillstatus(BillState.COMFIRED);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("BillStatus"));
        MaturedDebtTotalBillFactory.getLocalInstance(ctx).updatePartial(info, selector);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_maturedTotalBill_confirm");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _unConfirm(Context ctx, MaturedDebtTotalBillInfo info) throws BOSException, EASBizException {
        if (!info.getBillstatus().equals((Object)BillState.COMFIRED)) {
            throw new SAException(SAException.LARGETOTAL_NOTALLOW_UNCONFIRM);
        }
        info.setBillstatus(BillState.SUBMIT);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("BillStatus"));
        MaturedDebtTotalBillFactory.getLocalInstance(ctx).updatePartial(info, selector);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_maturedTotalBill_unConfirm");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _report(Context ctx, MaturedDebtTotalBillInfo info) throws BOSException, EASBizException {
        ILargeTotalReportService maTotalReportService = LargeTotalReportServiceFactory.getLargeTotalReportService(ctx, info);
        maTotalReportService.initService(ctx, info);
        maTotalReportService.beforeReport();
        maTotalReportService.doService();
        maTotalReportService.afterReport(info.getId().toString());
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_maturedTotalBill_report");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _cancelReport(Context ctx, MaturedDebtTotalBillInfo info) throws BOSException, EASBizException {
        ILargeTotalCancelReportService maTotalUnReportService = LargeTotalCancelReportServiceFactory.getLargeTotalUnReportService(ctx, info);
        maTotalUnReportService.initService(ctx, info);
        maTotalUnReportService.beforeUnReport();
        maTotalUnReportService.doService();
        maTotalUnReportService.afterUnReport(info.getId().toString());
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_maturedTotalBill_unReport");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _genMaturedDebtTotalBill(Context ctx, ReportOrgSolutionSettingInfo info, Date payDate, String person, IMaturedDebtDetailMergeBill iMaturedDebtDetailMergeBill) throws BOSException, EASBizException {
        HashSet<String> detailIds = new HashSet<String>();
        HashSet<String> serialIds = new HashSet<String>();
        FilterInfo totalFilter = new FilterInfo();
        totalFilter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)DateUtils.getMonthOfFirstDay(payDate), CompareType.EQUALS));
        totalFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getFillInOrgUnit().getId().toString(), CompareType.EQUALS));
        if (super.exists(ctx, totalFilter)) {
            return;
        }
        MaturedDebtTotalBillInfo totalInfo = new MaturedDebtTotalBillInfo();
        totalInfo.setReportOrgSolution(info);
        totalInfo.setBeginDate(DateUtils.getMonthOfFirstDay(payDate));
        totalInfo.setEndDate(DateUtils.getMonthOfLastDay(payDate));
        String payDateStr = ThreadLocalDateUtil.formatDate(payDate);
        totalInfo.setYear(payDateStr.split("-")[0].toString());
        totalInfo.setMonth(payDateStr.split("-")[1].toString());
        totalInfo.setPerson(person);
        totalInfo.setCompany(info.getFillInOrgUnit());
        totalInfo.setFillInOrgGroupName(info.getFillInOrgGroupName());
        totalInfo.setFillInOrgGroupCode(info.getFillInOrgGroupCode());
        totalInfo.setFillInOrgUnitName(info.getFillInOrgUnitName());
        totalInfo.setFillInOrgUnitCode(info.getFillInOrgUnitCode());
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        FilterInfo filter = new FilterInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        sic.add(new SelectorItemInfo("*"));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)DateUtils.getMonthOfFirstDay(payDate), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("reportOrgSolution.id", (Object)info.getId().toString(), CompareType.EQUALS));
        MaturedDebtDetailMergeBillCollection detailMergeCols = iMaturedDebtDetailMergeBill.getMaturedDebtDetailMergeBillCollection(view);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)detailMergeCols)) {
            MaturedDebtDetailMergeBillCollection completedDetailMergeCols = new MaturedDebtDetailMergeBillCollection();
            for (int k = 0; k < detailMergeCols.size(); ++k) {
                MaturedDebtDetailMergeBillInfo detailMergeInfo = detailMergeCols.get(k);
                if (!BillState.SUBMIT.equals((Object)detailMergeInfo.getState())) continue;
                completedDetailMergeCols.add(detailMergeInfo);
                detailIds.add(detailMergeInfo.getId().toString());
                serialIds.add(detailMergeInfo.getSerialId());
            }
            if (info.getReportOrgEntrys().size() != detailMergeCols.size()) {
                totalInfo.setBillstatus(BillState.SAVED);
            } else if (detailMergeCols.size() == completedDetailMergeCols.size()) {
                totalInfo.setBillstatus(BillState.SUBMIT);
            } else {
                totalInfo.setBillstatus(BillState.SAVED);
            }
        } else {
            totalInfo.setBillstatus(BillState.SUBMIT);
        }
        totalInfo.setBatchSeqId(beServiceHelper.getSerialNumber((int)1)[0]);
        this._addnew(ctx, (IObjectValue)totalInfo);
        if (BillState.SUBMIT.equals((Object)totalInfo.getBillstatus())) {
            this.disposeMaturedDebtMergeDetailInfo(ctx, detailIds, serialIds, totalInfo);
        }
    }
}

