/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BankPayingBillCollection;
import com.kingdee.eas.fm.be.BankPayingBillFactory;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.sa.AccessSourceEnum;
import com.kingdee.eas.fm.sa.BillStatusEnum;
import com.kingdee.eas.fm.sa.FundUseInfo;
import com.kingdee.eas.fm.sa.LargeAccessSourceSettingEntryCollection;
import com.kingdee.eas.fm.sa.LargeAccessSourceSettingEntryFactory;
import com.kingdee.eas.fm.sa.LargeDetailBillCollection;
import com.kingdee.eas.fm.sa.LargeDetailBillFactory;
import com.kingdee.eas.fm.sa.LargeDetailBillInfo;
import com.kingdee.eas.fm.sa.ReportContentEnum;
import com.kingdee.eas.fm.sa.ReportOrgSolutionSettingInfo;
import com.kingdee.eas.fm.sa.SAException;
import com.kingdee.eas.fm.sa.app.handler.ITransLargeDetailHandler;
import com.kingdee.eas.fm.sa.app.util.Sequence;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractTransLargeHandler
implements ITransLargeDetailHandler {
    private static Logger logger = Logger.getLogger(AbstractTransLargeHandler.class);
    protected static final String LARGEDETAIL_BOSTYPE = new LargeDetailBillInfo().getBOSType().toString();

    @Override
    public Set<String> getSourceBillIdSet(Context ctx, String companyId, Date payDate, AccessSourceEnum source) throws EASBizException, BOSException {
        HashSet<String> sourceBillIdSet = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("reportOrg.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("payDate", (Object)payDate));
        filter.getFilterItems().add(new FilterItemInfo("accessSource", (Object)source.getValue()));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("sourceBillId"));
        view.setFilter(filter);
        view.setSelector(selector);
        LargeDetailBillCollection coll = LargeDetailBillFactory.getLocalInstance(ctx).getLargeDetailBillCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            sourceBillIdSet.add(coll.get(i).getSourceBillId());
        }
        return sourceBillIdSet;
    }

    @Override
    public Set<String> getAccountBankIdSet(Context ctx, String companyId, AccessSourceEnum source) throws EASBizException, BOSException {
        HashSet<String> acctBankIdSet = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.reportOrg.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("parent.state", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("parent.reportedType", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("accessSource", (Object)source.getValue()));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("accountBank.id"));
        view.setSelector(selector);
        view.setFilter(filter);
        LargeAccessSourceSettingEntryCollection coll = LargeAccessSourceSettingEntryFactory.getLocalInstance(ctx).getLargeAccessSourceSettingEntryCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            acctBankIdSet.add(coll.get(i).getAccountBank().getId().toString());
        }
        return acctBankIdSet;
    }

    @Override
    public abstract Set<String> getFilterBillIdSet(Context var1, String var2, Date var3, BigDecimal var4) throws EASBizException, BOSException;

    @Override
    public Set<String> getBillIdSet(Context ctx, String companyId, Date payDate, BigDecimal minAmount, AccessSourceEnum source) throws EASBizException, BOSException {
        HashSet<String> idSet = new HashSet<String>();
        Set<String> sourceBillIdSet = this.getSourceBillIdSet(ctx, companyId, payDate, source);
        Set<String> allIdSet = this.getFilterBillIdSet(ctx, companyId, payDate, minAmount);
        for (String billId : allIdSet) {
            if (sourceBillIdSet.contains(billId)) continue;
            idSet.add(billId);
        }
        return idSet;
    }

    @Override
    public Map<String, Boolean> getIsPersonPayMap(Context ctx, Set<String> billIdSet) throws EASBizException, BOSException {
        HashMap<String, Boolean> billId_isPersonPayMap = new HashMap<String, Boolean>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", billIdSet, CompareType.INCLUDE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("isPersonPay"));
        selector.add(new SelectorItemInfo("sourceBillId"));
        view.setFilter(filter);
        view.setSelector(selector);
        BankPayingBillCollection coll = BankPayingBillFactory.getLocalInstance((Context)ctx).getBankPayingBillCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            billId_isPersonPayMap.put(coll.get(i).getSourceBillId(), coll.get(i).isIsPersonPay());
        }
        return billId_isPersonPayMap;
    }

    @Override
    public abstract IObjectCollection getBillColl(Context var1, Set<String> var2) throws EASBizException, BOSException;

    @Override
    public BOTMappingInfo getBOTMappingInfo(Context ctx, CoreBillBaseInfo bill) throws EASBizException, BOSException {
        BOTMappingInfo bmap;
        IBOTMapping iBOTMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
        try {
            bmap = iBOTMapping.getMapping(bill, LARGEDETAIL_BOSTYPE, DefineSysEnum.BTP);
        }
        catch (BOTPException e) {
            throw new BTPException(BTPException.GETMAPPINGINFOERROR, (Throwable)e);
        }
        if (bmap == null) {
            throw new BTPException(BTPException.MAPPINGINFONULLERROR);
        }
        return bmap;
    }

    @Override
    public void genLargeDetailColl(Context ctx, String companyId, Date payDate, BigDecimal minAmount, AccessSourceEnum source, ReportOrgSolutionSettingInfo reportOrgSolution, Map<String, FundUseInfo> matchId_fundUseMap) throws EASBizException, BOSException {
        Set<String> billIdSet = this.getBillIdSet(ctx, companyId, payDate, minAmount, source);
        if (billIdSet.size() == 0) {
            logger.error((Object)("\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684" + source.getAlias() + "\u53bb\u8f6c\u6362\u6210\u5927\u989d\u8d44\u91d1\u660e\u7ec6"));
            return;
        }
        IObjectCollection billColl = this.getBillColl(ctx, billIdSet);
        CoreBaseCollection newLargeDetailBillColl = new CoreBaseCollection();
        HashMap<String, String> srcBillId_destIdMap = new HashMap<String, String>();
        for (int i = 0; i < billColl.size(); ++i) {
            LargeDetailBillInfo info = this.transOneLargeDetail(ctx, billColl.getObject(i), reportOrgSolution, matchId_fundUseMap);
            this.addnewVerify(ctx, info);
            newLargeDetailBillColl.add((CoreBaseInfo)info);
            srcBillId_destIdMap.put(info.getSourceBillId(), info.getId().toString());
        }
        LargeDetailBillFactory.getLocalInstance(ctx).addnewBatchData(newLargeDetailBillColl);
        BOTPUtil.saveBOTRelation((Context)ctx, srcBillId_destIdMap);
    }

    @Override
    public LargeDetailBillInfo transOneLargeDetail(Context ctx, IObjectValue bill, ReportOrgSolutionSettingInfo reportOrgSolution, Map<String, FundUseInfo> matchId_fundUseMap) throws BOSException, EASBizException {
        CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
        sourceBillCollection.add((CoreBillBaseInfo)bill);
        BTPTransformResult btpResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform(sourceBillCollection, LARGEDETAIL_BOSTYPE);
        LargeDetailBillCollection largeColl = (LargeDetailBillCollection)btpResult.getBills();
        if (largeColl.size() == 0) {
            throw new SAException(SAException.COMMON, new String[]{"\u5927\u989d\u8d44\u91d1\u660e\u7ec6botp\u8f6c\u6362\u5931\u8d25"});
        }
        LargeDetailBillInfo info = largeColl.get(0);
        info.setSourceBillId(bill.getString("id"));
        info.setSourceBillNumber(bill.getString("number"));
        info.setReportedType(ReportContentEnum.USE_OF_LARGE_FUNDS);
        this.initBillNumber(ctx, info);
        info.setSerialId(Sequence.gen18Sequence());
        info.setFillInOrgUnitName(reportOrgSolution.getFillInOrgUnitName());
        info.setFillInOrgUnitCode(reportOrgSolution.getFillInOrgUnitCode());
        info.setIsCBRecName(false);
        info.setIsTradeBusiness(true);
        info.setBillStatus(BillStatusEnum.SAVE);
        if (EmptyUtil.isEmpty((Object)info.getAmount())) {
            info.setAmount(BigDecimal.ZERO);
        }
        if (!EmptyUtil.isEmpty((Object)info.getPayDate())) {
            info.setPayDate(DateTimeUtils.truncateDate((Date)info.getPayDate()));
        }
        info.setCreator(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        this.fillLargeDetail(bill, info, matchId_fundUseMap);
        return info;
    }

    @Override
    public abstract void fillLargeDetail(IObjectValue var1, LargeDetailBillInfo var2, Map<String, FundUseInfo> var3) throws BOSException, EASBizException;

    @Override
    public void initBillNumber(Context ctx, LargeDetailBillInfo info) throws BOSException, EASBizException {
        FilterInfo filter;
        int i = 0;
        do {
            String numberSilent = null;
            try {
                numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getReportOrg().getId().toString());
            }
            catch (Exception e) {
                logger.info((Object)e);
                throw new SAException(SAException.COMMON, new String[]{e.getMessage()});
            }
            if (EmptyUtil.isEmpty((String)numberSilent)) {
                return;
            }
            info.setNumber(numberSilent);
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("reportOrg.id", (Object)info.getReportOrg().getId()));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
            ++i;
        } while (LargeDetailBillFactory.getLocalInstance(ctx).exists(filter));
    }

    @Override
    public void addnewVerify(Context ctx, LargeDetailBillInfo info) throws BOSException, EASBizException {
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"reportOrg");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"payDate");
    }

    @Override
    public void addnewLargeDetail(Context ctx, LargeDetailBillInfo info) throws BOSException, EASBizException {
        this.addnewVerify(ctx, info);
        LargeDetailBillFactory.getLocalInstance(ctx).addnew(info);
        this.saveBOTRelation(ctx, info);
    }

    @Override
    public void saveBOTRelation(Context ctx, LargeDetailBillInfo info) throws BOSException, EASBizException {
        ArrayList<String> srcIdList = new ArrayList<String>();
        String sourceBillID = info.getSourceBillId();
        srcIdList.add(sourceBillID);
        BOTPUtil.saveBOTRelation((Context)ctx, srcIdList, (String)info.getId().toString());
    }
}

