/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.sa.ILargeDetailMergeBill;
import com.kingdee.eas.fm.sa.ILargeTotalBill;
import com.kingdee.eas.fm.sa.LargeDetailMergeBillFactory;
import com.kingdee.eas.fm.sa.LargeTotalBillFactory;
import com.kingdee.eas.fm.sa.ReportContentEnum;
import com.kingdee.eas.fm.sa.ReportOrgSolutionSettingCollection;
import com.kingdee.eas.fm.sa.ReportOrgSolutionSettingInfo;
import com.kingdee.eas.fm.sa.SAException;
import com.kingdee.eas.fm.sa.app.handler.ITotalHandler;
import com.kingdee.eas.fm.sa.app.util.SAConstants;
import com.kingdee.eas.fm.sa.app.util.ThreadLocalDateUtil;
import com.kingdee.eas.util.ResourceBase;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class LargeTotalHandler
implements ITotalHandler {
    private static Logger logger = Logger.getLogger((String)LargeTotalHandler.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dealTotalBillHandler(Context ctx, Date payDate, ReportOrgSolutionSettingCollection reportOrgSolutionCol, Map<ReportContentEnum, ReportOrgSolutionSettingCollection> reportEnum_reportOrgSolutionColMap, Map<String, String> solutionEnum_personMap) throws BOSException, EASBizException {
        ReportOrgSolutionSettingCollection solutionCol = reportEnum_reportOrgSolutionColMap.get((Object)ReportContentEnum.USE_OF_LARGE_FUNDS);
        if (EmptyUtil.isEmpty((AbstractObjectCollection)solutionCol)) {
            logger.info((Object)(ReportContentEnum.USE_OF_LARGE_FUNDS.getAlias() + "\u6ca1\u6709\u7b26\u5408\u751f\u6210\u5927\u989d\u8d44\u91d1\u6c47\u603b\u62a5\u9001\u6761\u4ef6\u7684\u516c\u53f8"));
            return;
        }
        ILargeDetailMergeBill iLargeDetailMergeBill = LargeDetailMergeBillFactory.getLocalInstance(ctx);
        ILargeTotalBill iLargeTotalBill = LargeTotalBillFactory.getLocalInstance(ctx);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < solutionCol.size(); ++i) {
            ReportOrgSolutionSettingInfo info = solutionCol.get(i);
            boolean isLocked = false;
            String lockId = SAConstants.getSALargeMutexId(info.getId().toString(), payDate) + "$!Total";
            try {
                isLocked = iMutex.requestObjIDForUpdate(lockId);
                if (!isLocked) {
                    throw new SAException(SAException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"67_LargeTotalHandler", (Locale)ctx.getLocale()) + info.getFillInOrgUnitName() + ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"68_LargeTotalHandler", (Locale)ctx.getLocale()) + ThreadLocalDateUtil.formatDate(payDate) + ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"69_LargeTotalHandler", (Locale)ctx.getLocale())});
                }
                String key = SAConstants.getSolutionEnum2personMapKey(info, ReportContentEnum.USE_OF_LARGE_FUNDS);
                String person = solutionEnum_personMap.get(key);
                iLargeTotalBill.genLargeDetailTotalBill(info, payDate, person, iLargeDetailMergeBill);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            finally {
                if (isLocked) {
                    iMutex.releaseObjIDForUpdate(lockId);
                }
            }
        }
    }
}

