/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.LoanCollection;
import com.kingdee.eas.fm.fin.LoanEntryCollection;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.sa.AccessSourceEnum;
import com.kingdee.eas.fm.sa.DebtDetailBillInfo;
import com.kingdee.eas.fm.sa.FundUseInfo;
import com.kingdee.eas.fm.sa.app.handler.AbstractTransDebtHandler;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LoanTransDebtHandler
extends AbstractTransDebtHandler {
    @Override
    public Set<String> getFilterBillIdSet(Context ctx, String companyId, Date startDate) throws EASBizException, BOSException {
        HashSet<String> idSet = new HashSet<String>();
        Set<String> sourceIdSet = this.getRepaySourceIdSet(ctx, companyId, startDate, FinancingBillTypeEnum.Loan);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("isBonds", (Object)false));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)3));
        filter.getFilterItems().add(new FilterItemInfo("IssueDate", (Object)DateUtil.getLastDayOfMonth((Date)startDate), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("Balance", (Object)BigDecimal.ZERO, CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("id", sourceIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("Balance", (Object)BigDecimal.ZERO, CompareType.EQUALS));
        filter.setMaskString(" #0 and #1 and #2 and (( #3 and #4 ) or ( #5 and #6 )) ");
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        view.setSelector(selector);
        view.setFilter(filter);
        LoanCollection coll = LoanFactory.getLocalInstance((Context)ctx).getLoanCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            String billId = coll.get(i).getId().toString();
            idSet.add(billId);
        }
        return idSet;
    }

    public LoanCollection getBillColl(Context ctx, Set<String> billIdSet) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", billIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entrys.*"));
        selector.add(new SelectorItemInfo("company.name"));
        view.setSelector(selector);
        return LoanFactory.getLocalInstance((Context)ctx).getLoanCollection(view);
    }

    @Override
    public void fillDebtDetail(IObjectValue bill, DebtDetailBillInfo info, Map<String, FundUseInfo> matchId_fundUseMap) throws BOSException, EASBizException {
        LoanInfo loan = (LoanInfo)bill;
        info.setAccessSource(AccessSourceEnum.Loan);
        info.setFundUse(matchId_fundUseMap.get(loan.getType().getId().toString()));
        Date dueDateMonth = null;
        BigDecimal dueAmtMonth = BigDecimal.ZERO;
        LoanEntryCollection entrys = loan.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            Date date = entrys.get(i).getDate();
            BigDecimal amount = entrys.get(i).getAmount();
            if (date.getTime() > DateUtil.getLastDayOfCurMonth().getTime() || date.getTime() < DateUtil.getFirstDayOfCurMonth().getTime()) continue;
            if (dueDateMonth == null || dueDateMonth != null && dueDateMonth.before(date)) {
                dueDateMonth = date;
            }
            dueAmtMonth = dueAmtMonth.add(amount);
        }
        info.setDueDateMonth(dueDateMonth);
        info.setDueAmtMonth(dueAmtMonth.multiply(loan.getLocalCurExRate()));
    }
}

