/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.sa.IMaturedDebtDetailMergeBill;
import com.kingdee.eas.fm.sa.IMaturedDebtTotalBill;
import com.kingdee.eas.fm.sa.MaturedDebtDetailMergeBillFactory;
import com.kingdee.eas.fm.sa.MaturedDebtTotalBillFactory;
import com.kingdee.eas.fm.sa.ReportContentEnum;
import com.kingdee.eas.fm.sa.ReportOrgSolutionSettingCollection;
import com.kingdee.eas.fm.sa.ReportOrgSolutionSettingInfo;
import com.kingdee.eas.fm.sa.SAException;
import com.kingdee.eas.fm.sa.app.handler.ITotalHandler;
import com.kingdee.eas.fm.sa.app.util.SAConstants;
import com.kingdee.eas.fm.sa.app.util.ThreadLocalDateUtil;
import com.kingdee.eas.util.ResourceBase;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class MaturedDebtTotalHandler
implements ITotalHandler {
    private static Logger logger = Logger.getLogger((String)MaturedDebtTotalHandler.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dealTotalBillHandler(Context ctx, Date payDate, ReportOrgSolutionSettingCollection reportOrgSolutionCol, Map<ReportContentEnum, ReportOrgSolutionSettingCollection> reportEnum_reportOrgSolutionColMap, Map<String, String> solutionEnum_personMap) throws BOSException, EASBizException {
        ReportOrgSolutionSettingCollection solutionCol = reportEnum_reportOrgSolutionColMap.get((Object)ReportContentEnum.MATURECLAIM_AND_REPAYPLAN);
        if (EmptyUtil.isEmpty((AbstractObjectCollection)solutionCol)) {
            logger.info((Object)(ReportContentEnum.MATURECLAIM_AND_REPAYPLAN.getAlias() + "\u6ca1\u6709\u7b26\u5408\u751f\u6210\u5230\u671f\u503a\u52a1\u6c47\u603b\u62a5\u9001\u6761\u4ef6\u7684\u516c\u53f8"));
            return;
        }
        IMaturedDebtDetailMergeBill iMaturedDebtDetailMergeBill = MaturedDebtDetailMergeBillFactory.getLocalInstance(ctx);
        IMaturedDebtTotalBill iMaturedDebtTotalBill = MaturedDebtTotalBillFactory.getLocalInstance(ctx);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < solutionCol.size(); ++i) {
            ReportOrgSolutionSettingInfo info = solutionCol.get(i);
            boolean isLocked = false;
            String lockId = SAConstants.getSADebtMutexId(info.getId().toString(), payDate) + "$!Total";
            try {
                isLocked = iMutex.requestObjIDForUpdate(lockId);
                if (!isLocked) {
                    throw new SAException(SAException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"67_LargeTotalHandler", (Locale)ctx.getLocale()) + info.getFillInOrgUnitName() + ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"68_LargeTotalHandler", (Locale)ctx.getLocale()) + ThreadLocalDateUtil.formatDate(payDate) + ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"72_MaturedDebtTotalHandler", (Locale)ctx.getLocale())});
                }
                String key = SAConstants.getSolutionEnum2personMapKey(info, ReportContentEnum.MATURECLAIM_AND_REPAYPLAN);
                String person = solutionEnum_personMap.get(key);
                iMaturedDebtTotalBill.genMaturedDebtTotalBill(info, payDate, person, iMaturedDebtDetailMergeBill);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            finally {
                if (isLocked) {
                    iMutex.releaseObjIDForUpdate(lockId);
                }
            }
        }
    }
}

