/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.sa.AccessSourceEnum;
import com.kingdee.eas.fm.sa.FundUseInfo;
import com.kingdee.eas.fm.sa.LargeDetailBillInfo;
import com.kingdee.eas.fm.sa.PayTypeEnum;
import com.kingdee.eas.fm.sa.app.handler.AbstractTransLargeHandler;
import com.kingdee.eas.fm.sa.app.util.DateUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PaymentBillTransLargeHandler
extends AbstractTransLargeHandler {
    private static Logger logger = Logger.getLogger(PaymentBillTransLargeHandler.class);

    @Override
    public Set<String> getFilterBillIdSet(Context ctx, String companyId, Date payDate, BigDecimal minAmount) throws EASBizException, BOSException {
        HashSet<String> idSet = new HashSet<String>();
        Set<String> acctBankIdSet = this.getAccountBankIdSet(ctx, companyId, AccessSourceEnum.PaymentBill);
        if (acctBankIdSet.size() == 0) {
            logger.error((Object)("\u542f\u7528\u7684\u5927\u989d\u8d44\u91d1\u62a5\u9001\u53d6\u6570\u6765\u6e90\u8bbe\u7f6e\u6ca1\u6709\u914d\u7f6e\u516c\u53f8" + companyId + "\u4ed8\u6b3e\u5355\u6765\u6e90\u7684\u94f6\u884c\u8d26\u6237"));
            return idSet;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("payDate", (Object)payDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("payDate", (Object)DateUtils.getAfterDay(payDate, 1), CompareType.LESS));
        filter.getFilterItems().add(new FilterItemInfo("payerAccountBank.id", acctBankIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("actPayLocAmt", (Object)minAmount, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isCBPay", (Object)false));
        filter.getFilterItems().add(new FilterItemInfo("isNeedPay", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("isInitializeBill", (Object)false));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        view.setSelector(selector);
        view.setFilter(filter);
        PaymentBillCollection coll = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            String billId = coll.get(i).getId().toString();
            idSet.add(billId);
        }
        return idSet;
    }

    public PaymentBillCollection getBillColl(Context ctx, Set<String> billIdSet) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", billIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entries.fundFlowItem.id"));
        selector.add(new SelectorItemInfo("payerAccountBank.acctName"));
        selector.add(new SelectorItemInfo("payerAccountBank.name"));
        selector.add(new SelectorItemInfo("company.name"));
        selector.add(new SelectorItemInfo("settlementType.isIsPersonPay"));
        view.setSelector(selector);
        return PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection(view);
    }

    @Override
    public void fillLargeDetail(IObjectValue bill, LargeDetailBillInfo info, Map<String, FundUseInfo> matchId_fundUseMap) throws BOSException, EASBizException {
        PaymentBillInfo paymentBill = (PaymentBillInfo)bill;
        info.setAccessSource(AccessSourceEnum.PaymentBill);
        if (!EmptyUtil.isEmpty((CoreBaseInfo)paymentBill.getPayerAccountBank()) && !EmptyUtil.isEmpty((String)paymentBill.getPayerAccountBank().getAcctName())) {
            info.setPayName(paymentBill.getPayerAccountBank().getAcctName());
        }
        if (EmptyUtil.isEmpty((String)info.getPayName()) && !EmptyUtil.isEmpty((CoreBaseInfo)paymentBill.getPayerAccountBank())) {
            info.setPayName(paymentBill.getPayerAccountBank().getName());
        }
        if (EmptyUtil.isEmpty((String)info.getPayName())) {
            info.setPayName(paymentBill.getCompany().getName());
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)paymentBill.getFundFlowItem())) {
            info.setFundUse(matchId_fundUseMap.get(paymentBill.getFundFlowItem().getId().toString()));
        } else {
            PaymentBillEntryCollection entries = paymentBill.getEntries();
            if (!EmptyUtil.isEmpty((CoreBaseInfo)entries.get(0).getFundFlowItem())) {
                info.setFundUse(matchId_fundUseMap.get(entries.get(0).getFundFlowItem().getId().toString()));
            }
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getFundUse())) {
            info.setFundUseName(info.getFundUse().getName());
        }
        info.setPayType(PayTypeEnum.ToPublic);
        if (!EmptyUtil.isEmpty((CoreBaseInfo)paymentBill.getSettlementType()) && paymentBill.getSettlementType().isIsPersonPay()) {
            info.setPayType(PayTypeEnum.ToPrivate);
        }
    }
}

