/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.sa.AccessSourceEnum;
import com.kingdee.eas.fm.sa.FundUseInfo;
import com.kingdee.eas.fm.sa.LargeDetailBillInfo;
import com.kingdee.eas.fm.sa.PayTypeEnum;
import com.kingdee.eas.fm.sa.app.handler.AbstractTransLargeHandler;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SettlementBillTransLargeHandler
extends AbstractTransLargeHandler {
    private static Logger logger = Logger.getLogger(SettlementBillTransLargeHandler.class);

    @Override
    public Set<String> getFilterBillIdSet(Context ctx, String companyId, Date payDate, BigDecimal minAmount) throws EASBizException, BOSException {
        HashSet<String> idSet = new HashSet<String>();
        Set<String> acctBankIdSet = this.getAccountBankIdSet(ctx, companyId, AccessSourceEnum.SettlementBill);
        if (acctBankIdSet.size() == 0) {
            logger.error((Object)("\u542f\u7528\u7684\u5927\u989d\u8d44\u91d1\u62a5\u9001\u53d6\u6570\u6765\u6e90\u8bbe\u7f6e\u6ca1\u6709\u914d\u7f6e\u516c\u53f8" + companyId + "\u7ed3\u7b97\u5355\u6765\u6e90\u7684\u94f6\u884c\u8d26\u6237"));
            return idSet;
        }
        HashSet<Integer> typeSet = new HashSet<Integer>();
        typeSet.add(2);
        typeSet.add(100);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("settleDate", (Object)payDate));
        filter.getFilterItems().add(new FilterItemInfo("payerBankAcct.id", acctBankIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("localAmt", (Object)minAmount, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("type", typeSet, CompareType.INCLUDE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        view.setSelector(selector);
        view.setFilter(filter);
        SettlementBillCollection coll = SettlementBillFactory.getLocalInstance((Context)ctx).getSettlementBillCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            String settleId = coll.get(i).getId().toString();
            idSet.add(settleId);
        }
        return idSet;
    }

    public SettlementBillCollection getBillColl(Context ctx, Set<String> billIdSet) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", billIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("payerBankAcct.acctName"));
        selector.add(new SelectorItemInfo("payerBankAcct.name"));
        selector.add(new SelectorItemInfo("company.name"));
        selector.add(new SelectorItemInfo("settleType.isPersonPay"));
        view.setSelector(selector);
        return SettlementBillFactory.getLocalInstance((Context)ctx).getSettlementBillCollection(view);
    }

    @Override
    public void fillLargeDetail(IObjectValue bill, LargeDetailBillInfo info, Map<String, FundUseInfo> matchId_fundUseMap) throws BOSException, EASBizException {
        SettlementBillInfo settlementBill = (SettlementBillInfo)bill;
        info.setAccessSource(AccessSourceEnum.SettlementBill);
        if (!EmptyUtil.isEmpty((CoreBaseInfo)settlementBill.getPayerBankAcct()) && !EmptyUtil.isEmpty((String)settlementBill.getPayerBankAcct().getAcctName())) {
            info.setPayName(settlementBill.getPayerBankAcct().getAcctName());
        }
        if (EmptyUtil.isEmpty((String)info.getPayName()) && !EmptyUtil.isEmpty((CoreBaseInfo)settlementBill.getPayerBankAcct())) {
            info.setPayName(settlementBill.getPayerBankAcct().getName());
        }
        if (EmptyUtil.isEmpty((String)info.getPayName())) {
            info.setPayName(settlementBill.getCompany().getName());
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)settlementBill.getFundFlowItemOut())) {
            info.setFundUse(matchId_fundUseMap.get(settlementBill.getFundFlowItemOut().getId().toString()));
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getFundUse())) {
            info.setFundUseName(info.getFundUse().getName());
        }
        info.setPayType(PayTypeEnum.ToPublic);
        if (!EmptyUtil.isEmpty((CoreBaseInfo)settlementBill.getSettleType()) && settlementBill.getSettleType().isIsPersonPay()) {
            info.setPayType(PayTypeEnum.ToPrivate);
        }
    }
}

