/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.sa.BillState;
import com.kingdee.eas.fm.sa.LargeTotalBillFactory;
import com.kingdee.eas.fm.sa.LargeTotalBillInfo;
import com.kingdee.eas.fm.sa.ReportStatusEnum;
import com.kingdee.eas.fm.sa.ReportStorageSettingWebFacadeFactory;
import com.kingdee.eas.fm.sa.SAException;
import com.kingdee.eas.fm.sa.TotalBillInfo;
import com.kingdee.eas.fm.sa.app.service.ILargeTotalReportService;
import com.kingdee.eas.fm.sa.app.util.LargeTotalDBUtils;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class LargeTotalReportSerivce
implements ILargeTotalReportService {
    private static Logger logger = Logger.getLogger((String)LargeTotalReportSerivce.class.getName());
    protected Context ctx;
    protected LargeTotalBillInfo info;
    protected boolean isZeroSendReport;

    @Override
    public void initService(Context ctx, TotalBillInfo info) throws EASBizException, BOSException {
        ReportStorageSettingWebFacadeFactory.getLocalInstance(ctx).testDBOrOthfaceDrive();
        this.info = (LargeTotalBillInfo)info;
        this.ctx = ctx;
        this.isZeroSendReport = this.info.getLargeTotalAmt().compareTo(Constants.ZERO) == 0;
    }

    @Override
    public void beforeReport() throws EASBizException, BOSException {
        if (!this.info.getBillstatus().equals((Object)BillState.COMFIRED)) {
            throw new SAException(SAException.LARGETOTAL_NOTALLOW_REPORT);
        }
    }

    @Override
    public void doService() throws EASBizException, BOSException {
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentUser();
        this.info.setPerson(user.getName());
        this.info.setBizTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
        this.info.setBillstatus(BillState.REPORTED);
        if (this.isZeroSendReport) {
            this.info.setReportStatus(ReportStatusEnum.ZEROREPORTED);
        } else {
            this.info.setReportStatus(ReportStatusEnum.ADDNEW);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("person"));
        selector.add(new SelectorItemInfo("bizTime"));
        selector.add(new SelectorItemInfo("billstatus"));
        selector.add(new SelectorItemInfo("reportStatus"));
        selector.add(new SelectorItemInfo("largeTotalAmt"));
        LargeTotalBillFactory.getLocalInstance(this.ctx).updatePartial(this.info, selector);
        String detailSql = "update T_SA_LargeDetailBill set FillInTime = ? where FTotalBillNumber = ?";
        DbUtil.execute((Context)this.ctx, (String)detailSql, (Object[])new Object[]{this.info.getBizTime(), this.info.getBatchSeqId()});
    }

    @Override
    public void afterReport(String id) throws EASBizException, BOSException {
        LargeTotalDBUtils dbUtils = new LargeTotalDBUtils();
        if (!this.isZeroSendReport) {
            dbUtils.addNewLargeTotalFromDB(this.ctx, this.info, ReportStatusEnum.ADDNEW);
        } else {
            dbUtils.addNewLargeTotalFromDB(this.ctx, this.info, ReportStatusEnum.ZEROREPORTED);
        }
    }
}

