/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.sa.AcctBankTransDetailCollection;
import com.kingdee.eas.fm.sa.AcctBankTransDetailInfo;
import com.kingdee.eas.fm.sa.ReportOrgSolutionSettingInfo;
import com.kingdee.eas.fm.sa.ReportStorageSettingCollection;
import com.kingdee.eas.fm.sa.ReportStorageSettingFactory;
import com.kingdee.eas.fm.sa.ReportStorageSettingInfo;
import com.kingdee.eas.fm.sa.app.util.AcctBankTransDetailJDBCTool;
import com.kingdee.eas.fm.sa.app.util.ThreadLocalDateUtil;
import com.kingdee.eas.fm.sa.vo.AcctBankTransDetailVO;
import com.kingdee.eas.util.ResourceBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AcctBankTransDetailDBUtils {
    private static Logger logger = Logger.getLogger((String)AcctBankTransDetailDBUtils.class.getName());
    public static final String detail_Key = "acctTransDetailKey";

    public void addNewAcctTransDetailFromDB(Context ctx, ReportOrgSolutionSettingInfo info, AcctBankTransDetailCollection transDetailCol) throws BOSException, EASBizException {
        AcctBankTransDetailJDBCTool acctTransDetailJDBCTool = new AcctBankTransDetailJDBCTool();
        EntityViewInfo View = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        View.setSelector(sic);
        ReportStorageSettingCollection cols = ReportStorageSettingFactory.getLocalInstance(ctx).getReportStorageSettingCollection(View);
        ReportStorageSettingInfo reportStorageSettingInfo = cols.get(0);
        List<AcctBankTransDetailVO> detailListVos = this.parseAcctBankTransDetailInfoToVO(info, transDetailCol);
        try {
            acctTransDetailJDBCTool.batchInsert(detailListVos, reportStorageSettingInfo);
        }
        catch (Exception e) {
            String exMsg = ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"137_AcctBankTransDetailDBUtils", (Locale)ctx.getLocale()) + e.getMessage();
            logger.error((Object)exMsg);
            throw new BOSException(exMsg);
        }
    }

    private List<AcctBankTransDetailVO> parseAcctBankTransDetailInfoToVO(ReportOrgSolutionSettingInfo info, AcctBankTransDetailCollection transDetailCol) {
        ArrayList<AcctBankTransDetailVO> detailListVos = new ArrayList<AcctBankTransDetailVO>();
        for (int i = 0; i < transDetailCol.size(); ++i) {
            AcctBankTransDetailInfo detailInfo = transDetailCol.get(i);
            AcctBankTransDetailVO detailVo = new AcctBankTransDetailVO();
            detailVo.setId(detailInfo.getTransDetailID());
            detailVo.setTransTime(ThreadLocalDateUtil.formatTimestamp(detailInfo.getBizTime()));
            detailVo.setDbtName(detailInfo.getAcctBankName());
            detailVo.setDbtAcct(detailInfo.getAcctBankNumber());
            detailVo.setDbtBankName(detailInfo.getBankName());
            if (!EmptyUtil.isEmpty((String)detailInfo.getOppAcctName())) {
                detailVo.setCrtName(detailInfo.getOppAcctName());
            } else {
                detailVo.setCrtName("\u5bf9\u65b9\u540d\u79f0");
            }
            if (!EmptyUtil.isEmpty((String)detailInfo.getOppAcctNumber())) {
                detailVo.setCrtAcct(detailInfo.getOppAcctNumber());
            } else {
                detailVo.setCrtAcct("\u5bf9\u65b9\u8d26\u53f7");
            }
            if (!EmptyUtil.isEmpty((String)detailInfo.getOppBankName())) {
                detailVo.setCrtBankName(detailInfo.getOppBankName());
            } else {
                detailVo.setCrtBankName("\u5bf9\u65b9\u94f6\u884c");
            }
            detailVo.setPayFlag(detailInfo.isIsDebit() ? "\u4ed8" : "\u6536");
            detailVo.setTransAmt(detailInfo.getAmount());
            detailVo.setUsage(detailInfo.getUsage());
            detailVo.setTransAbstr(detailInfo.getDescription());
            detailVo.setRemark(detailInfo.getRemark());
            detailVo.setGroupCode(info.getFillInOrgGroupCode());
            detailVo.setGroupName(info.getFillInOrgGroupName());
            detailVo.setDataState("0");
            detailVo.setSubmitTime(ThreadLocalDateUtil.formatTimestamp(detailInfo.getCreateTime()));
            detailVo.setDataStatus("0");
            detailListVos.add(detailVo);
        }
        return detailListVos;
    }
}

