/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app.util;

import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.fm.be.app.util.DBCPConUtils;
import com.kingdee.eas.fm.be.bean.EReceiptDBInfo;
import com.kingdee.eas.fm.sa.ReportStorageSettingInfo;
import com.kingdee.eas.fm.sa.StorageType;
import com.kingdee.eas.fm.sa.vo.AcctBankTransDetailVO;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class AcctBankTransDetailJDBCTool {
    private Logger logger = Logger.getLogger((String)AcctBankTransDetailJDBCTool.class.getName());
    private static String insertDetailSql = "INSERT INTO zjjg_yhzhjyxx (id, transTime, dbtName, dbtAcct, dbtBankName, crtName, crtAcct, crtBankName, payFlag, transAmt, usages, transAbstr, remark, groupCode, groupName, dataState, submitTime, dataStatus)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    public void batchInsert(List<AcctBankTransDetailVO> detailList, ReportStorageSettingInfo reportStorageSettingInfo) throws Exception, SQLException {
        if (StorageType.dbStore.equals((Object)reportStorageSettingInfo.getStorageType())) {
            EReceiptDBInfo eReceiptDBInfo = new EReceiptDBInfo();
            eReceiptDBInfo.setDbType(reportStorageSettingInfo.getDbType());
            eReceiptDBInfo.setDbIP(reportStorageSettingInfo.getDbIP());
            eReceiptDBInfo.setDbPort(reportStorageSettingInfo.getDbPort());
            eReceiptDBInfo.setDbName(reportStorageSettingInfo.getDbName());
            eReceiptDBInfo.setDbUserName(reportStorageSettingInfo.getDbUserName());
            eReceiptDBInfo.setDbUserPwd(reportStorageSettingInfo.getDbPwd());
            Statement st = null;
            Statement ps = null;
            Connection conn = null;
            try {
                this.logger.info((Object)"Insert AcctTransDetailVO and List<AcctTransDetailVO> begin");
                conn = DBCPConUtils.getConnection((EReceiptDBInfo)eReceiptDBInfo);
                if (!EmptyUtil.isEmpty(detailList)) {
                    ps = conn.prepareStatement(insertDetailSql);
                    for (int i = 0; i < detailList.size(); ++i) {
                        AcctBankTransDetailVO detailVO = detailList.get(i);
                        ps.setString(1, detailVO.getId());
                        ps.setString(2, detailVO.getTransTime());
                        ps.setString(3, detailVO.getDbtName());
                        ps.setString(4, detailVO.getDbtAcct());
                        ps.setString(5, detailVO.getDbtBankName());
                        ps.setString(6, detailVO.getCrtName());
                        ps.setString(7, detailVO.getCrtAcct());
                        ps.setString(8, detailVO.getCrtBankName());
                        ps.setString(9, detailVO.getPayFlag());
                        ps.setBigDecimal(10, detailVO.getTransAmt());
                        ps.setString(11, detailVO.getUsage());
                        ps.setString(12, detailVO.getTransAbstr());
                        ps.setString(13, detailVO.getRemark());
                        ps.setString(14, detailVO.getGroupCode());
                        ps.setString(15, detailVO.getGroupName());
                        ps.setString(16, detailVO.getDataState());
                        ps.setString(17, detailVO.getSubmitTime());
                        ps.setString(18, "0");
                        ps.addBatch();
                    }
                    ps.executeBatch();
                }
                conn.commit();
                this.logger.info((Object)"batchInsert AcctTransDetailVO and List<AcctTransDetailVO> success");
            }
            catch (Exception e) {
                e.printStackTrace();
                conn.rollback();
                throw new Exception(e);
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ps = null;
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

