/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.sa.LargeDetailBillCollection;
import com.kingdee.eas.fm.sa.LargeDetailBillFactory;
import com.kingdee.eas.fm.sa.LargeDetailBillInfo;
import com.kingdee.eas.fm.sa.LargeTotalBillInfo;
import com.kingdee.eas.fm.sa.ReportStatusEnum;
import com.kingdee.eas.fm.sa.ReportStorageSettingCollection;
import com.kingdee.eas.fm.sa.ReportStorageSettingFactory;
import com.kingdee.eas.fm.sa.ReportStorageSettingInfo;
import com.kingdee.eas.fm.sa.app.util.LargeTotalJDBCTool;
import com.kingdee.eas.fm.sa.app.util.ThreadLocalDateUtil;
import com.kingdee.eas.fm.sa.vo.LargeDetailVO;
import com.kingdee.eas.fm.sa.vo.LargeTotalVO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class LargeTotalDBUtils {
    private static Logger logger = Logger.getLogger((String)LargeTotalDBUtils.class.getName());
    public static final String total_Key = "largeTotalKey";
    public static final String detail_Key = "largeDetailKey";

    public void addNewLargeTotalFromDB(Context ctx, LargeTotalBillInfo largeTotalBillInfo, ReportStatusEnum reportEnum) throws BOSException, EASBizException {
        LargeTotalJDBCTool largeTotalJDBCTool = new LargeTotalJDBCTool();
        EntityViewInfo View = new EntityViewInfo();
        SelectorItemCollection Sic = new SelectorItemCollection();
        Sic.add(new SelectorItemInfo("*"));
        View.setSelector(Sic);
        ReportStorageSettingCollection cols = ReportStorageSettingFactory.getLocalInstance(ctx).getReportStorageSettingCollection(View);
        ReportStorageSettingInfo reportStorageSettingInfo = cols.get(0);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        FilterInfo filter = new FilterInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("fundUse.name"));
        sic.add(new SelectorItemInfo("fundUse.number"));
        filter.getFilterItems().add(new FilterItemInfo("totalBillNumber", (Object)largeTotalBillInfo.getBatchSeqId()));
        LargeDetailBillCollection detailCol = LargeDetailBillFactory.getLocalInstance(ctx).getLargeDetailBillCollection(view);
        Map<String, Object> retMap = this.parseLargeFinancingInfoToVO(largeTotalBillInfo, detailCol, reportEnum);
        List detailListVo = (List)retMap.get(detail_Key);
        LargeTotalVO largeTotalVo = (LargeTotalVO)retMap.get(total_Key);
        try {
            largeTotalJDBCTool.batchInsert(largeTotalVo, detailListVo, reportStorageSettingInfo);
        }
        catch (Exception e) {
            String exMsg = ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"143_LargeTotalDBUtils", (Locale)ctx.getLocale()) + e.getMessage();
            logger.error((Object)exMsg);
            throw new BOSException(exMsg);
        }
    }

    public void deleteLargeTotalFromDB(Context ctx, LargeTotalBillInfo largeTotalBillInfo) throws BOSException, EASBizException {
        LargeTotalJDBCTool largeTotalJDBCTool = new LargeTotalJDBCTool();
        EntityViewInfo View = new EntityViewInfo();
        SelectorItemCollection Sic = new SelectorItemCollection();
        Sic.add(new SelectorItemInfo("*"));
        View.setSelector(Sic);
        ReportStorageSettingCollection cols = ReportStorageSettingFactory.getLocalInstance(ctx).getReportStorageSettingCollection(View);
        ReportStorageSettingInfo reportStorageSettingInfo = cols.get(0);
        Map<String, Object> retMap = this.parseLargeFinancingInfoToVO(largeTotalBillInfo, new LargeDetailBillCollection(), ReportStatusEnum.DELETED);
        LargeTotalVO largeTotalVo = (LargeTotalVO)retMap.get(total_Key);
        try {
            largeTotalJDBCTool.insert(largeTotalVo, reportStorageSettingInfo);
        }
        catch (Exception e) {
            String exMsg = ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"144_LargeTotalDBUtils", (Locale)ctx.getLocale()) + e.getMessage();
            logger.error((Object)exMsg);
            throw new BOSException(exMsg);
        }
    }

    private Map<String, Object> parseLargeFinancingInfoToVO(LargeTotalBillInfo largeTotalBillInfo, LargeDetailBillCollection col, ReportStatusEnum reportEnum) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        LargeTotalVO largeTotalVo = new LargeTotalVO();
        if (!EmptyUtil.isEmpty((CoreBaseInfo)largeTotalBillInfo)) {
            largeTotalVo.setMasterTabId(largeTotalBillInfo.getBatchSeqId());
            largeTotalVo.setSubmitUnitCode(largeTotalBillInfo.getFillInOrgGroupCode());
            largeTotalVo.setSubmitUnitName(largeTotalBillInfo.getFillInOrgGroupName());
            largeTotalVo.setDataYear(largeTotalBillInfo.getYear());
            largeTotalVo.setDataMonth(largeTotalBillInfo.getMonth());
            largeTotalVo.setDataDate(largeTotalBillInfo.getDay());
            largeTotalVo.setLargeFundsLevel(largeTotalBillInfo.getLargeSelectAmt());
            largeTotalVo.setTotalPaid(largeTotalBillInfo.getAmount());
            largeTotalVo.setLargeTotalPaid(largeTotalBillInfo.getLargeTotalAmt());
            largeTotalVo.setLargeFundsRoll(largeTotalBillInfo.getLargeTotalCount());
            largeTotalVo.setRemark(largeTotalBillInfo.getDescription());
            largeTotalVo.setSubmitTime(ThreadLocalDateUtil.formatTimestamp(largeTotalBillInfo.getBizTime()));
            largeTotalVo.setSubmitter(largeTotalBillInfo.getPerson());
            largeTotalVo.setGroupCode(largeTotalBillInfo.getFillInOrgUnitCode());
            largeTotalVo.setGroupName(largeTotalBillInfo.getFillInOrgUnitName());
            largeTotalVo.setDataState(this.translateStatus(reportEnum));
        }
        retMap.put(total_Key, largeTotalVo);
        if (!ReportStatusEnum.DELETED.equals((Object)reportEnum)) {
            ArrayList<LargeDetailVO> detailListVo = new ArrayList<LargeDetailVO>();
            retMap.put(detail_Key, detailListVo);
            if (col == null || col.isEmpty()) {
                return retMap;
            }
            for (int i = 0; i < col.size(); ++i) {
                LargeDetailVO detailVo = new LargeDetailVO();
                LargeDetailBillInfo detail = col.get(i);
                detailVo.setDetailTabId(detail.getSerialId());
                detailVo.setMasterTabId(largeTotalBillInfo.getBatchSeqId());
                detailVo.setSubmitUnitCode(detail.getFillInOrgUnitCode());
                detailVo.setPayerName(detail.getPayName());
                detailVo.setPayeeName(detail.getRecName());
                detailVo.setPayment(detail.getAmount());
                detailVo.setFundsUse(detail.getFundUse().getNumber());
                detailVo.setUseDescript(detail.getFundUseName());
                detailVo.setIfAbroad(detail.isIsCBRecName());
                detailVo.setPayDate(new Date(detail.getPayDate().getTime()));
                detailVo.setRemark(detail.getRemark());
                detailVo.setPayNature(detail.getPayType().getAlias());
                detailVo.setIsTradeCapital(detail.isIsTradeBusiness());
                detailVo.setSubmitTime(ThreadLocalDateUtil.formatTimestamp(largeTotalBillInfo.getBizTime()));
                detailListVo.add(detailVo);
            }
        }
        return retMap;
    }

    private String translateStatus(ReportStatusEnum reportEnum) {
        if (ReportStatusEnum.ADDNEW.equals((Object)reportEnum)) {
            return "0";
        }
        if (ReportStatusEnum.ZEROREPORTED.equals((Object)reportEnum)) {
            return "5";
        }
        if (ReportStatusEnum.DELETED.equals((Object)reportEnum)) {
            return "1";
        }
        return "0";
    }
}

