/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.sa.DebtDetailBillCollection;
import com.kingdee.eas.fm.sa.DebtDetailBillFactory;
import com.kingdee.eas.fm.sa.DebtDetailBillInfo;
import com.kingdee.eas.fm.sa.MaturedDebtTotalBillInfo;
import com.kingdee.eas.fm.sa.ReportStatusEnum;
import com.kingdee.eas.fm.sa.ReportStorageSettingCollection;
import com.kingdee.eas.fm.sa.ReportStorageSettingFactory;
import com.kingdee.eas.fm.sa.ReportStorageSettingInfo;
import com.kingdee.eas.fm.sa.app.util.MaturedDebtTotalJDBCTool;
import com.kingdee.eas.fm.sa.app.util.ThreadLocalDateUtil;
import com.kingdee.eas.fm.sa.vo.MaturedDebtDetailVO;
import com.kingdee.eas.fm.sa.vo.MaturedDebtTotalVO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class MaturedDebtTotalDBUtils {
    private static Logger logger = Logger.getLogger((String)MaturedDebtTotalDBUtils.class.getName());
    public static final String total_Key = "maturedDebtTotalKey";
    public static final String detail_Key = "maturedDebtDetailKey";

    public void addNewMaturedDebtTotalFromDB(Context ctx, MaturedDebtTotalBillInfo totalBillInfo, ReportStatusEnum reportEnum) throws BOSException, EASBizException {
        MaturedDebtTotalJDBCTool maturedDebtTotalJDBCTool = new MaturedDebtTotalJDBCTool();
        EntityViewInfo View = new EntityViewInfo();
        SelectorItemCollection Sic = new SelectorItemCollection();
        Sic.add(new SelectorItemInfo("*"));
        View.setSelector(Sic);
        ReportStorageSettingCollection cols = ReportStorageSettingFactory.getLocalInstance(ctx).getReportStorageSettingCollection(View);
        ReportStorageSettingInfo reportStorageSettingInfo = cols.get(0);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        FilterInfo filter = new FilterInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("fundUse.name"));
        sic.add(new SelectorItemInfo("fundUse.number"));
        filter.getFilterItems().add(new FilterItemInfo("totalBillNumber", (Object)totalBillInfo.getBatchSeqId()));
        DebtDetailBillCollection detailCol = DebtDetailBillFactory.getLocalInstance(ctx).getDebtDetailBillCollection(view);
        Map<String, Object> retMap = this.parseMaturedDebtInfoToVO(totalBillInfo, detailCol, reportEnum);
        List detailListVo = (List)retMap.get(detail_Key);
        MaturedDebtTotalVO totalVo = (MaturedDebtTotalVO)retMap.get(total_Key);
        try {
            maturedDebtTotalJDBCTool.batchInsert(totalVo, detailListVo, reportStorageSettingInfo);
        }
        catch (Exception e) {
            String exMsg = ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"145_MaturedDebtTotalDBUtils", (Locale)ctx.getLocale()) + e.getMessage();
            logger.error((Object)exMsg);
            throw new BOSException(exMsg);
        }
    }

    public void deleteMaturedDebtTotalFromDB(Context ctx, MaturedDebtTotalBillInfo totalBillInfo) throws BOSException, EASBizException {
        MaturedDebtTotalJDBCTool maturedDebtTotalJDBCTool = new MaturedDebtTotalJDBCTool();
        EntityViewInfo View = new EntityViewInfo();
        SelectorItemCollection Sic = new SelectorItemCollection();
        Sic.add(new SelectorItemInfo("*"));
        View.setSelector(Sic);
        ReportStorageSettingCollection cols = ReportStorageSettingFactory.getLocalInstance(ctx).getReportStorageSettingCollection(View);
        ReportStorageSettingInfo reportStorageSettingInfo = cols.get(0);
        Map<String, Object> retMap = this.parseMaturedDebtInfoToVO(totalBillInfo, new DebtDetailBillCollection(), ReportStatusEnum.DELETED);
        MaturedDebtTotalVO totalVo = (MaturedDebtTotalVO)retMap.get(total_Key);
        try {
            maturedDebtTotalJDBCTool.insert(totalVo, reportStorageSettingInfo);
        }
        catch (Exception e) {
            String exMsg = ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"146_MaturedDebtTotalDBUtils", (Locale)ctx.getLocale()) + e.getMessage();
            logger.error((Object)exMsg);
            throw new BOSException(exMsg);
        }
    }

    private Map<String, Object> parseMaturedDebtInfoToVO(MaturedDebtTotalBillInfo totalBillInfo, DebtDetailBillCollection col, ReportStatusEnum reportEnum) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        MaturedDebtTotalVO totalVo = new MaturedDebtTotalVO();
        if (!EmptyUtil.isEmpty((CoreBaseInfo)totalBillInfo)) {
            totalVo.setMasterTabId(totalBillInfo.getBatchSeqId());
            totalVo.setSubmitUnitCode(totalBillInfo.getFillInOrgUnitCode());
            totalVo.setSubmitUnitName(totalBillInfo.getFillInOrgUnitName());
            totalVo.setDataYear(totalBillInfo.getYear());
            totalVo.setDataMonth(totalBillInfo.getMonth());
            totalVo.setDataDate(totalBillInfo.getDay());
            totalVo.setRemark(totalBillInfo.getDescription());
            totalVo.setSubmitTime(ThreadLocalDateUtil.formatTimestamp(totalBillInfo.getBizTime()));
            totalVo.setSubmitter(totalBillInfo.getPerson());
            totalVo.setGroupCode(totalBillInfo.getFillInOrgGroupCode());
            totalVo.setGroupName(totalBillInfo.getFillInOrgGroupName());
            totalVo.setDataState(this.translateStatus(reportEnum));
        }
        retMap.put(total_Key, totalVo);
        if (!ReportStatusEnum.DELETED.equals((Object)reportEnum)) {
            ArrayList<MaturedDebtDetailVO> detailListVo = new ArrayList<MaturedDebtDetailVO>();
            retMap.put(detail_Key, detailListVo);
            if (col == null || col.isEmpty()) {
                return retMap;
            }
            for (int i = 0; i < col.size(); ++i) {
                MaturedDebtDetailVO detailVo = new MaturedDebtDetailVO();
                DebtDetailBillInfo detail = col.get(i);
                detailVo.setDetailTabId(detail.getSerialId());
                detailVo.setMasterTabId(totalBillInfo.getBatchSeqId());
                detailVo.setDebtorCode(detail.getFillInOrgUnitCode());
                detailVo.setDebtorName(detail.getFillInOrgUnitName());
                detailVo.setDebtType(detail.getFundUse().getName());
                detailVo.setDebteeName(detail.getDebteeName());
                detailVo.setDebtPrin(detail.getDebtPrinAmt());
                detailVo.setDebtAnnlRate(detail.getDebtAnnlRate());
                detailVo.setLoanDate(new Date(detail.getLoanDate().getTime()));
                detailVo.setDueDate(new Date(detail.getDueDate().getTime()));
                if (!EmptyUtil.isEmpty((Object)detail.getDueAmtMonth())) {
                    detailVo.setDueAmtMonth(detail.getDueAmtMonth());
                }
                if (!EmptyUtil.isEmpty((Object)detail.getDueDateMonth())) {
                    detailVo.setDueDateMonth(new Date(detail.getDueDateMonth().getTime()));
                }
                detailVo.setIfExecute(detail.isIsExecute() ? "\u662f" : "\u5426");
                detailVo.setExecutePhase(detail.getExecutePhase());
                detailVo.setRemark(detail.getRemark());
                detailVo.setSubmitTime(ThreadLocalDateUtil.formatTimestamp(totalBillInfo.getBizTime()));
                detailListVo.add(detailVo);
            }
        }
        return retMap;
    }

    private String translateStatus(ReportStatusEnum reportEnum) {
        if (ReportStatusEnum.ADDNEW.equals((Object)reportEnum)) {
            return "0";
        }
        if (ReportStatusEnum.ZEROREPORTED.equals((Object)reportEnum)) {
            return "5";
        }
        if (ReportStatusEnum.DELETED.equals((Object)reportEnum)) {
            return "1";
        }
        return "0";
    }
}

