/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app.util;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ThreadLocalDateUtil {
    private static final String date_format = "yyyy-MM-dd";
    private static final String timestamp_format = "yyyy-MM-dd HH:mm:ss";
    private static ThreadLocal<DateFormat> threadLocalDate = new ThreadLocal();
    private static ThreadLocal<DateFormat> threadLocalTime = new ThreadLocal();

    public static DateFormat getDateFormat() {
        DateFormat df = threadLocalDate.get();
        if (df == null) {
            df = new SimpleDateFormat(date_format);
            threadLocalDate.set(df);
        }
        return df;
    }

    public static String formatDate(Date date) {
        String formatDate = "";
        try {
            formatDate = ThreadLocalDateUtil.getDateFormat().format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
            formatDate = new java.sql.Date(date.getTime()).toString();
        }
        return formatDate;
    }

    public static Date parse(String strDate) throws ParseException {
        return ThreadLocalDateUtil.getDateFormat().parse(strDate);
    }

    public static DateFormat getTimestampFormat() {
        DateFormat df = threadLocalTime.get();
        if (df == null) {
            df = new SimpleDateFormat(timestamp_format);
            threadLocalTime.set(df);
        }
        return df;
    }

    public static String formatTimestamp(Timestamp time) {
        String formatDate = "";
        try {
            formatDate = ThreadLocalDateUtil.getTimestampFormat().format(time);
        }
        catch (Exception e) {
            e.printStackTrace();
            formatDate = new Timestamp(time.getTime()).toString().substring(0, 18);
        }
        return formatDate;
    }
}

