/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryOrgCollection;
import com.kingdee.eas.fm.sa.ReportOrgSolutionSettingInfo;
import com.kingdee.eas.fm.sa.app.AbstractAcctBankBalanceFacadeControllerBean;
import com.kingdee.eas.fm.sa.app.util.AcctBankBalanceTotalDBUtils;
import com.kingdee.eas.fm.sa.app.util.ThreadLocalDateUtil;
import com.kingdee.eas.fm.sa.vo.AcctBankBalanceDetailVO;
import com.kingdee.eas.fm.sa.vo.AcctBankBalanceTotalVO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class AcctBankBalanceFacadeControllerBean
extends AbstractAcctBankBalanceFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.sa.app.AcctBankBalanceFacadeControllerBean");

    @Override
    protected void _autoReportAcctBankBal(Context ctx, ReportOrgSolutionSettingInfo info, java.util.Date payDate, String person) throws BOSException, EASBizException {
        logger.error((Object)"------\u81ea\u52a8\u4e0a\u62a5\u94f6\u884c\u8d26\u6237\u4f59\u989d\u81f3\u56fd\u8d44\u59d4\u76d1\u7ba1\u5e73\u53f0 begin-------");
        Timestamp submitTime = new Timestamp(Calendar.getInstance().getTimeInMillis());
        String payDateStr = ThreadLocalDateUtil.formatDate(payDate);
        String masterTabId = payDateStr + "-" + info.getFillInOrgUnitCode();
        AccountBankCollection acctBankCols = this.initReportOrgSol2AcctBankCol(ctx, info);
        logger.error((Object)"------\u81ea\u52a8\u4e0a\u62a5\u94f6\u884c\u8d26\u6237\u4f59\u989d\u81f3\u56fd\u8d44\u59d4\u76d1\u7ba1\u5e73\u53f0 \u5904\u7406\u660e\u7ec6\u6570\u636e-------");
        List<AcctBankBalanceDetailVO> detailListVo = this.parseDetailInfo(ctx, payDate, submitTime, payDateStr, masterTabId, acctBankCols);
        logger.error((Object)"------\u81ea\u52a8\u4e0a\u62a5\u94f6\u884c\u8d26\u6237\u4f59\u989d\u81f3\u56fd\u8d44\u59d4\u76d1\u7ba1\u5e73\u53f0 \u5904\u7406\u4e3b\u8868\u6570\u636e-------");
        AcctBankBalanceTotalVO totalVo = this.parseMasterInfo(info, person, submitTime, payDateStr, masterTabId);
        AcctBankBalanceTotalDBUtils dbUtils = new AcctBankBalanceTotalDBUtils();
        dbUtils.addNewLargeTotalFromDB(ctx, totalVo, detailListVo);
        logger.error((Object)"------\u81ea\u52a8\u4e0a\u62a5\u94f6\u884c\u8d26\u6237\u4f59\u989d\u81f3\u56fd\u8d44\u59d4\u76d1\u7ba1\u5e73\u53f0 end-------");
    }

    protected AccountBankCollection initReportOrgSol2AcctBankCol(Context ctx, ReportOrgSolutionSettingInfo info) throws BOSException {
        ReportOrgSSEntryOrgCollection repCompanyCols = info.getReportOrgEntrys();
        HashSet<String> companyIds = new HashSet<String>();
        for (int i = 0; i < repCompanyCols.size(); ++i) {
            companyIds.add(repCompanyCols.get(i).getReportOrg().getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        FilterInfo filter = new FilterInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bankAccountNumber"));
        sic.add(new SelectorItemInfo("openDate"));
        sic.add(new SelectorItemInfo("isSetBankInterface"));
        sic.add(new SelectorItemInfo("bankInterfaceType"));
        sic.add(new SelectorItemInfo("isVirtualAcct"));
        sic.add(new SelectorItemInfo("isClosed"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("bank.parent.name"));
        HashSet<Integer> shareTypeEnumSet = new HashSet<Integer>();
        shareTypeEnumSet.add(0);
        shareTypeEnumSet.add(1);
        filter.getFilterItems().add(new FilterItemInfo("shareType", shareTypeEnumSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bank.isBank", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("company.id", companyIds, CompareType.INCLUDE));
        AccountBankCollection acctBankCols = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        return acctBankCols;
    }

    private AcctBankBalanceTotalVO parseMasterInfo(ReportOrgSolutionSettingInfo info, String person, Timestamp submitTime, String payDateStr, String masterTabId) {
        AcctBankBalanceTotalVO totalVo = new AcctBankBalanceTotalVO();
        totalVo.setMasterTabId(masterTabId);
        totalVo.setSubmitUnitCode(info.getFillInOrgUnitCode());
        totalVo.setSubmitUnitName(info.getFillInOrgUnitName());
        totalVo.setDataYear(payDateStr.split("-")[0].toString());
        totalVo.setDataMonth(payDateStr.split("-")[1].toString());
        totalVo.setDataDate(payDateStr.split("-")[2].toString());
        totalVo.setSubmitter(person);
        totalVo.setSubmitTime(ThreadLocalDateUtil.formatTimestamp(submitTime));
        totalVo.setGroupCode(info.getFillInOrgGroupCode());
        totalVo.setGroupName(info.getFillInOrgGroupName());
        totalVo.setDataState("0");
        return totalVo;
    }

    private List<AcctBankBalanceDetailVO> parseDetailInfo(Context ctx, java.util.Date payDate, Timestamp submitTime, String payDateStr, String masterTabId, AccountBankCollection acctBankCols) throws BOSException {
        ArrayList<AcctBankBalanceDetailVO> detailListVo = new ArrayList<AcctBankBalanceDetailVO>();
        for (int i = 0; i < acctBankCols.size(); ++i) {
            AccountBankInfo acctBankInfo = acctBankCols.get(i);
            AcctBankBalanceDetailVO detail = new AcctBankBalanceDetailVO();
            String detailTabId = "";
            detail.setMasterTabId(masterTabId);
            detail.setAcctTit(acctBankInfo.getName());
            detail.setAcctNo(acctBankInfo.getBankAccountNumber());
            detail.setBankBrName(acctBankInfo.getBank().getName());
            if (EmptyUtil.isEmpty((CoreBaseInfo)acctBankInfo.getBank().getParent())) {
                detail.setBankType(acctBankInfo.getBank().getName());
            } else {
                detail.setBankType(acctBankInfo.getBank().getParent().getName());
            }
            detail.setAcctOpenDate(new Date(acctBankInfo.getOpenDate().getTime()));
            detail.setIfAccmAcct(acctBankInfo.isIsVirtualAcct() ? "\u662f" : "\u5426");
            detail.setSubmitTime(ThreadLocalDateUtil.formatTimestamp(submitTime));
            detail.setBalanceDate(new Date(payDate.getTime()));
            if (acctBankInfo.isIsClosed()) {
                detail.setAcctState("\u9500\u6237");
                detail.setAcctBal(Constants.ZERO);
            } else {
                detail.setAcctState("\u6d3b\u52a8");
                BigDecimal acctBal = Constants.ZERO;
                try {
                    String sql = "select * from T_BE_AccountBankBalance where FACCOUNTBANKID = ? and FBIZDATE = ?";
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{acctBankInfo.getId().toString(), new Date(payDate.getTime())});
                    while (rs.next()) {
                        acctBal = rs.getBigDecimal("FBalance");
                        detailTabId = rs.getString("Fid");
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                detail.setAcctBal(acctBal);
            }
            if (EmptyUtil.isEmpty((String)detailTabId)) {
                detail.setDetailTabId(payDateStr + "-" + acctBankInfo.getBankAccountNumber());
            } else {
                detail.setDetailTabId(detailTabId);
            }
            detailListVo.add(detail);
        }
        return detailListVo;
    }
}

