/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fm.sa.AccessSourceEnum;
import com.kingdee.eas.fm.sa.BillStatusEnum;
import com.kingdee.eas.fm.sa.DebtDetailBillFactory;
import com.kingdee.eas.fm.sa.DebtDetailBillInfo;
import com.kingdee.eas.fm.sa.FundUseCollection;
import com.kingdee.eas.fm.sa.FundUseFactory;
import com.kingdee.eas.fm.sa.FundUseInfo;
import com.kingdee.eas.fm.sa.IDebtDetailBill;
import com.kingdee.eas.fm.sa.ReportContentEnum;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryOrgCollection;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryOrgFactory;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryOrgInfo;
import com.kingdee.eas.fm.sa.app.util.DateUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DebtDetailBillDataImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)DebtDetailBillDataImport.class.getName());
    private Map<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>();
    private Map<String, FundUseInfo> deBtTypeMap = new HashMap<String, FundUseInfo>();

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        return this.parseData(hsData, new DebtDetailBillInfo(), ctx);
    }

    private CoreBaseInfo parseData(Hashtable hsData, DebtDetailBillInfo info, Context ctx) throws TaskExternalException {
        Date dueDateMonth;
        Date endDate;
        Date startDate;
        FilterInfo filter;
        EntityViewInfo view;
        Object data = null;
        String companyId = null;
        String debtTypeId = null;
        data = this.getData(hsData, "FReportOrg_number");
        if (data != null && data.toString().trim().length() > 0) {
            if (this.companyMap.containsKey(data.toString().trim())) {
                CompanyOrgUnitInfo companyInfo = this.companyMap.get(data.toString().trim());
                info.setReportOrg(companyInfo);
                companyId = companyInfo.getId().toString();
            } else {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
                view.setFilter(filter);
                CompanyOrgUnitCollection companyCol = null;
                try {
                    companyCol = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                if (companyCol == null || companyCol.size() < 1) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"34_DebtDetailBillDataImport", (Locale)ctx.getLocale()) + data + ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"35_DebtDetailBillDataImport", (Locale)ctx.getLocale()));
                }
                try {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyCol.get(0).getId().toString()), (String)"debtDetailBill_import_08");
                    if (!isPermission) {
                        throw new TaskExternalException(data + ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"36_DebtDetailBillDataImport", (Locale)ctx.getLocale()));
                    }
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"37_DebtDetailBillDataImport", (Locale)ctx.getLocale()));
                }
                catch (BOSException e) {
                    e.printStackTrace();
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"37_DebtDetailBillDataImport", (Locale)ctx.getLocale()));
                }
                this.companyMap.put(data.toString().trim(), companyCol.get(0));
                CompanyOrgUnitInfo companyInfo = this.companyMap.get(data.toString().trim());
                info.setReportOrg(companyInfo);
                companyId = companyInfo.getId().toString();
            }
        }
        if (companyId == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"38_DebtDetailBillDataImport", (Locale)ctx.getLocale()));
        }
        try {
            view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            selector.add("parent.*");
            FilterInfo filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("reportOrg.id", (Object)info.getReportOrg().getId().toString()));
            view.setFilter(filter2);
            view.setSelector(selector);
            ReportOrgSSEntryOrgCollection coll = ReportOrgSSEntryOrgFactory.getLocalInstance(ctx).getReportOrgSSEntryOrgCollection(view);
            if (coll == null || coll.size() <= 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"39_DebtDetailBillDataImport", (Locale)ctx.getLocale()));
            }
            ReportOrgSSEntryOrgInfo reportOrgSSEntryOrgInfo = coll.get(0);
            info.setFillInOrgUnitName(reportOrgSSEntryOrgInfo.getParent().getFillInOrgUnitName());
            info.setFillInOrgUnitCode(reportOrgSSEntryOrgInfo.getParent().getFillInOrgUnitCode());
        }
        catch (BOSException e1) {
            e1.printStackTrace();
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"39_DebtDetailBillDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FStartDate");
        if (data != null && data.toString().trim().length() > 0) {
            startDate = DateTimeUtils.truncateDate((Date)TypeConversionUtils.objToDate((Object)data));
            if (!DateUtils.isFirstDayOfMonth(startDate)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"31_DebtDetailBillControllerBean", (Locale)ctx.getLocale()));
            }
        } else {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"40_DebtDetailBillDataImport", (Locale)ctx.getLocale()));
        }
        info.setStartDate(startDate);
        data = this.getData(hsData, "FEndDate");
        if (data != null && data.toString().trim().length() > 0) {
            endDate = DateTimeUtils.truncateDate((Date)TypeConversionUtils.objToDate((Object)data));
            if (!DateUtils.isEndDateOfMonth(endDate)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"32_DebtDetailBillControllerBean", (Locale)ctx.getLocale()));
            }
        } else {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"41_DebtDetailBillDataImport", (Locale)ctx.getLocale()));
        }
        info.setEndDate(endDate);
        if (!DateUtils.isTheSameOfMonth(info.getStartDate(), info.getEndDate())) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"33_DebtDetailBillControllerBean", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FFundUse_number");
        if (this.deBtTypeMap.containsKey(data.toString().trim())) {
            FundUseInfo debtTypeInfo = this.deBtTypeMap.get(data.toString().trim());
            info.setFundUse(debtTypeInfo);
            info.setFundUseName(debtTypeInfo.getName());
            debtTypeId = debtTypeInfo.getId().toString();
        } else {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("reportType", (Object)3));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view.setFilter(filter);
            FundUseCollection debtTypeCol = null;
            try {
                debtTypeCol = FundUseFactory.getLocalInstance(ctx).getFundUseCollection(view);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (debtTypeCol == null || debtTypeCol.size() < 1) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"42_DebtDetailBillDataImport", (Locale)ctx.getLocale()) + data + ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"35_DebtDetailBillDataImport", (Locale)ctx.getLocale()));
            }
            this.deBtTypeMap.put(data.toString().trim(), debtTypeCol.get(0));
            FundUseInfo debtTypeInfo = this.deBtTypeMap.get(data.toString().trim());
            info.setFundUse(debtTypeInfo);
            info.setFundUseName(debtTypeInfo.getName());
            debtTypeId = debtTypeInfo.getId().toString();
        }
        if (debtTypeId == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"43_DebtDetailBillDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FDebteeName");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"44_DebtDetailBillDataImport", (Locale)ctx.getLocale()));
        }
        info.setDebteeName(data.toString());
        data = this.getData(hsData, "FDebtPrinAmt");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"45_DebtDetailBillDataImport", (Locale)ctx.getLocale()));
        }
        info.setDebtPrinAmt(TypeConversionUtils.objToBigDecimal((Object)data));
        data = this.getData(hsData, "FDebtAnnlRate");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"46_DebtDetailBillDataImport", (Locale)ctx.getLocale()));
        }
        BigDecimal debtAnnlRate = TypeConversionUtils.objToBigDecimal((Object)data);
        info.setDebtAnnlRate(debtAnnlRate);
        data = this.getData(hsData, "FLoanDate");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"47_DebtDetailBillDataImport", (Locale)ctx.getLocale()));
        }
        info.setLoanDate(DateTimeUtils.truncateDate((Date)TypeConversionUtils.objToDate((Object)data)));
        data = this.getData(hsData, "FDueDate");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"48_DebtDetailBillDataImport", (Locale)ctx.getLocale()));
        }
        info.setDueDate(DateTimeUtils.truncateDate((Date)TypeConversionUtils.objToDate((Object)data)));
        data = this.getData(hsData, "FDueDateMonth");
        if (data != null && data.toString().trim().length() > 0) {
            dueDateMonth = DateTimeUtils.truncateDate((Date)TypeConversionUtils.objToDate((Object)data));
            Calendar cal = Calendar.getInstance();
            cal.setTime(dueDateMonth);
            int tempDay = cal.get(5);
            if (tempDay <= 10) {
                info.setIsExecute(true);
            } else {
                info.setIsExecute(false);
            }
        } else {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"49_DebtDetailBillDataImport", (Locale)ctx.getLocale()));
        }
        info.setDueDateMonth(dueDateMonth);
        data = this.getData(hsData, "FDueAmtMonth");
        if (data != null && data.toString().trim().length() > 0) {
            BigDecimal dueAmtMonth = TypeConversionUtils.objToBigDecimal((Object)data);
            info.setDueAmtMonth(dueAmtMonth);
        } else {
            info.setDueAmtMonth(Constants.ZERO);
        }
        data = this.getData(hsData, "FExecutePhase");
        if (data != null && data.toString().trim().length() > 0) {
            info.setExecutePhase(data.toString());
        }
        if ((data = this.getData(hsData, "FRemark")) != null && data.toString().trim().length() > 0) {
            info.setRemark(data.toString());
        }
        info.setAccessSource(AccessSourceEnum.Manual);
        info.setReportedType(ReportContentEnum.MATURECLAIM_AND_REPAYPLAN);
        info.setBillStatus(BillStatusEnum.SAVE);
        info.setIsImport(true);
        return info;
    }

    private Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return DebtDetailBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        DebtDetailBillInfo info = (DebtDetailBillInfo)coreBaseInfo;
        IDebtDetailBill iDebtDetailBill = (IDebtDetailBill)this.getController(ctx);
        try {
            info.setIsImport(true);
            iDebtDetailBill.addnew(info);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }
}

