/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.sa.FundUseMatchSolutionEntryCollection;
import com.kingdee.eas.fm.sa.FundUseMatchSolutionEntryInfo;
import com.kingdee.eas.fm.sa.FundUseMatchSolutionInfo;
import com.kingdee.eas.fm.sa.MatchPropertyEnum;
import com.kingdee.eas.fm.sa.SAException;
import com.kingdee.eas.fm.sa.StatusEnum;
import com.kingdee.eas.fm.sa.app.AbstractFundUseMatchSolutionControllerBean;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class FundUseMatchSolutionControllerBean
extends AbstractFundUseMatchSolutionControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.sa.app.FundUseMatchSolutionControllerBean");
    private static String resource = "com.kingdee.eas.fm.sa.SAResource";

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FundUseMatchSolutionInfo info = (FundUseMatchSolutionInfo)model;
        info.setState(StatusEnum.enable);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_fundUseMatchSolution_addnew");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return super._addnew(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FundUseMatchSolutionInfo info = (FundUseMatchSolutionInfo)model;
        this.checkNumberDup(ctx, info);
        this.verifyNotNull(ctx, info);
        this.verifyOnlyOrg(ctx, info);
        return super._save(ctx, model);
    }

    public void checkNumberDup(Context ctx, FundUseMatchSolutionInfo info) throws BOSException, EASBizException {
        String number = info.getNumber();
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        info.setNumber(info.getNumber().trim());
        FilterInfo filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)info, (boolean)false);
        if (this.exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{info.getNumber(), ""});
        }
    }

    public void verifyNotNull(Context ctx, FundUseMatchSolutionInfo info) throws BOSException, EASBizException {
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"name");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"matchProperty");
        FundUseMatchSolutionEntryCollection entrys = info.getEntrys();
        if (entrys == null || entrys.size() == 0) {
            throw new SAException(SAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"Entrys_Not_Null")});
        }
        this.verifyEntrys(ctx, info);
    }

    private void verifyEntrys(Context ctx, FundUseMatchSolutionInfo info) throws BOSException, EASBizException {
        block9: {
            FundUseMatchSolutionEntryCollection entrys;
            block8: {
                entrys = info.getEntrys();
                if (info.getMatchProperty() != MatchPropertyEnum.FundFlowItem_Large) break block8;
                HashMap<String, Integer> fundMap = new HashMap<String, Integer>();
                for (int i = 0; i < entrys.size(); ++i) {
                    FundUseMatchSolutionEntryInfo entry = entrys.get(i);
                    if (entry.getFundFlowItem() == null) {
                        throw new SAException(SAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"FundFlowItem_Not_Null", (String[])new String[]{String.valueOf(i + 1)})});
                    }
                    if (entry.getFundUse() == null) {
                        throw new SAException(SAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"FundUse_Not_Null", (String[])new String[]{String.valueOf(i + 1)})});
                    }
                    String fundFlowItemId = entry.getFundFlowItem().getId().toString();
                    Integer seq = (Integer)fundMap.get(fundFlowItemId);
                    if (seq != null) {
                        throw new SAException(SAException.FUNDFLOWITEMREPEAT, new Object[]{seq, i + 1});
                    }
                    fundMap.put(fundFlowItemId, i + 1);
                }
                break block9;
            }
            if (info.getMatchProperty() != MatchPropertyEnum.FinancingProducts_Claim) break block9;
            HashMap<String, Integer> fundMap = new HashMap<String, Integer>();
            for (int i = 0; i < entrys.size(); ++i) {
                FundUseMatchSolutionEntryInfo entry = entrys.get(i);
                if (entry.getFinancingProducts() == null) {
                    throw new SAException(SAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"FundFlowItem_Not_Null", (String[])new String[]{String.valueOf(i + 1)})});
                }
                if (entry.getFundUse() == null) {
                    throw new SAException(SAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"FundUse_Not_Null", (String[])new String[]{String.valueOf(i + 1)})});
                }
                String financingProductsId = entry.getFinancingProducts().getId().toString();
                Integer seq = (Integer)fundMap.get(financingProductsId);
                if (seq != null) {
                    throw new SAException(SAException.FUNDFLOWITEMREPEAT, new Object[]{seq, i + 1});
                }
                fundMap.put(financingProductsId, i + 1);
            }
        }
    }

    public void verifyOnlyOrg(Context ctx, FundUseMatchSolutionInfo info) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("matchProperty", (Object)info.getMatchProperty().getValue(), CompareType.EQUALS));
        if (this.exists(ctx, filter)) {
            throw new SAException(SAException.EXISTS_MATCHPROPERTY, new Object[]{info.getMatchProperty().getAlias()});
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FundUseMatchSolutionInfo info = this.getFundUseMatchSolutionInfo(ctx, pk);
        if (info.getState() != StatusEnum.disable) {
            throw new SAException(SAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"solution_disable_delete")});
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_fundUseMatchSolution_delete");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        super._delete(ctx, pk);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FundUseMatchSolutionInfo info = (FundUseMatchSolutionInfo)model;
        if (info.getState() == StatusEnum.enable) {
            throw new SAException(SAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"solution_enable_notUpdate")});
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_fundUseMatchSolution_update");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        super._update(ctx, pk, model);
    }
}

